/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.ConnectionPool;
import com.android.okhttp.Handshake;
import com.android.okhttp.Protocol;
import com.android.okhttp.Request;
import com.android.okhttp.Response;
import com.android.okhttp.Route;
import com.android.okhttp.TunnelRequest;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.http.HttpAuthenticator;
import com.android.okhttp.internal.http.HttpConnection;
import com.android.okhttp.internal.http.HttpEngine;
import com.android.okhttp.internal.http.HttpTransport;
import com.android.okhttp.internal.http.SpdyTransport;
import com.android.okhttp.internal.spdy.SpdyConnection;
import com.android.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.SSLSocket;

public final class Connection
implements Closeable {
    private final ConnectionPool pool;
    private final Route route;
    private Socket socket;
    private boolean connected = false;
    private HttpConnection httpConnection;
    private SpdyConnection spdyConnection;
    private int httpMinorVersion = 1;
    private long idleStartTimeNs;
    private Handshake handshake;
    private int recycleCount;
    private Object owner;

    public Connection(ConnectionPool pool, Route route) {
        this.pool = pool;
        this.route = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            return this.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Object owner) {
        if (this.isSpdy()) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != null) {
                throw new IllegalStateException("Connection already has an owner!");
            }
            this.owner = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner == null) {
                return false;
            }
            this.owner = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIfOwnedBy(Object owner) throws IOException {
        if (this.isSpdy()) {
            throw new IllegalStateException();
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != owner) {
                return;
            }
            this.owner = null;
        }
        this.socket.close();
    }

    public void connect(int connectTimeout, int readTimeout, TunnelRequest tunnelRequest) throws IOException {
        if (this.connected) {
            throw new IllegalStateException("already connected");
        }
        this.socket = this.route.proxy.type() == Proxy.Type.DIRECT || this.route.proxy.type() == Proxy.Type.HTTP ? this.route.address.socketFactory.createSocket() : new Socket(this.route.proxy);
        this.socket.setSoTimeout(readTimeout);
        Platform.get().connectSocket(this.socket, this.route.inetSocketAddress, connectTimeout);
        if (this.route.address.sslSocketFactory != null) {
            this.upgradeToTls(tunnelRequest);
        } else {
            this.httpConnection = new HttpConnection(this.pool, this, this.socket);
        }
        this.connected = true;
    }

    private void upgradeToTls(TunnelRequest tunnelRequest) throws IOException {
        ByteString maybeProtocol;
        Platform platform = Platform.get();
        if (this.requiresTunnel()) {
            this.makeTunnel(tunnelRequest);
        }
        this.socket = this.route.address.sslSocketFactory.createSocket(this.socket, this.route.address.uriHost, this.route.address.uriPort, true);
        SSLSocket sslSocket = (SSLSocket)this.socket;
        if (this.route.modernTls) {
            platform.enableTlsExtensions(sslSocket, this.route.address.uriHost);
        } else {
            platform.supportTlsIntolerantServer(sslSocket);
        }
        boolean useNpn = false;
        if (this.route.modernTls) {
            boolean http2 = this.route.address.protocols.contains((Object)Protocol.HTTP_2);
            boolean spdy3 = this.route.address.protocols.contains((Object)Protocol.SPDY_3);
            if (http2 && spdy3) {
                platform.setNpnProtocols(sslSocket, Protocol.HTTP2_SPDY3_AND_HTTP);
                useNpn = true;
            } else if (http2) {
                platform.setNpnProtocols(sslSocket, Protocol.HTTP2_AND_HTTP_11);
                useNpn = true;
            } else if (spdy3) {
                platform.setNpnProtocols(sslSocket, Protocol.SPDY3_AND_HTTP11);
                useNpn = true;
            }
        }
        sslSocket.startHandshake();
        if (!this.route.address.hostnameVerifier.verify(this.route.address.uriHost, sslSocket.getSession())) {
            throw new IOException("Hostname '" + this.route.address.uriHost + "' was not verified");
        }
        this.handshake = Handshake.get(sslSocket.getSession());
        Protocol selectedProtocol = Protocol.HTTP_11;
        if (useNpn && (maybeProtocol = platform.getNpnSelectedProtocol(sslSocket)) != null) {
            selectedProtocol = Protocol.find(maybeProtocol);
        }
        if (selectedProtocol.spdyVariant) {
            sslSocket.setSoTimeout(0);
            this.spdyConnection = new SpdyConnection.Builder(this.route.address.getUriHost(), true, this.socket).protocol(selectedProtocol).build();
            this.spdyConnection.sendConnectionHeader();
        } else {
            this.httpConnection = new HttpConnection(this.pool, this, this.socket);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public Route getRoute() {
        return this.route;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isAlive() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public boolean isReadable() {
        if (this.httpConnection != null) {
            return this.httpConnection.isReadable();
        }
        return true;
    }

    public void resetIdleStartTime() {
        if (this.spdyConnection != null) {
            throw new IllegalStateException("spdyConnection != null");
        }
        this.idleStartTimeNs = System.nanoTime();
    }

    public boolean isIdle() {
        return this.spdyConnection == null || this.spdyConnection.isIdle();
    }

    public boolean isExpired(long keepAliveDurationNs) {
        return this.getIdleStartTimeNs() < System.nanoTime() - keepAliveDurationNs;
    }

    public long getIdleStartTimeNs() {
        return this.spdyConnection == null ? this.idleStartTimeNs : this.spdyConnection.getIdleStartTimeNs();
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public Object newTransport(HttpEngine httpEngine) throws IOException {
        return this.spdyConnection != null ? new SpdyTransport(httpEngine, this.spdyConnection) : new HttpTransport(httpEngine, this.httpConnection);
    }

    public boolean isSpdy() {
        return this.spdyConnection != null;
    }

    public int getHttpMinorVersion() {
        return this.httpMinorVersion;
    }

    public void setHttpMinorVersion(int httpMinorVersion) {
        this.httpMinorVersion = httpMinorVersion;
    }

    public boolean requiresTunnel() {
        return this.route.address.sslSocketFactory != null && this.route.proxy.type() == Proxy.Type.HTTP;
    }

    public void updateReadTimeout(int newTimeout) throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("updateReadTimeout - not connected");
        }
        this.socket.setSoTimeout(newTimeout);
    }

    public void incrementRecycleCount() {
        ++this.recycleCount;
    }

    public int recycleCount() {
        return this.recycleCount;
    }

    private void makeTunnel(TunnelRequest tunnelRequest) throws IOException {
        Response response;
        HttpConnection tunnelConnection = new HttpConnection(this.pool, this, this.socket);
        Request request = tunnelRequest.getRequest();
        String requestLine = tunnelRequest.requestLine();
        block4: while (true) {
            tunnelConnection.writeRequest(request.headers(), requestLine);
            tunnelConnection.flush();
            response = tunnelConnection.readResponse().request(request).build();
            tunnelConnection.emptyResponseBody();
            switch (response.code()) {
                case 200: {
                    if (tunnelConnection.bufferSize() > 0L) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return;
                }
                case 407: {
                    request = HttpAuthenticator.processAuthHeader(this.route.address.authenticator, response, this.route.proxy);
                    if (request != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }
}

