/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.ConfigAwareConnectionPool;
import com.android.okhttp.OkHttpClient;
import java.io.IOException;
import java.net.Proxy;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class HttpHandler
extends URLStreamHandler {
    private final ConfigAwareConnectionPool configAwareConnectionPool = ConfigAwareConnectionPool.getInstance();

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return this.newOkHttpClient(null).open(url);
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (url == null || proxy == null) {
            throw new IllegalArgumentException("url == null || proxy == null");
        }
        return this.newOkHttpClient(proxy).open(url);
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }

    protected OkHttpClient newOkHttpClient(Proxy proxy) {
        OkHttpClient okHttpClient = HttpHandler.createHttpOkHttpClient(proxy);
        okHttpClient.setConnectionPool(this.configAwareConnectionPool.get());
        return okHttpClient;
    }

    public static OkHttpClient createHttpOkHttpClient(Proxy proxy) {
        ResponseCache responseCache;
        OkHttpClient client = new OkHttpClient();
        client.setFollowProtocolRedirects(false);
        if (proxy != null) {
            client.setProxy(proxy);
        }
        if ((responseCache = ResponseCache.getDefault()) != null) {
            client.setResponseCache(responseCache);
        }
        return client;
    }
}

