/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.ConfigAwareConnectionPool;
import com.android.okhttp.HttpHandler;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.Protocol;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.DefaultHostnameVerifier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public final class HttpsHandler
extends HttpHandler {
    private static final List<Protocol> ENABLED_PROTOCOLS = Arrays.asList(Protocol.HTTP_11);
    private final ConfigAwareConnectionPool configAwareConnectionPool = ConfigAwareConnectionPool.getInstance();

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    @Override
    protected OkHttpClient newOkHttpClient(Proxy proxy) {
        OkHttpClient okHttpClient = HttpsHandler.createHttpsOkHttpClient(proxy);
        okHttpClient.setConnectionPool(this.configAwareConnectionPool.get());
        return okHttpClient;
    }

    public static OkHttpClient createHttpsOkHttpClient(Proxy proxy) {
        OkHttpClient client = HttpHandler.createHttpOkHttpClient(proxy);
        client.setProtocols(ENABLED_PROTOCOLS);
        HostnameVerifier verifier = HttpsURLConnection.getDefaultHostnameVerifier();
        if (!(verifier instanceof DefaultHostnameVerifier)) {
            client.setHostnameVerifier(verifier);
        }
        client.setSslSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory());
        return client;
    }
}

