/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal;

import com.android.okhttp.Protocol;
import com.android.okio.ByteString;
import com.android.org.conscrypt.OpenSSLSocketImpl;
import dalvik.system.SocketTagger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.net.ssl.SSLSocket;

public final class Platform {
    private static final Platform PLATFORM = new Platform();

    public static Platform get() {
        return PLATFORM;
    }

    public void logW(String warning) {
        System.logW((String)warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    public URI toUriLenient(URL url) throws URISyntaxException {
        return url.toURILenient();
    }

    public void enableTlsExtensions(SSLSocket socket, String uriHost) {
        if (socket instanceof OpenSSLSocketImpl) {
            OpenSSLSocketImpl openSSLSocket = (OpenSSLSocketImpl)socket;
            openSSLSocket.setUseSessionTickets(true);
            openSSLSocket.setHostname(uriHost);
        }
    }

    public void supportTlsIntolerantServer(SSLSocket socket) {
        String fallbackScsv = "TLS_FALLBACK_SCSV";
        boolean socketSupportsFallbackScsv = false;
        String[] supportedCipherSuites = socket.getSupportedCipherSuites();
        for (int i = supportedCipherSuites.length - 1; i >= 0; --i) {
            String supportedCipherSuite = supportedCipherSuites[i];
            if (!"TLS_FALLBACK_SCSV".equals(supportedCipherSuite)) continue;
            socketSupportsFallbackScsv = true;
            break;
        }
        if (socketSupportsFallbackScsv) {
            String[] enabledCipherSuites = socket.getEnabledCipherSuites();
            String[] newEnabledCipherSuites = new String[enabledCipherSuites.length + 1];
            System.arraycopy(enabledCipherSuites, 0, newEnabledCipherSuites, 0, enabledCipherSuites.length);
            newEnabledCipherSuites[newEnabledCipherSuites.length - 1] = "TLS_FALLBACK_SCSV";
            socket.setEnabledCipherSuites(newEnabledCipherSuites);
        }
        socket.setEnabledProtocols(new String[]{"SSLv3"});
    }

    public ByteString getNpnSelectedProtocol(SSLSocket socket) {
        if (!(socket instanceof OpenSSLSocketImpl)) {
            return null;
        }
        OpenSSLSocketImpl socketImpl = (OpenSSLSocketImpl)socket;
        byte[] alpnResult = socketImpl.getAlpnSelectedProtocol();
        if (alpnResult != null) {
            return ByteString.of(alpnResult);
        }
        byte[] npnResult = socketImpl.getNpnSelectedProtocol();
        return npnResult == null ? null : ByteString.of(npnResult);
    }

    public void setNpnProtocols(SSLSocket socket, List<Protocol> npnProtocols) {
        if (socket instanceof OpenSSLSocketImpl) {
            OpenSSLSocketImpl socketImpl = (OpenSSLSocketImpl)socket;
            byte[] protocols = Platform.concatLengthPrefixed(npnProtocols);
            socketImpl.setAlpnProtocols(protocols);
            socketImpl.setNpnProtocols(protocols);
        }
    }

    public OutputStream newDeflaterOutputStream(OutputStream out, Deflater deflater, boolean syncFlush) {
        return new DeflaterOutputStream(out, deflater, syncFlush);
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public String getPrefix() {
        return "X-Android";
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        int size = 0;
        for (Protocol protocol : protocols) {
            size += protocol.name.size() + 1;
        }
        byte[] result = new byte[size];
        int pos = 0;
        for (Protocol protocol : protocols) {
            int nameSize = protocol.name.size();
            result[pos++] = (byte)nameSize;
            System.arraycopy((byte[])protocol.name.toByteArray(), (int)0, (byte[])result, (int)pos, (int)nameSize);
            pos += nameSize;
        }
        return result;
    }
}

