/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.Connection;
import com.android.okhttp.Handshake;
import com.android.okhttp.Headers;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.Protocol;
import com.android.okhttp.Request;
import com.android.okhttp.Response;
import com.android.okhttp.Route;
import com.android.okhttp.internal.Platform;
import com.android.okhttp.internal.Util;
import com.android.okhttp.internal.http.HttpAuthenticator;
import com.android.okhttp.internal.http.HttpDate;
import com.android.okhttp.internal.http.HttpEngine;
import com.android.okhttp.internal.http.HttpMethod;
import com.android.okhttp.internal.http.OkHeaders;
import com.android.okhttp.internal.http.RetryableSink;
import com.android.okio.BufferedSink;
import com.android.okio.ByteString;
import com.android.okio.Sink;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpURLConnectionImpl
extends HttpURLConnection {
    public static final int MAX_REDIRECTS = 20;
    final OkHttpClient client;
    private Headers.Builder requestHeaders = new Headers.Builder();
    private long fixedContentLength = -1L;
    private int redirectionCount;
    protected IOException httpEngineFailure;
    protected HttpEngine httpEngine;
    private Route route;
    Handshake handshake;

    public HttpURLConnectionImpl(URL url, OkHttpClient client) {
        super(url);
        this.client = client;
    }

    @Override
    public final void connect() throws IOException {
        boolean success;
        this.initHttpEngine();
        while (!(success = this.execute(false))) {
        }
    }

    @Override
    public final void disconnect() {
        if (this.httpEngine != null) {
            this.httpEngine.close();
        }
    }

    @Override
    public final InputStream getErrorStream() {
        try {
            HttpEngine response = this.getResponse();
            if (response.hasResponseBody() && response.getResponse().code() >= 400) {
                return response.getResponseBodyBytes();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(int position) {
        try {
            return this.getResponse().getResponse().headers().value(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            Response response = this.getResponse().getResponse();
            return fieldName == null ? response.statusLine() : response.headers().get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderFieldKey(int position) {
        try {
            return this.getResponse().getResponse().headers().name(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        try {
            Response response = this.getResponse().getResponse();
            return OkHeaders.toMultimap(response.headers(), response.statusLine());
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return OkHeaders.toMultimap(this.requestHeaders.build(), null);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        HttpEngine response = this.getResponse();
        if (this.getResponseCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        InputStream result = response.getResponseBodyBytes();
        if (result == null) {
            throw new ProtocolException("No response body exists; responseCode=" + this.getResponseCode());
        }
        return result;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.connect();
        BufferedSink sink = this.httpEngine.getBufferedRequestBody();
        if (sink == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (this.httpEngine.hasResponse()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        return sink.outputStream();
    }

    @Override
    public final Permission getPermission() throws IOException {
        String hostName = this.getURL().getHost();
        int hostPort = Util.getEffectivePort(this.getURL());
        if (this.usingProxy()) {
            InetSocketAddress proxyAddress = (InetSocketAddress)this.client.getProxy().address();
            hostName = proxyAddress.getHostName();
            hostPort = proxyAddress.getPort();
        }
        return new SocketPermission(hostName + ":" + hostPort, "connect, resolve");
    }

    @Override
    public final String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.requestHeaders.get(field);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.client.setConnectTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.client.setReadTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getReadTimeout() {
        return this.client.getReadTimeout();
    }

    private void initHttpEngine() throws IOException {
        if (this.httpEngineFailure != null) {
            throw this.httpEngineFailure;
        }
        if (this.httpEngine != null) {
            return;
        }
        this.connected = true;
        try {
            if (this.doOutput) {
                if (this.method.equals("GET")) {
                    this.method = "POST";
                } else if (!HttpMethod.hasRequestBody(this.method)) {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            this.httpEngine = this.newHttpEngine(this.method, null, null, null);
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    private HttpEngine newHttpEngine(String method, Connection connection, RetryableSink requestBody, Response priorResponse) {
        Request.Builder builder = new Request.Builder().url(this.getURL()).method(method, null);
        Headers headers = this.requestHeaders.build();
        for (int i = 0; i < headers.size(); ++i) {
            builder.addHeader(headers.name(i), headers.value(i));
        }
        boolean bufferRequestBody = false;
        if (HttpMethod.hasRequestBody(method)) {
            if (this.fixedContentLength != -1L) {
                builder.header("Content-Length", Long.toString(this.fixedContentLength));
            } else if (this.chunkLength > 0) {
                builder.header("Transfer-Encoding", "chunked");
            } else {
                bufferRequestBody = true;
            }
        }
        Request request = builder.build();
        OkHttpClient engineClient = this.client;
        if (engineClient.getOkResponseCache() != null && !this.getUseCaches()) {
            engineClient = this.client.clone().setOkResponseCache(null);
        }
        return new HttpEngine(engineClient, request, bufferRequestBody, connection, null, requestBody, priorResponse);
    }

    private HttpEngine getResponse() throws IOException {
        this.initHttpEngine();
        if (this.httpEngine.hasResponse()) {
            return this.httpEngine;
        }
        while (true) {
            if (!this.execute(true)) {
                continue;
            }
            Response response = this.httpEngine.getResponse();
            Retry retry = this.processResponseHeaders();
            if (retry == Retry.NONE) {
                this.httpEngine.releaseConnection();
                return this.httpEngine;
            }
            String retryMethod = this.method;
            Sink requestBody = this.httpEngine.getRequestBody();
            int responseCode = this.httpEngine.getResponse().code();
            if (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303) {
                retryMethod = "GET";
                this.requestHeaders.removeAll("Content-Length");
                requestBody = null;
            }
            if (requestBody != null && !(requestBody instanceof RetryableSink)) {
                throw new HttpRetryException("Cannot retry streamed HTTP body", responseCode);
            }
            if (retry == Retry.DIFFERENT_CONNECTION) {
                this.httpEngine.releaseConnection();
            }
            Connection connection = this.httpEngine.close();
            this.httpEngine = this.newHttpEngine(retryMethod, connection, (RetryableSink)requestBody, response);
        }
    }

    private boolean execute(boolean readResponse) throws IOException {
        try {
            this.httpEngine.sendRequest();
            this.route = this.httpEngine.getRoute();
            Handshake handshake = this.handshake = this.httpEngine.getConnection() != null ? this.httpEngine.getConnection().getHandshake() : null;
            if (readResponse) {
                this.httpEngine.readResponse();
            }
            return true;
        }
        catch (IOException e) {
            HttpEngine retryEngine = this.httpEngine.recover(e);
            if (retryEngine != null) {
                this.httpEngine = retryEngine;
                return false;
            }
            this.httpEngineFailure = e;
            throw e;
        }
    }

    private Retry processResponseHeaders() throws IOException {
        Connection connection = this.httpEngine.getConnection();
        Proxy selectedProxy = connection != null ? connection.getRoute().getProxy() : this.client.getProxy();
        int responseCode = this.getResponseCode();
        switch (responseCode) {
            case 407: {
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                Request successorRequest = HttpAuthenticator.processAuthHeader(this.client.getAuthenticator(), this.httpEngine.getResponse(), selectedProxy);
                if (successorRequest == null) {
                    return Retry.NONE;
                }
                this.requestHeaders = successorRequest.getHeaders().newBuilder();
                return Retry.SAME_CONNECTION;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                boolean samePort;
                if (!this.getInstanceFollowRedirects()) {
                    return Retry.NONE;
                }
                if (++this.redirectionCount > 20) {
                    throw new ProtocolException("Too many redirects: " + this.redirectionCount);
                }
                if (responseCode == 307 && !this.method.equals("GET") && !this.method.equals("HEAD")) {
                    return Retry.NONE;
                }
                String location = this.getHeaderField("Location");
                if (location == null) {
                    return Retry.NONE;
                }
                URL previousUrl = this.url;
                this.url = new URL(previousUrl, location);
                if (!this.url.getProtocol().equals("https") && !this.url.getProtocol().equals("http")) {
                    return Retry.NONE;
                }
                boolean sameProtocol = previousUrl.getProtocol().equals(this.url.getProtocol());
                if (!sameProtocol && !this.client.getFollowProtocolRedirects()) {
                    return Retry.NONE;
                }
                boolean sameHost = previousUrl.getHost().equals(this.url.getHost());
                boolean bl = samePort = Util.getEffectivePort(previousUrl) == Util.getEffectivePort(this.url);
                if (sameHost && samePort && sameProtocol) {
                    return Retry.SAME_CONNECTION;
                }
                return Retry.DIFFERENT_CONNECTION;
            }
        }
        return Retry.NONE;
    }

    @Override
    public final boolean usingProxy() {
        Proxy proxy = this.route != null ? this.route.getProxy() : this.client.getProxy();
        return proxy != null && proxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse().getResponse().statusMessage();
    }

    @Override
    public final int getResponseCode() throws IOException {
        return this.getResponse().getResponse().code();
    }

    @Override
    public final void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (newValue == null) {
            Platform.get().logW("Ignoring header " + field + " because its value was null.");
            return;
        }
        if ("X-Android-Transports".equals(field) || "X-Android-Protocols".equals(field)) {
            this.setProtocols(newValue, false);
        } else {
            this.requestHeaders.set(field, newValue);
        }
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        super.setIfModifiedSince(newValue);
        if (this.ifModifiedSince != 0L) {
            this.requestHeaders.set("If-Modified-Since", HttpDate.format(new Date(this.ifModifiedSince)));
        } else {
            this.requestHeaders.removeAll("If-Modified-Since");
        }
    }

    @Override
    public final void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        if (value == null) {
            Platform.get().logW("Ignoring header " + field + " because its value was null.");
            return;
        }
        if ("X-Android-Transports".equals(field) || "X-Android-Protocols".equals(field)) {
            this.setProtocols(value, true);
        } else {
            this.requestHeaders.add(field, value);
        }
    }

    private void setProtocols(String protocolsString, boolean append) {
        ArrayList<Protocol> protocolsList = new ArrayList<Protocol>();
        if (append) {
            protocolsList.addAll(this.client.getProtocols());
        }
        for (String protocol : protocolsString.split(",", -1)) {
            try {
                protocolsList.add(Protocol.find(ByteString.encodeUtf8(protocol)));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.client.setProtocols(protocolsList);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (!HttpMethod.METHODS.contains(method)) {
            throw new ProtocolException("Expected one of " + HttpMethod.METHODS + " but was " + method);
        }
        this.method = method;
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        this.setFixedLengthStreamingMode((long)contentLength);
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.chunkLength > 0) {
            throw new IllegalStateException("Already in chunked mode");
        }
        if (contentLength < 0L) {
            throw new IllegalArgumentException("contentLength < 0");
        }
        this.fixedContentLength = contentLength;
        ((HttpURLConnection)this).fixedContentLength = (int)Math.min(contentLength, Integer.MAX_VALUE);
    }

    static enum Retry {
        NONE,
        SAME_CONNECTION,
        DIFFERENT_CONNECTION;

    }
}

