/*
 * Decompiled with CFR 0.152.
 */
package com.android.okio;

import com.android.okio.Base64;
import com.android.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class ByteString {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    private transient int hashCode;
    private transient String utf8;

    ByteString(byte[] data) {
        this.data = data;
    }

    public static ByteString of(byte ... data) {
        return new ByteString((byte[])data.clone());
    }

    public static ByteString encodeUtf8(String s) {
        ByteString byteString = new ByteString(s.getBytes(Util.UTF_8));
        byteString.utf8 = s;
        return byteString;
    }

    public String utf8() {
        String result = this.utf8;
        return result != null ? result : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public static ByteString decodeBase64(String base64) {
        byte[] decoded = Base64.decode(base64);
        return decoded != null ? new ByteString(decoded) : null;
    }

    public String hex() {
        char[] result = new char[this.data.length * 2];
        int c = 0;
        for (byte b : this.data) {
            result[c++] = HEX_DIGITS[b >> 4 & 0xF];
            result[c++] = HEX_DIGITS[b & 0xF];
        }
        return new String(result);
    }

    public static ByteString decodeHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + hex);
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int d1 = ByteString.decodeHexDigit(hex.charAt(i * 2)) << 4;
            int d2 = ByteString.decodeHexDigit(hex.charAt(i * 2 + 1));
            result[i] = (byte)(d1 + d2);
        }
        return ByteString.of(result);
    }

    private static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c);
    }

    public static ByteString read(InputStream in, int byteCount) throws IOException {
        int read;
        byte[] result = new byte[byteCount];
        for (int offset = 0; offset < byteCount; offset += read) {
            read = in.read(result, offset, byteCount - offset);
            if (read != -1) continue;
            throw new EOFException();
        }
        return new ByteString(result);
    }

    public ByteString toAsciiLowercase() {
        for (int i = 0; i < this.data.length; ++i) {
            byte c = this.data[i];
            if (c < 65 || c > 90) continue;
            byte[] lowercase = (byte[])this.data.clone();
            lowercase[i++] = (byte)(c - -32);
            while (i < lowercase.length) {
                c = lowercase[i];
                if (c >= 65 && c <= 90) {
                    lowercase[i] = (byte)(c - -32);
                }
                ++i;
            }
            return new ByteString(lowercase);
        }
        return this;
    }

    public byte getByte(int pos) {
        return this.data[pos];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ByteString && Arrays.equals(((ByteString)o).data, this.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        return result != 0 ? result : (this.hashCode = Arrays.hashCode(this.data));
    }

    public String toString() {
        if (this.data.length == 0) {
            return "ByteString[size=0]";
        }
        if (this.data.length <= 16) {
            return String.format("ByteString[size=%s data=%s]", this.data.length, this.hex());
        }
        try {
            return String.format("ByteString[size=%s md5=%s]", this.data.length, ByteString.of(MessageDigest.getInstance("MD5").digest(this.data)).hex());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

