/*
 * Decompiled with CFR 0.152.
 */
package com.android.okio;

import com.android.okio.BufferedSink;
import com.android.okio.BufferedSource;
import com.android.okio.ByteString;
import com.android.okio.Deadline;
import com.android.okio.Segment;
import com.android.okio.SegmentPool;
import com.android.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OkBuffer
implements BufferedSource,
BufferedSink,
Cloneable {
    Segment head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public OkBuffer buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                OkBuffer.this.writeByte((byte)b);
            }

            @Override
            public void write(byte[] data, int offset, int byteCount) {
                OkBuffer.this.write(data, offset, byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return this + ".outputStream()";
            }
        };
    }

    @Override
    public OkBuffer emitCompleteSegments() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long byteCount) throws EOFException {
        if (this.size < byteCount) {
            throw new EOFException();
        }
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                return OkBuffer.this.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] sink, int offset, int byteCount) {
                return OkBuffer.this.read(sink, offset, byteCount);
            }

            @Override
            public int available() {
                return (int)Math.min(OkBuffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return OkBuffer.this + ".inputStream()";
            }
        };
    }

    public long completeSegmentByteCount() {
        long result = this.size;
        if (result == 0L) {
            return 0L;
        }
        Segment tail = this.head.prev;
        if (tail.limit < 2048) {
            result -= (long)(tail.limit - tail.pos);
        }
        return result;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int pos = segment.pos;
        int limit = segment.limit;
        byte[] data = segment.data;
        byte b = data[pos++];
        --this.size;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return b;
    }

    public byte getByte(long pos) {
        Util.checkOffsetAndCount(this.size, pos, 1L);
        Segment s = this.head;
        int segmentByteCount;
        while (pos >= (long)(segmentByteCount = s.limit - s.pos)) {
            pos -= (long)segmentByteCount;
            s = s.next;
        }
        return s.data[s.pos + (int)pos];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int limit = segment.limit;
        int pos = segment.pos;
        if (limit - pos < 2) {
            int s = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)s;
        }
        byte[] data = segment.data;
        int s = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.size -= 2L;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return (short)s;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int limit = segment.limit;
        int pos = segment.pos;
        if (limit - pos < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] data = segment.data;
        int i = (data[pos++] & 0xFF) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
        this.size -= 4L;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return i;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int limit = segment.limit;
        int pos = segment.pos;
        if (limit - pos < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] data = segment.data;
        long v = ((long)data[pos++] & 0xFFL) << 56 | ((long)data[pos++] & 0xFFL) << 48 | ((long)data[pos++] & 0xFFL) << 40 | ((long)data[pos++] & 0xFFL) << 32 | ((long)data[pos++] & 0xFFL) << 24 | ((long)data[pos++] & 0xFFL) << 16 | ((long)data[pos++] & 0xFFL) << 8 | (long)data[pos++] & 0xFFL;
        this.size -= 8L;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return v;
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public ByteString readByteString(long byteCount) {
        return new ByteString(this.readBytes(byteCount));
    }

    @Override
    public String readUtf8(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment head = this.head;
        if ((long)head.pos + byteCount > (long)head.limit) {
            return new String(this.readBytes(byteCount), Util.UTF_8);
        }
        String result = new String(head.data, head.pos, (int)byteCount, Util.UTF_8);
        head.pos = (int)((long)head.pos + byteCount);
        this.size -= byteCount;
        if (head.pos == head.limit) {
            this.head = head.pop();
            SegmentPool.INSTANCE.recycle(head);
        }
        return result;
    }

    @Override
    public String readUtf8Line() throws IOException {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(newline);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            throw new EOFException();
        }
        return this.readUtf8Line(newline);
    }

    String readUtf8Line(long newline) {
        if (newline > 0L && this.getByte(newline - 1L) == 13) {
            String result = this.readUtf8(newline - 1L);
            this.skip(2L);
            return result;
        }
        String result = this.readUtf8(newline);
        this.skip(1L);
        return result;
    }

    private byte[] readBytes(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        int offset = 0;
        byte[] result = new byte[(int)byteCount];
        while ((long)offset < byteCount) {
            int toCopy = (int)Math.min(byteCount - (long)offset, (long)(this.head.limit - this.head.pos));
            System.arraycopy((byte[])this.head.data, (int)this.head.pos, (byte[])result, (int)offset, (int)toCopy);
            offset += toCopy;
            this.head.pos += toCopy;
            if (this.head.pos != this.head.limit) continue;
            Segment toRecycle = this.head;
            this.head = toRecycle.pop();
            SegmentPool.INSTANCE.recycle(toRecycle);
        }
        this.size -= byteCount;
        return result;
    }

    int read(byte[] sink, int offset, int byteCount) {
        Segment s = this.head;
        if (s == null) {
            return -1;
        }
        int toCopy = Math.min(byteCount, s.limit - s.pos);
        System.arraycopy((byte[])s.data, (int)s.pos, (byte[])sink, (int)offset, (int)toCopy);
        s.pos += toCopy;
        this.size -= (long)toCopy;
        if (s.pos == s.limit) {
            this.head = s.pop();
            SegmentPool.INSTANCE.recycle(s);
        }
        return toCopy;
    }

    public void clear() {
        this.skip(this.size);
    }

    @Override
    public void skip(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        this.size -= byteCount;
        while (byteCount > 0L) {
            int toSkip = (int)Math.min(byteCount, (long)(this.head.limit - this.head.pos));
            byteCount -= (long)toSkip;
            this.head.pos += toSkip;
            if (this.head.pos != this.head.limit) continue;
            Segment toRecycle = this.head;
            this.head = toRecycle.pop();
            SegmentPool.INSTANCE.recycle(toRecycle);
        }
    }

    @Override
    public OkBuffer write(ByteString byteString) {
        return this.write(byteString.data, 0, byteString.data.length);
    }

    @Override
    public OkBuffer writeUtf8(String string2) {
        byte[] data = string2.getBytes(Util.UTF_8);
        return this.write(data, 0, data.length);
    }

    @Override
    public OkBuffer write(byte[] source) {
        return this.write(source, 0, source.length);
    }

    @Override
    public OkBuffer write(byte[] source, int offset, int byteCount) {
        int limit = offset + byteCount;
        while (offset < limit) {
            Segment tail = this.writableSegment(1);
            int toCopy = Math.min(limit - offset, 2048 - tail.limit);
            System.arraycopy((byte[])source, (int)offset, (byte[])tail.data, (int)tail.limit, (int)toCopy);
            offset += toCopy;
            tail.limit += toCopy;
        }
        this.size += (long)byteCount;
        return this;
    }

    @Override
    public OkBuffer writeByte(int b) {
        Segment tail = this.writableSegment(1);
        tail.data[tail.limit++] = (byte)b;
        ++this.size;
        return this;
    }

    @Override
    public OkBuffer writeShort(int s) {
        Segment tail = this.writableSegment(2);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(s >>> 8 & 0xFF);
        data[limit++] = (byte)(s & 0xFF);
        tail.limit = limit;
        this.size += 2L;
        return this;
    }

    @Override
    public BufferedSink writeShortLe(int s) {
        return this.writeShort(Util.reverseBytesShort((short)s));
    }

    @Override
    public OkBuffer writeInt(int i) {
        Segment tail = this.writableSegment(4);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(i >>> 24 & 0xFF);
        data[limit++] = (byte)(i >>> 16 & 0xFF);
        data[limit++] = (byte)(i >>> 8 & 0xFF);
        data[limit++] = (byte)(i & 0xFF);
        tail.limit = limit;
        this.size += 4L;
        return this;
    }

    @Override
    public BufferedSink writeIntLe(int i) {
        return this.writeInt(Util.reverseBytesInt(i));
    }

    @Override
    public OkBuffer writeLong(long v) {
        Segment tail = this.writableSegment(8);
        byte[] data = tail.data;
        int limit = tail.limit;
        data[limit++] = (byte)(v >>> 56 & 0xFFL);
        data[limit++] = (byte)(v >>> 48 & 0xFFL);
        data[limit++] = (byte)(v >>> 40 & 0xFFL);
        data[limit++] = (byte)(v >>> 32 & 0xFFL);
        data[limit++] = (byte)(v >>> 24 & 0xFFL);
        data[limit++] = (byte)(v >>> 16 & 0xFFL);
        data[limit++] = (byte)(v >>> 8 & 0xFFL);
        data[limit++] = (byte)(v & 0xFFL);
        tail.limit = limit;
        this.size += 8L;
        return this;
    }

    @Override
    public BufferedSink writeLongLe(long v) {
        return this.writeLong(Util.reverseBytesLong(v));
    }

    Segment writableSegment(int minimumCapacity) {
        if (minimumCapacity < 1 || minimumCapacity > 2048) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.INSTANCE.take());
            return this.head.prev;
        }
        Segment tail = this.head.prev;
        if (tail.limit + minimumCapacity > 2048) {
            tail = tail.push(SegmentPool.INSTANCE.take());
        }
        return tail;
    }

    @Override
    public void write(OkBuffer source, long byteCount) {
        if (source == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            if (byteCount < (long)(source.head.limit - source.head.pos)) {
                Segment tail;
                Segment segment = tail = this.head != null ? this.head.prev : null;
                if (tail == null || byteCount + (long)(tail.limit - tail.pos) > 2048L) {
                    source.head = source.head.split((int)byteCount);
                } else {
                    source.head.writeTo(tail, (int)byteCount);
                    source.size -= byteCount;
                    this.size += byteCount;
                    return;
                }
            }
            Segment segmentToMove = source.head;
            long movedByteCount = segmentToMove.limit - segmentToMove.pos;
            source.head = segmentToMove.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segmentToMove);
            } else {
                Segment tail = this.head.prev;
                tail = tail.push(segmentToMove);
                tail.compact();
            }
            source.size -= movedByteCount;
            this.size += movedByteCount;
            byteCount -= movedByteCount;
        }
    }

    @Override
    public long read(OkBuffer sink, long byteCount) {
        if (this.size == 0L) {
            return -1L;
        }
        if (byteCount > this.size) {
            byteCount = this.size;
        }
        sink.write(this, byteCount);
        return byteCount;
    }

    @Override
    public OkBuffer deadline(Deadline deadline) {
        return this;
    }

    @Override
    public long indexOf(byte b) {
        return this.indexOf(b, 0L);
    }

    public long indexOf(byte b, long fromIndex) {
        Segment s = this.head;
        if (s == null) {
            return -1L;
        }
        long offset = 0L;
        do {
            int segmentByteCount;
            if (fromIndex > (long)(segmentByteCount = s.limit - s.pos)) {
                fromIndex -= (long)segmentByteCount;
            } else {
                byte[] data = s.data;
                long limit = s.limit;
                for (long pos = (long)s.pos + fromIndex; pos < limit; ++pos) {
                    if (data[(int)pos] != b) continue;
                    return offset + pos - (long)s.pos;
                }
                fromIndex = 0L;
            }
            offset += (long)segmentByteCount;
        } while ((s = s.next) != this.head);
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(this.head.limit - this.head.pos);
        Segment s = this.head.next;
        while (s != this.head) {
            result.add(s.limit - s.pos);
            s = s.next;
        }
        return result;
    }

    public boolean equals(Object o) {
        long count;
        if (!(o instanceof OkBuffer)) {
            return false;
        }
        OkBuffer that = (OkBuffer)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment sa = this.head;
        Segment sb = that.head;
        int posA = sa.pos;
        int posB = sb.pos;
        for (long pos = 0L; pos < this.size; pos += count) {
            count = Math.min(sa.limit - posA, sb.limit - posB);
            int i = 0;
            while ((long)i < count) {
                if (sa.data[posA++] != sb.data[posB++]) {
                    return false;
                }
                ++i;
            }
            if (posA == sa.limit) {
                sa = sa.next;
                posA = sa.pos;
            }
            if (posB != sb.limit) continue;
            sb = sb.next;
            posB = sb.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment s = this.head;
        if (s == null) {
            return 0;
        }
        int result = 1;
        do {
            int limit = s.limit;
            for (int pos = s.pos; pos < limit; ++pos) {
                result = 31 * result + s.data[pos];
            }
        } while ((s = s.next) != this.head);
        return result;
    }

    public String toString() {
        if (this.size == 0L) {
            return "OkBuffer[size=0]";
        }
        if (this.size <= 16L) {
            ByteString data = this.clone().readByteString(this.size);
            return String.format("OkBuffer[size=%s data=%s]", this.size, data.hex());
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
            Segment s = this.head.next;
            while (s != this.head) {
                md5.update(s.data, s.pos, s.limit - s.pos);
                s = s.next;
            }
            return String.format("OkBuffer[size=%s md5=%s]", this.size, ByteString.of(md5.digest()).hex());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    public OkBuffer clone() {
        OkBuffer result = new OkBuffer();
        if (this.size() == 0L) {
            return result;
        }
        result.write(this.head.data, this.head.pos, this.head.limit - this.head.pos);
        Segment s = this.head.next;
        while (s != this.head) {
            result.write(s.data, s.pos, s.limit - s.pos);
            s = s.next;
        }
        return result;
    }
}

