/*
 * Decompiled with CFR 0.152.
 */
package com.android.okio;

import com.android.okio.BufferedSource;
import com.android.okio.ByteString;
import com.android.okio.Deadline;
import com.android.okio.OkBuffer;
import com.android.okio.Source;
import com.android.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class RealBufferedSource
implements BufferedSource {
    public final OkBuffer buffer;
    public final Source source;
    private boolean closed;

    public RealBufferedSource(Source source, OkBuffer buffer) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.buffer = buffer;
        this.source = source;
    }

    public RealBufferedSource(Source source) {
        this(source, new OkBuffer());
    }

    @Override
    public OkBuffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(OkBuffer sink, long byteCount) throws IOException {
        long read;
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (read = this.source.read(this.buffer, 2048L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min(byteCount, this.buffer.size);
        return this.buffer.read(sink, toRead);
    }

    @Override
    public boolean exhausted() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 2048L) == -1L;
    }

    @Override
    public void require(long byteCount) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (this.buffer.size < byteCount) {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            throw new EOFException();
        }
    }

    @Override
    public byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString(long byteCount) throws IOException {
        this.require(byteCount);
        return this.buffer.readByteString(byteCount);
    }

    @Override
    public String readUtf8(long byteCount) throws IOException {
        this.require(byteCount);
        return this.buffer.readUtf8(byteCount);
    }

    @Override
    public String readUtf8Line() throws IOException {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        return this.buffer.readUtf8Line(newline);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            throw new EOFException();
        }
        return this.buffer.readUtf8Line(newline);
    }

    @Override
    public short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public void skip(long byteCount) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (byteCount > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 2048L) == -1L) {
                throw new EOFException();
            }
            long toSkip = Math.min(byteCount, this.buffer.size());
            this.buffer.skip(toSkip);
            byteCount -= toSkip;
        }
    }

    @Override
    public long indexOf(byte b) throws IOException {
        long index;
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long start = 0L;
        while ((index = this.buffer.indexOf(b, start)) == -1L) {
            start = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
        }
        return index;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                long count;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                if (RealBufferedSource.this.buffer.size == 0L && (count = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] data, int offset, int byteCount) throws IOException {
                long count;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                Util.checkOffsetAndCount(data.length, offset, byteCount);
                if (RealBufferedSource.this.buffer.size == 0L && (count = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(data, offset, byteCount);
            }

            @Override
            public int available() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public Source deadline(Deadline deadline) {
        this.source.deadline(deadline);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

