/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import com.android.server.IoThread;

class BluetoothManagerService
extends IBluetoothManager.Stub {
    private static final String TAG = "BluetoothManagerService";
    private static final boolean DBG = true;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String ACTION_SERVICE_STATE_CHANGED = "com.android.bluetooth.btservice.action.STATE_CHANGED";
    private static final String EXTRA_ACTION = "action";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDR_VALID = "bluetooth_addr_valid";
    private static final String SECURE_SETTINGS_BLUETOOTH_ADDRESS = "bluetooth_address";
    private static final String SECURE_SETTINGS_BLUETOOTH_NAME = "bluetooth_name";
    private static final int TIMEOUT_BIND_MS = 3000;
    private static final int TIMEOUT_SAVE_MS = 500;
    private static final int SERVICE_RESTART_TIME_MS = 200;
    private static final int ERROR_RESTART_TIME_MS = 3000;
    private static final int USER_SWITCHED_TIME_MS = 200;
    private static final int MESSAGE_ENABLE = 1;
    private static final int MESSAGE_DISABLE = 2;
    private static final int MESSAGE_REGISTER_ADAPTER = 20;
    private static final int MESSAGE_UNREGISTER_ADAPTER = 21;
    private static final int MESSAGE_REGISTER_STATE_CHANGE_CALLBACK = 30;
    private static final int MESSAGE_UNREGISTER_STATE_CHANGE_CALLBACK = 31;
    private static final int MESSAGE_BLUETOOTH_SERVICE_CONNECTED = 40;
    private static final int MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED = 41;
    private static final int MESSAGE_RESTART_BLUETOOTH_SERVICE = 42;
    private static final int MESSAGE_BLUETOOTH_STATE_CHANGE = 60;
    private static final int MESSAGE_TIMEOUT_BIND = 100;
    private static final int MESSAGE_TIMEOUT_UNBIND = 101;
    private static final int MESSAGE_GET_NAME_AND_ADDRESS = 200;
    private static final int MESSAGE_SAVE_NAME_AND_ADDRESS = 201;
    private static final int MESSAGE_USER_SWITCHED = 300;
    private static final int MAX_SAVE_RETRIES = 3;
    private static final int MAX_ERROR_RESTART_RETRIES = 6;
    private static final int BLUETOOTH_OFF = 0;
    private static final int BLUETOOTH_ON_BLUETOOTH = 1;
    private static final int BLUETOOTH_ON_AIRPLANE = 2;
    private static final int SERVICE_IBLUETOOTH = 1;
    private static final int SERVICE_IBLUETOOTHGATT = 2;
    private final Context mContext;
    private String mAddress;
    private String mName;
    private final ContentResolver mContentResolver;
    private final RemoteCallbackList<IBluetoothManagerCallback> mCallbacks;
    private final RemoteCallbackList<IBluetoothStateChangeCallback> mStateChangeCallbacks;
    private IBluetooth mBluetooth;
    private IBluetoothGatt mBluetoothGatt;
    private boolean mBinding;
    private boolean mUnbinding;
    private boolean mQuietEnable = false;
    private boolean mQuietEnableExternal;
    private boolean mEnableExternal;
    private boolean mEnable;
    private int mState;
    private final BluetoothHandler mHandler;
    private int mErrorRecoveryRetryCounter;
    private final int mSystemUiUid;
    private final IBluetoothCallback mBluetoothCallback = new IBluetoothCallback.Stub(){

        @Override
        public void onBluetoothStateChange(int prevState, int newState) throws RemoteException {
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(60, prevState, newState);
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED".equals(action)) {
                String newName = intent.getStringExtra("android.bluetooth.adapter.extra.LOCAL_NAME");
                Log.d(BluetoothManagerService.TAG, "Bluetooth Adapter name changed to " + newName);
                if (newName != null) {
                    BluetoothManagerService.this.storeNameAndAddress(newName, null);
                }
            } else {
                if ("android.intent.action.AIRPLANE_MODE".equals(action)) {
                    BroadcastReceiver broadcastReceiver = BluetoothManagerService.this.mReceiver;
                    synchronized (broadcastReceiver) {
                        if (BluetoothManagerService.this.isBluetoothPersistedStateOn()) {
                            if (BluetoothManagerService.this.isAirplaneModeOn()) {
                                BluetoothManagerService.this.persistBluetoothSetting(2);
                            } else {
                                BluetoothManagerService.this.persistBluetoothSetting(1);
                            }
                        }
                        if (BluetoothManagerService.this.isAirplaneModeOn()) {
                            BluetoothManagerService.this.sendDisableMsg();
                        } else if (BluetoothManagerService.this.mEnableExternal) {
                            BluetoothManagerService.this.sendEnableMsg(BluetoothManagerService.this.mQuietEnableExternal);
                        }
                    }
                }
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    BluetoothManagerService.this.mHandler.sendMessage(BluetoothManagerService.this.mHandler.obtainMessage(300, intent.getIntExtra("android.intent.extra.user_handle", 0), 0));
                } else if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
                    BroadcastReceiver broadcastReceiver = BluetoothManagerService.this.mReceiver;
                    synchronized (broadcastReceiver) {
                        if (BluetoothManagerService.this.mEnableExternal && BluetoothManagerService.this.isBluetoothPersistedStateOnBluetooth()) {
                            Log.d(BluetoothManagerService.TAG, "Auto-enabling Bluetooth.");
                            BluetoothManagerService.this.sendEnableMsg(BluetoothManagerService.this.mQuietEnableExternal);
                        }
                    }
                    if (!BluetoothManagerService.this.isNameAndAddressSet()) {
                        Log.d(BluetoothManagerService.TAG, "Retrieving Bluetooth Adapter name and address...");
                        BluetoothManagerService.this.getNameAndAddress();
                    }
                }
            }
        }
    };
    private BluetoothServiceConnection mConnection = new BluetoothServiceConnection();

    private void registerForAirplaneMode(IntentFilter filter) {
        boolean mIsAirplaneSensitive;
        ContentResolver resolver = this.mContext.getContentResolver();
        String airplaneModeRadios = Settings.Global.getString(resolver, "airplane_mode_radios");
        String toggleableRadios = Settings.Global.getString(resolver, "airplane_mode_toggleable_radios");
        boolean bl = mIsAirplaneSensitive = airplaneModeRadios == null ? true : airplaneModeRadios.contains("bluetooth");
        if (mIsAirplaneSensitive) {
            filter.addAction("android.intent.action.AIRPLANE_MODE");
        }
    }

    BluetoothManagerService(Context context) {
        this.mHandler = new BluetoothHandler(IoThread.get().getLooper());
        this.mContext = context;
        this.mBluetooth = null;
        this.mBinding = false;
        this.mUnbinding = false;
        this.mEnable = false;
        this.mState = 10;
        this.mQuietEnableExternal = false;
        this.mEnableExternal = false;
        this.mAddress = null;
        this.mName = null;
        this.mErrorRecoveryRetryCounter = 0;
        this.mContentResolver = context.getContentResolver();
        this.mCallbacks = new RemoteCallbackList();
        this.mStateChangeCallbacks = new RemoteCallbackList();
        IntentFilter filter = new IntentFilter("android.intent.action.BOOT_COMPLETED");
        filter.addAction("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        this.registerForAirplaneMode(filter);
        filter.setPriority(1000);
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.loadStoredNameAndAddress();
        if (this.isBluetoothPersistedStateOn()) {
            this.mEnableExternal = true;
        }
        int sysUiUid = -1;
        try {
            sysUiUid = this.mContext.getPackageManager().getPackageUid("com.android.systemui", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.wtf(TAG, "Unable to resolve SystemUI's UID.", e);
        }
        this.mSystemUiUid = sysUiUid;
    }

    private final boolean isAirplaneModeOn() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    private final boolean isBluetoothPersistedStateOn() {
        return Settings.Global.getInt(this.mContentResolver, "bluetooth_on", 0) != 0;
    }

    private final boolean isBluetoothPersistedStateOnBluetooth() {
        return Settings.Global.getInt(this.mContentResolver, "bluetooth_on", 0) == 1;
    }

    private void persistBluetoothSetting(int value) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "bluetooth_on", value);
    }

    private boolean isNameAndAddressSet() {
        return this.mName != null && this.mAddress != null && this.mName.length() > 0 && this.mAddress.length() > 0;
    }

    private void loadStoredNameAndAddress() {
        Log.d(TAG, "Loading stored name and address");
        if (this.mContext.getResources().getBoolean(17956929) && Settings.Secure.getInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 0) == 0) {
            Log.d(TAG, "invalid bluetooth name and address stored");
            return;
        }
        this.mName = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME);
        this.mAddress = Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS);
        Log.d(TAG, "Stored bluetooth Name=" + this.mName + ",Address=" + this.mAddress);
    }

    private void storeNameAndAddress(String name, String address) {
        if (name != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME, name);
            this.mName = name;
            Log.d(TAG, "Stored Bluetooth name: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_NAME));
        }
        if (address != null) {
            Settings.Secure.putString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS, address);
            this.mAddress = address;
            Log.d(TAG, "Stored Bluetoothaddress: " + Settings.Secure.getString(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDRESS));
        }
        if (name != null && address != null) {
            Settings.Secure.putInt(this.mContentResolver, SECURE_SETTINGS_BLUETOOTH_ADDR_VALID, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBluetooth registerAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Log.w(TAG, "Callback is null in registerAdapter");
            return null;
        }
        Message msg = this.mHandler.obtainMessage(20);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            return this.mBluetooth;
        }
    }

    @Override
    public void unregisterAdapter(IBluetoothManagerCallback callback) {
        if (callback == null) {
            Log.w(TAG, "Callback is null in unregisterAdapter");
            return;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(21);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void registerStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(30);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void unregisterStateChangeCallback(IBluetoothStateChangeCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Message msg = this.mHandler.obtainMessage(31);
        msg.obj = callback;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Log.w(TAG, "isEnabled(): not allowed for non-active and non system user");
            return false;
        }
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            try {
                return this.mBluetooth != null && this.mBluetooth.isEnabled();
            }
            catch (RemoteException e) {
                Log.e(TAG, "isEnabled()", e);
            }
        }
        return false;
    }

    public void getNameAndAddress() {
        Log.d(TAG, "getNameAndAddress(): mBluetooth = " + this.mBluetooth + " mBinding = " + this.mBinding);
        Message msg = this.mHandler.obtainMessage(200);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableNoAutoConnect() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
        Log.d(TAG, "enableNoAutoConnect():  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding);
        int callingAppId = UserHandle.getAppId(Binder.getCallingUid());
        if (callingAppId != 1027) {
            throw new SecurityException("no permission to enable Bluetooth quietly");
        }
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = true;
            this.mEnableExternal = true;
            this.sendEnableMsg(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enable() {
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Log.w(TAG, "enable(): not allowed for non-active and non system user");
            return false;
        }
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permission");
        Log.d(TAG, "enable():  mBluetooth =" + this.mBluetooth + " mBinding = " + this.mBinding);
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            this.mQuietEnableExternal = false;
            this.mEnableExternal = true;
            long callingIdentity = Binder.clearCallingIdentity();
            this.persistBluetoothSetting(1);
            Binder.restoreCallingIdentity(callingIdentity);
            this.sendEnableMsg(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable(boolean persist) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH ADMIN permissicacheNameAndAddresson");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Log.w(TAG, "disable(): not allowed for non-active and non system user");
            return false;
        }
        Log.d(TAG, "disable(): mBluetooth = " + this.mBluetooth + " mBinding = " + this.mBinding);
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        synchronized (broadcastReceiver) {
            if (persist) {
                long callingIdentity = Binder.clearCallingIdentity();
                this.persistBluetoothSetting(0);
                Binder.restoreCallingIdentity(callingIdentity);
            }
            this.mEnableExternal = false;
            this.sendDisableMsg();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAndFinish() {
        Log.d(TAG, "unbindAndFinish(): " + this.mBluetooth + " mBinding = " + this.mBinding);
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mUnbinding) {
                return;
            }
            this.mUnbinding = true;
            if (this.mBluetooth != null) {
                if (!this.mConnection.isGetNameAddressOnly()) {
                    try {
                        this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
                    }
                    catch (RemoteException re) {
                        Log.e(TAG, "Unable to unregister BluetoothCallback", re);
                    }
                }
                Log.d(TAG, "Sending unbind request.");
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
                this.mUnbinding = false;
                this.mBinding = false;
            } else {
                this.mUnbinding = false;
            }
        }
    }

    @Override
    public IBluetoothGatt getBluetoothGatt() {
        return this.mBluetoothGatt;
    }

    private void sendBluetoothStateCallback(boolean isUp) {
        int n = this.mStateChangeCallbacks.beginBroadcast();
        Log.d(TAG, "Broadcasting onBluetoothStateChange(" + isUp + ") to " + n + " receivers.");
        for (int i = 0; i < n; ++i) {
            try {
                this.mStateChangeCallbacks.getBroadcastItem(i).onBluetoothStateChange(isUp);
                continue;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to call onBluetoothStateChange() on callback #" + i, e);
            }
        }
        this.mStateChangeCallbacks.finishBroadcast();
    }

    private void sendBluetoothServiceUpCallback() {
        if (!this.mConnection.isGetNameAddressOnly()) {
            Log.d(TAG, "Calling onBluetoothServiceUp callbacks");
            int n = this.mCallbacks.beginBroadcast();
            Log.d(TAG, "Broadcasting onBluetoothServiceUp() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceUp(this.mBluetooth);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to call onBluetoothServiceUp() on callback #" + i, e);
                }
            }
            this.mCallbacks.finishBroadcast();
        }
    }

    private void sendBluetoothServiceDownCallback() {
        if (!this.mConnection.isGetNameAddressOnly()) {
            Log.d(TAG, "Calling onBluetoothServiceDown callbacks");
            int n = this.mCallbacks.beginBroadcast();
            Log.d(TAG, "Broadcasting onBluetoothServiceDown() to " + n + " receivers.");
            for (int i = 0; i < n; ++i) {
                try {
                    this.mCallbacks.getBroadcastItem(i).onBluetoothServiceDown();
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to call onBluetoothServiceDown() on callback #" + i, e);
                }
            }
            this.mCallbacks.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAddress() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Log.w(TAG, "getAddress(): not allowed for non-active and non system user");
            return null;
        }
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth != null) {
                try {
                    return this.mBluetooth.getAddress();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "getAddress(): Unable to retrieve address remotely..Returning cached address", e);
                }
            }
        }
        return this.mAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (Binder.getCallingUid() != 1000 && !this.checkIfCallerIsForegroundUser()) {
            Log.w(TAG, "getName(): not allowed for non-active and non system user");
            return null;
        }
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth != null) {
                try {
                    return this.mBluetooth.getName();
                }
                catch (RemoteException e) {
                    Log.e(TAG, "getName(): Unable to retrieve name remotely..Returning cached name", e);
                }
            }
        }
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnable(boolean quietMode) {
        this.mQuietEnable = quietMode;
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth == null && !this.mBinding) {
                Message timeoutMsg = this.mHandler.obtainMessage(100);
                this.mHandler.sendMessageDelayed(timeoutMsg, 3000L);
                this.mConnection.setGetNameAddressOnly(false);
                Intent i = new Intent(IBluetooth.class.getName());
                if (!this.doBind(i, this.mConnection, 65, UserHandle.CURRENT)) {
                    this.mHandler.removeMessages(100);
                } else {
                    this.mBinding = true;
                }
            } else if (this.mBluetooth != null) {
                if (this.mConnection.isGetNameAddressOnly()) {
                    this.mConnection.setGetNameAddressOnly(false);
                    try {
                        this.mBluetooth.registerCallback(this.mBluetoothCallback);
                    }
                    catch (RemoteException re) {
                        Log.e(TAG, "Unable to register BluetoothCallback", re);
                    }
                    this.sendBluetoothServiceUpCallback();
                }
                try {
                    if (!this.mQuietEnable) {
                        if (!this.mBluetooth.enable()) {
                            Log.e(TAG, "IBluetooth.enable() returned false");
                        }
                    } else if (!this.mBluetooth.enableNoAutoConnect()) {
                        Log.e(TAG, "IBluetooth.enableNoAutoConnect() returned false");
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to call enable()", e);
                }
            }
        }
    }

    boolean doBind(Intent intent, ServiceConnection conn, int flags, UserHandle user) {
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, conn, flags, user)) {
            Log.e(TAG, "Fail to bind to: " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisable() {
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth != null && !this.mConnection.isGetNameAddressOnly()) {
                Log.d(TAG, "Sending off request.");
                try {
                    if (!this.mBluetooth.disable()) {
                        Log.e(TAG, "IBluetooth.disable() returned false");
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to call disable()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfCallerIsForegroundUser() {
        int callingUser = UserHandle.getCallingUserId();
        int callingUid = Binder.getCallingUid();
        long callingIdentity = Binder.clearCallingIdentity();
        int callingAppId = UserHandle.getAppId(callingUid);
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            valid = callingUser == foregroundUser || callingAppId == 1027 || callingAppId == this.mSystemUiUid;
            Log.d(TAG, "checkIfCallerIsForegroundUser: valid=" + valid + " callingUser=" + callingUser + " foregroundUser=" + foregroundUser);
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return valid;
    }

    private void bluetoothStateChangeHandler(int prevState, int newState) {
        if (prevState != newState) {
            if (newState == 12 || newState == 10) {
                boolean isUp = newState == 12;
                this.sendBluetoothStateCallback(isUp);
                if (isUp) {
                    if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                        Intent i = new Intent(IBluetoothGatt.class.getName());
                        this.doBind(i, this.mConnection, 65, UserHandle.CURRENT);
                    }
                } else if (!isUp && this.canUnbindBluetoothService()) {
                    this.sendBluetoothServiceDownCallback();
                    this.unbindAndFinish();
                }
            }
            Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", prevState);
            intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
            intent.addFlags(0x4000000);
            Log.d(TAG, "Bluetooth State Change Intent: " + prevState + " -> " + newState);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, BLUETOOTH_PERM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForOnOff(boolean on, boolean off) {
        for (int i = 0; i < 10; ++i) {
            BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
            synchronized (bluetoothServiceConnection) {
                try {
                    if (this.mBluetooth == null) {
                        break;
                    }
                    if (on) {
                        if (this.mBluetooth.getState() == 12) {
                            return true;
                        }
                    } else if (off) {
                        if (this.mBluetooth.getState() == 10) {
                            return true;
                        }
                    } else if (this.mBluetooth.getState() != 12) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "getState()", e);
                    break;
                }
            }
            if (on || off) {
                SystemClock.sleep(300L);
                continue;
            }
            SystemClock.sleep(50L);
        }
        Log.e(TAG, "waitForOnOff time out");
        return false;
    }

    private void sendDisableMsg() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    private void sendEnableMsg(boolean quietMode) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, quietMode ? 1 : 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canUnbindBluetoothService() {
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            try {
                if (this.mEnable || this.mBluetooth == null) {
                    return false;
                }
                if (this.mHandler.hasMessages(60)) {
                    return false;
                }
                return this.mBluetooth.getState() == 10;
            }
            catch (RemoteException e) {
                Log.e(TAG, "getState()", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverBluetoothServiceFromError() {
        Log.e(TAG, "recoverBluetoothServiceFromError");
        BluetoothServiceConnection bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth != null) {
                try {
                    this.mBluetooth.unregisterCallback(this.mBluetoothCallback);
                }
                catch (RemoteException re) {
                    Log.e(TAG, "Unable to unregister", re);
                }
            }
        }
        SystemClock.sleep(500L);
        this.handleDisable();
        this.waitForOnOff(false, true);
        this.sendBluetoothServiceDownCallback();
        bluetoothServiceConnection = this.mConnection;
        synchronized (bluetoothServiceConnection) {
            if (this.mBluetooth != null) {
                this.mBluetooth = null;
                this.mContext.unbindService(this.mConnection);
            }
        }
        this.mHandler.removeMessages(60);
        this.mState = 10;
        this.mEnable = false;
        if (this.mErrorRecoveryRetryCounter++ < 6) {
            Message restartMsg = this.mHandler.obtainMessage(42);
            this.mHandler.sendMessageDelayed(restartMsg, 3000L);
        }
    }

    private class BluetoothHandler
    extends Handler {
        public BluetoothHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Log.d(BluetoothManagerService.TAG, "Message: " + msg.what);
            switch (msg.what) {
                case 200: {
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_GET_NAME_AND_ADDRESS");
                    BluetoothServiceConnection bluetoothServiceConnection = BluetoothManagerService.this.mConnection;
                    synchronized (bluetoothServiceConnection) {
                        if (BluetoothManagerService.this.mBluetooth == null && !BluetoothManagerService.this.mBinding) {
                            Log.d(BluetoothManagerService.TAG, "Binding to service to get name and address");
                            BluetoothManagerService.this.mConnection.setGetNameAddressOnly(true);
                            Message timeoutMsg = BluetoothManagerService.this.mHandler.obtainMessage(100);
                            BluetoothManagerService.this.mHandler.sendMessageDelayed(timeoutMsg, 3000L);
                            Intent i = new Intent(IBluetooth.class.getName());
                            if (!BluetoothManagerService.this.doBind(i, BluetoothManagerService.this.mConnection, 65, UserHandle.CURRENT)) {
                                BluetoothManagerService.this.mHandler.removeMessages(100);
                            } else {
                                BluetoothManagerService.this.mBinding = true;
                            }
                        } else {
                            Message saveMsg = BluetoothManagerService.this.mHandler.obtainMessage(201);
                            saveMsg.arg1 = 0;
                            if (BluetoothManagerService.this.mBluetooth != null) {
                                BluetoothManagerService.this.mHandler.sendMessage(saveMsg);
                            } else {
                                BluetoothManagerService.this.mHandler.sendMessageDelayed(saveMsg, 500L);
                            }
                        }
                        break;
                    }
                }
                case 201: {
                    boolean unbind = false;
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_SAVE_NAME_AND_ADDRESS");
                    BluetoothServiceConnection saveMsg = BluetoothManagerService.this.mConnection;
                    synchronized (saveMsg) {
                        if (!BluetoothManagerService.this.mEnable && BluetoothManagerService.this.mBluetooth != null) {
                            try {
                                BluetoothManagerService.this.mBluetooth.enable();
                            }
                            catch (RemoteException e) {
                                Log.e(BluetoothManagerService.TAG, "Unable to call enable()", e);
                            }
                        }
                    }
                    if (BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothManagerService.this.waitForOnOff(true, false);
                    }
                    saveMsg = BluetoothManagerService.this.mConnection;
                    synchronized (saveMsg) {
                        if (BluetoothManagerService.this.mBluetooth != null) {
                            String name = null;
                            String address = null;
                            try {
                                name = BluetoothManagerService.this.mBluetooth.getName();
                                address = BluetoothManagerService.this.mBluetooth.getAddress();
                            }
                            catch (RemoteException re) {
                                Log.e(BluetoothManagerService.TAG, "", re);
                            }
                            if (name != null && address != null) {
                                BluetoothManagerService.this.storeNameAndAddress(name, address);
                                if (BluetoothManagerService.this.mConnection.isGetNameAddressOnly()) {
                                    unbind = true;
                                }
                            } else if (msg.arg1 < 3) {
                                Message retryMsg = BluetoothManagerService.this.mHandler.obtainMessage(201);
                                retryMsg.arg1 = 1 + msg.arg1;
                                Log.d(BluetoothManagerService.TAG, "Retrying name/address remote retrieval and save.....Retry count =" + retryMsg.arg1);
                                BluetoothManagerService.this.mHandler.sendMessageDelayed(retryMsg, 500L);
                            } else {
                                Log.w(BluetoothManagerService.TAG, "Maximum name/address remote retrieval retry exceeded");
                                if (BluetoothManagerService.this.mConnection.isGetNameAddressOnly()) {
                                    unbind = true;
                                }
                            }
                            if (!BluetoothManagerService.this.mEnable) {
                                try {
                                    BluetoothManagerService.this.mBluetooth.disable();
                                }
                                catch (RemoteException e) {
                                    Log.e(BluetoothManagerService.TAG, "Unable to call disable()", e);
                                }
                            }
                        } else {
                            Message getMsg = BluetoothManagerService.this.mHandler.obtainMessage(200);
                            BluetoothManagerService.this.mHandler.sendMessage(getMsg);
                        }
                    }
                    if (!BluetoothManagerService.this.mEnable && BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothManagerService.this.waitForOnOff(false, true);
                    }
                    if (!unbind) break;
                    BluetoothManagerService.this.unbindAndFinish();
                    break;
                }
                case 1: {
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_ENABLE: mBluetooth = " + BluetoothManagerService.this.mBluetooth);
                    BluetoothManagerService.this.mHandler.removeMessages(42);
                    BluetoothManagerService.this.mEnable = true;
                    BluetoothManagerService.this.handleEnable(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    BluetoothManagerService.this.mHandler.removeMessages(42);
                    if (BluetoothManagerService.this.mEnable && BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothManagerService.this.waitForOnOff(true, false);
                        BluetoothManagerService.this.mEnable = false;
                        BluetoothManagerService.this.handleDisable();
                        BluetoothManagerService.this.waitForOnOff(false, false);
                        break;
                    }
                    BluetoothManagerService.this.mEnable = false;
                    BluetoothManagerService.this.handleDisable();
                    break;
                }
                case 20: {
                    IBluetoothManagerCallback callback = (IBluetoothManagerCallback)msg.obj;
                    boolean added = BluetoothManagerService.this.mCallbacks.register(callback);
                    Log.d(BluetoothManagerService.TAG, "Added callback: " + (callback == null ? "null" : callback) + ":" + added);
                    break;
                }
                case 21: {
                    IBluetoothManagerCallback callback = (IBluetoothManagerCallback)msg.obj;
                    boolean removed = BluetoothManagerService.this.mCallbacks.unregister(callback);
                    Log.d(BluetoothManagerService.TAG, "Removed callback: " + (callback == null ? "null" : callback) + ":" + removed);
                    break;
                }
                case 30: {
                    IBluetoothStateChangeCallback callback = (IBluetoothStateChangeCallback)msg.obj;
                    if (callback == null) break;
                    BluetoothManagerService.this.mStateChangeCallbacks.register(callback);
                    break;
                }
                case 31: {
                    IBluetoothStateChangeCallback callback = (IBluetoothStateChangeCallback)msg.obj;
                    if (callback == null) break;
                    BluetoothManagerService.this.mStateChangeCallbacks.unregister(callback);
                    break;
                }
                case 40: {
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_BLUETOOTH_SERVICE_CONNECTED: " + msg.arg1);
                    IBinder service = (IBinder)msg.obj;
                    BluetoothServiceConnection removed = BluetoothManagerService.this.mConnection;
                    synchronized (removed) {
                        if (msg.arg1 == 2) {
                            BluetoothManagerService.this.mBluetoothGatt = IBluetoothGatt.Stub.asInterface(service);
                            break;
                        }
                        BluetoothManagerService.this.mHandler.removeMessages(100);
                        BluetoothManagerService.this.mBinding = false;
                        BluetoothManagerService.this.mBluetooth = IBluetooth.Stub.asInterface(service);
                        try {
                            boolean enableHciSnoopLog;
                            boolean bl = enableHciSnoopLog = Settings.Secure.getInt(BluetoothManagerService.this.mContentResolver, "bluetooth_hci_log", 0) == 1;
                            if (!BluetoothManagerService.this.mBluetooth.configHciSnoopLog(enableHciSnoopLog)) {
                                Log.e(BluetoothManagerService.TAG, "IBluetooth.configHciSnoopLog return false");
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(BluetoothManagerService.TAG, "Unable to call configHciSnoopLog", e);
                        }
                        if (BluetoothManagerService.this.mConnection.isGetNameAddressOnly()) {
                            Message getMsg = BluetoothManagerService.this.mHandler.obtainMessage(200);
                            BluetoothManagerService.this.mHandler.sendMessage(getMsg);
                            if (!BluetoothManagerService.this.mEnable) {
                                return;
                            }
                        }
                        BluetoothManagerService.this.mConnection.setGetNameAddressOnly(false);
                        try {
                            BluetoothManagerService.this.mBluetooth.registerCallback(BluetoothManagerService.this.mBluetoothCallback);
                        }
                        catch (RemoteException re) {
                            Log.e(BluetoothManagerService.TAG, "Unable to register BluetoothCallback", re);
                        }
                        BluetoothManagerService.this.sendBluetoothServiceUpCallback();
                        try {
                            if (!BluetoothManagerService.this.mQuietEnable) {
                                if (!BluetoothManagerService.this.mBluetooth.enable()) {
                                    Log.e(BluetoothManagerService.TAG, "IBluetooth.enable() returned false");
                                }
                            } else if (!BluetoothManagerService.this.mBluetooth.enableNoAutoConnect()) {
                                Log.e(BluetoothManagerService.TAG, "IBluetooth.enableNoAutoConnect() returned false");
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(BluetoothManagerService.TAG, "Unable to call enable()", e);
                        }
                    }
                    if (BluetoothManagerService.this.mEnable) break;
                    BluetoothManagerService.this.waitForOnOff(true, false);
                    BluetoothManagerService.this.handleDisable();
                    BluetoothManagerService.this.waitForOnOff(false, false);
                    break;
                }
                case 100: {
                    Log.e(BluetoothManagerService.TAG, "MESSAGE_TIMEOUT_BIND");
                    BluetoothServiceConnection service = BluetoothManagerService.this.mConnection;
                    synchronized (service) {
                        BluetoothManagerService.this.mBinding = false;
                        break;
                    }
                }
                case 60: {
                    int prevState = msg.arg1;
                    int newState = msg.arg2;
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_BLUETOOTH_STATE_CHANGE: prevState = " + prevState + ", newState=" + newState);
                    BluetoothManagerService.this.mState = newState;
                    BluetoothManagerService.this.bluetoothStateChangeHandler(prevState, newState);
                    if (prevState == 11 && newState == 10 && BluetoothManagerService.this.mBluetooth != null && BluetoothManagerService.this.mEnable) {
                        BluetoothManagerService.this.recoverBluetoothServiceFromError();
                    }
                    if (newState != 12 || BluetoothManagerService.this.mErrorRecoveryRetryCounter == 0) break;
                    Log.w(BluetoothManagerService.TAG, "bluetooth is recovered from error");
                    BluetoothManagerService.this.mErrorRecoveryRetryCounter = 0;
                    break;
                }
                case 41: {
                    Log.e(BluetoothManagerService.TAG, "MESSAGE_BLUETOOTH_SERVICE_DISCONNECTED: " + msg.arg1);
                    BluetoothServiceConnection prevState = BluetoothManagerService.this.mConnection;
                    synchronized (prevState) {
                        if (msg.arg1 == 1) {
                            if (BluetoothManagerService.this.mBluetooth == null) {
                                break;
                            }
                        } else {
                            if (msg.arg1 == 2) {
                                BluetoothManagerService.this.mBluetoothGatt = null;
                                break;
                            }
                            Log.e(BluetoothManagerService.TAG, "Bad msg.arg1: " + msg.arg1);
                            break;
                        }
                        BluetoothManagerService.this.mBluetooth = null;
                    }
                    if (BluetoothManagerService.this.mEnable) {
                        BluetoothManagerService.this.mEnable = false;
                        Message restartMsg = BluetoothManagerService.this.mHandler.obtainMessage(42);
                        BluetoothManagerService.this.mHandler.sendMessageDelayed(restartMsg, 200L);
                    }
                    if (BluetoothManagerService.this.mConnection.isGetNameAddressOnly()) break;
                    BluetoothManagerService.this.sendBluetoothServiceDownCallback();
                    if (BluetoothManagerService.this.mState == 11 || BluetoothManagerService.this.mState == 12) {
                        BluetoothManagerService.this.bluetoothStateChangeHandler(12, 13);
                        BluetoothManagerService.this.mState = 13;
                    }
                    if (BluetoothManagerService.this.mState == 13) {
                        BluetoothManagerService.this.bluetoothStateChangeHandler(13, 10);
                    }
                    BluetoothManagerService.this.mHandler.removeMessages(60);
                    BluetoothManagerService.this.mState = 10;
                    break;
                }
                case 42: {
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_RESTART_BLUETOOTH_SERVICE: Restart IBluetooth service");
                    BluetoothManagerService.this.mEnable = true;
                    BluetoothManagerService.this.handleEnable(BluetoothManagerService.this.mQuietEnable);
                    break;
                }
                case 101: {
                    Log.e(BluetoothManagerService.TAG, "MESSAGE_TIMEOUT_UNBIND");
                    BluetoothServiceConnection restartMsg = BluetoothManagerService.this.mConnection;
                    synchronized (restartMsg) {
                        BluetoothManagerService.this.mUnbinding = false;
                        break;
                    }
                }
                case 300: {
                    Log.d(BluetoothManagerService.TAG, "MESSAGE_USER_SWITCHED");
                    BluetoothManagerService.this.mHandler.removeMessages(300);
                    if (BluetoothManagerService.this.mEnable && BluetoothManagerService.this.mBluetooth != null) {
                        BluetoothServiceConnection restartMsg = BluetoothManagerService.this.mConnection;
                        synchronized (restartMsg) {
                            if (BluetoothManagerService.this.mBluetooth != null) {
                                try {
                                    BluetoothManagerService.this.mBluetooth.unregisterCallback(BluetoothManagerService.this.mBluetoothCallback);
                                }
                                catch (RemoteException re) {
                                    Log.e(BluetoothManagerService.TAG, "Unable to unregister", re);
                                }
                            }
                        }
                        if (BluetoothManagerService.this.mState == 13) {
                            BluetoothManagerService.this.bluetoothStateChangeHandler(BluetoothManagerService.this.mState, 10);
                            BluetoothManagerService.this.mState = 10;
                        }
                        if (BluetoothManagerService.this.mState == 10) {
                            BluetoothManagerService.this.bluetoothStateChangeHandler(BluetoothManagerService.this.mState, 11);
                            BluetoothManagerService.this.mState = 11;
                        }
                        BluetoothManagerService.this.waitForOnOff(true, false);
                        if (BluetoothManagerService.this.mState == 11) {
                            BluetoothManagerService.this.bluetoothStateChangeHandler(BluetoothManagerService.this.mState, 12);
                        }
                        BluetoothManagerService.this.handleDisable();
                        BluetoothManagerService.this.bluetoothStateChangeHandler(12, 13);
                        BluetoothManagerService.this.waitForOnOff(false, true);
                        BluetoothManagerService.this.bluetoothStateChangeHandler(13, 10);
                        BluetoothManagerService.this.sendBluetoothServiceDownCallback();
                        restartMsg = BluetoothManagerService.this.mConnection;
                        synchronized (restartMsg) {
                            if (BluetoothManagerService.this.mBluetooth != null) {
                                BluetoothManagerService.this.mBluetooth = null;
                                BluetoothManagerService.this.mContext.unbindService(BluetoothManagerService.this.mConnection);
                            }
                        }
                        SystemClock.sleep(100L);
                        BluetoothManagerService.this.mHandler.removeMessages(60);
                        BluetoothManagerService.this.mState = 10;
                        BluetoothManagerService.this.handleEnable(BluetoothManagerService.this.mQuietEnable);
                        break;
                    }
                    if (!BluetoothManagerService.this.mBinding && BluetoothManagerService.this.mBluetooth == null) break;
                    Message userMsg = BluetoothManagerService.this.mHandler.obtainMessage(300);
                    userMsg.arg2 = 1 + msg.arg2;
                    BluetoothManagerService.this.mHandler.sendMessageDelayed(userMsg, 200L);
                    Log.d(BluetoothManagerService.TAG, "delay MESSAGE_USER_SWITCHED " + userMsg.arg2);
                }
            }
        }
    }

    private class BluetoothServiceConnection
    implements ServiceConnection {
        private boolean mGetNameAddressOnly;

        private BluetoothServiceConnection() {
        }

        public void setGetNameAddressOnly(boolean getOnly) {
            this.mGetNameAddressOnly = getOnly;
        }

        public boolean isGetNameAddressOnly() {
            return this.mGetNameAddressOnly;
        }

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d(BluetoothManagerService.TAG, "BluetoothServiceConnection: " + className.getClassName());
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(40);
            if (className.getClassName().equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (className.getClassName().equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Log.e(BluetoothManagerService.TAG, "Unknown service connected: " + className.getClassName());
                return;
            }
            msg.obj = service;
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Log.d(BluetoothManagerService.TAG, "BluetoothServiceConnection, disconnected: " + className.getClassName());
            Message msg = BluetoothManagerService.this.mHandler.obtainMessage(41);
            if (className.getClassName().equals("com.android.bluetooth.btservice.AdapterService")) {
                msg.arg1 = 1;
            } else if (className.getClassName().equals("com.android.bluetooth.gatt.GattService")) {
                msg.arg1 = 2;
            } else {
                Log.e(BluetoothManagerService.TAG, "Unknown service disconnected: " + className.getClassName());
                return;
            }
            BluetoothManagerService.this.mHandler.sendMessage(msg);
        }
    }
}

