/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.MobileDataStateTracker;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.SamplingDataTracker;
import android.net.UidRange;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.DataConnectionStats;
import com.android.server.connectivity.Nat464Xlat;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.PacManager;
import com.android.server.connectivity.PermissionMonitor;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.LockdownVpnTracker;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConnectivityService
extends IConnectivityManager.Stub {
    private static final String TAG = "ConnectivityService";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean SAMPLE_DBG = false;
    private static final boolean LOGD_RULES = false;
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int DEFAULT_FAIL_FAST_TIME_MS = 60000;
    private static final String FAIL_FAST_TIME_MS = "persist.radio.fail_fast_time_ms";
    private static final String ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED = "android.net.ConnectivityService.action.PKT_CNT_SAMPLE_INTERVAL_ELAPSED";
    private static final int SAMPLE_INTERVAL_ELAPSED_REQUEST_CODE = 0;
    private PendingIntent mSampleIntervalElapsedIntent;
    private static final int DEFAULT_SAMPLING_INTERVAL_IN_SECONDS = 720;
    private static final int DEFAULT_START_SAMPLING_INTERVAL_IN_SECONDS = 60;
    AlarmManager mAlarmManager;
    private Tethering mTethering;
    private final PermissionMonitor mPermissionMonitor;
    private KeyStore mKeyStore;
    @GuardedBy(value="mVpns")
    private final SparseArray<Vpn> mVpns = new SparseArray();
    private boolean mLockdownEnabled;
    private LockdownVpnTracker mLockdownTracker;
    private Nat464Xlat mClat;
    private Object mRulesLock = new Object();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private NetworkStateTracker[] mNetTrackers;
    private Context mContext;
    private int mNetworkPreference;
    private int mActiveDefaultNetwork = -1;
    private int mDefaultInetConditionPublished = 0;
    private Object mDnsLock = new Object();
    private int mNumDnsEntries;
    private boolean mTestMode;
    private static ConnectivityService sServiceInstance;
    private INetworkManagementService mNetd;
    private INetworkPolicyManager mPolicyManager;
    private String mCurrentTcpBufferSizes;
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    private static final int EVENT_CHANGE_MOBILE_DATA_ENABLED = 2;
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 8;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 9;
    private static final int EVENT_SET_DEPENDENCY_MET = 10;
    private static final int EVENT_SEND_STICKY_BROADCAST_INTENT = 11;
    private static final int EVENT_SET_POLICY_DATA_ENABLE = 12;
    private static final int EVENT_ENABLE_FAIL_FAST_MOBILE_DATA = 14;
    private static final int EVENT_SAMPLE_INTERVAL_ELAPSED = 15;
    private static final int EVENT_PROXY_HAS_CHANGED = 16;
    private static final int EVENT_REGISTER_NETWORK_FACTORY = 17;
    private static final int EVENT_REGISTER_NETWORK_AGENT = 18;
    private static final int EVENT_REGISTER_NETWORK_REQUEST = 19;
    private static final int EVENT_TIMEOUT_NETWORK_REQUEST = 20;
    private static final int EVENT_REGISTER_NETWORK_LISTENER = 21;
    private static final int EVENT_RELEASE_NETWORK_REQUEST = 22;
    private static final int EVENT_UNREGISTER_NETWORK_FACTORY = 23;
    private static final int EVENT_EXPIRE_NET_TRANSITION_WAKELOCK = 24;
    private static final int EVENT_SYSTEM_READY = 25;
    private final InternalHandler mHandler;
    private final NetworkStateTrackerHandler mTrackerHandler;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private String mNetTransitionWakeLockCausedBy = "";
    private int mNetTransitionWakeLockSerialNumber;
    private int mNetTransitionWakeLockTimeout;
    private InetAddress mDefaultDns;
    private static final int INET_CONDITION_LOG_MAX_SIZE = 15;
    private ArrayList mInetLog;
    private volatile ProxyInfo mDefaultProxy = null;
    private Object mProxyLock = new Object();
    private boolean mDefaultProxyDisabled = false;
    private ProxyInfo mGlobalProxy = null;
    private PacManager mPacManager = null;
    private SettingsObserver mSettingsObserver;
    private UserManager mUserManager;
    NetworkConfig[] mNetConfigs;
    int mNetworksDefined;
    List mProtectedNetworks;
    private DataConnectionStats mDataConnectionStats;
    private AtomicInteger mEnableFailFastMobileDataTag = new AtomicInteger(0);
    TelephonyManager mTelephonyManager;
    private static final int MIN_NET_ID = 100;
    private static final int MAX_NET_ID = 65535;
    private int mNextNetId = 100;
    private int mNextNetworkRequestId = 1;
    private LegacyTypeTracker mLegacyTypeTracker = new LegacyTypeTracker();
    private INetworkManagementEventObserver mDataActivityObserver = new BaseNetworkObserver(){

        @Override
        public void interfaceClassDataActivityChanged(String label, boolean active, long tsNanos) {
            int deviceType = Integer.parseInt(label);
            ConnectivityService.this.sendDataActivityBroadcast(deviceType, active, tsNanos);
        }
    };
    private INetworkPolicyListener mPolicyListener = new INetworkPolicyListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                int oldRules = ConnectivityService.this.mUidRules.get(uid, 0);
                if (oldRules == uidRules) {
                    return;
                }
                ConnectivityService.this.mUidRules.put(uid, uidRules);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                ConnectivityService.this.mMeteredIfaces.clear();
                for (String iface : meteredIfaces) {
                    ConnectivityService.this.mMeteredIfaces.add(iface);
                }
            }
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
            NetworkInfo info;
            NetworkStateTracker tracker;
            int networkType = ConnectivityService.this.mActiveDefaultNetwork;
            if (ConnectivityManager.isNetworkTypeValid(networkType) && (tracker = ConnectivityService.this.mNetTrackers[networkType]) != null && (info = tracker.getNetworkInfo()) != null && info.isConnected()) {
                ConnectivityService.this.sendConnectedBroadcast(info);
            }
        }
    };
    private BroadcastReceiver mUserPresentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (ConnectivityService.this.updateLockdownVpn()) {
                ConnectivityService.this.mContext.unregisterReceiver(this);
            }
        }
    };
    private static final String DEFAULT_TCP_BUFFER_SIZES = "4096,87380,110208,4096,16384,110208";
    private static final String NOTIFICATION_ID = "CaptivePortal.Notification";
    private volatile boolean mIsNotificationVisible = false;
    private static final String PROVISIONING_URL_PATH = "/data/misc/radio/provisioning_urls.xml";
    private final File mProvisioningUrlFile = new File("/data/misc/radio/provisioning_urls.xml");
    private static final String TAG_PROVISIONING_URLS = "provisioningUrls";
    private static final String TAG_PROVISIONING_URL = "provisioningUrl";
    private static final String TAG_REDIRECTED_URL = "redirectedUrl";
    private static final String ATTR_MCC = "mcc";
    private static final String ATTR_MNC = "mnc";
    private static final int REDIRECTED_PROVISIONING = 1;
    private static final int PROVISIONING = 2;
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_STARTING".equals(action)) {
                ConnectivityService.this.onUserStart(userId);
            } else if ("android.intent.action.USER_STOPPING".equals(action)) {
                ConnectivityService.this.onUserStop(userId);
            }
        }
    };
    private final HashMap<Messenger, NetworkFactoryInfo> mNetworkFactoryInfos = new HashMap();
    private final HashMap<NetworkRequest, NetworkRequestInfo> mNetworkRequests = new HashMap();
    private final SparseArray<NetworkAgentInfo> mNetworkForRequestId = new SparseArray();
    private final SparseArray<NetworkAgentInfo> mNetworkForNetId = new SparseArray();
    private final HashMap<Messenger, NetworkAgentInfo> mNetworkAgentInfos = new HashMap();
    private final NetworkRequest mDefaultRequest;

    public ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        int[] protectedNetworks;
        String[] naStrings;
        String dns;
        String id2;
        ConnectivityService.log("ConnectivityService starting up");
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        this.mDefaultRequest = new NetworkRequest(netCap, -1, this.nextNetworkRequestId());
        NetworkRequestInfo nri = new NetworkRequestInfo(null, this.mDefaultRequest, new Binder(), true);
        this.mNetworkRequests.put(this.mDefaultRequest, nri);
        HandlerThread handlerThread = new HandlerThread("ConnectivityServiceThread");
        handlerThread.start();
        this.mHandler = new InternalHandler(handlerThread.getLooper());
        this.mTrackerHandler = new NetworkStateTrackerHandler(handlerThread.getLooper());
        if (TextUtils.isEmpty(SystemProperties.get("net.hostname")) && (id2 = Settings.Secure.getString(context.getContentResolver(), "android_id")) != null && id2.length() > 0) {
            String name = new String("android-").concat(id2);
            SystemProperties.set("net.hostname", name);
        }
        if ((dns = Settings.Global.getString(context.getContentResolver(), "default_dns_server")) == null || dns.length() == 0) {
            dns = context.getResources().getString(17039400);
        }
        try {
            this.mDefaultDns = NetworkUtils.numericToInetAddress(dns);
        }
        catch (IllegalArgumentException e) {
            ConnectivityService.loge("Error setting defaultDns using " + dns);
        }
        this.mContext = ConnectivityService.checkNotNull(context, "missing Context");
        this.mNetd = ConnectivityService.checkNotNull(netManager, "missing INetworkManagementService");
        this.mPolicyManager = ConnectivityService.checkNotNull(policyManager, "missing INetworkPolicyManager");
        this.mKeyStore = KeyStore.getInstance();
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("unable to register INetworkPolicyListener" + e.toString());
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694733);
        this.mNetTrackers = new NetworkStateTracker[18];
        this.mNetConfigs = new NetworkConfig[18];
        boolean wifiOnly = SystemProperties.getBoolean("ro.radio.noril", false);
        ConnectivityService.log("wifiOnly=" + wifiOnly);
        for (String naString : naStrings = context.getResources().getStringArray(17235980)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (n.type > 17) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (wifiOnly && ConnectivityManager.isNetworkTypeMobile(n.type)) {
                    ConnectivityService.log("networkAttributes - ignoring mobile as this dev is wifiOnly " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                this.mLegacyTypeTracker.addSupportedType(n.type);
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17235981)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            ConnectivityService.loge("Ignoring protectedNetwork " + p);
        }
        this.mTestMode = SystemProperties.get("cm.test.mode").equals("true") && SystemProperties.get("ro.build.type").equals("eng");
        this.mTethering = new Tethering(this.mContext, this.mNetd, statsService, this.mHandler.getLooper());
        this.mPermissionMonitor = new PermissionMonitor(this.mContext, this.mNetd);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_STARTING");
        intentFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        this.mClat = new Nat464Xlat(this.mContext, this.mNetd, this, this.mTrackerHandler);
        try {
            this.mNetd.registerObserver(this.mTethering);
            this.mNetd.registerObserver(this.mDataActivityObserver);
            this.mNetd.registerObserver(this.mClat);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("Error registering observer :" + e);
        }
        this.mInetLog = new ArrayList();
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 9);
        this.mSettingsObserver.observe(this.mContext);
        this.mDataConnectionStats = new DataConnectionStats(this.mContext);
        this.mDataConnectionStats.startMonitoring();
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals(ConnectivityService.ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED)) {
                    ConnectivityService.this.mHandler.sendMessage(ConnectivityService.this.mHandler.obtainMessage(15));
                }
            }
        }, new IntentFilter(filter));
        this.mPacManager = new PacManager(this.mContext, this.mHandler, 16);
        this.mUserManager = (UserManager)context.getSystemService("user");
    }

    private synchronized int nextNetworkRequestId() {
        return this.mNextNetworkRequestId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignNextNetId(NetworkAgentInfo nai) {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 100; i <= 65535; ++i) {
                int netId = this.mNextNetId++;
                if (this.mNextNetId > 65535) {
                    this.mNextNetId = 100;
                }
                if (this.mNetworkForNetId.get(netId) != null) continue;
                nai.network = new Network(netId);
                this.mNetworkForNetId.put(netId, nai);
                return;
            }
        }
        throw new IllegalStateException("No free netIds");
    }

    private int getConnectivityChangeDelay() {
        ContentResolver cr = this.mContext.getContentResolver();
        int defaultDelay = SystemProperties.getInt("conn.connectivity_change_delay", 3000);
        return Settings.Global.getInt(cr, "connectivity_change_delay", defaultDelay);
    }

    private boolean teardown(NetworkStateTracker netTracker) {
        if (netTracker.teardown()) {
            netTracker.setTeardownRequested(true);
            return true;
        }
        return false;
    }

    private boolean isNetworkBlocked(int networkType, int uid) {
        return this.isNetworkWithLinkPropertiesBlocked(this.getLinkPropertiesForType(networkType), uid);
    }

    private boolean isNetworkBlocked(NetworkAgentInfo nai, int uid) {
        return this.isNetworkWithLinkPropertiesBlocked(nai.linkProperties, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkWithLinkPropertiesBlocked(LinkProperties lp, int uid) {
        int uidRules;
        boolean networkCostly;
        String iface = lp == null ? "" : lp.getInterfaceName();
        Object object = this.mRulesLock;
        synchronized (object) {
            networkCostly = this.mMeteredIfaces.contains(iface);
            uidRules = this.mUidRules.get(uid, 0);
        }
        return networkCostly && (uidRules & 1) != 0;
    }

    private NetworkInfo getFilteredNetworkInfo(int networkType, int uid) {
        NetworkInfo info = this.getNetworkInfoForType(networkType);
        return this.getFilteredNetworkInfo(info, networkType, uid);
    }

    private NetworkInfo getFilteredNetworkInfo(NetworkInfo info, int networkType, int uid) {
        if (this.isNetworkBlocked(networkType, uid)) {
            info = new NetworkInfo(info);
            info.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        return info;
    }

    private NetworkInfo getFilteredNetworkInfo(NetworkAgentInfo nai, int uid) {
        NetworkInfo info = nai.networkInfo;
        if (this.isNetworkBlocked(nai, uid)) {
            info = new NetworkInfo(info);
            info.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
            ConnectivityService.log("returning Blocked NetworkInfo");
        }
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
            ConnectivityService.log("returning Locked NetworkInfo");
        }
        return info;
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    private NetworkInfo getProvisioningNetworkInfo() {
        this.enforceAccessPermission();
        NetworkInfo provNi = null;
        for (NetworkInfo ni : this.getAllNetworkInfo()) {
            if (!ni.isConnectedToProvisioningNetwork()) continue;
            provNi = ni;
            break;
        }
        ConnectivityService.log("getProvisioningNetworkInfo: X provNi=" + provNi);
        return provNi;
    }

    @Override
    public NetworkInfo getProvisioningOrActiveNetworkInfo() {
        this.enforceAccessPermission();
        NetworkInfo provNi = this.getProvisioningNetworkInfo();
        if (provNi == null) {
            int uid = Binder.getCallingUid();
            provNi = this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
        }
        ConnectivityService.log("getProvisioningOrActiveNetworkInfo: X provNi=" + provNi);
        return provNi;
    }

    public NetworkInfo getActiveNetworkInfoUnfiltered() {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(this.mActiveDefaultNetwork)) {
            return this.getNetworkInfoForType(this.mActiveDefaultNetwork);
        }
        return null;
    }

    @Override
    public NetworkInfo getActiveNetworkInfoForUid(int uid) {
        this.enforceConnectivityInternalPermission();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    @Override
    public NetworkInfo getNetworkInfo(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(networkType, uid);
    }

    private NetworkInfo getNetworkInfo(int networkType, int uid) {
        NetworkInfo info = null;
        if (ConnectivityManager.isNetworkTypeValid(networkType) && this.getNetworkInfoForType(networkType) != null) {
            info = this.getFilteredNetworkInfo(networkType, uid);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInfo getNetworkInfoForNetwork(Network network) {
        this.enforceAccessPermission();
        if (network == null) {
            return null;
        }
        int uid = Binder.getCallingUid();
        NetworkAgentInfo nai = null;
        Object object = this.mNetworkForNetId;
        synchronized (object) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai == null) {
            return null;
        }
        object = nai;
        synchronized (object) {
            if (nai.networkInfo == null) {
                return null;
            }
            return this.getFilteredNetworkInfo(nai, uid);
        }
    }

    @Override
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList<NetworkInfo> result = Lists.newArrayList();
        for (int networkType = 0; networkType <= 17; ++networkType) {
            if (this.getNetworkInfoForType(networkType) == null) continue;
            result.add(this.getFilteredNetworkInfo(networkType, uid));
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    @Override
    public Network getNetworkForType(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        if (this.isNetworkBlocked(networkType, uid)) {
            return null;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        return nai == null ? null : nai.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network[] getAllNetworks() {
        this.enforceAccessPermission();
        ArrayList<Network> result = new ArrayList<Network>();
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mNetworkForNetId.size(); ++i) {
                result.add(new Network(this.mNetworkForNetId.valueAt((int)i).network));
            }
        }
        return result.toArray(new Network[result.size()]);
    }

    @Override
    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return ConnectivityManager.isNetworkTypeValid(networkType) && this.getNetworkInfoForType(networkType) != null;
    }

    @Override
    public LinkProperties getActiveLinkProperties() {
        return this.getLinkPropertiesForType(this.mActiveDefaultNetwork);
    }

    @Override
    public LinkProperties getLinkPropertiesForType(int networkType) {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType)) {
            return this.getLinkPropertiesForTypeInternal(networkType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkProperties getLinkProperties(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = null;
        Object object = this.mNetworkForNetId;
        synchronized (object) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai != null) {
            object = nai;
            synchronized (object) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkCapabilities getNetworkCapabilities(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = null;
        Object object = this.mNetworkForNetId;
        synchronized (object) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai != null) {
            object = nai;
            synchronized (object) {
                return new NetworkCapabilities(nai.networkCapabilities);
            }
        }
        return null;
    }

    @Override
    public NetworkState[] getAllNetworkState() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList<NetworkState> result = Lists.newArrayList();
        for (int networkType = 0; networkType <= 17; ++networkType) {
            if (this.getNetworkInfoForType(networkType) == null) continue;
            NetworkInfo info = this.getFilteredNetworkInfo(networkType, uid);
            LinkProperties lp = this.getLinkPropertiesForTypeInternal(networkType);
            NetworkCapabilities netcap = this.getNetworkCapabilitiesForType(networkType);
            result.add(new NetworkState(info, lp, netcap));
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    private NetworkState getNetworkStateUnchecked(int networkType) {
        NetworkInfo info;
        if (ConnectivityManager.isNetworkTypeValid(networkType) && (info = this.getNetworkInfoForType(networkType)) != null) {
            return new NetworkState(info, this.getLinkPropertiesForTypeInternal(networkType), this.getNetworkCapabilitiesForType(networkType));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveNetworkMetered() {
        this.enforceAccessPermission();
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.isNetworkMeteredUnchecked(this.mActiveDefaultNetwork);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean isNetworkMeteredUnchecked(int networkType) {
        NetworkState state = this.getNetworkStateUnchecked(networkType);
        if (state != null) {
            try {
                return this.mPolicyManager.isNetworkMetered(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        NetworkInfo.DetailedState netState;
        InetAddress addr;
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        try {
            addr = InetAddress.getByAddress(hostAddress);
        }
        catch (UnknownHostException e) {
            ConnectivityService.log("requestRouteToHostAddress got " + e.toString());
            return false;
        }
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("requestRouteToHostAddress on invalid network: " + networkType);
            return false;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            if (!this.mLegacyTypeTracker.isTypeSupported(networkType)) {
                ConnectivityService.log("requestRouteToHostAddress on unsupported network: " + networkType);
            } else {
                ConnectivityService.log("requestRouteToHostAddress on down network: " + networkType);
            }
            return false;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            netState = nai.networkInfo.getDetailedState();
        }
        if (netState != NetworkInfo.DetailedState.CONNECTED && netState != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
            return false;
        }
        int uid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            int netId;
            LinkProperties lp;
            NetworkAgentInfo networkAgentInfo2 = nai;
            synchronized (networkAgentInfo2) {
                lp = nai.linkProperties;
                netId = nai.network.netId;
            }
            boolean ok = this.addLegacyRouteToHost(lp, addr, netId, uid);
            ConnectivityService.log("requestRouteToHostAddress ok=" + ok);
            boolean bl = ok;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean addLegacyRouteToHost(LinkProperties lp, InetAddress addr, int netId, int uid) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), addr);
        if (bestRoute == null) {
            bestRoute = RouteInfo.makeHostRoute(addr, lp.getInterfaceName());
        } else {
            String iface = bestRoute.getInterface();
            bestRoute = bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute(addr, iface) : RouteInfo.makeHostRoute(addr, bestRoute.getGateway(), iface);
        }
        ConnectivityService.log("Adding " + bestRoute + " for interface " + bestRoute.getInterface());
        try {
            this.mNetd.addLegacyRouteForNetId(netId, bestRoute, uid);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception trying to add a route: " + e);
            return false;
        }
        return true;
    }

    @Override
    public void setDataDependency(int networkType, boolean met) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10, met ? 1 : 0, networkType));
    }

    private void handleSetDependencyMet(int networkType, boolean met) {
        if (this.mNetTrackers[networkType] != null) {
            ConnectivityService.log("handleSetDependencyMet(" + networkType + ", " + met + ")");
            this.mNetTrackers[networkType].setDependencyMet(met);
        }
    }

    @Override
    public void setPolicyDataEnable(int networkType, boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(12, networkType, enabled ? 1 : 0));
    }

    private void handleSetPolicyDataEnable(int networkType, boolean enabled) {
    }

    private void enforceInternetPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", TAG);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
    }

    public void sendConnectedBroadcast(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendConnectedBroadcastDelayed(NetworkInfo info, int delayMs) {
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcastDelayed(info, "android.net.conn.CONNECTIVITY_CHANGE", delayMs);
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    private void sendGeneralBroadcastDelayed(NetworkInfo info, String bcastType, int delayMs) {
        this.sendStickyBroadcastDelayed(this.makeGeneralIntent(info, bcastType), delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataActivityBroadcast(int deviceType, boolean active, long tsNanos) {
        Intent intent = new Intent("android.net.conn.DATA_ACTIVITY_CHANGE");
        intent.putExtra("deviceType", deviceType);
        intent.putExtra("isActive", active);
        intent.putExtra("tsNanos", tsNanos);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, "android.permission.RECEIVE_DATA_ACTIVITY_CHANGE", null, null, 0, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x4000000);
            ConnectivityService.log("sendStickyBroadcast: action=" + intent.getAction());
            long ident = Binder.clearCallingIdentity();
            try {
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private void sendStickyBroadcastDelayed(Intent intent, int delayMs) {
        if (delayMs <= 0) {
            this.sendStickyBroadcast(intent);
        } else {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(11, intent), delayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        Intent intent = new Intent(ACTION_PKT_CNT_SAMPLE_INTERVAL_ELAPSED);
        intent.setPackage(this.mContext.getPackageName());
        this.mSampleIntervalElapsedIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.setAlarm(60000, this.mSampleIntervalElapsedIntent);
        this.loadGlobalProxy();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcastAsUser(this.mInitialBroadcast, UserHandle.ALL);
                this.mInitialBroadcast = null;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(9));
        if (!this.updateLockdownVpn()) {
            IntentFilter filter = new IntentFilter("android.intent.action.USER_PRESENT");
            this.mContext.registerReceiver(this.mUserPresentReceiver, filter);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(25));
        this.mPermissionMonitor.startMonitoring();
    }

    @Override
    public void captivePortalCheckCompleted(NetworkInfo info, boolean isCaptivePortal) {
        this.enforceConnectivityInternalPermission();
        ConnectivityService.log("captivePortalCheckCompleted: ni=" + info + " captive=" + isCaptivePortal);
    }

    private void setupDataActivityTracking(NetworkAgentInfo networkAgent) {
        int timeout;
        String iface = networkAgent.linkProperties.getInterfaceName();
        int type = -1;
        if (networkAgent.networkCapabilities.hasTransport(0)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_mobile", 5);
            type = 0;
        } else if (networkAgent.networkCapabilities.hasTransport(1)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_wifi", 0);
            type = 1;
        } else {
            timeout = 0;
        }
        if (timeout > 0 && iface != null && type != -1) {
            try {
                this.mNetd.addIdleTimer(iface, timeout, type);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setupDataActivityTracking " + e);
            }
        }
    }

    private void removeDataActivityTracking(NetworkAgentInfo networkAgent) {
        String iface = networkAgent.linkProperties.getInterfaceName();
        NetworkCapabilities caps = networkAgent.networkCapabilities;
        if (iface != null && (caps.hasTransport(0) || caps.hasTransport(1))) {
            try {
                this.mNetd.removeIdleTimer(iface);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeDataActivityTracking " + e);
            }
        }
    }

    private void updateMtu(LinkProperties newLp, LinkProperties oldLp) {
        String iface = newLp.getInterfaceName();
        int mtu = newLp.getMtu();
        if (oldLp != null && newLp.isIdenticalMtu(oldLp)) {
            return;
        }
        if (!LinkProperties.isValidMtu(mtu, newLp.hasGlobalIPv6Address())) {
            ConnectivityService.loge("Unexpected mtu value: " + mtu + ", " + iface);
            return;
        }
        if (TextUtils.isEmpty(iface)) {
            ConnectivityService.loge("Setting MTU size with null iface.");
            return;
        }
        try {
            ConnectivityService.log("Setting MTU size: " + iface + ", " + mtu);
            this.mNetd.setMtu(iface, mtu);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception in setMtu()" + e);
        }
    }

    private void updateTcpBufferSizes(NetworkAgentInfo nai) {
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        String tcpBufferSizes = nai.linkProperties.getTcpBufferSizes();
        String[] values = null;
        if (tcpBufferSizes != null) {
            values = tcpBufferSizes.split(",");
        }
        if (values == null || values.length != 6) {
            ConnectivityService.log("Invalid tcpBufferSizes string: " + tcpBufferSizes + ", using defaults");
            tcpBufferSizes = DEFAULT_TCP_BUFFER_SIZES;
            values = tcpBufferSizes.split(",");
        }
        if (tcpBufferSizes.equals(this.mCurrentTcpBufferSizes)) {
            return;
        }
        try {
            Slog.d(TAG, "Setting tx/rx TCP buffers to " + tcpBufferSizes);
            String prefix = "/sys/kernel/ipv4/tcp_";
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", values[0]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", values[1]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", values[2]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", values[3]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", values[4]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", values[5]);
            this.mCurrentTcpBufferSizes = tcpBufferSizes;
        }
        catch (IOException e) {
            ConnectivityService.loge("Can't set TCP buffer sizes:" + e);
        }
        String defaultRwndKey = "net.tcp.default_init_rwnd";
        int defaultRwndValue = SystemProperties.getInt("net.tcp.default_init_rwnd", 0);
        Integer rwndValue = Settings.Global.getInt(this.mContext.getContentResolver(), "tcp_default_init_rwnd", defaultRwndValue);
        String sysctlKey = "sys.sysctl.tcp_def_init_rwnd";
        if (rwndValue != 0) {
            SystemProperties.set("sys.sysctl.tcp_def_init_rwnd", rwndValue.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVmDnsCache() {
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x4000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = SystemProperties.get(NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.valueOf(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 17 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        Object activeNetworkInfo;
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("NetworkFactories for:");
        pw.increaseIndent();
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            pw.println(nfi.name);
        }
        pw.decreaseIndent();
        pw.println();
        NetworkAgentInfo defaultNai = this.mNetworkForRequestId.get(this.mDefaultRequest.requestId);
        pw.print("Active default network: ");
        if (defaultNai == null) {
            pw.println("none");
        } else {
            pw.println(defaultNai.network.netId);
        }
        pw.println();
        pw.println("Current Networks:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            pw.println(nai.toString());
            pw.increaseIndent();
            pw.println("Requests:");
            pw.increaseIndent();
            for (int i = 0; i < nai.networkRequests.size(); ++i) {
                pw.println(nai.networkRequests.valueAt(i).toString());
            }
            pw.decreaseIndent();
            pw.println("Lingered:");
            pw.increaseIndent();
            for (NetworkRequest nr : nai.networkLingered) {
                pw.println(nr.toString());
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println();
        pw.println("Network Requests:");
        pw.increaseIndent();
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            pw.println(nri.toString());
        }
        pw.println();
        pw.decreaseIndent();
        pw.print("mActiveDefaultNetwork: " + this.mActiveDefaultNetwork);
        if (this.mActiveDefaultNetwork != -1 && (activeNetworkInfo = this.getActiveNetworkInfo()) != null) {
            pw.print(" " + (Object)((Object)((NetworkInfo)activeNetworkInfo).getState()) + "/" + (Object)((Object)((NetworkInfo)activeNetworkInfo).getDetailedState()));
        }
        pw.println();
        pw.println("mLegacyTypeTracker:");
        pw.increaseIndent();
        this.mLegacyTypeTracker.dump(pw);
        pw.decreaseIndent();
        pw.println();
        activeNetworkInfo = this;
        synchronized (activeNetworkInfo) {
            pw.println("NetworkTransitionWakeLock is currently " + (this.mNetTransitionWakeLock.isHeld() ? "" : "not ") + "held.");
            pw.println("It was last requested for " + this.mNetTransitionWakeLockCausedBy);
        }
        pw.println();
        this.mTethering.dump(fd, pw, args);
        if (this.mInetLog != null) {
            pw.println();
            pw.println("Inet condition reports:");
            pw.increaseIndent();
            for (int i = 0; i < this.mInetLog.size(); ++i) {
                pw.println(this.mInetLog.get(i));
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLiveNetworkAgent(NetworkAgentInfo nai, String msg) {
        NetworkAgentInfo officialNai;
        if (nai.network == null) {
            return false;
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            officialNai = this.mNetworkForNetId.get(nai.network.netId);
        }
        if (officialNai != null && officialNai.equals(nai)) {
            return true;
        }
        if (officialNai != null) {
            ConnectivityService.loge(msg + " - isLiveNetworkAgent found mismatched netId: " + officialNai + " - " + nai);
        }
        return false;
    }

    private boolean isRequest(NetworkRequest request) {
        return this.mNetworkRequests.get((Object)request).isRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelHalfConnect(Message msg) {
        AsyncChannel ac = (AsyncChannel)msg.obj;
        if (this.mNetworkFactoryInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                    if (!nri.isRequest) continue;
                    NetworkAgentInfo nai = this.mNetworkForRequestId.get(nri.request.requestId);
                    ac.sendMessage(536576, nai != null ? nai.getCurrentScore() : 0, 0, nri.request);
                }
            } else {
                ConnectivityService.loge("Error connecting NetworkFactory");
                this.mNetworkFactoryInfos.remove(msg.obj);
            }
        } else if (this.mNetworkAgentInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                this.mNetworkAgentInfos.get((Object)msg.replyTo).asyncChannel.sendMessage(69633);
            } else {
                ConnectivityService.loge("Error connecting NetworkAgent");
                NetworkAgentInfo nai = this.mNetworkAgentInfos.remove(msg.replyTo);
                if (nai != null) {
                    SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
                    synchronized (sparseArray) {
                        this.mNetworkForNetId.remove(nai.network.netId);
                    }
                    this.mLegacyTypeTracker.remove(nai);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelDisconnected(Message msg) {
        NetworkAgentInfo nai = this.mNetworkAgentInfos.get(msg.replyTo);
        if (nai != null) {
            ConnectivityService.log(nai.name() + " got DISCONNECTED, was satisfying " + nai.networkRequests.size());
            if (nai.created) {
                try {
                    this.mNetd.removeNetwork(nai.network.netId);
                }
                catch (Exception e) {
                    ConnectivityService.loge("Exception removing network: " + e);
                }
            }
            if (nai.networkInfo.isConnected()) {
                nai.networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
            }
            if (this.isDefaultNetwork(nai)) {
                this.mDefaultInetConditionPublished = 0;
            }
            this.notifyNetworkCallbacks(nai, 524292);
            nai.networkMonitor.sendMessage(532487);
            this.mNetworkAgentInfos.remove(msg.replyTo);
            this.updateClat(null, nai.linkProperties, nai);
            this.mLegacyTypeTracker.remove(nai);
            SparseArray<NetworkAgentInfo> e = this.mNetworkForNetId;
            synchronized (e) {
                this.mNetworkForNetId.remove(nai.network.netId);
            }
            ArrayList<NetworkAgentInfo> toActivate = new ArrayList<NetworkAgentInfo>();
            for (int i = 0; i < nai.networkRequests.size(); ++i) {
                NetworkRequest request = nai.networkRequests.valueAt(i);
                NetworkAgentInfo currentNetwork = this.mNetworkForRequestId.get(request.requestId);
                if (currentNetwork == null || currentNetwork.network.netId != nai.network.netId) continue;
                ConnectivityService.log("Checking for replacement network to handle request " + request);
                this.mNetworkForRequestId.remove(request.requestId);
                this.sendUpdatedScoreToFactories(request, 0);
                NetworkAgentInfo alternative = null;
                for (Map.Entry<Messenger, NetworkAgentInfo> entry : this.mNetworkAgentInfos.entrySet()) {
                    NetworkAgentInfo existing = entry.getValue();
                    if (!existing.networkInfo.isConnected() || !request.networkCapabilities.satisfiedByNetworkCapabilities(existing.networkCapabilities) || alternative != null && alternative.getCurrentScore() >= existing.getCurrentScore()) continue;
                    alternative = existing;
                }
                if (alternative == null) continue;
                ConnectivityService.log(" found replacement in " + alternative.name());
                if (toActivate.contains(alternative)) continue;
                toActivate.add(alternative);
            }
            if (nai.networkRequests.get(this.mDefaultRequest.requestId) != null) {
                this.removeDataActivityTracking(nai);
                this.mActiveDefaultNetwork = -1;
                this.notifyLockdownVpn(nai);
                this.requestNetworkTransitionWakelock(nai.name());
            }
            for (NetworkAgentInfo networkToActivate : toActivate) {
                networkToActivate.networkLingered.clear();
                networkToActivate.networkMonitor.sendMessage(532481);
                this.rematchNetworkAndRequests(networkToActivate, false);
            }
        }
    }

    private void handleRegisterNetworkRequest(Message msg) {
        NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
        NetworkCapabilities newCap = nri.request.networkCapabilities;
        int score = 0;
        NetworkAgentInfo bestNetwork = null;
        for (NetworkAgentInfo network : this.mNetworkAgentInfos.values()) {
            ConnectivityService.log("handleRegisterNetworkRequest checking " + network.name());
            if (!newCap.satisfiedByNetworkCapabilities(network.networkCapabilities)) continue;
            ConnectivityService.log("apparently satisfied.  currentScore=" + network.getCurrentScore());
            if (bestNetwork != null && bestNetwork.getCurrentScore() >= network.getCurrentScore()) continue;
            if (!nri.isRequest) {
                network.addRequest(nri.request);
                this.notifyNetworkCallback(network, nri);
                continue;
            }
            bestNetwork = network;
        }
        if (bestNetwork != null) {
            ConnectivityService.log("using " + bestNetwork.name());
            if (bestNetwork.networkInfo.isConnected()) {
                bestNetwork.networkLingered.clear();
                bestNetwork.networkMonitor.sendMessage(532481);
            }
            bestNetwork.addRequest(nri.request);
            this.mNetworkForRequestId.put(nri.request.requestId, bestNetwork);
            this.notifyNetworkCallback(bestNetwork, nri);
            score = bestNetwork.getCurrentScore();
            if (nri.request.legacyType != -1) {
                this.mLegacyTypeTracker.add(nri.request.legacyType, bestNetwork);
            }
        }
        this.mNetworkRequests.put(nri.request, nri);
        if (nri.isRequest) {
            ConnectivityService.log("sending new NetworkRequest to factories");
            for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
                nfi.asyncChannel.sendMessage(536576, score, 0, nri.request);
            }
        }
    }

    private void handleReleaseNetworkRequest(NetworkRequest request, int callingUid) {
        NetworkRequestInfo nri = this.mNetworkRequests.get(request);
        if (nri != null) {
            if (1000 != callingUid && nri.mUid != callingUid) {
                ConnectivityService.log("Attempt to release unowned NetworkRequest " + request);
                return;
            }
            ConnectivityService.log("releasing NetworkRequest " + request);
            nri.unlinkDeathRecipient();
            this.mNetworkRequests.remove(request);
            if (nri.isRequest) {
                for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                    if (nai.networkRequests.get(nri.request.requestId) == null) continue;
                    nai.networkRequests.remove(nri.request.requestId);
                    ConnectivityService.log(" Removing from current network " + nai.name() + ", leaving " + nai.networkRequests.size() + " requests.");
                    boolean keep = nai.isVPN();
                    for (int i = 0; i < nai.networkRequests.size() && !keep; ++i) {
                        NetworkRequest r = nai.networkRequests.valueAt(i);
                        if (!this.isRequest(r)) continue;
                        keep = true;
                    }
                    if (keep) continue;
                    ConnectivityService.log("no live requests for " + nai.name() + "; disconnecting");
                    nai.asyncChannel.disconnect();
                }
                NetworkAgentInfo nai = this.mNetworkForRequestId.get(nri.request.requestId);
                if (nai != null) {
                    this.mNetworkForRequestId.remove(nri.request.requestId);
                    if (nri.request.legacyType != -1) {
                        this.mLegacyTypeTracker.remove(nri.request.legacyType, nai);
                    }
                }
                for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
                    nfi.asyncChannel.sendMessage(536577, nri.request);
                }
            } else {
                for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                    nai.networkRequests.remove(nri.request.requestId);
                }
            }
            this.callCallbackForRequest(nri, null, 524296);
        }
    }

    @Override
    public int tether(String iface) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.tether(iface);
        }
        return 3;
    }

    @Override
    public int untether(String iface) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.untether(iface);
        }
        return 3;
    }

    @Override
    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    @Override
    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    @Override
    public int setUsbTethering(boolean enable) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    @Override
    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    @Override
    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    @Override
    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    @Override
    public String[] getTetheredDhcpRanges() {
        this.enforceConnectivityInternalPermission();
        return this.mTethering.getTetheredDhcpRanges();
    }

    @Override
    public boolean isTetheringSupported() {
        this.enforceTetherAccessPermission();
        int defaultVal = SystemProperties.get("ro.tether.denied").equals("true") ? 0 : 1;
        boolean tetherEnabledInSettings = Settings.Global.getInt(this.mContext.getContentResolver(), "tether_supported", defaultVal) != 0 && !this.mUserManager.hasUserRestriction("no_config_tethering");
        return tetherEnabledInSettings && (this.mTethering.getTetherableUsbRegexs().length != 0 || this.mTethering.getTetherableWifiRegexs().length != 0 || this.mTethering.getTetherableBluetoothRegexs().length != 0) && this.mTethering.getUpstreamIfaceTypes().length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNetworkTransitionWakelock(String forWhom) {
        int serialNum = 0;
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            serialNum = ++this.mNetTransitionWakeLockSerialNumber;
            this.mNetTransitionWakeLock.acquire();
            this.mNetTransitionWakeLockCausedBy = forWhom;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(24, serialNum, 0), this.mNetTransitionWakeLockTimeout);
    }

    @Override
    public void reportInetCondition(int networkType, int percentage) {
        if (percentage > 50) {
            return;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            this.reportBadNetwork(nai.network);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportBadNetwork(Network network) {
        this.enforceAccessPermission();
        this.enforceInternetPermission();
        if (network == null) {
            return;
        }
        int uid = Binder.getCallingUid();
        NetworkAgentInfo nai = null;
        Object object = this.mNetworkForNetId;
        synchronized (object) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai == null) {
            return;
        }
        ConnectivityService.log("reportBadNetwork(" + nai.name() + ") by " + uid);
        object = nai;
        synchronized (object) {
            if (!nai.created) {
                return;
            }
            if (this.isNetworkBlocked(nai, uid)) {
                return;
            }
            nai.networkMonitor.sendMessage(532488, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            ProxyInfo ret = this.mGlobalProxy;
            if (ret == null && !this.mDefaultProxyDisabled) {
                ret = this.mDefaultProxy;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalProxy(ProxyInfo proxyProperties) {
        this.enforceConnectivityInternalPermission();
        Object object = this.mProxyLock;
        synchronized (object) {
            if (proxyProperties == this.mGlobalProxy) {
                return;
            }
            if (proxyProperties != null && proxyProperties.equals(this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals(proxyProperties)) {
                return;
            }
            String host = "";
            int port = 0;
            String exclList = "";
            String pacFileUrl = "";
            if (!(proxyProperties == null || TextUtils.isEmpty(proxyProperties.getHost()) && proxyProperties.getPacFileUrl() == null)) {
                if (!proxyProperties.isValid()) {
                    ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                    return;
                }
                this.mGlobalProxy = new ProxyInfo(proxyProperties);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionListAsString();
                if (proxyProperties.getPacFileUrl() != null) {
                    pacFileUrl = proxyProperties.getPacFileUrl().toString();
                }
            } else {
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(res, "global_http_proxy_host", host);
                Settings.Global.putInt(res, "global_http_proxy_port", port);
                Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclList);
                Settings.Global.putString(res, "global_proxy_pac_url", pacFileUrl);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (this.mGlobalProxy == null) {
                proxyProperties = this.mDefaultProxy;
            }
            this.sendProxyBroadcast(proxyProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Global.getString(res, "global_http_proxy_host");
        int port = Settings.Global.getInt(res, "global_http_proxy_port", 0);
        String exclList = Settings.Global.getString(res, "global_http_proxy_exclusion_list");
        String pacFileUrl = Settings.Global.getString(res, "global_proxy_pac_url");
        if (!TextUtils.isEmpty(host) || !TextUtils.isEmpty(pacFileUrl)) {
            ProxyInfo proxyProperties = !TextUtils.isEmpty(pacFileUrl) ? new ProxyInfo(pacFileUrl) : new ProxyInfo(host, port, exclList);
            if (!proxyProperties.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                return;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getGlobalProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyDefaultProxy(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && proxy.getPacFileUrl() == null) {
            proxy = null;
        }
        Object object = this.mProxyLock;
        synchronized (object) {
            if (this.mDefaultProxy != null && this.mDefaultProxy.equals(proxy)) {
                return;
            }
            if (this.mDefaultProxy == proxy) {
                return;
            }
            if (proxy != null && !proxy.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxy.toString());
                return;
            }
            if (this.mGlobalProxy != null && proxy != null && proxy.getPacFileUrl() != null && proxy.getPacFileUrl().equals(this.mGlobalProxy.getPacFileUrl())) {
                this.mGlobalProxy = proxy;
                this.sendProxyBroadcast(this.mGlobalProxy);
                return;
            }
            this.mDefaultProxy = proxy;
            if (this.mGlobalProxy != null) {
                return;
            }
            if (!this.mDefaultProxyDisabled) {
                this.sendProxyBroadcast(proxy);
            }
        }
    }

    private void handleDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Global.getString(this.mContext.getContentResolver(), "http_proxy");
        if (!TextUtils.isEmpty(proxy)) {
            String[] data = proxy.split(":");
            if (data.length == 0) {
                return;
            }
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyInfo p = new ProxyInfo(data[0], proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProxyBroadcast(ProxyInfo proxy) {
        if (proxy == null) {
            proxy = new ProxyInfo("", 0, "");
        }
        if (this.mPacManager.setCurrentProxyScriptUrl(proxy)) {
            return;
        }
        ConnectivityService.log("sending Proxy Broadcast for " + proxy);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("android.intent.extra.PROXY_INFO", proxy);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }

    int convertFeatureToNetworkType(int networkType, String feature) {
        int usedNetworkType = networkType;
        if (networkType == 0) {
            if (TextUtils.equals(feature, "enableMMS")) {
                usedNetworkType = 2;
            } else if (TextUtils.equals(feature, "enableSUPL")) {
                usedNetworkType = 3;
            } else if (TextUtils.equals(feature, "enableDUN") || TextUtils.equals(feature, "enableDUNAlways")) {
                usedNetworkType = 4;
            } else if (TextUtils.equals(feature, "enableHIPRI")) {
                usedNetworkType = 5;
            } else if (TextUtils.equals(feature, "enableFOTA")) {
                usedNetworkType = 10;
            } else if (TextUtils.equals(feature, "enableIMS")) {
                usedNetworkType = 11;
            } else if (TextUtils.equals(feature, "enableCBS")) {
                usedNetworkType = 12;
            } else if (TextUtils.equals(feature, "enableEmergency")) {
                usedNetworkType = 15;
            } else {
                Slog.e(TAG, "Can't match any mobile netTracker!");
            }
        } else if (networkType == 1) {
            if (TextUtils.equals(feature, "p2p")) {
                usedNetworkType = 13;
            } else {
                Slog.e(TAG, "Can't match any wifi netTracker!");
            }
        } else {
            Slog.e(TAG, "Unexpected network type");
        }
        return usedNetworkType;
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareVpn(String oldPackage, String newPackage) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).prepare(oldPackage, newPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVpnPackageAuthorization(boolean authorized) {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mVpns.get(user).setPackageAuthorization(authorized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).establish(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLegacyVpn(VpnProfile profile) {
        this.throwIfLockdownEnabled();
        LinkProperties egress = this.getActiveLinkProperties();
        if (egress == null) {
            throw new IllegalStateException("Missing active network connection");
        }
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mVpns.get(user).startLegacyVpn(profile, this.mKeyStore, egress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyVpnInfo getLegacyVpnInfo() {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).getLegacyVpnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnConfig getVpnConfig() {
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).getVpnConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockdownVpn() {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Lockdown VPN only available to AID_SYSTEM");
            return false;
        }
        this.mLockdownEnabled = LockdownVpnTracker.isEnabled();
        if (this.mLockdownEnabled) {
            if (!this.mKeyStore.isUnlocked()) {
                Slog.w(TAG, "KeyStore locked; unable to create LockdownTracker");
                return false;
            }
            String profileName = new String(this.mKeyStore.get("LOCKDOWN_VPN"));
            VpnProfile profile = VpnProfile.decode(profileName, this.mKeyStore.get("VPN_" + profileName));
            int user = UserHandle.getUserId(Binder.getCallingUid());
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                this.setLockdownTracker(new LockdownVpnTracker(this.mContext, this.mNetd, this, this.mVpns.get(user), profile));
            }
        } else {
            this.setLockdownTracker(null);
        }
        return true;
    }

    private void setLockdownTracker(LockdownVpnTracker tracker) {
        LockdownVpnTracker existing = this.mLockdownTracker;
        this.mLockdownTracker = null;
        if (existing != null) {
            existing.shutdown();
        }
        try {
            if (tracker != null) {
                this.mNetd.setFirewallEnabled(true);
                this.mNetd.setFirewallInterfaceRule("lo", true);
                this.mLockdownTracker = tracker;
                this.mLockdownTracker.init();
            } else {
                this.mNetd.setFirewallEnabled(false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void throwIfLockdownEnabled() {
        if (this.mLockdownEnabled) {
            throw new IllegalStateException("Unavailable in lockdown mode");
        }
    }

    @Override
    public void supplyMessenger(int networkType, Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType) && this.mNetTrackers[networkType] != null) {
            this.mNetTrackers[networkType].supplyMessenger(messenger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findConnectionTypeForIface(String iface) {
        this.enforceConnectivityInternalPermission();
        if (TextUtils.isEmpty(iface)) {
            return -1;
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mNetworkForNetId.size(); ++i) {
                NetworkAgentInfo nai = this.mNetworkForNetId.valueAt(i);
                LinkProperties lp = nai.linkProperties;
                if (lp == null || !iface.equals(lp.getInterfaceName()) || nai.networkInfo == null) continue;
                return nai.networkInfo.getType();
            }
        }
        return -1;
    }

    private void setEnableFailFastMobileData(int enabled) {
        int tag = enabled == 1 ? this.mEnableFailFastMobileDataTag.incrementAndGet() : this.mEnableFailFastMobileDataTag.get();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(14, tag, enabled));
    }

    @Override
    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        return -1;
    }

    private void setProvNotificationVisible(boolean visible, int networkType, String action) {
        ConnectivityService.log("setProvNotificationVisible: E visible=" + visible + " networkType=" + networkType + " action=" + action);
        Intent intent = new Intent(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        int id2 = 65536 + (networkType - -1);
        this.setProvNotificationVisibleIntent(visible, id2, networkType, null, pendingIntent);
    }

    private void setProvNotificationVisibleIntent(boolean visible, int id2, int networkType, String extraInfo, PendingIntent intent) {
        ConnectivityService.log("setProvNotificationVisibleIntent: E visible=" + visible + " networkType=" + networkType + " extraInfo=" + extraInfo);
        Resources r = Resources.getSystem();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            int icon;
            String details;
            String title;
            Notification notification = new Notification();
            switch (networkType) {
                case 1: {
                    title = r.getString(17040548, 0);
                    details = r.getString(17040550, extraInfo);
                    icon = 17303126;
                    break;
                }
                case 0: 
                case 5: {
                    title = r.getString(17040549, 0);
                    details = this.mTelephonyManager.getNetworkOperatorName();
                    icon = 17303122;
                    break;
                }
                default: {
                    title = r.getString(17040549, 0);
                    details = r.getString(17040550, extraInfo);
                    icon = 17303122;
                }
            }
            notification.when = 0L;
            notification.icon = icon;
            notification.flags = 16;
            notification.tickerText = title;
            notification.color = this.mContext.getResources().getColor(17170520);
            notification.setLatestEventInfo(this.mContext, title, details, notification.contentIntent);
            notification.contentIntent = intent;
            try {
                notificationManager.notify(NOTIFICATION_ID, id2, notification);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificaitionVisible: visible notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        } else {
            try {
                notificationManager.cancel(NOTIFICATION_ID, id2);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificaitionVisible: cancel notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        }
        this.mIsNotificationVisible = visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProvisioningUrlBaseFromFile(int type) {
        block32: {
            String element;
            String tagType;
            FileReader fileReader = null;
            XmlPullParser parser = null;
            Configuration config = this.mContext.getResources().getConfiguration();
            switch (type) {
                case 2: {
                    tagType = TAG_PROVISIONING_URL;
                    break;
                }
                case 1: {
                    tagType = TAG_REDIRECTED_URL;
                    break;
                }
                default: {
                    throw new RuntimeException("getProvisioningUrlBaseFromFile: Unexpected parameter " + type);
                }
            }
            try {
                fileReader = new FileReader(this.mProvisioningUrlFile);
                parser = Xml.newPullParser();
                parser.setInput(fileReader);
                XmlUtils.beginDocument(parser, TAG_PROVISIONING_URLS);
                while (true) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) break;
                    if (!element.equals(tagType)) continue;
                    String mcc = parser.getAttributeValue(null, ATTR_MCC);
                    try {
                        String mnc;
                        if (mcc != null && Integer.parseInt(mcc) == config.mcc && (mnc = parser.getAttributeValue(null, ATTR_MNC)) != null && Integer.parseInt(mnc) == config.mnc) {
                            parser.next();
                            if (parser.getEventType() == 4) {
                                String string2 = parser.getText();
                                return string2;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        ConnectivityService.loge("NumberFormatException in getProvisioningUrlBaseFromFile: " + e);
                    }
                }
                element = null;
            }
            catch (FileNotFoundException e) {
                ConnectivityService.loge("Carrier Provisioning Urls file not found");
                break block32;
            }
            catch (XmlPullParserException e) {
                ConnectivityService.loge("Xml parser exception reading Carrier Provisioning Urls file: " + e);
                break block32;
            }
            catch (IOException e) {
                ConnectivityService.loge("I/O exception reading Carrier Provisioning Urls file: " + e);
                break block32;
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return element;
        }
        return null;
    }

    @Override
    public String getMobileRedirectedProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile(1);
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17039403);
        }
        return url;
    }

    @Override
    public String getMobileProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile(2);
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17039402);
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioining_url from resource =" + url);
        } else {
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioning_url from File =" + url);
        }
        if (!TextUtils.isEmpty(url)) {
            String phoneNumber = this.mTelephonyManager.getLine1Number();
            if (TextUtils.isEmpty(phoneNumber)) {
                phoneNumber = "0000000000";
            }
            url = String.format(url, this.mTelephonyManager.getSimSerialNumber(), this.mTelephonyManager.getDeviceId(), phoneNumber);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            this.setProvNotificationVisible(visible, networkType, action);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAirplaneMode(boolean enable) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "airplane_mode_on", enable ? 1 : 0);
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            intent.putExtra("state", enable);
            this.mContext.sendBroadcast(intent);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStart(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn != null) {
                ConnectivityService.loge("Starting user already has a VPN");
                return;
            }
            userVpn = new Vpn(this.mHandler.getLooper(), this.mContext, this.mNetd, this, userId);
            this.mVpns.put(userId, userVpn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStop(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn == null) {
                ConnectivityService.loge("Stopping user has no VPN");
                return;
            }
            this.mVpns.delete(userId);
        }
    }

    @Override
    public LinkQualityInfo getLinkQualityInfo(int networkType) {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(networkType) && this.mNetTrackers[networkType] != null) {
            return this.mNetTrackers[networkType].getLinkQualityInfo();
        }
        return null;
    }

    @Override
    public LinkQualityInfo getActiveLinkQualityInfo() {
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid(this.mActiveDefaultNetwork) && this.mNetTrackers[this.mActiveDefaultNetwork] != null) {
            return this.mNetTrackers[this.mActiveDefaultNetwork].getLinkQualityInfo();
        }
        return null;
    }

    @Override
    public LinkQualityInfo[] getAllLinkQualityInfo() {
        this.enforceAccessPermission();
        ArrayList<LinkQualityInfo> result = Lists.newArrayList();
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            LinkQualityInfo li;
            if (tracker == null || (li = tracker.getLinkQualityInfo()) == null) continue;
            result.add(li);
        }
        return result.toArray(new LinkQualityInfo[result.size()]);
    }

    private void handleNetworkSamplingTimeout() {
        String ifaceName;
        HashMap<String, SamplingDataTracker.SamplingSnapshot> mapIfaceToSample = new HashMap<String, SamplingDataTracker.SamplingSnapshot>();
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            if (tracker == null || (ifaceName = tracker.getNetworkInterfaceName()) == null) continue;
            mapIfaceToSample.put(ifaceName, null);
        }
        SamplingDataTracker.getSamplingSnapshots(mapIfaceToSample);
        for (NetworkStateTracker tracker : this.mNetTrackers) {
            SamplingDataTracker.SamplingSnapshot ss;
            if (tracker == null || (ss = (SamplingDataTracker.SamplingSnapshot)mapIfaceToSample.get(ifaceName = tracker.getNetworkInterfaceName())) == null) continue;
            tracker.stopSampling(ss);
            tracker.startSampling(ss);
        }
        int samplingIntervalInSeconds = Settings.Global.getInt(this.mContext.getContentResolver(), "connectivity_sampling_interval_in_seconds", 720);
        this.setAlarm(samplingIntervalInSeconds * 1000, this.mSampleIntervalElapsedIntent);
    }

    void setAlarm(int timeoutInMilliseconds, PendingIntent intent) {
        long wakeupTime = SystemClock.elapsedRealtime() + (long)timeoutInMilliseconds;
        int alarmType = Resources.getSystem().getBoolean(17956981) ? 2 : 3;
        this.mAlarmManager.set(alarmType, wakeupTime, intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkRequest requestNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, int timeoutMs, IBinder binder, int legacyType) {
        if (!networkCapabilities.hasCapability(13)) {
            this.enforceConnectivityInternalPermission();
        } else {
            this.enforceChangePermission();
        }
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        if (!networkCapabilities.hasCapability(11)) {
            int uidRules;
            int uid = Binder.getCallingUid();
            Object object = this.mRulesLock;
            synchronized (object) {
                uidRules = this.mUidRules.get(uid, 0);
            }
            if ((uidRules & 1) != 0) {
                networkCapabilities.addCapability(11);
            }
        }
        if (timeoutMs < 0 || timeoutMs > 6000000) {
            throw new IllegalArgumentException("Bad timeout specified");
        }
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, legacyType, this.nextNetworkRequestId());
        ConnectivityService.log("requestNetwork for " + networkRequest);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder, true);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(19, nri));
        if (timeoutMs > 0) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(20, nri), timeoutMs);
        }
        return networkRequest;
    }

    @Override
    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        return null;
    }

    @Override
    public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder) {
        this.enforceAccessPermission();
        NetworkRequest networkRequest = new NetworkRequest(new NetworkCapabilities(networkCapabilities), -1, this.nextNetworkRequestId());
        ConnectivityService.log("listenForNetwork for " + networkRequest);
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder, false);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
        return networkRequest;
    }

    @Override
    public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
    }

    @Override
    public void releaseNetworkRequest(NetworkRequest networkRequest) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(22, ConnectivityService.getCallingUid(), 0, networkRequest));
    }

    @Override
    public void registerNetworkFactory(Messenger messenger, String name) {
        this.enforceConnectivityInternalPermission();
        NetworkFactoryInfo nfi = new NetworkFactoryInfo(name, messenger, new AsyncChannel());
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, nfi));
    }

    private void handleRegisterNetworkFactory(NetworkFactoryInfo nfi) {
        ConnectivityService.log("Got NetworkFactory Messenger for " + nfi.name);
        this.mNetworkFactoryInfos.put(nfi.messenger, nfi);
        nfi.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nfi.messenger);
    }

    @Override
    public void unregisterNetworkFactory(Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(23, messenger));
    }

    private void handleUnregisterNetworkFactory(Messenger messenger) {
        NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(messenger);
        if (nfi == null) {
            ConnectivityService.loge("Failed to find Messenger in unregisterNetworkFactory");
            return;
        }
        ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
    }

    private boolean isDefaultNetwork(NetworkAgentInfo nai) {
        return this.mNetworkForRequestId.get(this.mDefaultRequest.requestId) == nai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int currentScore, NetworkMisc networkMisc) {
        this.enforceConnectivityInternalPermission();
        NetworkAgentInfo nai = new NetworkAgentInfo(messenger, new AsyncChannel(), new NetworkInfo(networkInfo), new LinkProperties(linkProperties), new NetworkCapabilities(networkCapabilities), currentScore, this.mContext, this.mTrackerHandler, new NetworkMisc(networkMisc));
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            nai.networkMonitor.systemReady = this.mSystemReady;
        }
        ConnectivityService.log("registerNetworkAgent " + nai);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(18, nai));
    }

    private void handleRegisterNetworkAgent(NetworkAgentInfo na) {
        this.mNetworkAgentInfos.put(na.messenger, na);
        this.assignNextNetId(na);
        na.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, na.messenger);
        NetworkInfo networkInfo = na.networkInfo;
        na.networkInfo = null;
        this.updateNetworkInfo(na, networkInfo);
    }

    private void updateLinkProperties(NetworkAgentInfo networkAgent, LinkProperties oldLp) {
        LinkProperties newLp = networkAgent.linkProperties;
        int netId = networkAgent.network.netId;
        this.mClat.fixupLinkProperties(networkAgent, oldLp);
        this.updateInterfaces(newLp, oldLp, netId);
        this.updateMtu(newLp, oldLp);
        this.updateTcpBufferSizes(networkAgent);
        boolean flushDns = this.updateRoutes(newLp, oldLp, netId);
        this.updateDnses(newLp, oldLp, netId, flushDns);
        this.updateClat(newLp, oldLp, networkAgent);
        if (this.isDefaultNetwork(networkAgent)) {
            this.handleApplyDefaultProxy(newLp.getHttpProxy());
        }
        if (!Objects.equals(newLp, oldLp)) {
            this.notifyNetworkCallbacks(networkAgent, 524295);
        }
    }

    private void updateClat(LinkProperties newLp, LinkProperties oldLp, NetworkAgentInfo na) {
        boolean wasRunningClat = this.mClat.isRunningClat(na);
        boolean shouldRunClat = Nat464Xlat.requiresClat(na);
        if (!wasRunningClat && shouldRunClat) {
            this.mClat.startClat(na);
        } else if (wasRunningClat && !shouldRunClat) {
            this.mClat.stopClat();
        }
    }

    private void updateInterfaces(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<Object> interfaceDiff = new LinkProperties.CompareResult();
        if (oldLp != null) {
            interfaceDiff = oldLp.compareAllInterfaceNames(newLp);
        } else if (newLp != null) {
            interfaceDiff.added = newLp.getAllInterfaceNames();
        }
        for (String iface : interfaceDiff.added) {
            try {
                ConnectivityService.log("Adding iface " + iface + " to network " + netId);
                this.mNetd.addInterfaceToNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception adding interface: " + e);
            }
        }
        for (String iface : interfaceDiff.removed) {
            try {
                ConnectivityService.log("Removing iface " + iface + " from network " + netId);
                this.mNetd.removeInterfaceFromNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception removing interface: " + e);
            }
        }
    }

    private boolean updateRoutes(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<Object> routeDiff = new LinkProperties.CompareResult();
        if (oldLp != null) {
            routeDiff = oldLp.compareAllRoutes(newLp);
        } else if (newLp != null) {
            routeDiff.added = newLp.getAllRoutes();
        }
        for (RouteInfo route : routeDiff.added) {
            if (route.hasGateway()) continue;
            ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getDestination().getAddress() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for non-gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.added) {
            if (!route.hasGateway()) continue;
            ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getGateway() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.removed) {
            ConnectivityService.log("Removing Route [" + route + "] from network " + netId);
            try {
                this.mNetd.removeRoute(netId, route);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeRoute: " + e);
            }
        }
        return !routeDiff.added.isEmpty() || !routeDiff.removed.isEmpty();
    }

    private void updateDnses(LinkProperties newLp, LinkProperties oldLp, int netId, boolean flush) {
        if (oldLp == null || !newLp.isIdenticalDnses(oldLp)) {
            List<InetAddress> dnses = newLp.getDnsServers();
            if (dnses.size() == 0 && this.mDefaultDns != null) {
                dnses = new ArrayList<InetAddress>();
                dnses.add(this.mDefaultDns);
                ConnectivityService.loge("no dns provided for netId " + netId + ", so using defaults");
            }
            ConnectivityService.log("Setting Dns servers for network " + netId + " to " + dnses);
            try {
                this.mNetd.setDnsServersForNetwork(netId, NetworkUtils.makeStrings(dnses), newLp.getDomains());
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setDnsServersForNetwork: " + e);
            }
            NetworkAgentInfo defaultNai = this.mNetworkForRequestId.get(this.mDefaultRequest.requestId);
            if (defaultNai != null && defaultNai.network.netId == netId) {
                this.setDefaultDnsSystemProperties(dnses);
            }
            this.flushVmDnsCache();
        } else if (flush) {
            try {
                this.mNetd.flushNetworkDnsCache(netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in flushNetworkDnsCache: " + e);
            }
            this.flushVmDnsCache();
        }
    }

    private void setDefaultDnsSystemProperties(Collection<InetAddress> dnses) {
        int last = 0;
        for (InetAddress dns : dnses) {
            String key = "net.dns" + ++last;
            String value = dns.getHostAddress();
            SystemProperties.set(key, value);
        }
        for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
            String key = "net.dns" + i;
            SystemProperties.set(key, "");
        }
        this.mNumDnsEntries = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilities(NetworkAgentInfo networkAgent, NetworkCapabilities networkCapabilities) {
        if (!Objects.equals(networkAgent.networkCapabilities, networkCapabilities)) {
            NetworkAgentInfo networkAgentInfo = networkAgent;
            synchronized (networkAgentInfo) {
                networkAgent.networkCapabilities = networkCapabilities;
            }
            this.notifyNetworkCallbacks(networkAgent, 524294);
        }
    }

    private void sendUpdatedScoreToFactories(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.networkRequests.size(); ++i) {
            NetworkRequest nr = nai.networkRequests.valueAt(i);
            if (!this.isRequest(nr)) continue;
            this.sendUpdatedScoreToFactories(nr, nai.getCurrentScore());
        }
    }

    private void sendUpdatedScoreToFactories(NetworkRequest networkRequest, int score) {
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            nfi.asyncChannel.sendMessage(536576, score, 0, networkRequest);
        }
    }

    private void callCallbackForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType) {
        if (nri.messenger == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(NetworkRequest.class.getSimpleName(), new NetworkRequest(nri.request));
        Message msg = Message.obtain();
        if (notificationType != 524293 && notificationType != 524296) {
            bundle.putParcelable(Network.class.getSimpleName(), networkAgent.network);
        }
        switch (notificationType) {
            case 524291: {
                msg.arg1 = 30000;
                break;
            }
            case 524294: {
                bundle.putParcelable(NetworkCapabilities.class.getSimpleName(), new NetworkCapabilities(networkAgent.networkCapabilities));
                break;
            }
            case 524295: {
                bundle.putParcelable(LinkProperties.class.getSimpleName(), new LinkProperties(networkAgent.linkProperties));
            }
        }
        msg.what = notificationType;
        msg.setData(bundle);
        try {
            nri.messenger.send(msg);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("RemoteException caught trying to send a callback msg for " + nri.request);
        }
    }

    private void teardownUnneededNetwork(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.networkRequests.size(); ++i) {
            NetworkRequest nr = nai.networkRequests.valueAt(i);
            if (!this.isRequest(nr)) continue;
            ConnectivityService.loge("Dead network still had at least " + nr);
            break;
        }
        nai.asyncChannel.disconnect();
    }

    private void handleLingerComplete(NetworkAgentInfo oldNetwork) {
        if (oldNetwork == null) {
            ConnectivityService.loge("Unknown NetworkAgentInfo in handleLingerComplete");
            return;
        }
        ConnectivityService.log("handleLingerComplete for " + oldNetwork.name());
        this.teardownUnneededNetwork(oldNetwork);
    }

    private void makeDefault(NetworkAgentInfo newNetwork) {
        ConnectivityService.log("Switching to new default network: " + newNetwork);
        this.mActiveDefaultNetwork = newNetwork.networkInfo.getType();
        this.setupDataActivityTracking(newNetwork);
        try {
            this.mNetd.setDefaultNetId(newNetwork.network.netId);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception setting default network :" + e);
        }
        this.notifyLockdownVpn(newNetwork);
        this.handleApplyDefaultProxy(newNetwork.linkProperties.getHttpProxy());
        this.updateTcpBufferSizes(newNetwork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rematchNetworkAndRequests(NetworkAgentInfo newNetwork, boolean nascent) {
        if (!newNetwork.created) {
            ConnectivityService.loge("ERROR: uncreated network being rematched.");
        }
        if (nascent && !newNetwork.validated) {
            ConnectivityService.loge("ERROR: nascent network not validated.");
        }
        boolean keep = newNetwork.isVPN();
        boolean isNewDefault = false;
        ConnectivityService.log("rematching " + newNetwork.name());
        ArrayList<NetworkAgentInfo> affectedNetworks = new ArrayList<NetworkAgentInfo>();
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            NetworkAgentInfo currentNetwork = this.mNetworkForRequestId.get(nri.request.requestId);
            if (newNetwork == currentNetwork) {
                ConnectivityService.log("Network " + newNetwork.name() + " was already satisfying" + " request " + nri.request.requestId + ". No change.");
                keep = true;
                continue;
            }
            if (!nri.request.networkCapabilities.satisfiedByNetworkCapabilities(newNetwork.networkCapabilities)) continue;
            if (!nri.isRequest) {
                newNetwork.addRequest(nri.request);
                continue;
            }
            if (currentNetwork != null && currentNetwork.getCurrentScore() >= newNetwork.getCurrentScore()) continue;
            if (currentNetwork != null) {
                ConnectivityService.log("   accepting network in place of " + currentNetwork.name());
                currentNetwork.networkRequests.remove(nri.request.requestId);
                currentNetwork.networkLingered.add(nri.request);
                affectedNetworks.add(currentNetwork);
            } else {
                ConnectivityService.log("   accepting network in place of null");
            }
            this.mNetworkForRequestId.put(nri.request.requestId, newNetwork);
            newNetwork.addRequest(nri.request);
            if (nri.isRequest && nri.request.legacyType != -1) {
                this.mLegacyTypeTracker.add(nri.request.legacyType, newNetwork);
            }
            keep = true;
            this.sendUpdatedScoreToFactories(nri.request, newNetwork.getCurrentScore());
            if (this.mDefaultRequest.requestId != nri.request.requestId) continue;
            isNewDefault = true;
            this.mActiveDefaultNetwork = newNetwork.networkInfo.getType();
            if (newNetwork.linkProperties != null) {
                this.updateTcpBufferSizes(newNetwork);
                this.setDefaultDnsSystemProperties(newNetwork.linkProperties.getDnsServers());
            } else {
                this.setDefaultDnsSystemProperties(new ArrayList<InetAddress>());
            }
            if (currentNetwork != null) {
                this.mLegacyTypeTracker.remove(currentNetwork.networkInfo.getType(), currentNetwork);
            }
            this.mDefaultInetConditionPublished = newNetwork.validated ? 100 : 0;
            this.mLegacyTypeTracker.add(newNetwork.networkInfo.getType(), newNetwork);
            this.notifyLockdownVpn(newNetwork);
        }
        for (NetworkAgentInfo nai : affectedNetworks) {
            boolean teardown = !nai.isVPN() && nai.validated;
            for (int i = 0; i < nai.networkRequests.size() && teardown; ++i) {
                NetworkRequest nr = nai.networkRequests.valueAt(i);
                try {
                    if (!this.isRequest(nr)) continue;
                    teardown = false;
                    continue;
                }
                catch (Exception e) {
                    ConnectivityService.loge("Request " + nr + " not found in mNetworkRequests.");
                    ConnectivityService.loge("  it came from request list  of " + nai.name());
                }
            }
            if (teardown) {
                nai.networkMonitor.sendMessage(532483);
                this.notifyNetworkCallbacks(nai, 524291);
                continue;
            }
            nai.networkLingered.clear();
        }
        if (keep) {
            if (isNewDefault) {
                this.makeDefault(newNetwork);
                ConnectivityService i$ = this;
                synchronized (i$) {
                    if (this.mNetTransitionWakeLock.isHeld()) {
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8, this.mNetTransitionWakeLockSerialNumber, 0), 1000L);
                    }
                }
            }
            try {
                IBatteryStats bs = BatteryStatsService.getService();
                int type = newNetwork.networkInfo.getType();
                String baseIface = newNetwork.linkProperties.getInterfaceName();
                bs.noteNetworkInterfaceType(baseIface, type);
                for (LinkProperties stacked : newNetwork.linkProperties.getStackedLinks()) {
                    String stackedIface = stacked.getInterfaceName();
                    bs.noteNetworkInterfaceType(stackedIface, type);
                    NetworkStatsFactory.noteStackedIface(stackedIface, baseIface);
                }
            }
            catch (RemoteException ignored) {
                // empty catch block
            }
            this.notifyNetworkCallbacks(newNetwork, 524290);
        } else if (nascent) {
            ConnectivityService.log("Validated network turns out to be unwanted.  Tear it down.");
            this.teardownUnneededNetwork(newNetwork);
        }
    }

    private void rematchAllNetworksAndRequests(NetworkAgentInfo changed, int oldScore) {
        if (changed != null && oldScore < changed.getCurrentScore()) {
            this.rematchNetworkAndRequests(changed, false);
        } else {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                this.rematchNetworkAndRequests(nai, false);
            }
        }
    }

    private void updateInetCondition(NetworkAgentInfo nai, boolean valid) {
        int newInetCondition;
        if (!nai.validated) {
            return;
        }
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        int n = newInetCondition = valid ? 100 : 0;
        if (newInetCondition == this.mDefaultInetConditionPublished) {
            return;
        }
        this.mDefaultInetConditionPublished = newInetCondition;
        this.sendInetConditionBroadcast(nai.networkInfo);
    }

    private void notifyLockdownVpn(NetworkAgentInfo nai) {
        if (this.mLockdownTracker != null) {
            if (nai != null && nai.isVPN()) {
                this.mLockdownTracker.onVpnStateChanged(nai.networkInfo);
            } else {
                this.mLockdownTracker.onNetworkInfoChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkInfo(NetworkAgentInfo networkAgent, NetworkInfo newInfo) {
        NetworkInfo.State state = newInfo.getState();
        NetworkInfo oldInfo = null;
        Object object = networkAgent;
        synchronized (object) {
            oldInfo = networkAgent.networkInfo;
            networkAgent.networkInfo = newInfo;
        }
        this.notifyLockdownVpn(networkAgent);
        if (oldInfo != null && oldInfo.getState() == state) {
            return;
        }
        ConnectivityService.log(networkAgent.name() + " EVENT_NETWORK_INFO_CHANGED, going from " + (oldInfo == null ? "null" : oldInfo.getState()) + " to " + (Object)((Object)state));
        if (state == NetworkInfo.State.CONNECTED && !networkAgent.created) {
            try {
                if (networkAgent.isVPN()) {
                    this.mNetd.createVirtualNetwork(networkAgent.network.netId, !networkAgent.linkProperties.getDnsServers().isEmpty(), networkAgent.networkMisc == null || !networkAgent.networkMisc.allowBypass);
                } else {
                    this.mNetd.createPhysicalNetwork(networkAgent.network.netId);
                }
            }
            catch (Exception e) {
                ConnectivityService.loge("Error creating network " + networkAgent.network.netId + ": " + e.getMessage());
                return;
            }
            networkAgent.created = true;
            this.updateLinkProperties(networkAgent, null);
            this.notifyNetworkCallbacks(networkAgent, 524289);
            networkAgent.networkMonitor.sendMessage(532481);
            if (networkAgent.isVPN()) {
                object = this.mProxyLock;
                synchronized (object) {
                    if (!this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = true;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(null);
                        }
                    }
                }
            }
            this.rematchNetworkAndRequests(networkAgent, false);
        } else if (state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.SUSPENDED) {
            networkAgent.asyncChannel.disconnect();
            if (networkAgent.isVPN()) {
                object = this.mProxyLock;
                synchronized (object) {
                    if (this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = false;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(this.mDefaultProxy);
                        }
                    }
                }
            }
        }
    }

    private void updateNetworkScore(NetworkAgentInfo nai, int score) {
        ConnectivityService.log("updateNetworkScore for " + nai.name() + " to " + score);
        if (score < 0) {
            ConnectivityService.loge("updateNetworkScore for " + nai.name() + " got a negative score (" + score + ").  Bumping score to min of 0");
            score = 0;
        }
        int oldScore = nai.getCurrentScore();
        nai.setCurrentScore(score);
        if (nai.created) {
            this.rematchAllNetworksAndRequests(nai, oldScore);
        }
        this.sendUpdatedScoreToFactories(nai);
    }

    protected void notifyNetworkCallback(NetworkAgentInfo nai, NetworkRequestInfo nri) {
        int notifyType = 524290;
        this.callCallbackForRequest(nri, nai, notifyType);
    }

    private void sendLegacyNetworkBroadcast(NetworkAgentInfo nai, boolean connected, int type) {
        NetworkInfo info = new NetworkInfo(nai.networkInfo);
        info.setType(type);
        if (connected) {
            info.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, info.getExtraInfo());
            this.sendConnectedBroadcastDelayed(info, this.getConnectivityChangeDelay());
        } else {
            info.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, info.getExtraInfo());
            Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
            intent.putExtra("networkInfo", info);
            intent.putExtra("networkType", info.getType());
            if (info.isFailover()) {
                intent.putExtra("isFailover", true);
                nai.networkInfo.setFailover(false);
            }
            if (info.getReason() != null) {
                intent.putExtra("reason", info.getReason());
            }
            if (info.getExtraInfo() != null) {
                intent.putExtra("extraInfo", info.getExtraInfo());
            }
            NetworkAgentInfo newDefaultAgent = null;
            if (nai.networkRequests.get(this.mDefaultRequest.requestId) != null) {
                newDefaultAgent = this.mNetworkForRequestId.get(this.mDefaultRequest.requestId);
                if (newDefaultAgent != null) {
                    intent.putExtra("otherNetwork", newDefaultAgent.networkInfo);
                } else {
                    intent.putExtra("noConnectivity", true);
                }
            }
            intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
            Intent immediateIntent = new Intent(intent);
            immediateIntent.setAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
            this.sendStickyBroadcast(immediateIntent);
            this.sendStickyBroadcastDelayed(intent, this.getConnectivityChangeDelay());
            if (newDefaultAgent != null) {
                this.sendConnectedBroadcastDelayed(newDefaultAgent.networkInfo, this.getConnectivityChangeDelay());
            }
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType) {
        ConnectivityService.log("notifyType " + this.notifyTypeToName(notifyType) + " for " + networkAgent.name());
        for (int i = 0; i < networkAgent.networkRequests.size(); ++i) {
            NetworkRequest nr = networkAgent.networkRequests.valueAt(i);
            NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
            this.callCallbackForRequest(nri, networkAgent, notifyType);
        }
    }

    private String notifyTypeToName(int notifyType) {
        switch (notifyType) {
            case 524289: {
                return "PRECHECK";
            }
            case 524290: {
                return "AVAILABLE";
            }
            case 524291: {
                return "LOSING";
            }
            case 524292: {
                return "LOST";
            }
            case 524293: {
                return "UNAVAILABLE";
            }
            case 524294: {
                return "CAP_CHANGED";
            }
            case 524295: {
                return "IP_CHANGED";
            }
            case 524296: {
                return "RELEASED";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkProperties getLinkPropertiesForTypeInternal(int networkType) {
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return new LinkProperties();
    }

    private NetworkInfo getNetworkInfoForType(int networkType) {
        if (!this.mLegacyTypeTracker.isTypeSupported(networkType)) {
            return null;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkInfo result = new NetworkInfo(nai.networkInfo);
            result.setType(networkType);
            return result;
        }
        NetworkInfo result = new NetworkInfo(networkType, 0, ConnectivityManager.getNetworkTypeName(networkType), "");
        result.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        result.setIsAvailable(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkCapabilities getNetworkCapabilitiesForType(int networkType) {
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new NetworkCapabilities(nai.networkCapabilities);
            }
        }
        return new NetworkCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVpnAddress(String address, int prefixLength) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).addAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVpnAddress(String address, int prefixLength) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).removeAddress(address, prefixLength);
        }
    }

    private class NetworkRequestInfo
    implements IBinder.DeathRecipient {
        static final boolean REQUEST = true;
        static final boolean LISTEN = false;
        final NetworkRequest request;
        IBinder mBinder;
        final int mPid;
        final int mUid;
        final Messenger messenger;
        final boolean isRequest;

        NetworkRequestInfo(Messenger m, NetworkRequest r, IBinder binder, boolean isRequest) {
            this.messenger = m;
            this.request = r;
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.isRequest = isRequest;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            ConnectivityService.log("ConnectivityService NetworkRequestInfo binderDied(" + this.request + ", " + this.mBinder + ")");
            ConnectivityService.this.releaseNetworkRequest(this.request);
        }

        public String toString() {
            return (this.isRequest ? "Request" : "Listen") + " from uid/pid:" + this.mUid + "/" + this.mPid + " for " + this.request;
        }
    }

    private static class NetworkFactoryInfo {
        public final String name;
        public final Messenger messenger;
        public final AsyncChannel asyncChannel;

        public NetworkFactoryInfo(String name, Messenger messenger, AsyncChannel asyncChannel) {
            this.name = name;
            this.messenger = messenger;
            this.asyncChannel = asyncChannel;
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mWhat;
        private Handler mHandler;

        SettingsObserver(Handler handler, int what) {
            super(handler);
            this.mHandler = handler;
            this.mWhat = what;
        }

        void observe(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Global.getUriFor("http_proxy"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mWhat).sendToTarget();
        }
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: 
                case 24: {
                    String causedBy = null;
                    ConnectivityService connectivityService = ConnectivityService.this;
                    synchronized (connectivityService) {
                        if (msg.arg1 != ConnectivityService.this.mNetTransitionWakeLockSerialNumber || !ConnectivityService.this.mNetTransitionWakeLock.isHeld()) {
                            break;
                        }
                        ConnectivityService.this.mNetTransitionWakeLock.release();
                        causedBy = ConnectivityService.this.mNetTransitionWakeLockCausedBy;
                    }
                    if (msg.what == 24) {
                        ConnectivityService.log("Failed to find a new network - expiring NetTransition Wakelock");
                        break;
                    }
                    ConnectivityService.log("NetTransition Wakelock (" + (causedBy == null ? "unknown" : causedBy) + " cleared because we found a replacement network");
                    break;
                }
                case 9: {
                    ConnectivityService.this.handleDeprecatedGlobalHttpProxy();
                    break;
                }
                case 10: {
                    boolean met = msg.arg1 == 1;
                    ConnectivityService.this.handleSetDependencyMet(msg.arg2, met);
                    break;
                }
                case 11: {
                    Intent intent = (Intent)msg.obj;
                    ConnectivityService.this.sendStickyBroadcast(intent);
                    break;
                }
                case 12: {
                    int networkType = msg.arg1;
                    boolean enabled = msg.arg2 == 1;
                    ConnectivityService.this.handleSetPolicyDataEnable(networkType, enabled);
                    break;
                }
                case 14: {
                    int tag = ConnectivityService.this.mEnableFailFastMobileDataTag.get();
                    if (msg.arg1 == tag) {
                        MobileDataStateTracker mobileDst = (MobileDataStateTracker)ConnectivityService.this.mNetTrackers[0];
                        if (mobileDst == null) break;
                        mobileDst.setEnableFailFastMobileData(msg.arg2);
                        break;
                    }
                    ConnectivityService.log("EVENT_ENABLE_FAIL_FAST_MOBILE_DATA: stale arg1:" + msg.arg1 + " != tag:" + tag);
                    break;
                }
                case 15: {
                    ConnectivityService.this.handleNetworkSamplingTimeout();
                    break;
                }
                case 16: {
                    ConnectivityService.this.handleApplyDefaultProxy((ProxyInfo)msg.obj);
                    break;
                }
                case 17: {
                    ConnectivityService.this.handleRegisterNetworkFactory((NetworkFactoryInfo)msg.obj);
                    break;
                }
                case 23: {
                    ConnectivityService.this.handleUnregisterNetworkFactory((Messenger)msg.obj);
                    break;
                }
                case 18: {
                    ConnectivityService.this.handleRegisterNetworkAgent((NetworkAgentInfo)msg.obj);
                    break;
                }
                case 19: 
                case 21: {
                    ConnectivityService.this.handleRegisterNetworkRequest(msg);
                    break;
                }
                case 22: {
                    ConnectivityService.this.handleReleaseNetworkRequest((NetworkRequest)msg.obj, msg.arg1);
                    break;
                }
                case 25: {
                    for (NetworkAgentInfo nai : ConnectivityService.this.mNetworkAgentInfos.values()) {
                        nai.networkMonitor.systemReady = true;
                    }
                    break;
                }
            }
        }
    }

    private class NetworkStateTrackerHandler
    extends Handler {
        public NetworkStateTrackerHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    ConnectivityService.this.handleAsyncChannelHalfConnect(msg);
                    break;
                }
                case 69635: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) break;
                    nai.asyncChannel.disconnect();
                    break;
                }
                case 69636: {
                    ConnectivityService.this.handleAsyncChannelDisconnected(msg);
                    break;
                }
                case 528386: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_CAPABILITIES_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    ConnectivityService.this.updateCapabilities(nai, (NetworkCapabilities)msg.obj);
                    break;
                }
                case 528387: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("NetworkAgent not found for EVENT_NETWORK_PROPERTIES_CHANGED");
                        break;
                    }
                    LinkProperties oldLp = nai.linkProperties;
                    NetworkAgentInfo networkAgentInfo = nai;
                    synchronized (networkAgentInfo) {
                        nai.linkProperties = (LinkProperties)msg.obj;
                    }
                    if (!nai.created) break;
                    ConnectivityService.this.updateLinkProperties(nai, oldLp);
                    break;
                }
                case 528385: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_INFO_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.updateNetworkInfo(nai, info);
                    break;
                }
                case 528388: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_SCORE_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    Integer score = (Integer)msg.obj;
                    if (score == null) break;
                    ConnectivityService.this.updateNetworkScore(nai, score);
                    break;
                }
                case 528389: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_UID_RANGES_ADDED from unknown NetworkAgent");
                        break;
                    }
                    try {
                        ConnectivityService.this.mNetd.addVpnUidRanges(nai.network.netId, (UidRange[])msg.obj);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception in addVpnUidRanges: " + e);
                    }
                    break;
                }
                case 528390: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_UID_RANGES_REMOVED from unknown NetworkAgent");
                        break;
                    }
                    try {
                        ConnectivityService.this.mNetd.removeVpnUidRanges(nai.network.netId, (UidRange[])msg.obj);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception in removeVpnUidRanges: " + e);
                    }
                    break;
                }
                case 528392: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_SET_EXPLICITLY_SELECTED from unknown NetworkAgent");
                        break;
                    }
                    if (nai.created && !nai.networkMisc.explicitlySelected) {
                        ConnectivityService.loge("ERROR: created network explicitly selected.");
                    }
                    nai.networkMisc.explicitlySelected = true;
                    break;
                }
                case 532482: {
                    boolean valid;
                    NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                    if (!ConnectivityService.this.isLiveNetworkAgent(nai, "EVENT_NETWORK_VALIDATED")) break;
                    boolean bl = valid = msg.arg1 == 0;
                    if (valid) {
                        ConnectivityService.log("Validated " + nai.name());
                        boolean previouslyValidated = nai.validated;
                        int previousScore = nai.getCurrentScore();
                        nai.validated = true;
                        ConnectivityService.this.rematchNetworkAndRequests(nai, !previouslyValidated);
                        if (nai.getCurrentScore() != previousScore) {
                            ConnectivityService.this.sendUpdatedScoreToFactories(nai);
                        }
                    }
                    ConnectivityService.this.updateInetCondition(nai, valid);
                    nai.asyncChannel.sendMessage(528391, valid ? 1 : 2, 0, null);
                    break;
                }
                case 532485: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                    if (!ConnectivityService.this.isLiveNetworkAgent(nai, "EVENT_NETWORK_LINGER_COMPLETE")) break;
                    ConnectivityService.this.handleLingerComplete(nai);
                    break;
                }
                case 532491: {
                    if (msg.arg1 == 0) {
                        ConnectivityService.this.setProvNotificationVisibleIntent(false, msg.arg2, 0, null, null);
                        break;
                    }
                    NetworkAgentInfo nai = null;
                    SparseArray valid = ConnectivityService.this.mNetworkForNetId;
                    synchronized (valid) {
                        nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkForNetId.get(msg.arg2);
                    }
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_PROVISIONING_NOTIFICATION from unknown NetworkMonitor");
                        break;
                    }
                    ConnectivityService.this.setProvNotificationVisibleIntent(true, msg.arg2, nai.networkInfo.getType(), nai.networkInfo.getExtraInfo(), (PendingIntent)msg.obj);
                    break;
                }
                case 458752: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    NetworkInfo.State state = info.getState();
                    if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.SUSPENDED) {
                        ConnectivityService.log("ConnectivityChange for " + info.getTypeName() + ": " + (Object)((Object)state) + "/" + (Object)((Object)info.getDetailedState()));
                    }
                    EventLogTags.writeConnectivityStateChanged(info.getType(), info.getSubtype(), info.getDetailedState().ordinal());
                    if (info.isConnectedToProvisioningNetwork()) {
                        LinkProperties lp = ConnectivityService.this.getLinkPropertiesForTypeInternal(info.getType());
                        ConnectivityService.log("EVENT_STATE_CHANGED: connected to provisioning network, lp=" + lp);
                    } else if (state == NetworkInfo.State.DISCONNECTED || state == NetworkInfo.State.SUSPENDED || state == NetworkInfo.State.CONNECTED) {
                        // empty if block
                    }
                    ConnectivityService.this.notifyLockdownVpn(null);
                    break;
                }
                case 458753: {
                    NetworkInfo networkInfo = (NetworkInfo)msg.obj;
                }
            }
        }
    }

    private class LegacyTypeTracker {
        private static final boolean DBG = true;
        private static final boolean VDBG = false;
        private static final String TAG = "CSLegacyTypeTracker";
        private ArrayList<NetworkAgentInfo>[] mTypeLists = new ArrayList[18];

        public void addSupportedType(int type) {
            if (this.mTypeLists[type] != null) {
                throw new IllegalStateException("legacy list for type " + type + "already initialized");
            }
            this.mTypeLists[type] = new ArrayList();
        }

        public boolean isTypeSupported(int type) {
            return ConnectivityManager.isNetworkTypeValid(type) && this.mTypeLists[type] != null;
        }

        public NetworkAgentInfo getNetworkForType(int type) {
            if (this.isTypeSupported(type) && !this.mTypeLists[type].isEmpty()) {
                return this.mTypeLists[type].get(0);
            }
            return null;
        }

        private void maybeLogBroadcast(NetworkAgentInfo nai, boolean connected, int type) {
            this.log("Sending " + (connected ? "connected" : "disconnected") + " broadcast for type " + type + " " + nai.name() + " isDefaultNetwork=" + ConnectivityService.this.isDefaultNetwork(nai));
        }

        public void add(int type, NetworkAgentInfo nai) {
            if (!this.isTypeSupported(type)) {
                return;
            }
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list.contains(nai)) {
                ConnectivityService.loge("Attempting to register duplicate agent for type " + type + ": " + nai);
                return;
            }
            list.add(nai);
            if (list.size() == 1 || ConnectivityService.this.isDefaultNetwork(nai)) {
                this.maybeLogBroadcast(nai, true, type);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, true, type);
            }
        }

        public void remove(int type, NetworkAgentInfo nai) {
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list == null || list.isEmpty()) {
                return;
            }
            boolean wasFirstNetwork = list.get(0).equals(nai);
            if (!list.remove(nai)) {
                return;
            }
            if (wasFirstNetwork || ConnectivityService.this.isDefaultNetwork(nai)) {
                this.maybeLogBroadcast(nai, false, type);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, false, type);
            }
            if (!list.isEmpty() && wasFirstNetwork) {
                this.log("Other network available for type " + type + ", sending connected broadcast");
                this.maybeLogBroadcast(list.get(0), false, type);
                ConnectivityService.this.sendLegacyNetworkBroadcast(list.get(0), false, type);
            }
        }

        public void remove(NetworkAgentInfo nai) {
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                this.remove(type, nai);
            }
        }

        private String naiToString(NetworkAgentInfo nai) {
            String name = nai != null ? nai.name() : "null";
            String state = nai.networkInfo != null ? (Object)((Object)nai.networkInfo.getState()) + "/" + (Object)((Object)nai.networkInfo.getDetailedState()) : "???/???";
            return name + " " + state;
        }

        public void dump(IndentingPrintWriter pw) {
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                if (this.mTypeLists[type] == null) continue;
                pw.print(type + " ");
                pw.increaseIndent();
                if (this.mTypeLists[type].size() == 0) {
                    pw.println("none");
                }
                for (NetworkAgentInfo nai : this.mTypeLists[type]) {
                    pw.println(this.naiToString(nai));
                }
                pw.decreaseIndent();
            }
        }

        private void log(String s) {
            Slog.d(TAG, s);
        }
    }
}

