/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.IAlarmManager;
import android.app.INotificationManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.media.AudioService;
import android.os.Build;
import android.os.Environment;
import android.os.FactoryTest;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Slog;
import android.view.WindowManager;
import android.webkit.WebViewFactory;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.server.AlarmManagerService;
import com.android.server.AssetAtlasService;
import com.android.server.AttributeCache;
import com.android.server.BatteryService;
import com.android.server.BluetoothManagerService;
import com.android.server.CertBlacklister;
import com.android.server.CommonTimeManagementService;
import com.android.server.ConnectivityService;
import com.android.server.ConsumerIrService;
import com.android.server.CountryDetectorService;
import com.android.server.DiskStatsService;
import com.android.server.DockObserver;
import com.android.server.DropBoxManagerService;
import com.android.server.EntropyMixer;
import com.android.server.InputMethodManagerService;
import com.android.server.LocalServices;
import com.android.server.LocationManagerService;
import com.android.server.LockSettingsService;
import com.android.server.MmsServiceBroker;
import com.android.server.MountService;
import com.android.server.NetworkManagementService;
import com.android.server.NetworkScoreService;
import com.android.server.NetworkTimeUpdateService;
import com.android.server.NsdService;
import com.android.server.PersistentDataBlockService;
import com.android.server.SamplingProfilerService;
import com.android.server.SerialService;
import com.android.server.SystemConfig;
import com.android.server.SystemServiceManager;
import com.android.server.TelephonyRegistry;
import com.android.server.TextServicesManagerService;
import com.android.server.UiModeManagerService;
import com.android.server.UpdateLockService;
import com.android.server.VibratorService;
import com.android.server.Watchdog;
import com.android.server.WiredAccessoryManager;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accounts.AccountManagerService;
import com.android.server.am.ActivityManagerService;
import com.android.server.clipboard.ClipboardService;
import com.android.server.content.ContentService;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import com.android.server.display.DisplayManagerService;
import com.android.server.dreams.DreamManagerService;
import com.android.server.fingerprint.FingerprintService;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.input.InputManagerService;
import com.android.server.job.JobSchedulerService;
import com.android.server.lights.LightsService;
import com.android.server.media.MediaRouterService;
import com.android.server.media.MediaSessionService;
import com.android.server.media.projection.MediaProjectionManagerService;
import com.android.server.net.NetworkPolicyManagerService;
import com.android.server.net.NetworkStatsService;
import com.android.server.notification.NotificationManagerService;
import com.android.server.os.SchedulingPolicyService;
import com.android.server.pm.BackgroundDexOptService;
import com.android.server.pm.Installer;
import com.android.server.pm.LauncherAppsService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.UserManagerService;
import com.android.server.power.PowerManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.restrictions.RestrictionsManagerService;
import com.android.server.search.SearchManagerService;
import com.android.server.statusbar.StatusBarManagerService;
import com.android.server.storage.DeviceStorageMonitorService;
import com.android.server.trust.TrustManagerService;
import com.android.server.tv.TvInputManagerService;
import com.android.server.twilight.TwilightService;
import com.android.server.usage.UsageStatsService;
import com.android.server.wallpaper.WallpaperManagerService;
import com.android.server.webkit.WebViewUpdateService;
import com.android.server.wm.WindowManagerService;
import dalvik.system.VMRuntime;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public final class SystemServer {
    private static final String TAG = "SystemServer";
    private static final String ENCRYPTING_STATE = "trigger_restart_min_framework";
    private static final String ENCRYPTED_STATE = "1";
    private static final long SNAPSHOT_INTERVAL = 3600000L;
    private static final long EARLIEST_SUPPORTED_TIME = 86400000L;
    private static final String BACKUP_MANAGER_SERVICE_CLASS = "com.android.server.backup.BackupManagerService$Lifecycle";
    private static final String APPWIDGET_SERVICE_CLASS = "com.android.server.appwidget.AppWidgetService";
    private static final String VOICE_RECOGNITION_MANAGER_SERVICE_CLASS = "com.android.server.voiceinteraction.VoiceInteractionManagerService";
    private static final String PRINT_MANAGER_SERVICE_CLASS = "com.android.server.print.PrintManagerService";
    private static final String USB_SERVICE_CLASS = "com.android.server.usb.UsbService$Lifecycle";
    private static final String WIFI_SERVICE_CLASS = "com.android.server.wifi.WifiService";
    private static final String WIFI_P2P_SERVICE_CLASS = "com.android.server.wifi.p2p.WifiP2pService";
    private static final String ETHERNET_SERVICE_CLASS = "com.android.server.ethernet.EthernetService";
    private static final String JOB_SCHEDULER_SERVICE_CLASS = "com.android.server.job.JobSchedulerService";
    private static final String PERSISTENT_DATA_BLOCK_PROP = "ro.frp.pst";
    private final int mFactoryTestMode = FactoryTest.getMode();
    private Timer mProfilerSnapshotTimer;
    private Context mSystemContext;
    private SystemServiceManager mSystemServiceManager;
    private Installer mInstaller;
    private PowerManagerService mPowerManagerService;
    private ActivityManagerService mActivityManagerService;
    private DisplayManagerService mDisplayManagerService;
    private PackageManagerService mPackageManagerService;
    private PackageManager mPackageManager;
    private ContentResolver mContentResolver;
    private boolean mOnlyCore;
    private boolean mFirstBoot;

    private static native void nativeInit();

    public static void main(String[] args) {
        new SystemServer().run();
    }

    private void run() {
        if (System.currentTimeMillis() < 86400000L) {
            Slog.w(TAG, "System clock is before 1970; setting to 1970.");
            SystemClock.setCurrentTimeMillis(86400000L);
        }
        Slog.i(TAG, "Entered the Android system server!");
        EventLog.writeEvent(3010, SystemClock.uptimeMillis());
        SystemProperties.set("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
        if (SamplingProfilerIntegration.isEnabled()) {
            SamplingProfilerIntegration.start();
            this.mProfilerSnapshotTimer = new Timer();
            this.mProfilerSnapshotTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SamplingProfilerIntegration.writeSnapshot("system_server", null);
                }
            }, 3600000L, 3600000L);
        }
        VMRuntime.getRuntime().clearGrowthLimit();
        VMRuntime.getRuntime().setTargetHeapUtilization(0.8f);
        Build.ensureFingerprintProperty();
        Environment.setUserRequired(true);
        BinderInternal.disableBackgroundScheduling(true);
        Process.setThreadPriority(-2);
        Process.setCanSelfBackground(false);
        Looper.prepareMainLooper();
        System.loadLibrary("android_servers");
        SystemServer.nativeInit();
        this.performPendingShutdown();
        this.createSystemContext();
        this.mSystemServiceManager = new SystemServiceManager(this.mSystemContext);
        LocalServices.addService(SystemServiceManager.class, this.mSystemServiceManager);
        try {
            this.startBootstrapServices();
            this.startCoreServices();
            this.startOtherServices();
        }
        catch (Throwable ex) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting system services", ex);
            throw ex;
        }
        if (StrictMode.conditionallyEnableDebugLogging()) {
            Slog.i(TAG, "Enabled StrictMode for system server main thread.");
        }
        Looper.loop();
        throw new RuntimeException("Main thread loop unexpectedly exited");
    }

    private void reportWtf(String msg, Throwable e) {
        Slog.w(TAG, "***********************************************");
        Slog.wtf(TAG, "BOOT FAILURE " + msg, e);
    }

    private void performPendingShutdown() {
        String shutdownAction = SystemProperties.get("sys.shutdown.requested", "");
        if (shutdownAction != null && shutdownAction.length() > 0) {
            boolean reboot = shutdownAction.charAt(0) == '1';
            String reason = shutdownAction.length() > 1 ? shutdownAction.substring(1, shutdownAction.length()) : null;
            ShutdownThread.rebootOrShutdown(reboot, reason);
        }
    }

    private void createSystemContext() {
        ActivityThread activityThread = ActivityThread.systemMain();
        this.mSystemContext = activityThread.getSystemContext();
        this.mSystemContext.setTheme(16974143);
    }

    private void startBootstrapServices() {
        this.mInstaller = this.mSystemServiceManager.startService(Installer.class);
        this.mActivityManagerService = this.mSystemServiceManager.startService(ActivityManagerService.Lifecycle.class).getService();
        this.mActivityManagerService.setSystemServiceManager(this.mSystemServiceManager);
        this.mPowerManagerService = this.mSystemServiceManager.startService(PowerManagerService.class);
        this.mActivityManagerService.initPowerManagement();
        this.mDisplayManagerService = this.mSystemServiceManager.startService(DisplayManagerService.class);
        this.mSystemServiceManager.startBootPhase(100);
        String cryptState = SystemProperties.get("vold.decrypt");
        if (ENCRYPTING_STATE.equals(cryptState)) {
            Slog.w(TAG, "Detected encryption in progress - only parsing core apps");
            this.mOnlyCore = true;
        } else if (ENCRYPTED_STATE.equals(cryptState)) {
            Slog.w(TAG, "Device encrypted - only parsing core apps");
            this.mOnlyCore = true;
        }
        Slog.i(TAG, "Package Manager");
        this.mPackageManagerService = PackageManagerService.main(this.mSystemContext, this.mInstaller, this.mFactoryTestMode != 0, this.mOnlyCore);
        this.mFirstBoot = this.mPackageManagerService.isFirstBoot();
        this.mPackageManager = this.mSystemContext.getPackageManager();
        Slog.i(TAG, "User Service");
        ServiceManager.addService("user", UserManagerService.getInstance());
        AttributeCache.init(this.mSystemContext);
        this.mActivityManagerService.setSystemProcess();
    }

    private void startCoreServices() {
        this.mSystemServiceManager.startService(LightsService.class);
        this.mSystemServiceManager.startService(BatteryService.class);
        this.mSystemServiceManager.startService(UsageStatsService.class);
        this.mActivityManagerService.setUsageStatsManager(LocalServices.getService(UsageStatsManagerInternal.class));
        this.mSystemServiceManager.startService(WebViewUpdateService.class);
    }

    private void startOtherServices() {
        boolean safeMode;
        final Context context = this.mSystemContext;
        AccountManagerService accountManager = null;
        ContentService contentService = null;
        VibratorService vibrator = null;
        IAlarmManager alarm = null;
        MountService mountService = null;
        NetworkManagementService networkManagement = null;
        NetworkStatsService networkStats = null;
        NetworkPolicyManagerService networkPolicy = null;
        ConnectivityService connectivity = null;
        NetworkScoreService networkScore = null;
        NsdService serviceDiscovery = null;
        WindowManagerService wm = null;
        BluetoothManagerService bluetooth = null;
        Object usb = null;
        SerialService serial = null;
        NetworkTimeUpdateService networkTimeUpdater = null;
        CommonTimeManagementService commonTimeMgmtService = null;
        InputManagerService inputManager = null;
        TelephonyRegistry telephonyRegistry = null;
        ConsumerIrService consumerIr = null;
        AudioService audioService = null;
        MmsServiceBroker mmsService = null;
        boolean disableStorage = SystemProperties.getBoolean("config.disable_storage", false);
        boolean disableMedia = SystemProperties.getBoolean("config.disable_media", false);
        boolean disableBluetooth = SystemProperties.getBoolean("config.disable_bluetooth", false);
        boolean disableTelephony = SystemProperties.getBoolean("config.disable_telephony", false);
        boolean disableLocation = SystemProperties.getBoolean("config.disable_location", false);
        boolean disableSystemUI = SystemProperties.getBoolean("config.disable_systemui", false);
        boolean disableNonCoreServices = SystemProperties.getBoolean("config.disable_noncore", false);
        boolean disableNetwork = SystemProperties.getBoolean("config.disable_network", false);
        boolean isEmulator = SystemProperties.get("ro.kernel.qemu").equals(ENCRYPTED_STATE);
        try {
            Slog.i(TAG, "Reading configuration...");
            SystemConfig.getInstance();
            Slog.i(TAG, "Scheduling Policy");
            ServiceManager.addService("scheduling_policy", new SchedulingPolicyService());
            Slog.i(TAG, "Telephony Registry");
            telephonyRegistry = new TelephonyRegistry(context);
            ServiceManager.addService("telephony.registry", telephonyRegistry);
            Slog.i(TAG, "Entropy Mixer");
            ServiceManager.addService("entropy", new EntropyMixer(context));
            this.mContentResolver = context.getContentResolver();
            try {
                Slog.i(TAG, "Account Manager");
                accountManager = new AccountManagerService(context);
                ServiceManager.addService("account", accountManager);
            }
            catch (Throwable e) {
                Slog.e(TAG, "Failure starting Account Manager", e);
            }
            Slog.i(TAG, "Content Manager");
            contentService = ContentService.main(context, this.mFactoryTestMode == 1);
            Slog.i(TAG, "System Content Providers");
            this.mActivityManagerService.installSystemProviders();
            Slog.i(TAG, "Vibrator Service");
            vibrator = new VibratorService(context);
            ServiceManager.addService("vibrator", vibrator);
            Slog.i(TAG, "Consumer IR Service");
            consumerIr = new ConsumerIrService(context);
            ServiceManager.addService("consumer_ir", consumerIr);
            this.mSystemServiceManager.startService(AlarmManagerService.class);
            alarm = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
            Slog.i(TAG, "Init Watchdog");
            Watchdog watchdog = Watchdog.getInstance();
            watchdog.init(context, this.mActivityManagerService);
            Slog.i(TAG, "Input Manager");
            inputManager = new InputManagerService(context);
            Slog.i(TAG, "Window Manager");
            wm = WindowManagerService.main(context, inputManager, this.mFactoryTestMode != 1, !this.mFirstBoot, this.mOnlyCore);
            ServiceManager.addService("window", wm);
            ServiceManager.addService("input", inputManager);
            this.mActivityManagerService.setWindowManager(wm);
            inputManager.setWindowManagerCallbacks(wm.getInputMonitor());
            inputManager.start();
            this.mDisplayManagerService.windowManagerAndInputReady();
            if (isEmulator) {
                Slog.i(TAG, "No Bluetooh Service (emulator)");
            } else if (this.mFactoryTestMode == 1) {
                Slog.i(TAG, "No Bluetooth Service (factory test)");
            } else if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                Slog.i(TAG, "No Bluetooth Service (Bluetooth Hardware Not Present)");
            } else if (disableBluetooth) {
                Slog.i(TAG, "Bluetooth Service disabled by config");
            } else {
                Slog.i(TAG, "Bluetooth Manager Service");
                bluetooth = new BluetoothManagerService(context);
                ServiceManager.addService("bluetooth_manager", bluetooth);
            }
        }
        catch (RuntimeException e) {
            Slog.e("System", "******************************************");
            Slog.e("System", "************ Failure starting core service", e);
        }
        StatusBarManagerService statusBar = null;
        INotificationManager notification = null;
        InputMethodManagerService imm = null;
        WallpaperManagerService wallpaper = null;
        LocationManagerService location = null;
        CountryDetectorService countryDetector = null;
        TextServicesManagerService tsms = null;
        LockSettingsService lockSettings = null;
        AssetAtlasService atlas = null;
        MediaRouterService mediaRouter = null;
        if (this.mFactoryTestMode != 1) {
            try {
                Slog.i(TAG, "Input Method Service");
                imm = new InputMethodManagerService(context, wm);
                ServiceManager.addService("input_method", imm);
            }
            catch (Throwable e) {
                this.reportWtf("starting Input Manager Service", e);
            }
            try {
                Slog.i(TAG, "Accessibility Manager");
                ServiceManager.addService("accessibility", new AccessibilityManagerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting Accessibility Manager", e);
            }
        }
        try {
            wm.displayReady();
        }
        catch (Throwable e) {
            this.reportWtf("making display ready", e);
        }
        try {
            this.mPackageManagerService.performBootDexOpt();
        }
        catch (Throwable e) {
            this.reportWtf("performing boot dexopt", e);
        }
        try {
            ActivityManagerNative.getDefault().showBootMessage(context.getResources().getText(17040518), false);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (this.mFactoryTestMode != 1) {
            if (!disableStorage && !"0".equals(SystemProperties.get("system_init.startmountservice"))) {
                try {
                    Slog.i(TAG, "Mount Service");
                    mountService = new MountService(context);
                    ServiceManager.addService("mount", mountService);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Mount Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "LockSettingsService");
                    lockSettings = new LockSettingsService(context);
                    ServiceManager.addService("lock_settings", lockSettings);
                }
                catch (Throwable e) {
                    this.reportWtf("starting LockSettingsService service", e);
                }
                if (!SystemProperties.get(PERSISTENT_DATA_BLOCK_PROP).equals("")) {
                    this.mSystemServiceManager.startService(PersistentDataBlockService.class);
                }
                this.mSystemServiceManager.startService(DevicePolicyManagerService.Lifecycle.class);
            }
            if (!disableSystemUI) {
                try {
                    Slog.i(TAG, "Status Bar");
                    statusBar = new StatusBarManagerService(context, wm);
                    ServiceManager.addService("statusbar", statusBar);
                }
                catch (Throwable e) {
                    this.reportWtf("starting StatusBarManagerService", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Clipboard Service");
                    ServiceManager.addService("clipboard", new ClipboardService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Clipboard Service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "NetworkManagement Service");
                    networkManagement = NetworkManagementService.create(context);
                    ServiceManager.addService("network_management", networkManagement);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkManagement Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Text Service Manager Service");
                    tsms = new TextServicesManagerService(context);
                    ServiceManager.addService("textservices", tsms);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Text Service Manager Service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "Network Score Service");
                    networkScore = new NetworkScoreService(context);
                    ServiceManager.addService("network_score", networkScore);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Network Score Service", e);
                }
                try {
                    Slog.i(TAG, "NetworkStats Service");
                    networkStats = new NetworkStatsService(context, networkManagement, alarm);
                    ServiceManager.addService("netstats", networkStats);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkStats Service", e);
                }
                try {
                    Slog.i(TAG, "NetworkPolicy Service");
                    networkPolicy = new NetworkPolicyManagerService(context, this.mActivityManagerService, (IPowerManager)((Object)ServiceManager.getService("power")), networkStats, networkManagement);
                    ServiceManager.addService("netpolicy", networkPolicy);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkPolicy Service", e);
                }
                this.mSystemServiceManager.startService(WIFI_P2P_SERVICE_CLASS);
                this.mSystemServiceManager.startService(WIFI_SERVICE_CLASS);
                this.mSystemServiceManager.startService("com.android.server.wifi.WifiScanningService");
                this.mSystemServiceManager.startService("com.android.server.wifi.RttService");
                if (this.mPackageManager.hasSystemFeature("android.hardware.ethernet")) {
                    this.mSystemServiceManager.startService(ETHERNET_SERVICE_CLASS);
                }
                try {
                    Slog.i(TAG, "Connectivity Service");
                    connectivity = new ConnectivityService(context, networkManagement, networkStats, networkPolicy);
                    ServiceManager.addService("connectivity", connectivity);
                    networkStats.bindConnectivityManager(connectivity);
                    networkPolicy.bindConnectivityManager(connectivity);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Connectivity Service", e);
                }
                try {
                    Slog.i(TAG, "Network Service Discovery Service");
                    serviceDiscovery = NsdService.create(context);
                    ServiceManager.addService("servicediscovery", serviceDiscovery);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Service Discovery Service", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "UpdateLock Service");
                    ServiceManager.addService("updatelock", new UpdateLockService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting UpdateLockService", e);
                }
            }
            if (mountService != null && !this.mOnlyCore) {
                mountService.waitForAsecScan();
            }
            try {
                if (accountManager != null) {
                    accountManager.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Account Manager Service ready", e);
            }
            try {
                if (contentService != null) {
                    contentService.systemReady();
                }
            }
            catch (Throwable e) {
                this.reportWtf("making Content Service ready", e);
            }
            this.mSystemServiceManager.startService(NotificationManagerService.class);
            notification = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
            networkPolicy.bindNotificationManager(notification);
            this.mSystemServiceManager.startService(DeviceStorageMonitorService.class);
            if (!disableLocation) {
                try {
                    Slog.i(TAG, "Location Manager");
                    location = new LocationManagerService(context);
                    ServiceManager.addService("location", location);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Location Manager", e);
                }
                try {
                    Slog.i(TAG, "Country Detector");
                    countryDetector = new CountryDetectorService(context);
                    ServiceManager.addService("country_detector", countryDetector);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Country Detector", e);
                }
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Search Service");
                    ServiceManager.addService("search", new SearchManagerService(context));
                }
                catch (Throwable e) {
                    this.reportWtf("starting Search Service", e);
                }
            }
            try {
                Slog.i(TAG, "DropBox Service");
                ServiceManager.addService("dropbox", new DropBoxManagerService(context, new File("/data/system/dropbox")));
            }
            catch (Throwable e) {
                this.reportWtf("starting DropBoxManagerService", e);
            }
            if (!disableNonCoreServices && context.getResources().getBoolean(17956920)) {
                try {
                    Slog.i(TAG, "Wallpaper Service");
                    wallpaper = new WallpaperManagerService(context);
                    ServiceManager.addService("wallpaper", wallpaper);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Wallpaper Service", e);
                }
            }
            if (!disableMedia && !"0".equals(SystemProperties.get("system_init.startaudioservice"))) {
                try {
                    Slog.i(TAG, "Audio Service");
                    audioService = new AudioService(context);
                    ServiceManager.addService("audio", audioService);
                }
                catch (Throwable e) {
                    this.reportWtf("starting Audio Service", e);
                }
            }
            if (!disableNonCoreServices) {
                this.mSystemServiceManager.startService(DockObserver.class);
            }
            if (!disableMedia) {
                try {
                    Slog.i(TAG, "Wired Accessory Manager");
                    inputManager.setWiredAccessoryCallbacks(new WiredAccessoryManager(context, inputManager));
                }
                catch (Throwable e) {
                    this.reportWtf("starting WiredAccessoryManager", e);
                }
            }
            if (!disableNonCoreServices) {
                if (this.mPackageManager.hasSystemFeature("android.hardware.usb.host") || this.mPackageManager.hasSystemFeature("android.hardware.usb.accessory")) {
                    this.mSystemServiceManager.startService(USB_SERVICE_CLASS);
                }
                try {
                    Slog.i(TAG, "Serial Service");
                    serial = new SerialService(context);
                    ServiceManager.addService("serial", serial);
                }
                catch (Throwable e) {
                    Slog.e(TAG, "Failure starting SerialService", e);
                }
            }
            this.mSystemServiceManager.startService(TwilightService.class);
            this.mSystemServiceManager.startService(UiModeManagerService.class);
            this.mSystemServiceManager.startService(JobSchedulerService.class);
            if (!disableNonCoreServices) {
                if (this.mPackageManager.hasSystemFeature("android.software.backup")) {
                    this.mSystemServiceManager.startService(BACKUP_MANAGER_SERVICE_CLASS);
                }
                if (this.mPackageManager.hasSystemFeature("android.software.app_widgets")) {
                    this.mSystemServiceManager.startService(APPWIDGET_SERVICE_CLASS);
                }
                if (this.mPackageManager.hasSystemFeature("android.software.voice_recognizers")) {
                    this.mSystemServiceManager.startService(VOICE_RECOGNITION_MANAGER_SERVICE_CLASS);
                }
            }
            try {
                Slog.i(TAG, "DiskStats Service");
                ServiceManager.addService("diskstats", new DiskStatsService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting DiskStats Service", e);
            }
            try {
                Slog.i(TAG, "SamplingProfiler Service");
                ServiceManager.addService("samplingprofiler", new SamplingProfilerService(context));
            }
            catch (Throwable e) {
                this.reportWtf("starting SamplingProfiler Service", e);
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "NetworkTimeUpdateService");
                    networkTimeUpdater = new NetworkTimeUpdateService(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting NetworkTimeUpdate service", e);
                }
            }
            if (!disableMedia) {
                try {
                    Slog.i(TAG, "CommonTimeManagementService");
                    commonTimeMgmtService = new CommonTimeManagementService(context);
                    ServiceManager.addService("commontime_management", commonTimeMgmtService);
                }
                catch (Throwable e) {
                    this.reportWtf("starting CommonTimeManagementService service", e);
                }
            }
            if (!disableNetwork) {
                try {
                    Slog.i(TAG, "CertBlacklister");
                    CertBlacklister blacklister = new CertBlacklister(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting CertBlacklister", e);
                }
            }
            if (!disableNonCoreServices) {
                this.mSystemServiceManager.startService(DreamManagerService.class);
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Assets Atlas Service");
                    atlas = new AssetAtlasService(context);
                    ServiceManager.addService("assetatlas", atlas);
                }
                catch (Throwable e) {
                    this.reportWtf("starting AssetAtlasService", e);
                }
            }
            if (this.mPackageManager.hasSystemFeature("android.software.print")) {
                this.mSystemServiceManager.startService(PRINT_MANAGER_SERVICE_CLASS);
            }
            this.mSystemServiceManager.startService(RestrictionsManagerService.class);
            this.mSystemServiceManager.startService(MediaSessionService.class);
            if (this.mPackageManager.hasSystemFeature("android.hardware.hdmi.cec")) {
                this.mSystemServiceManager.startService(HdmiControlService.class);
            }
            if (this.mPackageManager.hasSystemFeature("android.software.live_tv")) {
                this.mSystemServiceManager.startService(TvInputManagerService.class);
            }
            if (!disableNonCoreServices) {
                try {
                    Slog.i(TAG, "Media Router Service");
                    mediaRouter = new MediaRouterService(context);
                    ServiceManager.addService("media_router", mediaRouter);
                }
                catch (Throwable e) {
                    this.reportWtf("starting MediaRouterService", e);
                }
                this.mSystemServiceManager.startService(TrustManagerService.class);
                this.mSystemServiceManager.startService(FingerprintService.class);
                try {
                    Slog.i(TAG, "BackgroundDexOptService");
                    BackgroundDexOptService.schedule(context);
                }
                catch (Throwable e) {
                    this.reportWtf("starting BackgroundDexOptService", e);
                }
            }
            this.mSystemServiceManager.startService(LauncherAppsService.class);
        }
        if (!disableNonCoreServices) {
            this.mSystemServiceManager.startService(MediaProjectionManagerService.class);
        }
        if (safeMode = wm.detectSafeMode()) {
            this.mActivityManagerService.enterSafeMode();
            VMRuntime.getRuntime().disableJitCompilation();
        } else {
            VMRuntime.getRuntime().startJitCompilation();
        }
        mmsService = this.mSystemServiceManager.startService(MmsServiceBroker.class);
        try {
            vibrator.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Vibrator Service ready", e);
        }
        if (lockSettings != null) {
            try {
                lockSettings.systemReady();
            }
            catch (Throwable e) {
                this.reportWtf("making Lock Settings Service ready", e);
            }
        }
        this.mSystemServiceManager.startBootPhase(480);
        this.mSystemServiceManager.startBootPhase(500);
        try {
            wm.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Window Manager Service ready", e);
        }
        if (safeMode) {
            this.mActivityManagerService.showSafeModeOverlay();
        }
        Configuration config = wm.computeNewConfiguration();
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager w = (WindowManager)context.getSystemService("window");
        w.getDefaultDisplay().getMetrics(metrics);
        context.getResources().updateConfiguration(config, metrics);
        try {
            this.mPowerManagerService.systemReady(this.mActivityManagerService.getAppOpsService());
        }
        catch (Throwable e) {
            this.reportWtf("making Power Manager Service ready", e);
        }
        try {
            this.mPackageManagerService.systemReady();
        }
        catch (Throwable e) {
            this.reportWtf("making Package Manager Service ready", e);
        }
        try {
            this.mDisplayManagerService.systemReady(safeMode, this.mOnlyCore);
        }
        catch (Throwable e) {
            this.reportWtf("making Display Manager Service ready", e);
        }
        final MountService mountServiceF = mountService;
        final NetworkManagementService networkManagementF = networkManagement;
        final NetworkStatsService networkStatsF = networkStats;
        final NetworkPolicyManagerService networkPolicyF = networkPolicy;
        final ConnectivityService connectivityF = connectivity;
        final NetworkScoreService networkScoreF = networkScore;
        final WallpaperManagerService wallpaperF = wallpaper;
        final InputMethodManagerService immF = imm;
        final LocationManagerService locationF = location;
        final CountryDetectorService countryDetectorF = countryDetector;
        final NetworkTimeUpdateService networkTimeUpdaterF = networkTimeUpdater;
        final CommonTimeManagementService commonTimeMgmtServiceF = commonTimeMgmtService;
        final TextServicesManagerService textServiceManagerServiceF = tsms;
        final StatusBarManagerService statusBarF = statusBar;
        final AssetAtlasService atlasF = atlas;
        final InputManagerService inputManagerF = inputManager;
        final TelephonyRegistry telephonyRegistryF = telephonyRegistry;
        final MediaRouterService mediaRouterF = mediaRouter;
        final AudioService audioServiceF = audioService;
        final MmsServiceBroker mmsServiceF = mmsService;
        this.mActivityManagerService.systemReady(new Runnable(){

            @Override
            public void run() {
                Slog.i(SystemServer.TAG, "Making services ready");
                SystemServer.this.mSystemServiceManager.startBootPhase(550);
                try {
                    SystemServer.this.mActivityManagerService.startObservingNativeCrashes();
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("observing native crashes", e);
                }
                Slog.i(SystemServer.TAG, "WebViewFactory preparation");
                WebViewFactory.prepareWebViewInSystemServer();
                try {
                    SystemServer.startSystemUi(context);
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("starting System UI", e);
                }
                try {
                    if (mountServiceF != null) {
                        mountServiceF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Mount Service ready", e);
                }
                try {
                    if (networkScoreF != null) {
                        networkScoreF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Score Service ready", e);
                }
                try {
                    if (networkManagementF != null) {
                        networkManagementF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Managment Service ready", e);
                }
                try {
                    if (networkStatsF != null) {
                        networkStatsF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Stats Service ready", e);
                }
                try {
                    if (networkPolicyF != null) {
                        networkPolicyF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Network Policy Service ready", e);
                }
                try {
                    if (connectivityF != null) {
                        connectivityF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("making Connectivity Service ready", e);
                }
                try {
                    if (audioServiceF != null) {
                        audioServiceF.systemReady();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying AudioService running", e);
                }
                Watchdog.getInstance().start();
                SystemServer.this.mSystemServiceManager.startBootPhase(600);
                try {
                    if (wallpaperF != null) {
                        wallpaperF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying WallpaperService running", e);
                }
                try {
                    if (immF != null) {
                        immF.systemRunning(statusBarF);
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying InputMethodService running", e);
                }
                try {
                    if (locationF != null) {
                        locationF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying Location Service running", e);
                }
                try {
                    if (countryDetectorF != null) {
                        countryDetectorF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying CountryDetectorService running", e);
                }
                try {
                    if (networkTimeUpdaterF != null) {
                        networkTimeUpdaterF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying NetworkTimeService running", e);
                }
                try {
                    if (commonTimeMgmtServiceF != null) {
                        commonTimeMgmtServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying CommonTimeManagementService running", e);
                }
                try {
                    if (textServiceManagerServiceF != null) {
                        textServiceManagerServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying TextServicesManagerService running", e);
                }
                try {
                    if (atlasF != null) {
                        atlasF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying AssetAtlasService running", e);
                }
                try {
                    if (inputManagerF != null) {
                        inputManagerF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying InputManagerService running", e);
                }
                try {
                    if (telephonyRegistryF != null) {
                        telephonyRegistryF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying TelephonyRegistry running", e);
                }
                try {
                    if (mediaRouterF != null) {
                        mediaRouterF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying MediaRouterService running", e);
                }
                try {
                    if (mmsServiceF != null) {
                        mmsServiceF.systemRunning();
                    }
                }
                catch (Throwable e) {
                    SystemServer.this.reportWtf("Notifying MmsService running", e);
                }
            }
        });
    }

    static final void startSystemUi(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.SystemUIService"));
        context.startServiceAsUser(intent, UserHandle.OWNER);
    }
}

