/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.UEventObserver;
import android.util.Log;
import android.util.Slog;
import com.android.server.input.InputManagerService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class WiredAccessoryManager
implements InputManagerService.WiredAccessoryCallbacks {
    private static final String TAG = WiredAccessoryManager.class.getSimpleName();
    private static final boolean LOG = true;
    private static final int BIT_HEADSET = 1;
    private static final int BIT_HEADSET_NO_MIC = 2;
    private static final int BIT_USB_HEADSET_ANLG = 4;
    private static final int BIT_USB_HEADSET_DGTL = 8;
    private static final int BIT_HDMI_AUDIO = 16;
    private static final int BIT_LINEOUT = 32;
    private static final int SUPPORTED_HEADSETS = 63;
    private static final String NAME_H2W = "h2w";
    private static final String NAME_USB_AUDIO = "usb_audio";
    private static final String NAME_HDMI_AUDIO = "hdmi_audio";
    private static final String NAME_HDMI = "hdmi";
    private static final int MSG_NEW_DEVICE_STATE = 1;
    private static final int MSG_SYSTEM_READY = 2;
    private final Object mLock = new Object();
    private final PowerManager.WakeLock mWakeLock;
    private final AudioManager mAudioManager;
    private int mHeadsetState;
    private int mSwitchValues;
    private final WiredAccessoryObserver mObserver;
    private final InputManagerService mInputManager;
    private final boolean mUseDevInputEventForAudioJack;
    private final Handler mHandler = new Handler(Looper.myLooper(), null, true){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    WiredAccessoryManager.this.setDevicesState(msg.arg1, msg.arg2, (String)msg.obj);
                    WiredAccessoryManager.this.mWakeLock.release();
                    break;
                }
                case 2: {
                    WiredAccessoryManager.this.onSystemReady();
                    WiredAccessoryManager.this.mWakeLock.release();
                }
            }
        }
    };

    public WiredAccessoryManager(Context context, InputManagerService inputManager) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "WiredAccessoryManager");
        this.mWakeLock.setReferenceCounted(false);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mInputManager = inputManager;
        this.mUseDevInputEventForAudioJack = context.getResources().getBoolean(17956960);
        this.mObserver = new WiredAccessoryObserver();
    }

    private void onSystemReady() {
        if (this.mUseDevInputEventForAudioJack) {
            int switchValues = 0;
            if (this.mInputManager.getSwitchState(-1, -256, 2) == 1) {
                switchValues |= 4;
            }
            if (this.mInputManager.getSwitchState(-1, -256, 4) == 1) {
                switchValues |= 0x10;
            }
            if (this.mInputManager.getSwitchState(-1, -256, 6) == 1) {
                switchValues |= 0x40;
            }
            this.notifyWiredAccessoryChanged(0L, switchValues, 84);
        }
        this.mObserver.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWiredAccessoryChanged(long whenNanos, int switchValues, int switchMask) {
        Slog.v(TAG, "notifyWiredAccessoryChanged: when=" + whenNanos + " bits=" + this.switchCodeToString(switchValues, switchMask) + " mask=" + Integer.toHexString(switchMask));
        Object object = this.mLock;
        synchronized (object) {
            int headset;
            this.mSwitchValues = this.mSwitchValues & ~switchMask | switchValues;
            switch (this.mSwitchValues & 0x54) {
                case 0: {
                    headset = 0;
                    break;
                }
                case 4: {
                    headset = 2;
                    break;
                }
                case 64: {
                    headset = 32;
                    break;
                }
                case 20: {
                    headset = 1;
                    break;
                }
                case 16: {
                    headset = 1;
                    break;
                }
                default: {
                    headset = 0;
                }
            }
            this.updateLocked(NAME_H2W, this.mHeadsetState & 0xFFFFFFDC | headset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            Message msg = this.mHandler.obtainMessage(2, 0, 0, null);
            this.mHandler.sendMessage(msg);
        }
    }

    private void updateLocked(String newName, int newState) {
        int headsetState = newState & 0x3F;
        int usb_headset_anlg = headsetState & 4;
        int usb_headset_dgtl = headsetState & 8;
        int h2w_headset = headsetState & 0x23;
        boolean h2wStateChange = true;
        boolean usbStateChange = true;
        Slog.v(TAG, "newName=" + newName + " newState=" + newState + " headsetState=" + headsetState + " prev headsetState=" + this.mHeadsetState);
        if (this.mHeadsetState == headsetState) {
            Log.e(TAG, "No state change.");
            return;
        }
        if (h2w_headset == 35) {
            Log.e(TAG, "Invalid combination, unsetting h2w flag");
            h2wStateChange = false;
        }
        if (usb_headset_anlg == 4 && usb_headset_dgtl == 8) {
            Log.e(TAG, "Invalid combination, unsetting usb flag");
            usbStateChange = false;
        }
        if (!h2wStateChange && !usbStateChange) {
            Log.e(TAG, "invalid transition, returning ...");
            return;
        }
        this.mWakeLock.acquire();
        Message msg = this.mHandler.obtainMessage(1, headsetState, this.mHeadsetState, newName);
        this.mHandler.sendMessage(msg);
        this.mHeadsetState = headsetState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDevicesState(int headsetState, int prevHeadsetState, String headsetName) {
        Object object = this.mLock;
        synchronized (object) {
            int allHeadsets = 63;
            int curHeadset = 1;
            while (allHeadsets != 0) {
                if ((curHeadset & allHeadsets) != 0) {
                    this.setDeviceStateLocked(curHeadset, headsetState, prevHeadsetState, headsetName);
                    allHeadsets &= ~curHeadset;
                }
                curHeadset <<= 1;
            }
        }
    }

    private void setDeviceStateLocked(int headset, int headsetState, int prevHeadsetState, String headsetName) {
        if ((headsetState & headset) != (prevHeadsetState & headset)) {
            int outDevice = 0;
            int inDevice = 0;
            int state = (headsetState & headset) != 0 ? 1 : 0;
            if (headset == 1) {
                outDevice = 4;
                inDevice = -2147483632;
            } else if (headset == 2) {
                outDevice = 8;
            } else if (headset == 32) {
                outDevice = 131072;
            } else if (headset == 4) {
                outDevice = 2048;
            } else if (headset == 8) {
                outDevice = 4096;
            } else if (headset == 16) {
                outDevice = 1024;
            } else {
                Slog.e(TAG, "setDeviceState() invalid headset type: " + headset);
                return;
            }
            Slog.v(TAG, "device " + headsetName + (state == 1 ? " connected" : " disconnected"));
            if (outDevice != 0) {
                this.mAudioManager.setWiredDeviceConnectionState(outDevice, state, headsetName);
            }
            if (inDevice != 0) {
                this.mAudioManager.setWiredDeviceConnectionState(inDevice, state, headsetName);
            }
        }
    }

    private String switchCodeToString(int switchValues, int switchMask) {
        StringBuffer sb = new StringBuffer();
        if ((switchMask & 4) != 0 && (switchValues & 4) != 0) {
            sb.append("SW_HEADPHONE_INSERT ");
        }
        if ((switchMask & 0x10) != 0 && (switchValues & 0x10) != 0) {
            sb.append("SW_MICROPHONE_INSERT");
        }
        return sb.toString();
    }

    class WiredAccessoryObserver
    extends UEventObserver {
        private final List<UEventInfo> mUEventInfo = this.makeObservedUEventList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            Object object = WiredAccessoryManager.this.mLock;
            synchronized (object) {
                Slog.v(TAG, "init()");
                char[] buffer = new char[1024];
                for (int i = 0; i < this.mUEventInfo.size(); ++i) {
                    UEventInfo uei = this.mUEventInfo.get(i);
                    try {
                        FileReader file = new FileReader(uei.getSwitchStatePath());
                        int len = file.read(buffer, 0, 1024);
                        file.close();
                        int curState = Integer.valueOf(new String(buffer, 0, len).trim());
                        if (curState <= 0) continue;
                        this.updateStateLocked(uei.getDevPath(), uei.getDevName(), curState);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        Slog.w(TAG, uei.getSwitchStatePath() + " not found while attempting to determine initial switch state");
                        continue;
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "", e);
                    }
                }
            }
            for (int i = 0; i < this.mUEventInfo.size(); ++i) {
                UEventInfo uei = this.mUEventInfo.get(i);
                this.startObserving("DEVPATH=" + uei.getDevPath());
            }
        }

        private List<UEventInfo> makeObservedUEventList() {
            UEventInfo uei;
            ArrayList<UEventInfo> retVal = new ArrayList<UEventInfo>();
            if (!WiredAccessoryManager.this.mUseDevInputEventForAudioJack) {
                uei = new UEventInfo(WiredAccessoryManager.NAME_H2W, 1, 2, 32);
                if (uei.checkSwitchExists()) {
                    retVal.add(uei);
                } else {
                    Slog.w(TAG, "This kernel does not have wired headset support");
                }
            }
            if ((uei = new UEventInfo(WiredAccessoryManager.NAME_USB_AUDIO, 4, 8, 0)).checkSwitchExists()) {
                retVal.add(uei);
            } else {
                Slog.w(TAG, "This kernel does not have usb audio support");
            }
            uei = new UEventInfo(WiredAccessoryManager.NAME_HDMI_AUDIO, 16, 0, 0);
            if (uei.checkSwitchExists()) {
                retVal.add(uei);
            } else {
                uei = new UEventInfo(WiredAccessoryManager.NAME_HDMI, 16, 0, 0);
                if (uei.checkSwitchExists()) {
                    retVal.add(uei);
                } else {
                    Slog.w(TAG, "This kernel does not have HDMI audio support");
                }
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            Slog.v(TAG, "Headset UEVENT: " + event.toString());
            try {
                String devPath = event.get("DEVPATH");
                String name = event.get("SWITCH_NAME");
                int state = Integer.parseInt(event.get("SWITCH_STATE"));
                Object object = WiredAccessoryManager.this.mLock;
                synchronized (object) {
                    this.updateStateLocked(devPath, name, state);
                }
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Could not parse switch state from event " + event);
            }
        }

        private void updateStateLocked(String devPath, String name, int state) {
            for (int i = 0; i < this.mUEventInfo.size(); ++i) {
                UEventInfo uei = this.mUEventInfo.get(i);
                if (!devPath.equals(uei.getDevPath())) continue;
                WiredAccessoryManager.this.updateLocked(name, uei.computeNewHeadsetState(WiredAccessoryManager.this.mHeadsetState, state));
                return;
            }
        }

        private final class UEventInfo {
            private final String mDevName;
            private final int mState1Bits;
            private final int mState2Bits;
            private final int mStateNbits;

            public UEventInfo(String devName, int state1Bits, int state2Bits, int stateNbits) {
                this.mDevName = devName;
                this.mState1Bits = state1Bits;
                this.mState2Bits = state2Bits;
                this.mStateNbits = stateNbits;
            }

            public String getDevName() {
                return this.mDevName;
            }

            public String getDevPath() {
                return String.format(Locale.US, "/devices/virtual/switch/%s", this.mDevName);
            }

            public String getSwitchStatePath() {
                return String.format(Locale.US, "/sys/class/switch/%s/state", this.mDevName);
            }

            public boolean checkSwitchExists() {
                File f = new File(this.getSwitchStatePath());
                return f.exists();
            }

            public int computeNewHeadsetState(int headsetState, int switchState) {
                int preserveMask = ~(this.mState1Bits | this.mState2Bits | this.mStateNbits);
                int setBits = switchState == 1 ? this.mState1Bits : (switchState == 2 ? this.mState2Bits : (switchState == this.mStateNbits ? this.mStateNbits : 0));
                return headsetState & preserveMask | setBits;
            }
        }
    }
}

