/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityController;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.wm.TaskGroup;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class ActivityStack {
    static final int LAUNCH_TICK = 500;
    static final int PAUSE_TIMEOUT = 500;
    static final int STOP_TIMEOUT = 10000;
    static final int DESTROY_TIMEOUT = 10000;
    static final long ACTIVITY_INACTIVE_RESET_TIME = 0L;
    static final long START_WARN_TIME = 5000L;
    static final boolean SHOW_APP_STARTING_PREVIEW = true;
    static final long TRANSLUCENT_CONVERSION_TIMEOUT = 2000L;
    static final boolean SCREENSHOT_FORCE_565 = ActivityManager.isLowRamDeviceStatic();
    final ActivityManagerService mService;
    final WindowManagerService mWindowManager;
    private ArrayList<TaskRecord> mTaskHistory = new ArrayList();
    final ArrayList<TaskGroup> mValidateAppTokens = new ArrayList();
    final ArrayList<ActivityRecord> mLRUActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    ActivityRecord mPausingActivity = null;
    ActivityRecord mLastPausedActivity = null;
    ActivityRecord mLastNoHistoryActivity = null;
    ActivityRecord mResumedActivity = null;
    ActivityRecord mLastStartedActivity = null;
    ActivityRecord mTranslucentActivityWaiting = null;
    private ArrayList<ActivityRecord> mUndrawnActivitiesBelowTopTranslucent = new ArrayList();
    boolean mConfigWillChange;
    long mLaunchStartTime = 0L;
    long mFullyDrawnStartTime = 0L;
    private ActivityRecord mLastScreenshotActivity = null;
    private Bitmap mLastScreenshotBitmap = null;
    int mCurrentUser;
    final int mStackId;
    final ActivityStackSupervisor.ActivityContainer mActivityContainer;
    ArrayList<ActivityStack> mStacks;
    int mDisplayId;
    final ActivityStackSupervisor mStackSupervisor;
    private boolean inResumeTopActivity;
    static final int PAUSE_TIMEOUT_MSG = 101;
    static final int DESTROY_TIMEOUT_MSG = 102;
    static final int LAUNCH_TICK_MSG = 103;
    static final int STOP_TIMEOUT_MSG = 104;
    static final int DESTROY_ACTIVITIES_MSG = 105;
    static final int TRANSLUCENT_TIMEOUT_MSG = 106;
    static final int RELEASE_BACKGROUND_RESOURCES_TIMEOUT_MSG = 107;
    final Handler mHandler;
    static final int FINISH_IMMEDIATELY = 0;
    static final int FINISH_AFTER_PAUSE = 1;
    static final int FINISH_AFTER_VISIBLE = 2;

    int numActivities() {
        int count = 0;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            count += this.mTaskHistory.get((int)taskNdx).mActivities.size();
        }
        return count;
    }

    ActivityStack(ActivityStackSupervisor.ActivityContainer activityContainer) {
        this.mActivityContainer = activityContainer;
        this.mStackSupervisor = activityContainer.getOuter();
        this.mService = this.mStackSupervisor.mService;
        this.mHandler = new ActivityStackHandler(this.mService.mHandler.getLooper());
        this.mWindowManager = this.mService.mWindowManager;
        this.mStackId = activityContainer.mStackId;
        this.mCurrentUser = this.mService.mCurrentUserId;
    }

    private boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUser) {
            return true;
        }
        for (int i = 0; i < this.mService.mCurrentProfileIds.length; ++i) {
            if (this.mService.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    boolean okToShowLocked(ActivityRecord r) {
        return this.isCurrentProfileLocked(r.userId) || (r.info.flags & 0x400) != 0;
    }

    final ActivityRecord topRunningActivityLocked(ActivityRecord notTop) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ActivityRecord r = this.mTaskHistory.get(taskNdx).topRunningActivityLocked(notTop);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    final ActivityRecord topRunningNonDelayedActivityLocked(ActivityRecord notTop) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || r.delayedResume || r == notTop || !this.okToShowLocked(r)) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topRunningActivityLocked(IBinder token, int taskId) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId == taskId) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int i = activities.size() - 1; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || token == r.appToken || !this.okToShowLocked(r)) continue;
                return r;
            }
        }
        return null;
    }

    final ActivityRecord topActivity() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                return r;
            }
        }
        return null;
    }

    final TaskRecord topTask() {
        int size = this.mTaskHistory.size();
        if (size > 0) {
            return this.mTaskHistory.get(size - 1);
        }
        return null;
    }

    TaskRecord taskForIdLocked(int id2) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskId != id2) continue;
            return task;
        }
        return null;
    }

    ActivityRecord isInStackLocked(IBinder token) {
        TaskRecord task;
        ActivityRecord r = ActivityRecord.forToken(token);
        if (r != null && (task = r.task) != null && task.mActivities.contains(r) && this.mTaskHistory.contains(task)) {
            if (task.stack != this) {
                Slog.w("ActivityManager", "Illegal state! task does not point to stack it is in.");
            }
            return r;
        }
        return null;
    }

    final boolean updateLRUListLocked(ActivityRecord r) {
        boolean hadit = this.mLRUActivities.remove(r);
        this.mLRUActivities.add(r);
        return hadit;
    }

    final boolean isHomeStack() {
        return this.mStackId == 0;
    }

    final boolean isOnHomeDisplay() {
        return this.isAttached() && this.mActivityContainer.mActivityDisplay.mDisplayId == 0;
    }

    final void moveToFront() {
        if (this.isAttached()) {
            if (this.isOnHomeDisplay()) {
                this.mStackSupervisor.moveHomeStack(this.isHomeStack());
            }
            this.mStacks.remove(this);
            this.mStacks.add(this);
        }
    }

    final boolean isAttached() {
        return this.mStacks != null;
    }

    ActivityRecord findTaskLocked(ActivityRecord target) {
        Intent intent = target.intent;
        ActivityInfo info = target.info;
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        boolean isDocument = intent != null & intent.isDocument();
        Uri documentData = isDocument ? intent.getData() : null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            Uri taskDocumentData;
            boolean taskIsDocument;
            ActivityRecord r;
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.voiceSession != null || task.userId != userId || (r = task.getTopActivity()) == null || r.finishing || r.userId != userId || r.launchMode == 3) continue;
            Intent taskIntent = task.intent;
            Intent affinityIntent = task.affinityIntent;
            if (taskIntent != null && taskIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = taskIntent.getData();
            } else if (affinityIntent != null && affinityIntent.isDocument()) {
                taskIsDocument = true;
                taskDocumentData = affinityIntent.getData();
            } else {
                taskIsDocument = false;
                taskDocumentData = null;
            }
            if (!isDocument && !taskIsDocument && task.rootAffinity != null) {
                if (!task.rootAffinity.equals(target.taskAffinity)) continue;
                return r;
            }
            if (taskIntent != null && taskIntent.getComponent() != null && taskIntent.getComponent().compareTo(cls) == 0 && Objects.equals(documentData, taskDocumentData)) {
                return r;
            }
            if (affinityIntent == null || affinityIntent.getComponent() == null || affinityIntent.getComponent().compareTo(cls) != 0 || !Objects.equals(documentData, taskDocumentData)) continue;
            return r;
        }
        return null;
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info) {
        ComponentName cls = intent.getComponent();
        if (info.targetActivity != null) {
            cls = new ComponentName(info.packageName, info.targetActivity);
        }
        int userId = UserHandle.getUserId(info.applicationInfo.uid);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!this.isCurrentProfileLocked(task.userId)) {
                return null;
            }
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || !r.intent.getComponent().equals(cls) || r.userId != userId) continue;
                return r;
            }
        }
        return null;
    }

    final void switchUserLocked(int userId) {
        if (this.mCurrentUser == userId) {
            return;
        }
        this.mCurrentUser = userId;
        int index = this.mTaskHistory.size();
        int i = 0;
        while (i < index) {
            TaskRecord task = this.mTaskHistory.get(i);
            if (this.isCurrentProfileLocked(task.userId)) {
                this.mTaskHistory.remove(i);
                this.mTaskHistory.add(task);
                --index;
                continue;
            }
            ++i;
        }
    }

    void minimalResumeActivityLocked(ActivityRecord r) {
        r.state = ActivityState.RESUMED;
        r.stopped = false;
        this.mResumedActivity = r;
        r.task.touchActiveTime();
        this.mService.addRecentTaskLocked(r.task);
        this.completeResumeLocked(r);
        this.mStackSupervisor.checkReadyForSleepLocked();
        this.setLaunchTime(r);
    }

    private void startLaunchTraces() {
        if (this.mFullyDrawnStartTime != 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
        }
        Trace.asyncTraceBegin(64L, "launching", 0);
        Trace.asyncTraceBegin(64L, "drawing", 0);
    }

    private void stopFullyDrawnTraceIfNeeded() {
        if (this.mFullyDrawnStartTime != 0L && this.mLaunchStartTime == 0L) {
            Trace.asyncTraceEnd(64L, "drawing", 0);
            this.mFullyDrawnStartTime = 0L;
        }
    }

    void setLaunchTime(ActivityRecord r) {
        if (r.displayStartTime == 0L) {
            r.fullyDrawnStartTime = r.displayStartTime = SystemClock.uptimeMillis();
            if (this.mLaunchStartTime == 0L) {
                this.startLaunchTraces();
                this.mLaunchStartTime = this.mFullyDrawnStartTime = r.displayStartTime;
            }
        } else if (this.mLaunchStartTime == 0L) {
            this.startLaunchTraces();
            this.mLaunchStartTime = this.mFullyDrawnStartTime = SystemClock.uptimeMillis();
        }
    }

    void clearLaunchTime(ActivityRecord r) {
        if (this.mStackSupervisor.mWaitingActivityLaunched.isEmpty()) {
            r.fullyDrawnStartTime = 0L;
            r.displayStartTime = 0L;
        } else {
            this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
            this.mStackSupervisor.scheduleIdleTimeoutLocked(r);
        }
    }

    void awakeFromSleepingLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                activities.get(activityNdx).setSleeping(false);
            }
        }
    }

    boolean checkReadyForSleepLocked() {
        if (this.mResumedActivity != null) {
            this.startPausingLocked(false, true, false, false);
            return true;
        }
        return this.mPausingActivity != null;
    }

    void goToSleep() {
        this.ensureActivitiesVisibleLocked(null, 0);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.state != ActivityState.STOPPING && r.state != ActivityState.STOPPED) continue;
                r.setSleeping(true);
            }
        }
    }

    private void invalidateLastScreenshot() {
        this.mLastScreenshotActivity = null;
        if (this.mLastScreenshotBitmap != null) {
            this.mLastScreenshotBitmap.recycle();
        }
        this.mLastScreenshotBitmap = null;
    }

    public final Bitmap screenshotActivities(ActivityRecord who) {
        if (who.noDisplay) {
            return null;
        }
        if (this.isHomeStack()) {
            this.invalidateLastScreenshot();
            return null;
        }
        int w = this.mService.mThumbnailWidth;
        int h = this.mService.mThumbnailHeight;
        if (w > 0) {
            if (who != this.mLastScreenshotActivity || this.mLastScreenshotBitmap == null || this.mLastScreenshotActivity.state == ActivityState.RESUMED || this.mLastScreenshotBitmap.getWidth() != w || this.mLastScreenshotBitmap.getHeight() != h) {
                this.mLastScreenshotActivity = who;
                this.mLastScreenshotBitmap = this.mWindowManager.screenshotApplications(who.appToken, 0, w, h, SCREENSHOT_FORCE_565);
            }
            if (this.mLastScreenshotBitmap != null) {
                return this.mLastScreenshotBitmap.copy(this.mLastScreenshotBitmap.getConfig(), true);
            }
        }
        Slog.e("ActivityManager", "Invalid thumbnail dimensions: " + w + "x" + h);
        return null;
    }

    final boolean startPausingLocked(boolean userLeaving, boolean uiSleeping, boolean resuming, boolean dontWait) {
        ActivityRecord prev;
        if (this.mPausingActivity != null) {
            Slog.wtf("ActivityManager", "Going to pause when pause is already pending for " + this.mPausingActivity);
            this.completePauseLocked(false);
        }
        if ((prev = this.mResumedActivity) == null) {
            if (!resuming) {
                Slog.wtf("ActivityManager", "Trying to pause when nothing is resumed");
                this.mStackSupervisor.resumeTopActivitiesLocked();
            }
            return false;
        }
        if (this.mActivityContainer.mParentActivity == null) {
            this.mStackSupervisor.pauseChildStacks(prev, userLeaving, uiSleeping, resuming, dontWait);
        }
        this.mResumedActivity = null;
        this.mPausingActivity = prev;
        this.mLastPausedActivity = prev;
        this.mLastNoHistoryActivity = (prev.intent.getFlags() & 0x40000000) != 0 || (prev.info.flags & 0x80) != 0 ? prev : null;
        prev.state = ActivityState.PAUSING;
        prev.task.touchActiveTime();
        this.clearLaunchTime(prev);
        ActivityRecord next = this.mStackSupervisor.topRunningActivityLocked();
        if (this.mService.mHasRecents && (next == null || next.noDisplay || next.task != prev.task)) {
            prev.updateThumbnail(this.screenshotActivities(prev), null);
        }
        this.stopFullyDrawnTraceIfNeeded();
        this.mService.updateCpuStats();
        if (prev.app != null && prev.app.thread != null) {
            try {
                EventLog.writeEvent(30013, prev.userId, System.identityHashCode(prev), prev.shortComponentName);
                this.mService.updateUsageStats(prev, false);
                prev.app.thread.schedulePauseActivity(prev.appToken, prev.finishing, userLeaving, prev.configChangeFlags, dontWait);
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during pause", e);
                this.mPausingActivity = null;
                this.mLastPausedActivity = null;
                this.mLastNoHistoryActivity = null;
            }
        } else {
            this.mPausingActivity = null;
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        if (!this.mService.isSleepingOrShuttingDown()) {
            this.mStackSupervisor.acquireLaunchWakelock();
        }
        if (this.mPausingActivity != null) {
            if (!uiSleeping) {
                prev.pauseKeyDispatchingLocked();
            }
            if (dontWait) {
                this.completePauseLocked(false);
                return false;
            }
            Message msg = this.mHandler.obtainMessage(101);
            msg.obj = prev;
            prev.pauseTime = SystemClock.uptimeMillis();
            this.mHandler.sendMessageDelayed(msg, 500L);
            return true;
        }
        if (!resuming) {
            this.mStackSupervisor.getFocusedStack().resumeTopActivityLocked(null);
        }
        return false;
    }

    final void activityPausedLocked(IBinder token, boolean timeout) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(101, r);
            if (this.mPausingActivity == r) {
                this.completePauseLocked(true);
            } else {
                EventLog.writeEvent(30012, r.userId, System.identityHashCode(r), r.shortComponentName, this.mPausingActivity != null ? this.mPausingActivity.shortComponentName : "(none)");
            }
        }
    }

    final void activityStoppedLocked(ActivityRecord r, Bundle icicle, PersistableBundle persistentState, CharSequence description) {
        if (r.state != ActivityState.STOPPING) {
            Slog.i("ActivityManager", "Activity reported stop, but no longer stopping: " + r);
            this.mHandler.removeMessages(104, r);
            return;
        }
        if (persistentState != null) {
            r.persistentState = persistentState;
            this.mService.notifyTaskPersisterLocked(r.task, false);
        }
        if (icicle != null) {
            r.icicle = icicle;
            r.haveState = true;
            r.launchCount = 0;
            r.updateThumbnail(null, description);
        }
        if (!r.stopped) {
            this.mHandler.removeMessages(104, r);
            r.stopped = true;
            r.state = ActivityState.STOPPED;
            if (this.mActivityContainer.mActivityDisplay.mVisibleBehindActivity == r) {
                this.mStackSupervisor.requestVisibleBehindLocked(r, false);
            }
            if (r.finishing) {
                r.clearOptionsLocked();
            } else if (r.configDestroy) {
                this.destroyActivityLocked(r, true, "stop-config");
                this.mStackSupervisor.resumeTopActivitiesLocked();
            } else {
                this.mStackSupervisor.updatePreviousProcessLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePauseLocked(boolean resumeNext) {
        ActivityRecord prev = this.mPausingActivity;
        if (prev != null) {
            prev.state = ActivityState.PAUSED;
            if (prev.finishing) {
                prev = this.finishCurrentActivityLocked(prev, 2, false);
            } else if (prev.app != null) {
                if (prev.waitingVisible) {
                    prev.waitingVisible = false;
                    this.mStackSupervisor.mWaitingVisibleActivities.remove(prev);
                }
                if (prev.configDestroy) {
                    this.destroyActivityLocked(prev, true, "pause-config");
                } else if (!this.hasVisibleBehindActivity()) {
                    this.mStackSupervisor.mStoppingActivities.add(prev);
                    if (this.mStackSupervisor.mStoppingActivities.size() > 3 || prev.frontOfTask && this.mTaskHistory.size() <= 1) {
                        this.mStackSupervisor.scheduleIdleLocked();
                    } else {
                        this.mStackSupervisor.checkReadyForSleepLocked();
                    }
                }
            } else {
                prev = null;
            }
            this.mPausingActivity = null;
        }
        if (resumeNext) {
            ActivityStack topStack = this.mStackSupervisor.getFocusedStack();
            if (!this.mService.isSleepingOrShuttingDown()) {
                this.mStackSupervisor.resumeTopActivitiesLocked(topStack, prev, null);
            } else {
                this.mStackSupervisor.checkReadyForSleepLocked();
                ActivityRecord top = topStack.topRunningActivityLocked(null);
                if (top == null || prev != null && top != prev) {
                    this.mStackSupervisor.resumeTopActivitiesLocked(topStack, null, null);
                }
            }
        }
        if (prev != null) {
            long diff;
            prev.resumeKeyDispatchingLocked();
            if (prev.app != null && prev.cpuTimeAtResume > 0L && this.mService.mBatteryStatsService.isOnBattery() && (diff = this.mService.mProcessCpuTracker.getCpuTimeForPid(prev.app.pid) - prev.cpuTimeAtResume) > 0L) {
                BatteryStatsImpl bsi;
                BatteryStatsImpl batteryStatsImpl = bsi = this.mService.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    BatteryStatsImpl.Uid.Proc ps = bsi.getProcessStatsLocked(prev.info.applicationInfo.uid, prev.info.packageName);
                    if (ps != null) {
                        ps.addForegroundTimeLocked(diff);
                    }
                }
            }
            prev.cpuTimeAtResume = 0L;
        }
    }

    private void completeResumeLocked(ActivityRecord next) {
        ProcessRecord app;
        next.idle = false;
        next.results = null;
        next.newIntents = null;
        if (next.isHomeActivity() && next.isNotResolverActivity() && (app = next.task.mActivities.get((int)0).app) != null && app != this.mService.mHomeProcess) {
            this.mService.mHomeProcess = app;
        }
        if (next.nowVisible) {
            this.mStackSupervisor.notifyActivityDrawnForKeyguard();
        }
        this.mStackSupervisor.scheduleIdleTimeoutLocked(next);
        this.mStackSupervisor.reportResumedActivityLocked(next);
        next.resumeKeyDispatchingLocked();
        this.mNoAnimActivities.clear();
        next.cpuTimeAtResume = next.app != null ? this.mService.mProcessCpuTracker.getCpuTimeForPid(next.app.pid) : 0L;
        if (next == this.mLastScreenshotActivity) {
            this.invalidateLastScreenshot();
        }
        next.returningOptions = null;
        if (this.mActivityContainer.mActivityDisplay.mVisibleBehindActivity == next) {
            this.mActivityContainer.mActivityDisplay.setVisibleBehindActivity(null);
        }
    }

    private void setVisibile(ActivityRecord r, boolean visible) {
        r.visible = visible;
        this.mWindowManager.setAppVisibility(r.appToken, visible);
        ArrayList<ActivityStackSupervisor.ActivityContainer> containers = r.mChildContainers;
        for (int containerNdx = containers.size() - 1; containerNdx >= 0; --containerNdx) {
            ActivityStackSupervisor.ActivityContainer container = containers.get(containerNdx);
            container.setVisible(visible);
        }
    }

    ActivityRecord findNextTranslucentActivity(ActivityRecord r) {
        TaskRecord task = r.task;
        if (task == null) {
            return null;
        }
        ActivityStack stack = task.stack;
        if (stack == null) {
            return null;
        }
        ArrayList<TaskRecord> tasks = stack.mTaskHistory;
        int taskNdx = tasks.indexOf(task);
        ArrayList<ActivityRecord> activities = task.mActivities;
        int activityNdx = activities.indexOf(r) + 1;
        int numStacks = this.mStacks.size();
        for (int stackNdx = this.mStacks.indexOf(stack); stackNdx < numStacks; ++stackNdx) {
            tasks = this.mStacks.get((int)stackNdx).mTaskHistory;
            int numTasks = tasks.size();
            while (taskNdx < numTasks) {
                activities = tasks.get((int)taskNdx).mActivities;
                int numActivities = activities.size();
                while (activityNdx < numActivities) {
                    ActivityRecord activity = activities.get(activityNdx);
                    if (!activity.finishing) {
                        return activity.fullscreen ? null : activity;
                    }
                    ++activityNdx;
                }
                activityNdx = 0;
                ++taskNdx;
            }
            taskNdx = 0;
        }
        return null;
    }

    private boolean isStackVisible() {
        if (!this.isAttached()) {
            return false;
        }
        if (this.mStackSupervisor.isFrontStack(this)) {
            return true;
        }
        for (int i = this.mStacks.indexOf(this) + 1; i < this.mStacks.size(); ++i) {
            ArrayList<TaskRecord> tasks = this.mStacks.get(i).getAllTasks();
            for (int taskNdx = 0; taskNdx < tasks.size(); ++taskNdx) {
                TaskRecord task = tasks.get(taskNdx);
                ArrayList<ActivityRecord> activities = task.mActivities;
                for (int activityNdx = 0; activityNdx < activities.size(); ++activityNdx) {
                    ActivityRecord r = activities.get(activityNdx);
                    if (r.finishing || !r.visible || !r.fullscreen && (this.isHomeStack() || !r.frontOfTask || !task.isOverHomeStack())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    final void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges) {
        ActivityRecord top = this.topRunningActivityLocked(null);
        if (top == null) {
            return;
        }
        if (this.mTranslucentActivityWaiting != top) {
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            if (this.mTranslucentActivityWaiting != null) {
                this.notifyActivityDrawnLocked(null);
                this.mTranslucentActivityWaiting = null;
            }
            this.mHandler.removeMessages(106);
        }
        boolean aboveTop = true;
        boolean behindFullscreen = !this.isStackVisible();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing || aboveTop && r != top) continue;
                aboveTop = false;
                if (!behindFullscreen || r.mLaunchTaskBehind) {
                    if (r != starting) {
                        this.ensureActivityConfigurationLocked(r, 0);
                    }
                    if (r.app == null || r.app.thread == null) {
                        if (r != starting) {
                            r.startFreezingScreenLocked(r.app, configChanges);
                        }
                        if (!r.visible || r.mLaunchTaskBehind) {
                            this.setVisibile(r, true);
                        }
                        if (r != starting) {
                            this.mStackSupervisor.startSpecificActivityLocked(r, false, false);
                        }
                    } else if (r.visible) {
                        r.stopFreezingScreenLocked(false);
                        try {
                            if (r.returningOptions != null) {
                                r.app.thread.scheduleOnNewActivityOptions(r.appToken, r.returningOptions);
                            }
                        }
                        catch (RemoteException e) {}
                    } else {
                        r.visible = true;
                        if (r.state != ActivityState.RESUMED && r != starting) {
                            try {
                                if (this.mTranslucentActivityWaiting != null) {
                                    r.updateOptionsLocked(r.returningOptions);
                                    this.mUndrawnActivitiesBelowTopTranslucent.add(r);
                                }
                                this.setVisibile(r, true);
                                r.sleeping = false;
                                r.app.pendingUiClean = true;
                                r.app.thread.scheduleWindowVisibility(r.appToken, true);
                                r.stopFreezingScreenLocked(false);
                            }
                            catch (Exception e) {
                                Slog.w("ActivityManager", "Exception thrown making visibile: " + r.intent.getComponent(), e);
                            }
                        }
                    }
                    configChanges |= r.configChangeFlags;
                    if (r.fullscreen) {
                        behindFullscreen = true;
                        continue;
                    }
                    if (this.isHomeStack() || !r.frontOfTask || !task.isOverHomeStack()) continue;
                    behindFullscreen = true;
                    continue;
                }
                if (!r.visible) continue;
                try {
                    this.setVisibile(r, false);
                    switch (r.state) {
                        case STOPPING: 
                        case STOPPED: {
                            if (r.app == null || r.app.thread == null) break;
                            r.app.thread.scheduleWindowVisibility(r.appToken, false);
                            break;
                        }
                        case INITIALIZING: 
                        case RESUMED: 
                        case PAUSING: 
                        case PAUSED: {
                            if (this.getVisibleBehindActivity() == r) {
                                this.releaseBackgroundResources();
                                break;
                            }
                            if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
                                this.mStackSupervisor.mStoppingActivities.add(r);
                            }
                            this.mStackSupervisor.scheduleIdleLocked();
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception thrown making hidden: " + r.intent.getComponent(), e);
                }
            }
        }
        if (this.mTranslucentActivityWaiting != null && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            this.notifyActivityDrawnLocked(null);
        }
    }

    void convertToTranslucent(ActivityRecord r) {
        this.mTranslucentActivityWaiting = r;
        this.mUndrawnActivitiesBelowTopTranslucent.clear();
        this.mHandler.sendEmptyMessageDelayed(106, 2000L);
    }

    void notifyActivityDrawnLocked(ActivityRecord r) {
        this.mActivityContainer.setDrawn();
        if (r == null || this.mUndrawnActivitiesBelowTopTranslucent.remove(r) && this.mUndrawnActivitiesBelowTopTranslucent.isEmpty()) {
            ActivityRecord waitingActivity = this.mTranslucentActivityWaiting;
            this.mTranslucentActivityWaiting = null;
            this.mUndrawnActivitiesBelowTopTranslucent.clear();
            this.mHandler.removeMessages(106);
            if (waitingActivity != null) {
                this.mWindowManager.setWindowOpaque(waitingActivity.appToken, false);
                if (waitingActivity.app != null && waitingActivity.app.thread != null) {
                    try {
                        waitingActivity.app.thread.scheduleTranslucentConversionComplete(waitingActivity.appToken, r != null);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void cancelInitializingActivities() {
        ActivityRecord topActivity = this.topRunningActivityLocked(null);
        boolean aboveTop = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (aboveTop) {
                    if (r != topActivity) continue;
                    aboveTop = false;
                    continue;
                }
                if (r.state != ActivityState.INITIALIZING || !r.mStartingWindowShown) continue;
                r.mStartingWindowShown = false;
                this.mWindowManager.removeAppStartingWindow(r.appToken);
            }
        }
    }

    final boolean resumeTopActivityLocked(ActivityRecord prev) {
        return this.resumeTopActivityLocked(prev, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean resumeTopActivityLocked(ActivityRecord prev, Bundle options) {
        if (this.inResumeTopActivity) {
            return false;
        }
        boolean result = false;
        try {
            this.inResumeTopActivity = true;
            result = this.resumeTopActivityInnerLocked(prev, options);
        }
        finally {
            this.inResumeTopActivity = false;
        }
        return result;
    }

    final boolean resumeTopActivityInnerLocked(ActivityRecord prev, Bundle options) {
        TaskRecord prevTask;
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        ActivityRecord parent = this.mActivityContainer.mParentActivity;
        if (parent != null && parent.state != ActivityState.RESUMED || !this.mActivityContainer.isAttachedLocked()) {
            return false;
        }
        this.cancelInitializingActivities();
        ActivityRecord next = this.topRunningActivityLocked(null);
        boolean userLeaving = this.mStackSupervisor.mUserLeaving;
        this.mStackSupervisor.mUserLeaving = false;
        TaskRecord taskRecord = prevTask = prev != null ? prev.task : null;
        if (next == null) {
            ActivityOptions.abort(options);
            int returnTaskType = prevTask == null || !prevTask.isOverHomeStack() ? 1 : prevTask.getTaskToReturnTo();
            return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(returnTaskType, prev);
        }
        next.delayedResume = false;
        if (this.mResumedActivity == next && next.state == ActivityState.RESUMED && this.mStackSupervisor.allResumedActivitiesComplete()) {
            this.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            ActivityOptions.abort(options);
            this.mStackSupervisor.notifyActivityDrawnForKeyguard();
            return false;
        }
        TaskRecord nextTask = next.task;
        if (prevTask != null && prevTask.stack == this && prevTask.isOverHomeStack() && prev.finishing && prev.frontOfTask) {
            if (prevTask == nextTask) {
                prevTask.setFrontOfTask();
            } else if (prevTask != this.topTask()) {
                int taskNdx = this.mTaskHistory.indexOf(prevTask) + 1;
                this.mTaskHistory.get(taskNdx).setTaskToReturnTo(1);
            } else {
                int returnTaskType = prevTask == null || !prevTask.isOverHomeStack() ? 1 : prevTask.getTaskToReturnTo();
                return this.isOnHomeDisplay() && this.mStackSupervisor.resumeHomeStackTask(returnTaskType, prev);
            }
        }
        if (this.mService.isSleepingOrShuttingDown() && this.mLastPausedActivity == next && this.mStackSupervisor.allPausedActivitiesComplete()) {
            this.mWindowManager.executeAppTransition();
            this.mNoAnimActivities.clear();
            ActivityOptions.abort(options);
            return false;
        }
        if (this.mService.mStartedUsers.get(next.userId) == null) {
            Slog.w("ActivityManager", "Skipping resume of top activity " + next + ": user " + next.userId + " is stopped");
            return false;
        }
        this.mStackSupervisor.mStoppingActivities.remove(next);
        this.mStackSupervisor.mGoingToSleepActivities.remove(next);
        next.sleeping = false;
        this.mStackSupervisor.mWaitingVisibleActivities.remove(next);
        if (!this.mStackSupervisor.allPausedActivitiesComplete()) {
            return false;
        }
        boolean dontWaitForPause = (next.info.flags & 0x4000) != 0;
        boolean pausing = this.mStackSupervisor.pauseBackStacks(userLeaving, true, dontWaitForPause);
        if (this.mResumedActivity != null) {
            pausing |= this.startPausingLocked(userLeaving, false, true, dontWaitForPause);
        }
        if (pausing) {
            if (next.app != null && next.app.thread != null) {
                this.mService.updateLruProcessLocked(next.app, true, null);
            }
            return true;
        }
        if (this.mService.isSleeping() && this.mLastNoHistoryActivity != null && !this.mLastNoHistoryActivity.finishing) {
            this.requestFinishActivityLocked(this.mLastNoHistoryActivity.appToken, 0, null, "no-history", false);
            this.mLastNoHistoryActivity = null;
        }
        if (prev != null && prev != next) {
            if (!prev.waitingVisible && next != null && !next.nowVisible) {
                prev.waitingVisible = true;
                this.mStackSupervisor.mWaitingVisibleActivities.add(prev);
            } else if (prev.finishing) {
                this.mWindowManager.setAppVisibility(prev.appToken, false);
            }
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(next.packageName, false, next.userId);
        }
        catch (RemoteException e1) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + next.packageName + ": " + e);
        }
        boolean anim2 = true;
        if (prev != null) {
            if (prev.finishing) {
                if (this.mNoAnimActivities.contains(prev)) {
                    anim2 = false;
                    this.mWindowManager.prepareAppTransition(0, false);
                } else {
                    this.mWindowManager.prepareAppTransition(prev.task == next.task ? 7 : 9, false);
                }
                this.mWindowManager.setAppWillBeHidden(prev.appToken);
                this.mWindowManager.setAppVisibility(prev.appToken, false);
            } else if (this.mNoAnimActivities.contains(next)) {
                anim2 = false;
                this.mWindowManager.prepareAppTransition(0, false);
            } else {
                this.mWindowManager.prepareAppTransition(prev.task == next.task ? 6 : (next.mLaunchTaskBehind ? 16 : 8), false);
            }
        } else if (this.mNoAnimActivities.contains(next)) {
            anim2 = false;
            this.mWindowManager.prepareAppTransition(0, false);
        } else {
            this.mWindowManager.prepareAppTransition(6, false);
        }
        Bundle resumeAnimOptions = null;
        if (anim2) {
            ActivityOptions opts = next.getOptionsForTargetActivityLocked();
            if (opts != null) {
                resumeAnimOptions = opts.toBundle();
            }
            next.applyOptionsLocked();
        } else {
            next.clearOptionsLocked();
        }
        ActivityStack lastStack = this.mStackSupervisor.getLastStack();
        if (next.app != null && next.app.thread != null) {
            this.mWindowManager.setAppVisibility(next.appToken, true);
            next.startLaunchTickingLocked();
            ActivityRecord lastResumedActivity = lastStack == null ? null : lastStack.mResumedActivity;
            ActivityState lastState = next.state;
            this.mService.updateCpuStats();
            next.state = ActivityState.RESUMED;
            this.mResumedActivity = next;
            next.task.touchActiveTime();
            this.mService.addRecentTaskLocked(next.task);
            this.mService.updateLruProcessLocked(next.app, true, null);
            this.updateLRUListLocked(next);
            this.mService.updateOomAdjLocked();
            boolean notUpdated = true;
            if (this.mStackSupervisor.isFrontStack(this)) {
                Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, next.mayFreezeScreenLocked(next.app) ? next.appToken : null);
                if (config != null) {
                    next.frozenBeforeDestroy = true;
                }
                boolean bl = notUpdated = !this.mService.updateConfigurationLocked(config, next, false, false);
            }
            if (notUpdated) {
                ActivityRecord nextNext = this.topRunningActivityLocked(null);
                if (nextNext != next) {
                    this.mStackSupervisor.scheduleResumeTopActivities();
                }
                if (this.mStackSupervisor.reportResumedActivityLocked(next)) {
                    this.mNoAnimActivities.clear();
                    return true;
                }
                return false;
            }
            try {
                ArrayList<ResultInfo> a = next.results;
                if (a != null) {
                    int N = a.size();
                    if (!next.finishing && N > 0) {
                        next.app.thread.scheduleSendResult(next.appToken, a);
                    }
                }
                if (next.newIntents != null) {
                    next.app.thread.scheduleNewIntent(next.newIntents, next.appToken);
                }
                EventLog.writeEvent(30007, next.userId, System.identityHashCode(next), next.task.taskId, next.shortComponentName);
                next.sleeping = false;
                this.mService.showAskCompatModeDialogLocked(next);
                next.app.pendingUiClean = true;
                next.app.forceProcessStateUpTo(2);
                next.clearOptionsLocked();
                next.app.thread.scheduleResumeActivity(next.appToken, next.app.repProcState, this.mService.isNextTransitionForward(), resumeAnimOptions);
                this.mStackSupervisor.checkReadyForSleepLocked();
            }
            catch (Exception e) {
                next.state = lastState;
                if (lastStack != null) {
                    lastStack.mResumedActivity = lastResumedActivity;
                }
                Slog.i("ActivityManager", "Restarting because process died: " + next);
                if (!next.hasBeenLaunched) {
                    next.hasBeenLaunched = true;
                } else if (lastStack != null && this.mStackSupervisor.isFrontStack(lastStack)) {
                    this.mWindowManager.setAppStartingWindow(next.appToken, next.packageName, next.theme, this.mService.compatibilityInfoForPackageLocked(next.info.applicationInfo), next.nonLocalizedLabel, next.labelRes, next.icon, next.logo, next.windowFlags, null, true);
                }
                this.mStackSupervisor.startSpecificActivityLocked(next, true, false);
                return true;
            }
            try {
                next.visible = true;
                this.completeResumeLocked(next);
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown during resume of " + next, e);
                this.requestFinishActivityLocked(next.appToken, 0, null, "resume-exception", true);
                return true;
            }
            next.stopped = false;
        } else {
            if (!next.hasBeenLaunched) {
                next.hasBeenLaunched = true;
            } else {
                this.mWindowManager.setAppStartingWindow(next.appToken, next.packageName, next.theme, this.mService.compatibilityInfoForPackageLocked(next.info.applicationInfo), next.nonLocalizedLabel, next.labelRes, next.icon, next.logo, next.windowFlags, null, true);
            }
            this.mStackSupervisor.startSpecificActivityLocked(next, true, true);
        }
        return true;
    }

    private void insertTaskAtTop(TaskRecord task) {
        if (this.isOnHomeDisplay()) {
            ActivityStack lastStack = this.mStackSupervisor.getLastStack();
            boolean fromHome = lastStack.isHomeStack();
            if (!this.isHomeStack() && (fromHome || this.topTask() != task)) {
                task.setTaskToReturnTo(fromHome ? (lastStack.topTask() == null ? 1 : lastStack.topTask().taskType) : 0);
            }
        } else {
            task.setTaskToReturnTo(0);
        }
        this.mTaskHistory.remove(task);
        int taskNdx = this.mTaskHistory.size();
        if (!this.isCurrentProfileLocked(task.userId)) {
            while (--taskNdx >= 0 && this.isCurrentProfileLocked(this.mTaskHistory.get((int)taskNdx).userId)) {
            }
            ++taskNdx;
        }
        this.mTaskHistory.add(taskNdx, task);
        this.updateTaskMovement(task, true);
    }

    final void startActivityLocked(ActivityRecord r, boolean newTask, boolean doResume, boolean keepCurTransition, Bundle options) {
        TaskRecord rTask = r.task;
        int taskId = rTask.taskId;
        if (!r.mLaunchTaskBehind && (this.taskForIdLocked(taskId) == null || newTask)) {
            this.insertTaskAtTop(rTask);
            this.mWindowManager.moveTaskToTop(taskId);
        }
        TaskRecord task = null;
        if (!newTask) {
            boolean startIt = true;
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                task = this.mTaskHistory.get(taskNdx);
                if (task.getTopActivity() == null) continue;
                if (task == r.task) {
                    if (startIt) break;
                    task.addActivityToTop(r);
                    r.putInHistory();
                    this.mWindowManager.addAppToken(task.mActivities.indexOf(r), r.appToken, r.task.taskId, this.mStackId, r.info.screenOrientation, r.fullscreen, (r.info.flags & 0x400) != 0, r.userId, r.info.configChanges, task.voiceSession != null, r.mLaunchTaskBehind);
                    ActivityOptions.abort(options);
                    return;
                }
                if (task.numFullscreen <= 0) continue;
                startIt = false;
            }
        }
        if (task == r.task && this.mTaskHistory.indexOf(task) != this.mTaskHistory.size() - 1) {
            this.mStackSupervisor.mUserLeaving = false;
        }
        task = r.task;
        task.addActivityToTop(r);
        task.setFrontOfTask();
        r.putInHistory();
        if (!this.isHomeStack() || this.numActivities() > 0) {
            boolean showStartingIcon = newTask;
            ProcessRecord proc = r.app;
            if (proc == null) {
                proc = this.mService.mProcessNames.get(r.processName, r.info.applicationInfo.uid);
            }
            if (proc == null || proc.thread == null) {
                showStartingIcon = true;
            }
            if ((r.intent.getFlags() & 0x10000) != 0) {
                this.mWindowManager.prepareAppTransition(0, keepCurTransition);
                this.mNoAnimActivities.add(r);
            } else {
                this.mWindowManager.prepareAppTransition(newTask ? (r.mLaunchTaskBehind ? 16 : 8) : 6, keepCurTransition);
                this.mNoAnimActivities.remove(r);
            }
            this.mWindowManager.addAppToken(task.mActivities.indexOf(r), r.appToken, r.task.taskId, this.mStackId, r.info.screenOrientation, r.fullscreen, (r.info.flags & 0x400) != 0, r.userId, r.info.configChanges, task.voiceSession != null, r.mLaunchTaskBehind);
            boolean doShow = true;
            if (newTask) {
                if ((r.intent.getFlags() & 0x200000) != 0) {
                    this.resetTaskIfNeededLocked(r, r);
                    doShow = this.topRunningNonDelayedActivityLocked(null) == r;
                }
            } else if (options != null && new ActivityOptions(options).getAnimationType() == 5) {
                doShow = false;
            }
            if (r.mLaunchTaskBehind) {
                this.mWindowManager.setAppVisibility(r.appToken, true);
                this.ensureActivitiesVisibleLocked(null, 0);
            } else if (doShow) {
                ActivityRecord prev = this.mResumedActivity;
                if (prev != null) {
                    if (prev.task != r.task) {
                        prev = null;
                    } else if (prev.nowVisible) {
                        prev = null;
                    }
                }
                this.mWindowManager.setAppStartingWindow(r.appToken, r.packageName, r.theme, this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo), r.nonLocalizedLabel, r.labelRes, r.icon, r.logo, r.windowFlags, prev != null ? prev.appToken : null, showStartingIcon);
                r.mStartingWindowShown = true;
            }
        } else {
            this.mWindowManager.addAppToken(task.mActivities.indexOf(r), r.appToken, r.task.taskId, this.mStackId, r.info.screenOrientation, r.fullscreen, (r.info.flags & 0x400) != 0, r.userId, r.info.configChanges, task.voiceSession != null, r.mLaunchTaskBehind);
            ActivityOptions.abort(options);
            options = null;
        }
        if (doResume) {
            this.mStackSupervisor.resumeTopActivitiesLocked(this, r, options);
        }
    }

    final void validateAppTokensLocked() {
        this.mValidateAppTokens.clear();
        this.mValidateAppTokens.ensureCapacity(this.numActivities());
        int numTasks = this.mTaskHistory.size();
        for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ArrayList<ActivityRecord> activities = task.mActivities;
            if (activities.isEmpty()) continue;
            TaskGroup group = new TaskGroup();
            group.taskId = task.taskId;
            this.mValidateAppTokens.add(group);
            int numActivities = activities.size();
            for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                group.tokens.add(r.appToken);
            }
        }
        this.mWindowManager.validateAppTokens(this.mStackId, this.mValidateAppTokens);
    }

    final ActivityOptions resetTargetTaskIfNeededLocked(TaskRecord task, boolean forceReset) {
        ActivityOptions topOptions = null;
        int replyChainEnd = -1;
        boolean canMoveOptions = true;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = task.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            boolean clearWhenTaskReset;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean allowTaskReparenting = (flags & 0x40) != 0;
            boolean bl = clearWhenTaskReset = (target.intent.getFlags() & 0x80000) != 0;
            if (!finishOnTaskLaunch && !clearWhenTaskReset && target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!finishOnTaskLaunch && !clearWhenTaskReset && allowTaskReparenting && target.taskAffinity != null && !target.taskAffinity.equals(task.affinity)) {
                int start;
                TaskRecord targetTask;
                ActivityRecord bottom;
                ActivityRecord activityRecord = bottom = !this.mTaskHistory.isEmpty() && !this.mTaskHistory.get((int)0).mActivities.isEmpty() ? this.mTaskHistory.get((int)0).mActivities.get(0) : null;
                if (bottom != null && target.taskAffinity != null && target.taskAffinity.equals(bottom.task.affinity)) {
                    targetTask = bottom.task;
                } else {
                    targetTask = this.createTaskRecord(this.mStackSupervisor.getNextTaskId(), target.info, null, null, null, false);
                    targetTask.affinityIntent = target.intent;
                }
                int targetTaskId = targetTask.taskId;
                this.mWindowManager.setAppGroupId(target.appToken, targetTaskId);
                boolean noOptions = canMoveOptions;
                for (int srcPos = start = replyChainEnd < 0 ? i : replyChainEnd; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    p.setTask(targetTask, null);
                    targetTask.addActivityAtBottom(p);
                    this.mWindowManager.setAppGroupId(p.appToken, targetTaskId);
                }
                this.mWindowManager.moveTaskToBottom(targetTaskId);
                replyChainEnd = -1;
                continue;
            }
            if (forceReset || finishOnTaskLaunch || clearWhenTaskReset) {
                int end = clearWhenTaskReset ? numActivities - 1 : (replyChainEnd < 0 ? i : replyChainEnd);
                boolean noOptions = canMoveOptions;
                for (int srcPos = i; srcPos <= end; ++srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    canMoveOptions = false;
                    if (noOptions && topOptions == null && (topOptions = p.takeOptionsLocked()) != null) {
                        noOptions = false;
                    }
                    if (!this.finishActivityLocked(p, 0, null, "reset", false)) continue;
                    --end;
                    --srcPos;
                }
                replyChainEnd = -1;
                continue;
            }
            replyChainEnd = -1;
        }
        return topOptions;
    }

    private int resetAffinityTaskIfNeededLocked(TaskRecord affinityTask, TaskRecord task, boolean topTaskIsHigher, boolean forceReset, int taskInsertionPoint) {
        int replyChainEnd = -1;
        int taskId = task.taskId;
        String taskAffinity = task.affinity;
        ArrayList<ActivityRecord> activities = affinityTask.mActivities;
        int numActivities = activities.size();
        int rootActivityNdx = affinityTask.findEffectiveRootIndex();
        for (int i = numActivities - 1; i > rootActivityNdx; --i) {
            int start;
            boolean allowTaskReparenting;
            ActivityRecord target = activities.get(i);
            if (target.frontOfTask) break;
            int flags = target.info.flags;
            boolean finishOnTaskLaunch = (flags & 2) != 0;
            boolean bl = allowTaskReparenting = (flags & 0x40) != 0;
            if (target.resultTo != null) {
                if (replyChainEnd >= 0) continue;
                replyChainEnd = i;
                continue;
            }
            if (!topTaskIsHigher || !allowTaskReparenting || taskAffinity == null || !taskAffinity.equals(target.taskAffinity)) continue;
            if (forceReset || finishOnTaskLaunch) {
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    if (p.finishing) continue;
                    this.finishActivityLocked(p, 0, null, "reset", false);
                }
            } else {
                ArrayList<ActivityRecord> taskActivities;
                int targetNdx;
                if (taskInsertionPoint < 0) {
                    taskInsertionPoint = task.mActivities.size();
                }
                for (int srcPos = start = replyChainEnd >= 0 ? replyChainEnd : i; srcPos >= i; --srcPos) {
                    ActivityRecord p = activities.get(srcPos);
                    p.setTask(task, null);
                    task.addActivityAtIndex(taskInsertionPoint, p);
                    this.mWindowManager.setAppGroupId(p.appToken, taskId);
                }
                this.mWindowManager.moveTaskToTop(taskId);
                if (target.info.launchMode == 1 && (targetNdx = (taskActivities = task.mActivities).indexOf(target)) > 0) {
                    ActivityRecord p = taskActivities.get(targetNdx - 1);
                    if (p.intent.getComponent().equals(target.intent.getComponent())) {
                        this.finishActivityLocked(p, 0, null, "replace", false);
                    }
                }
            }
            replyChainEnd = -1;
        }
        return taskInsertionPoint;
    }

    final ActivityRecord resetTaskIfNeededLocked(ActivityRecord taskTop, ActivityRecord newActivity) {
        boolean forceReset = (newActivity.info.flags & 4) != 0;
        TaskRecord task = taskTop.task;
        boolean taskFound = false;
        ActivityOptions topOptions = null;
        int reparentInsertionPoint = -1;
        for (int i = this.mTaskHistory.size() - 1; i >= 0; --i) {
            TaskRecord targetTask = this.mTaskHistory.get(i);
            if (targetTask == task) {
                topOptions = this.resetTargetTaskIfNeededLocked(task, forceReset);
                taskFound = true;
                continue;
            }
            reparentInsertionPoint = this.resetAffinityTaskIfNeededLocked(targetTask, task, taskFound, forceReset, reparentInsertionPoint);
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        while ((taskTop = this.mTaskHistory.get(taskNdx--).getTopActivity()) == null && taskNdx >= 0) {
        }
        if (topOptions != null) {
            if (taskTop != null) {
                taskTop.updateOptionsLocked(topOptions);
            } else {
                topOptions.abort();
            }
        }
        return taskTop;
    }

    void sendActivityResultLocked(int callingUid, ActivityRecord r, String resultWho, int requestCode, int resultCode, Intent data) {
        if (callingUid > 0) {
            this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, data, r.getUriPermissionsLocked(), r.userId);
        }
        if (this.mResumedActivity == r && r.app != null && r.app.thread != null) {
            try {
                ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
                list.add(new ResultInfo(resultWho, requestCode, resultCode, data));
                r.app.thread.scheduleSendResult(r.appToken, list);
                return;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception thrown sending result to " + r, e);
            }
        }
        r.addResultLocked(null, resultWho, requestCode, resultCode, data);
    }

    private void adjustFocusedActivityLocked(ActivityRecord r) {
        if (this.mStackSupervisor.isFrontStack(this) && this.mService.mFocusedActivity == r) {
            ActivityRecord top;
            ActivityRecord next = this.topRunningActivityLocked(null);
            if (next != r) {
                TaskRecord task = r.task;
                if (r.frontOfTask && task == this.topTask() && task.isOverHomeStack()) {
                    this.mStackSupervisor.moveHomeStackTaskToTop(task.getTaskToReturnTo());
                }
            }
            if ((top = this.mStackSupervisor.topRunningActivityLocked()) != null) {
                this.mService.setFocusedActivityLocked(top);
            }
        }
    }

    final void stopActivityLocked(ActivityRecord r) {
        block6: {
            if (!((r.intent.getFlags() & 0x40000000) == 0 && (r.info.flags & 0x80) == 0 || r.finishing || this.mService.isSleeping())) {
                this.requestFinishActivityLocked(r.appToken, 0, null, "no-history", false);
            }
            if (r.app != null && r.app.thread != null) {
                this.adjustFocusedActivityLocked(r);
                r.resumeKeyDispatchingLocked();
                try {
                    r.stopped = false;
                    r.state = ActivityState.STOPPING;
                    if (!r.visible) {
                        this.mWindowManager.setAppVisibility(r.appToken, false);
                    }
                    r.app.thread.scheduleStopActivity(r.appToken, r.visible, r.configChangeFlags);
                    if (this.mService.isSleepingOrShuttingDown()) {
                        r.setSleeping(true);
                    }
                    Message msg = this.mHandler.obtainMessage(104, r);
                    this.mHandler.sendMessageDelayed(msg, 10000L);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Exception thrown during pause", e);
                    r.stopped = true;
                    r.state = ActivityState.STOPPED;
                    if (!r.configDestroy) break block6;
                    this.destroyActivityLocked(r, true, "stop-except");
                }
            }
        }
    }

    final boolean requestFinishActivityLocked(IBinder token, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        ActivityRecord r = this.isInStackLocked(token);
        if (r == null) {
            return false;
        }
        this.finishActivityLocked(r, resultCode, resultData, reason, oomAdj);
        return true;
    }

    final void finishSubActivityLocked(ActivityRecord self, String resultWho, int requestCode) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.resultTo != self || r.requestCode != requestCode || (r.resultWho != null || resultWho != null) && (r.resultWho == null || !r.resultWho.equals(resultWho))) continue;
                this.finishActivityLocked(r, 0, null, "request-sub", false);
            }
        }
        this.mService.updateOomAdjLocked();
    }

    final void finishTopRunningActivityLocked(ProcessRecord app) {
        ActivityRecord r = this.topRunningActivityLocked(null);
        if (r != null && r.app == app) {
            Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
            int taskNdx = this.mTaskHistory.indexOf(r.task);
            int activityNdx = r.task.mActivities.indexOf(r);
            this.finishActivityLocked(r, 0, null, "crashed", false);
            if (--activityNdx < 0) {
                while (--taskNdx >= 0 && (activityNdx = this.mTaskHistory.get((int)taskNdx).mActivities.size() - 1) < 0) {
                }
            }
            if (activityNdx >= 0) {
                r = this.mTaskHistory.get((int)taskNdx).mActivities.get(activityNdx);
                if (!(r.state != ActivityState.RESUMED && r.state != ActivityState.PAUSING && r.state != ActivityState.PAUSED || r.isHomeActivity() && this.mService.mHomeProcess == r.app)) {
                    Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                    this.finishActivityLocked(r, 0, null, "crashed", false);
                }
            }
        }
    }

    final void finishVoiceTask(IVoiceInteractionSession session) {
        IBinder sessionBinder = session.asBinder();
        boolean didOne = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord tr = this.mTaskHistory.get(taskNdx);
            if (tr.voiceSession == null || tr.voiceSession.asBinder() != sessionBinder) continue;
            for (int activityNdx = tr.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = tr.mActivities.get(activityNdx);
                if (r.finishing) continue;
                this.finishActivityLocked(r, 0, null, "finish-voice", false);
                didOne = true;
            }
        }
        if (didOne) {
            this.mService.updateOomAdjLocked();
        }
    }

    final boolean finishActivityAffinityLocked(ActivityRecord r) {
        ArrayList<ActivityRecord> activities = r.task.mActivities;
        for (int index = activities.indexOf(r); index >= 0; --index) {
            ActivityRecord cur = activities.get(index);
            if (!Objects.equals(cur.taskAffinity, r.taskAffinity)) break;
            this.finishActivityLocked(cur, 0, null, "request-affinity", true);
        }
        return true;
    }

    final void finishActivityResultsLocked(ActivityRecord r, int resultCode, Intent resultData) {
        ActivityRecord resultTo = r.resultTo;
        if (resultTo != null) {
            if (resultTo.userId != r.userId && resultData != null) {
                resultData.setContentUserHint(r.userId);
            }
            if (r.info.applicationInfo.uid > 0) {
                this.mService.grantUriPermissionFromIntentLocked(r.info.applicationInfo.uid, resultTo.packageName, resultData, resultTo.getUriPermissionsLocked(), resultTo.userId);
            }
            resultTo.addResultLocked(r, r.resultWho, r.requestCode, resultCode, resultData);
            r.resultTo = null;
        }
        r.results = null;
        r.pendingResults = null;
        r.newIntents = null;
        r.icicle = null;
    }

    final boolean finishActivityLocked(ActivityRecord r, int resultCode, Intent resultData, String reason, boolean oomAdj) {
        if (r.finishing) {
            Slog.w("ActivityManager", "Duplicate finish request for " + r);
            return false;
        }
        r.makeFinishing();
        TaskRecord task = r.task;
        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, reason);
        ArrayList<ActivityRecord> activities = task.mActivities;
        int index = activities.indexOf(r);
        if (index < activities.size() - 1) {
            task.setFrontOfTask();
            if ((r.intent.getFlags() & 0x80000) != 0) {
                ActivityRecord next = activities.get(index + 1);
                next.intent.addFlags(524288);
            }
        }
        r.pauseKeyDispatchingLocked();
        this.adjustFocusedActivityLocked(r);
        this.finishActivityResultsLocked(r, resultCode, resultData);
        if (this.mResumedActivity == r) {
            boolean endTask = index <= 0;
            this.mWindowManager.prepareAppTransition(endTask ? 9 : 7, false);
            this.mWindowManager.setAppVisibility(r.appToken, false);
            if (this.mPausingActivity == null) {
                this.startPausingLocked(false, false, false, false);
            }
            if (endTask) {
                this.mStackSupervisor.endLockTaskModeIfTaskEnding(task);
            }
        } else if (r.state != ActivityState.PAUSING) {
            return this.finishCurrentActivityLocked(r, 1, oomAdj) == null;
        }
        return false;
    }

    final ActivityRecord finishCurrentActivityLocked(ActivityRecord r, int mode, boolean oomAdj) {
        if (mode == 2 && r.nowVisible) {
            if (!this.mStackSupervisor.mStoppingActivities.contains(r)) {
                this.mStackSupervisor.mStoppingActivities.add(r);
                if (this.mStackSupervisor.mStoppingActivities.size() > 3 || r.frontOfTask && this.mTaskHistory.size() <= 1) {
                    this.mStackSupervisor.scheduleIdleLocked();
                } else {
                    this.mStackSupervisor.checkReadyForSleepLocked();
                }
            }
            r.state = ActivityState.STOPPING;
            if (oomAdj) {
                this.mService.updateOomAdjLocked();
            }
            return r;
        }
        this.mStackSupervisor.mStoppingActivities.remove(r);
        this.mStackSupervisor.mGoingToSleepActivities.remove(r);
        this.mStackSupervisor.mWaitingVisibleActivities.remove(r);
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        ActivityState prevState = r.state;
        r.state = ActivityState.FINISHING;
        if (mode == 0 || prevState == ActivityState.STOPPED || prevState == ActivityState.INITIALIZING) {
            r.makeFinishing();
            boolean activityRemoved = this.destroyActivityLocked(r, true, "finish-imm");
            if (activityRemoved) {
                this.mStackSupervisor.resumeTopActivitiesLocked();
            }
            return activityRemoved ? null : r;
        }
        this.mStackSupervisor.mFinishingActivities.add(r);
        r.resumeKeyDispatchingLocked();
        this.mStackSupervisor.getFocusedStack().resumeTopActivityLocked(null);
        return r;
    }

    void finishAllActivitiesLocked(boolean immediately) {
        boolean noActivitiesInStack = true;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                noActivitiesInStack = false;
                if (r.finishing && !immediately) continue;
                Slog.d("ActivityManager", "finishAllActivitiesLocked: finishing " + r + " immediately");
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
        if (noActivitiesInStack) {
            this.mActivityContainer.onTaskListEmptyLocked();
        }
    }

    final boolean shouldUpRecreateTaskLocked(ActivityRecord srec, String destAffinity) {
        if (srec == null || srec.task.affinity == null || !srec.task.affinity.equals(destAffinity)) {
            return true;
        }
        if (srec.frontOfTask && srec.task != null && srec.task.getBaseIntent() != null && srec.task.getBaseIntent().isDocument()) {
            if (srec.task.getTaskToReturnTo() != 0) {
                return true;
            }
            int taskIdx = this.mTaskHistory.indexOf(srec.task);
            if (taskIdx <= 0) {
                Slog.w("ActivityManager", "shouldUpRecreateTask: task not in history for " + srec);
                return false;
            }
            if (taskIdx == 0) {
                return true;
            }
            TaskRecord prevTask = this.mTaskHistory.get(taskIdx);
            if (!srec.task.affinity.equals(prevTask.affinity)) {
                return true;
            }
        }
        return false;
    }

    final boolean navigateUpToLocked(IBinder token, Intent destIntent, int resultCode, Intent resultData) {
        ActivityRecord next;
        IActivityController controller;
        ActivityRecord srec = ActivityRecord.forToken(token);
        TaskRecord task = srec.task;
        ArrayList<ActivityRecord> activities = task.mActivities;
        int start = activities.indexOf(srec);
        if (!this.mTaskHistory.contains(task) || start < 0) {
            return false;
        }
        int finishTo = start - 1;
        ActivityRecord parent = finishTo < 0 ? null : activities.get(finishTo);
        boolean foundParentInTask = false;
        ComponentName dest = destIntent.getComponent();
        if (start > 0 && dest != null) {
            for (int i = finishTo; i >= 0; --i) {
                ActivityRecord r = activities.get(i);
                if (!r.info.packageName.equals(dest.getPackageName()) || !r.info.name.equals(dest.getClassName())) continue;
                finishTo = i;
                parent = r;
                foundParentInTask = true;
                break;
            }
        }
        if ((controller = this.mService.mController) != null && (next = this.topRunningActivityLocked(srec.appToken, 0)) != null) {
            boolean resumeOK = true;
            try {
                resumeOK = controller.activityResuming(next.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
                Watchdog.getInstance().setActivityController(null);
            }
            if (!resumeOK) {
                return false;
            }
        }
        long origId = Binder.clearCallingIdentity();
        for (int i = start; i > finishTo; --i) {
            ActivityRecord r = activities.get(i);
            this.requestFinishActivityLocked(r.appToken, resultCode, resultData, "navigate-up", true);
            resultCode = 0;
            resultData = null;
        }
        if (parent != null && foundParentInTask) {
            int parentLaunchMode = parent.info.launchMode;
            int destIntentFlags = destIntent.getFlags();
            if (parentLaunchMode == 3 || parentLaunchMode == 2 || parentLaunchMode == 1 || (destIntentFlags & 0x4000000) != 0) {
                parent.deliverNewIntentLocked(srec.info.applicationInfo.uid, destIntent);
            } else {
                try {
                    ActivityInfo aInfo = AppGlobals.getPackageManager().getActivityInfo(destIntent.getComponent(), 0, srec.userId);
                    int res = this.mStackSupervisor.startActivityLocked(srec.app.thread, destIntent, null, aInfo, null, null, parent.appToken, null, 0, -1, parent.launchedFromUid, parent.launchedFromPackage, -1, parent.launchedFromUid, 0, null, true, null, null, null);
                    foundParentInTask = res == 0;
                }
                catch (RemoteException e) {
                    foundParentInTask = false;
                }
                this.requestFinishActivityLocked(parent.appToken, resultCode, resultData, "navigate-up", true);
            }
        }
        Binder.restoreCallingIdentity(origId);
        return foundParentInTask;
    }

    final void cleanUpActivityLocked(ActivityRecord r, boolean cleanServices, boolean setState) {
        if (this.mResumedActivity == r) {
            this.mResumedActivity = null;
        }
        if (this.mPausingActivity == r) {
            this.mPausingActivity = null;
        }
        this.mService.clearFocusedActivity(r);
        r.configDestroy = false;
        r.frozenBeforeDestroy = false;
        if (setState) {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        this.mStackSupervisor.mFinishingActivities.remove(r);
        this.mStackSupervisor.mWaitingVisibleActivities.remove(r);
        if (r.finishing && r.pendingResults != null) {
            for (WeakReference<PendingIntentRecord> apr : r.pendingResults) {
                PendingIntentRecord rec = (PendingIntentRecord)apr.get();
                if (rec == null) continue;
                this.mService.cancelIntentSenderLocked(rec, false);
            }
            r.pendingResults = null;
        }
        if (cleanServices) {
            this.cleanUpActivityServicesLocked(r);
        }
        this.removeTimeoutsForActivityLocked(r);
        if (this.getVisibleBehindActivity() == r) {
            this.mStackSupervisor.requestVisibleBehindLocked(r, false);
        }
    }

    private void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mStackSupervisor.removeTimeoutsForActivityLocked(r);
        this.mHandler.removeMessages(101, r);
        this.mHandler.removeMessages(104, r);
        this.mHandler.removeMessages(102, r);
        r.finishLaunchTickingLocked();
    }

    private void removeActivityFromHistoryLocked(ActivityRecord r) {
        this.mStackSupervisor.removeChildActivityContainers(r);
        this.finishActivityResultsLocked(r, 0, null);
        r.makeFinishing();
        r.takeFromHistory();
        this.removeTimeoutsForActivityLocked(r);
        r.state = ActivityState.DESTROYED;
        r.app = null;
        this.mWindowManager.removeAppToken(r.appToken);
        TaskRecord task = r.task;
        if (task != null && task.removeActivity(r)) {
            if (this.mStackSupervisor.isFrontStack(this) && task == this.topTask() && task.isOverHomeStack()) {
                this.mStackSupervisor.moveHomeStackTaskToTop(task.getTaskToReturnTo());
            }
            this.removeTask(task);
        }
        this.cleanUpActivityServicesLocked(r);
        r.removeUriPermissionsLocked();
    }

    final void cleanUpActivityServicesLocked(ActivityRecord r) {
        if (r.connections != null) {
            for (ConnectionRecord c : r.connections) {
                this.mService.mServices.removeConnectionLocked(c, null, r);
            }
            r.connections = null;
        }
    }

    final void scheduleDestroyActivities(ProcessRecord owner, String reason) {
        Message msg = this.mHandler.obtainMessage(105);
        msg.obj = new ScheduleDestroyArgs(owner, reason);
        this.mHandler.sendMessage(msg);
    }

    final void destroyActivitiesLocked(ProcessRecord owner, String reason) {
        boolean lastIsOpaque = false;
        boolean activityRemoved = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.finishing) continue;
                if (r.fullscreen) {
                    lastIsOpaque = true;
                }
                if (owner != null && r.app != owner || !lastIsOpaque || !r.isDestroyable() || !this.destroyActivityLocked(r, true, reason)) continue;
                activityRemoved = true;
            }
        }
        if (activityRemoved) {
            this.mStackSupervisor.resumeTopActivitiesLocked();
        }
    }

    final boolean safelyDestroyActivityLocked(ActivityRecord r, String reason) {
        if (r.isDestroyable()) {
            return this.destroyActivityLocked(r, true, reason);
        }
        return false;
    }

    final int releaseSomeActivitiesLocked(ProcessRecord app, ArraySet<TaskRecord> tasks, String reason) {
        int maxTasks = tasks.size() / 4;
        if (maxTasks < 1) {
            maxTasks = 1;
        }
        int numReleased = 0;
        for (int taskNdx = 0; taskNdx < this.mTaskHistory.size() && maxTasks > 0; ++taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!tasks.contains(task)) continue;
            int curNum = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int actNdx = 0; actNdx < activities.size(); ++actNdx) {
                ActivityRecord activity = activities.get(actNdx);
                if (activity.app != app || !activity.isDestroyable()) continue;
                this.destroyActivityLocked(activity, true, reason);
                if (activities.get(actNdx) != activity) {
                    --actNdx;
                }
                ++curNum;
            }
            if (curNum <= 0) continue;
            numReleased += curNum;
            --maxTasks;
            if (this.mTaskHistory.get(taskNdx) == task) continue;
            --taskNdx;
        }
        return numReleased;
    }

    final boolean destroyActivityLocked(ActivityRecord r, boolean removeFromApp, String reason) {
        boolean hadApp;
        EventLog.writeEvent(30018, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName, reason);
        boolean removedFromHistory = false;
        this.cleanUpActivityLocked(r, false, false);
        boolean bl = hadApp = r.app != null;
        if (hadApp) {
            boolean skipDestroy;
            block12: {
                if (removeFromApp) {
                    r.app.activities.remove(r);
                    if (this.mService.mHeavyWeightProcess == r.app && r.app.activities.size() <= 0) {
                        this.mService.mHeavyWeightProcess = null;
                        this.mService.mHandler.sendEmptyMessage(25);
                    }
                    if (r.app.activities.isEmpty()) {
                        this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
                        this.mService.updateLruProcessLocked(r.app, false, null);
                        this.mService.updateOomAdjLocked();
                    }
                }
                skipDestroy = false;
                try {
                    r.app.thread.scheduleDestroyActivity(r.appToken, r.finishing, r.configChangeFlags);
                }
                catch (Exception e) {
                    if (!r.finishing) break block12;
                    this.removeActivityFromHistoryLocked(r);
                    removedFromHistory = true;
                    skipDestroy = true;
                }
            }
            r.nowVisible = false;
            if (r.finishing && !skipDestroy) {
                r.state = ActivityState.DESTROYING;
                Message msg = this.mHandler.obtainMessage(102, r);
                this.mHandler.sendMessageDelayed(msg, 10000L);
            } else {
                r.state = ActivityState.DESTROYED;
                r.app = null;
            }
        } else if (r.finishing) {
            this.removeActivityFromHistoryLocked(r);
            removedFromHistory = true;
        } else {
            r.state = ActivityState.DESTROYED;
            r.app = null;
        }
        r.configChangeFlags = 0;
        if (!this.mLRUActivities.remove(r) && hadApp) {
            Slog.w("ActivityManager", "Activity " + r + " being finished, but not in LRU list");
        }
        return removedFromHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activityDestroyedLocked(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityRecord r = ActivityRecord.forToken(token);
            if (r != null) {
                this.mHandler.removeMessages(102, r);
            }
            if (this.isInStackLocked(token) != null && r.state == ActivityState.DESTROYING) {
                this.cleanUpActivityLocked(r, true, false);
                this.removeActivityFromHistoryLocked(r);
            }
            this.mStackSupervisor.resumeTopActivitiesLocked();
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void releaseBackgroundResources() {
        if (this.hasVisibleBehindActivity() && !this.mHandler.hasMessages(107)) {
            ActivityRecord r = this.getVisibleBehindActivity();
            if (r == this.topRunningActivityLocked(null)) {
                return;
            }
            if (r != null && r.app != null && r.app.thread != null) {
                try {
                    r.app.thread.scheduleCancelVisibleBehind(r.appToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mHandler.sendEmptyMessageDelayed(107, 500L);
            } else {
                Slog.e("ActivityManager", "releaseBackgroundResources: activity " + r + " no longer running");
                this.backgroundResourcesReleased(r.appToken);
            }
        }
    }

    final void backgroundResourcesReleased(IBinder token) {
        this.mHandler.removeMessages(107);
        ActivityRecord r = this.getVisibleBehindActivity();
        if (r != null) {
            this.mStackSupervisor.mStoppingActivities.add(r);
            this.setVisibleBehindActivity(null);
        }
        this.mStackSupervisor.resumeTopActivitiesLocked();
    }

    boolean hasVisibleBehindActivity() {
        return this.isAttached() && this.mActivityContainer.mActivityDisplay.hasVisibleBehindActivity();
    }

    void setVisibleBehindActivity(ActivityRecord r) {
        if (this.isAttached()) {
            this.mActivityContainer.mActivityDisplay.setVisibleBehindActivity(r);
        }
    }

    ActivityRecord getVisibleBehindActivity() {
        return this.isAttached() ? this.mActivityContainer.mActivityDisplay.mVisibleBehindActivity : null;
    }

    private void removeHistoryRecordsForAppLocked(ArrayList<ActivityRecord> list, ProcessRecord app, String listName) {
        int i = list.size();
        while (i > 0) {
            ActivityRecord r = list.get(--i);
            if (r.app != app) continue;
            list.remove(i);
            this.removeTimeoutsForActivityLocked(r);
        }
    }

    boolean removeHistoryRecordsForAppLocked(ProcessRecord app) {
        this.removeHistoryRecordsForAppLocked(this.mLRUActivities, app, "mLRUActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mStoppingActivities, app, "mStoppingActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mGoingToSleepActivities, app, "mGoingToSleepActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mWaitingVisibleActivities, app, "mWaitingVisibleActivities");
        this.removeHistoryRecordsForAppLocked(this.mStackSupervisor.mFinishingActivities, app, "mFinishingActivities");
        boolean hasVisibleActivities = false;
        int i = this.numActivities();
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                --i;
                if (r.app != app) continue;
                boolean remove = !r.haveState && !r.stateNotNeeded || r.finishing ? true : r.launchCount > 2 && r.lastLaunchTime > SystemClock.uptimeMillis() - 60000L;
                if (remove) {
                    if (!r.finishing) {
                        Slog.w("ActivityManager", "Force removing " + r + ": app died, no saved state");
                        EventLog.writeEvent(30001, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName, "proc died without state saved");
                        if (r.state == ActivityState.RESUMED) {
                            this.mService.updateUsageStats(r, false);
                        }
                    }
                    this.removeActivityFromHistoryLocked(r);
                } else {
                    if (r.visible) {
                        hasVisibleActivities = true;
                    }
                    r.app = null;
                    r.nowVisible = false;
                    if (!r.haveState) {
                        r.icicle = null;
                    }
                }
                this.cleanUpActivityLocked(r, true, true);
            }
        }
        return hasVisibleActivities;
    }

    final void updateTransitLocked(int transit, Bundle options) {
        if (options != null) {
            ActivityRecord r = this.topRunningActivityLocked(null);
            if (r != null && r.state != ActivityState.RESUMED) {
                r.updateOptionsLocked(options);
            } else {
                ActivityOptions.abort(options);
            }
        }
        this.mWindowManager.prepareAppTransition(transit, false);
    }

    void updateTaskMovement(TaskRecord task, boolean toFront) {
        if (task.isPersistable) {
            task.mLastTimeMoved = System.currentTimeMillis();
            if (!toFront) {
                task.mLastTimeMoved *= -1L;
            }
        }
    }

    void moveHomeStackTaskToTop(int homeStackTaskType) {
        int top;
        for (int taskNdx = top = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (task.taskType != homeStackTaskType) continue;
            this.mTaskHistory.remove(taskNdx);
            this.mTaskHistory.add(top, task);
            this.updateTaskMovement(task, true);
            this.mWindowManager.moveTaskToTop(task.taskId);
            return;
        }
    }

    final void moveTaskToFrontLocked(TaskRecord tr, ActivityRecord reason, Bundle options) {
        int numTasks = this.mTaskHistory.size();
        int index = this.mTaskHistory.indexOf(tr);
        if (numTasks == 0 || index < 0) {
            if (reason != null && (reason.intent.getFlags() & 0x10000) != 0) {
                ActivityOptions.abort(options);
            } else {
                this.updateTransitLocked(10, options);
            }
            return;
        }
        this.moveToFront();
        this.insertTaskAtTop(tr);
        if (reason != null && (reason.intent.getFlags() & 0x10000) != 0) {
            this.mWindowManager.prepareAppTransition(0, false);
            ActivityRecord r = this.topRunningActivityLocked(null);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
            ActivityOptions.abort(options);
        } else {
            this.updateTransitLocked(10, options);
        }
        this.mWindowManager.moveTaskToTop(tr.taskId);
        this.mStackSupervisor.resumeTopActivitiesLocked();
        EventLog.writeEvent(30002, tr.userId, tr.taskId);
    }

    final boolean moveTaskToBackLocked(int taskId, ActivityRecord reason) {
        TaskRecord task;
        TaskRecord task2;
        TaskRecord tr = this.taskForIdLocked(taskId);
        if (tr == null) {
            Slog.i("ActivityManager", "moveTaskToBack: bad taskId=" + taskId);
            return false;
        }
        Slog.i("ActivityManager", "moveTaskToBack: " + tr);
        this.mStackSupervisor.endLockTaskModeIfTaskEnding(tr);
        if (this.mStackSupervisor.isFrontStack(this) && this.mService.mController != null) {
            ActivityRecord next = this.topRunningActivityLocked(null, taskId);
            if (next == null) {
                next = this.topRunningActivityLocked(null, 0);
            }
            if (next != null) {
                boolean moveOK = true;
                try {
                    moveOK = this.mService.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!moveOK) {
                    return false;
                }
            }
        }
        this.mTaskHistory.remove(tr);
        this.mTaskHistory.add(0, tr);
        this.updateTaskMovement(tr, false);
        int numTasks = this.mTaskHistory.size();
        for (int taskNdx = numTasks - 1; taskNdx >= 1 && !(task2 = this.mTaskHistory.get(taskNdx)).isOverHomeStack(); --taskNdx) {
            if (taskNdx != 1) continue;
            task2.setTaskToReturnTo(1);
        }
        if (reason != null && (reason.intent.getFlags() & 0x10000) != 0) {
            this.mWindowManager.prepareAppTransition(0, false);
            ActivityRecord r = this.topRunningActivityLocked(null);
            if (r != null) {
                this.mNoAnimActivities.add(r);
            }
        } else {
            this.mWindowManager.prepareAppTransition(11, false);
        }
        this.mWindowManager.moveTaskToBottom(taskId);
        TaskRecord taskRecord = task = this.mResumedActivity != null ? this.mResumedActivity.task : null;
        if (task == tr && tr.isOverHomeStack() || numTasks <= 1 && this.isOnHomeDisplay()) {
            if (!this.mService.mBooting && !this.mService.mBooted) {
                return false;
            }
            int taskToReturnTo = tr.getTaskToReturnTo();
            tr.setTaskToReturnTo(0);
            return this.mStackSupervisor.resumeHomeStackTask(taskToReturnTo, null);
        }
        this.mStackSupervisor.resumeTopActivitiesLocked();
        return true;
    }

    static final void logStartActivity(int tag, ActivityRecord r, TaskRecord task) {
        Uri data = r.intent.getData();
        String strData = data != null ? data.toSafeString() : null;
        EventLog.writeEvent(tag, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName, r.intent.getAction(), r.intent.getType(), strData, r.intent.getFlags());
    }

    final boolean ensureActivityConfigurationLocked(ActivityRecord r, int globalChanges) {
        if (this.mConfigWillChange) {
            return true;
        }
        Configuration newConfig = this.mService.mConfiguration;
        if (r.configuration == newConfig && !r.forceNewConfig) {
            return true;
        }
        if (r.finishing) {
            r.stopFreezingScreenLocked(false);
            return true;
        }
        Configuration oldConfig = r.configuration;
        r.configuration = newConfig;
        int changes = oldConfig.diff(newConfig);
        if (changes == 0 && !r.forceNewConfig) {
            return true;
        }
        if (r.app == null || r.app.thread == null) {
            r.stopFreezingScreenLocked(false);
            r.forceNewConfig = false;
            return true;
        }
        if ((changes & ~r.info.getRealConfigChanged()) != 0 || r.forceNewConfig) {
            r.configChangeFlags |= changes;
            r.startFreezingScreenLocked(r.app, globalChanges);
            r.forceNewConfig = false;
            if (r.app == null || r.app.thread == null) {
                this.destroyActivityLocked(r, true, "config");
            } else {
                if (r.state == ActivityState.PAUSING) {
                    r.configDestroy = true;
                    return true;
                }
                if (r.state == ActivityState.RESUMED) {
                    this.relaunchActivityLocked(r, r.configChangeFlags, true);
                    r.configChangeFlags = 0;
                } else {
                    this.relaunchActivityLocked(r, r.configChangeFlags, false);
                    r.configChangeFlags = 0;
                }
            }
            return false;
        }
        if (r.app != null && r.app.thread != null) {
            try {
                r.app.thread.scheduleActivityConfigurationChanged(r.appToken);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        r.stopFreezingScreenLocked(false);
        return true;
    }

    private boolean relaunchActivityLocked(ActivityRecord r, int changes, boolean andResume) {
        ArrayList<ResultInfo> results = null;
        ArrayList<Intent> newIntents = null;
        if (andResume) {
            results = r.results;
            newIntents = r.newIntents;
        }
        EventLog.writeEvent(andResume ? 30019 : 30020, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName);
        r.startFreezingScreenLocked(r.app, 0);
        this.mStackSupervisor.removeChildActivityContainers(r);
        try {
            r.forceNewConfig = false;
            r.app.thread.scheduleRelaunchActivity(r.appToken, results, newIntents, changes, !andResume, new Configuration(this.mService.mConfiguration));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (andResume) {
            r.results = null;
            r.newIntents = null;
            r.state = ActivityState.RESUMED;
        } else {
            this.mHandler.removeMessages(101, r);
            r.state = ActivityState.PAUSED;
        }
        return true;
    }

    boolean willActivityBeVisibleLocked(IBinder token) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.appToken == token) {
                    return true;
                }
                if (!r.fullscreen || r.finishing) continue;
                return false;
            }
        }
        ActivityRecord r = ActivityRecord.forToken(token);
        if (r == null) {
            return false;
        }
        if (r.finishing) {
            Slog.e("ActivityManager", "willActivityBeVisibleLocked: Returning false, would have returned true for r=" + r);
        }
        return !r.finishing;
    }

    void closeSystemDialogsLocked() {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if ((r.info.flags & 0x100) == 0) continue;
                this.finishActivityLocked(r, 0, null, "close-sys", true);
            }
        }
    }

    boolean forceStopPackageLocked(String name, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        TaskRecord lastTask = null;
        ComponentName homeActivity = null;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            int numActivities = activities.size();
            for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
                boolean samePackage;
                ActivityRecord r = activities.get(activityNdx);
                boolean bl = samePackage = r.packageName.equals(name) || name == null && r.userId == userId;
                if (userId != -1 && r.userId != userId || !samePackage && r.task != lastTask || r.app != null && !evenPersistent && r.app.persistent) continue;
                if (!doit) {
                    if (r.finishing) continue;
                    return true;
                }
                if (r.isHomeActivity()) {
                    if (homeActivity != null && homeActivity.equals(r.realActivity)) {
                        Slog.i("ActivityManager", "Skip force-stop again " + r);
                        continue;
                    }
                    homeActivity = r.realActivity;
                }
                didSomething = true;
                Slog.i("ActivityManager", "  Force finishing activity " + r);
                if (samePackage) {
                    if (r.app != null) {
                        r.app.removed = true;
                    }
                    r.app = null;
                }
                lastTask = r.task;
                if (!this.finishActivityLocked(r, 0, null, "force-stop", true)) continue;
                --numActivities;
                --activityNdx;
            }
        }
        return didSomething;
    }

    void getTasksLocked(List<ActivityManager.RunningTaskInfo> list, int callingUid, boolean allowed) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            ActivityRecord r = null;
            ActivityRecord top = null;
            int numActivities = 0;
            int numRunning = 0;
            ArrayList<ActivityRecord> activities = task.mActivities;
            if (activities.isEmpty() || !allowed && !task.isHomeTask() && task.effectiveUid != callingUid) continue;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                r = activities.get(activityNdx);
                if (top == null || top.state == ActivityState.INITIALIZING) {
                    top = r;
                    numRunning = 0;
                    numActivities = 0;
                }
                ++numActivities;
                if (r.app == null || r.app.thread == null) continue;
                ++numRunning;
            }
            ActivityManager.RunningTaskInfo ci = new ActivityManager.RunningTaskInfo();
            ci.id = task.taskId;
            ci.baseActivity = r.intent.getComponent();
            ci.topActivity = top.intent.getComponent();
            ci.lastActiveTime = task.lastActiveTime;
            if (top.task != null) {
                ci.description = top.task.lastDescription;
            }
            ci.numActivities = numActivities;
            ci.numRunning = numRunning;
            list.add(ci);
        }
    }

    public void unhandledBackLocked() {
        ArrayList<ActivityRecord> activities;
        int activityTop;
        int top = this.mTaskHistory.size() - 1;
        if (top >= 0 && (activityTop = (activities = this.mTaskHistory.get((int)top).mActivities).size() - 1) > 0) {
            this.finishActivityLocked(activities.get(activityTop), 0, null, "unhandled-back", true);
        }
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        if (this.mPausingActivity != null && this.mPausingActivity.app == app) {
            this.mPausingActivity = null;
        }
        if (this.mLastPausedActivity != null && this.mLastPausedActivity.app == app) {
            this.mLastPausedActivity = null;
            this.mLastNoHistoryActivity = null;
        }
        return this.removeHistoryRecordsForAppLocked(app);
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (r.app != app) continue;
                Slog.w("ActivityManager", "  Force finishing activity " + r.intent.getComponent().flattenToShortString());
                r.app = null;
                this.finishCurrentActivityLocked(r, 0, false);
            }
        }
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage, boolean needSep, String header) {
        boolean printed = false;
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = this.mTaskHistory.get(taskNdx);
            if (!(printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mTaskHistory.get((int)taskNdx).mActivities, "    ", "Hist", true, !dumpAll, dumpClient, dumpPackage, needSep, header, "    Task id #" + task.taskId))) continue;
            header = null;
        }
        return printed;
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        ArrayList<ActivityRecord> activities;
        block4: {
            block5: {
                ArrayList<ActivityRecord> list;
                int listTop;
                block3: {
                    activities = new ArrayList<ActivityRecord>();
                    if (!"all".equals(name)) break block3;
                    for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                        activities.addAll(this.mTaskHistory.get((int)taskNdx).mActivities);
                    }
                    break block4;
                }
                if (!"top".equals(name)) break block5;
                int top = this.mTaskHistory.size() - 1;
                if (top < 0 || (listTop = (list = this.mTaskHistory.get((int)top).mActivities).size() - 1) < 0) break block4;
                activities.add(list.get(listTop));
                break block4;
            }
            ActivityManagerService.ItemMatcher matcher = new ActivityManagerService.ItemMatcher();
            matcher.build(name);
            for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
                for (ActivityRecord r1 : this.mTaskHistory.get((int)taskNdx).mActivities) {
                    if (!matcher.match(r1, r1.intent.getComponent())) continue;
                    activities.add(r1);
                }
            }
        }
        return activities;
    }

    ActivityRecord restartPackage(String packageName) {
        ActivityRecord starting = this.topRunningActivityLocked(null);
        for (int taskNdx = this.mTaskHistory.size() - 1; taskNdx >= 0; --taskNdx) {
            ArrayList<ActivityRecord> activities = this.mTaskHistory.get((int)taskNdx).mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord a = activities.get(activityNdx);
                if (!a.info.packageName.equals(packageName)) continue;
                a.forceNewConfig = true;
                if (starting == null || a != starting || !a.visible) continue;
                a.startFreezingScreenLocked(starting.app, 256);
            }
        }
        return starting;
    }

    void removeTask(TaskRecord task) {
        TaskRecord nextTask;
        this.mStackSupervisor.endLockTaskModeIfTaskEnding(task);
        this.mWindowManager.removeTask(task.taskId);
        ActivityRecord r = this.mResumedActivity;
        if (r != null && r.task == task) {
            this.mResumedActivity = null;
        }
        int taskNdx = this.mTaskHistory.indexOf(task);
        int topTaskNdx = this.mTaskHistory.size() - 1;
        if (task.isOverHomeStack() && taskNdx < topTaskNdx && !(nextTask = this.mTaskHistory.get(taskNdx + 1)).isOverHomeStack()) {
            nextTask.setTaskToReturnTo(1);
        }
        this.mTaskHistory.remove(task);
        this.updateTaskMovement(task, true);
        if (task.mActivities.isEmpty()) {
            boolean isVoiceSession;
            boolean bl = isVoiceSession = task.voiceSession != null;
            if (isVoiceSession) {
                try {
                    task.voiceSession.taskFinished(task.intent, task.taskId);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (task.autoRemoveFromRecents() || isVoiceSession) {
                this.mService.mRecentTasks.remove(task);
                task.removedFromRecents(this.mService.mTaskPersister);
            }
        }
        if (this.mTaskHistory.isEmpty()) {
            if (this.isOnHomeDisplay()) {
                this.mStackSupervisor.moveHomeStack(!this.isHomeStack());
            }
            if (this.mStacks != null) {
                this.mStacks.remove(this);
                this.mStacks.add(0, this);
            }
            this.mActivityContainer.onTaskListEmptyLocked();
        }
    }

    TaskRecord createTaskRecord(int taskId, ActivityInfo info, Intent intent, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean toTop) {
        TaskRecord task = new TaskRecord(this.mService, taskId, info, intent, voiceSession, voiceInteractor);
        this.addTask(task, toTop, false);
        return task;
    }

    ArrayList<TaskRecord> getAllTasks() {
        return new ArrayList<TaskRecord>(this.mTaskHistory);
    }

    void addTask(TaskRecord task, boolean toTop, boolean moving) {
        task.stack = this;
        if (toTop) {
            this.insertTaskAtTop(task);
        } else {
            this.mTaskHistory.add(0, task);
            this.updateTaskMovement(task, false);
        }
        if (!moving && task.voiceSession != null) {
            try {
                task.voiceSession.taskStarted(task.intent, task.taskId);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    public int getStackId() {
        return this.mStackId;
    }

    public String toString() {
        return "ActivityStack{" + Integer.toHexString(System.identityHashCode(this)) + " stackId=" + this.mStackId + ", " + this.mTaskHistory.size() + " tasks}";
    }

    final class ActivityStackHandler
    extends Handler {
        ActivityStackHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 101: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity pause timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.app != null) {
                            ActivityStack.this.mService.logAppTooSlow(r.app, r.pauseTime, "pausing " + r);
                        }
                        ActivityStack.this.activityPausedLocked(r.appToken, true);
                        break;
                    }
                }
                case 103: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.continueLaunchTickingLocked()) {
                            ActivityStack.this.mService.logAppTooSlow(r.app, r.launchTickTime, "launching " + r);
                        }
                        break;
                    }
                }
                case 102: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity destroy timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.activityDestroyedLocked(r != null ? r.appToken : null);
                        break;
                    }
                }
                case 104: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityManager", "Activity stop timeout for " + r);
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        if (r.isInHistory()) {
                            ActivityStack.this.activityStoppedLocked(r, null, null, null);
                        }
                        break;
                    }
                }
                case 105: {
                    ScheduleDestroyArgs args = (ScheduleDestroyArgs)msg.obj;
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.destroyActivitiesLocked(args.mOwner, args.mReason);
                        break;
                    }
                }
                case 106: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStack.this.notifyActivityDrawnLocked(null);
                        break;
                    }
                }
                case 107: {
                    ActivityManagerService activityManagerService = ActivityStack.this.mService;
                    synchronized (activityManagerService) {
                        ActivityRecord r = ActivityStack.this.getVisibleBehindActivity();
                        Slog.e("ActivityManager", "Timeout waiting for cancelVisibleBehind player=" + r);
                        if (r != null) {
                            ActivityStack.this.mService.killAppAtUsersRequest(r.app, null);
                        }
                        break;
                    }
                }
            }
        }
    }

    static class ScheduleDestroyArgs {
        final ProcessRecord mOwner;
        final String mReason;

        ScheduleDestroyArgs(ProcessRecord owner, String reason) {
            this.mOwner = owner;
            this.mReason = reason;
        }
    }

    static enum ActivityState {
        INITIALIZING,
        RESUMED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED,
        FINISHING,
        DESTROYING,
        DESTROYED;

    }
}

