/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ProcessRecord;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class BroadcastQueue {
    static final String TAG = "BroadcastQueue";
    static final String TAG_MU = "ActivityManagerServiceMU";
    static final boolean DEBUG_BROADCAST = false;
    static final boolean DEBUG_BROADCAST_LIGHT = false;
    static final boolean DEBUG_MU = false;
    static final int MAX_BROADCAST_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 10 : 50;
    static final int MAX_BROADCAST_SUMMARY_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 25 : 300;
    final ActivityManagerService mService;
    final String mQueueName;
    final long mTimeoutPeriod;
    final boolean mDelayBehindServices;
    final ArrayList<BroadcastRecord> mParallelBroadcasts = new ArrayList();
    final ArrayList<BroadcastRecord> mOrderedBroadcasts = new ArrayList();
    final BroadcastRecord[] mBroadcastHistory = new BroadcastRecord[MAX_BROADCAST_HISTORY];
    final Intent[] mBroadcastSummaryHistory = new Intent[MAX_BROADCAST_SUMMARY_HISTORY];
    boolean mBroadcastsScheduled = false;
    boolean mPendingBroadcastTimeoutMessage;
    BroadcastRecord mPendingBroadcast = null;
    int mPendingBroadcastRecvIndex;
    static final int BROADCAST_INTENT_MSG = 200;
    static final int BROADCAST_TIMEOUT_MSG = 201;
    final BroadcastHandler mHandler;

    BroadcastQueue(ActivityManagerService service, Handler handler, String name, long timeoutPeriod, boolean allowDelayBehindServices) {
        this.mService = service;
        this.mHandler = new BroadcastHandler(handler.getLooper());
        this.mQueueName = name;
        this.mTimeoutPeriod = timeoutPeriod;
        this.mDelayBehindServices = allowDelayBehindServices;
    }

    public boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mPendingBroadcast != null && this.mPendingBroadcast.curApp.pid == pid;
    }

    public void enqueueParallelBroadcastLocked(BroadcastRecord r) {
        this.mParallelBroadcasts.add(r);
    }

    public void enqueueOrderedBroadcastLocked(BroadcastRecord r) {
        this.mOrderedBroadcasts.add(r);
    }

    public final boolean replaceParallelBroadcastLocked(BroadcastRecord r) {
        for (int i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
            if (!r.intent.filterEquals(this.mParallelBroadcasts.get((int)i).intent)) continue;
            this.mParallelBroadcasts.set(i, r);
            return true;
        }
        return false;
    }

    public final boolean replaceOrderedBroadcastLocked(BroadcastRecord r) {
        for (int i = this.mOrderedBroadcasts.size() - 1; i > 0; --i) {
            if (!r.intent.filterEquals(this.mOrderedBroadcasts.get((int)i).intent)) continue;
            this.mOrderedBroadcasts.set(i, r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCurBroadcastLocked(BroadcastRecord r, ProcessRecord app) throws RemoteException {
        if (app.thread == null) {
            throw new RemoteException();
        }
        r.receiver = app.thread.asBinder();
        r.curApp = app;
        app.curReceiver = r;
        app.forceProcessStateUpTo(8);
        this.mService.updateLruProcessLocked(app, false, null);
        this.mService.updateOomAdjLocked();
        r.intent.setComponent(r.curComponent);
        boolean started = false;
        try {
            this.mService.ensurePackageDexOpt(r.intent.getComponent().getPackageName());
            app.thread.scheduleReceiver(new Intent(r.intent), r.curReceiver, this.mService.compatibilityInfoForPackageLocked(r.curReceiver.applicationInfo), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.userId, app.repProcState);
            started = true;
        }
        finally {
            if (!started) {
                r.receiver = null;
                r.curApp = null;
                app.curReceiver = null;
            }
        }
    }

    public boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid == app.pid) {
            try {
                this.mPendingBroadcast = null;
                this.processCurBroadcastLocked(br, app);
                didSomething = true;
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception in new application when starting receiver " + br.curComponent.flattenToShortString(), e);
                this.logBroadcastReceiverDiscardLocked(br);
                this.finishReceiverLocked(br, br.resultCode, br.resultData, br.resultExtras, br.resultAbort, false);
                this.scheduleBroadcastsLocked();
                br.state = 0;
                throw new RuntimeException(e.getMessage());
            }
        }
        return didSomething;
    }

    public void skipPendingBroadcastLocked(int pid) {
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid == pid) {
            br.state = 0;
            br.nextReceiver = this.mPendingBroadcastRecvIndex;
            this.mPendingBroadcast = null;
            this.scheduleBroadcastsLocked();
        }
    }

    public void skipCurrentReceiverLocked(ProcessRecord app) {
        boolean reschedule = false;
        BroadcastRecord r = app.curReceiver;
        if (r != null) {
            this.logBroadcastReceiverDiscardLocked(r);
            this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
            reschedule = true;
        }
        if ((r = this.mPendingBroadcast) != null && r.curApp == app) {
            this.logBroadcastReceiverDiscardLocked(r);
            this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
            reschedule = true;
        }
        if (reschedule) {
            this.scheduleBroadcastsLocked();
        }
    }

    public void scheduleBroadcastsLocked() {
        if (this.mBroadcastsScheduled) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(200, this));
        this.mBroadcastsScheduled = true;
    }

    public BroadcastRecord getMatchingOrderedReceiver(IBinder receiver) {
        BroadcastRecord r;
        if (this.mOrderedBroadcasts.size() > 0 && (r = this.mOrderedBroadcasts.get(0)) != null && r.receiver == receiver) {
            return r;
        }
        return null;
    }

    public boolean finishReceiverLocked(BroadcastRecord r, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, boolean waitForServices) {
        int state = r.state;
        ActivityInfo receiver = r.curReceiver;
        r.state = 0;
        if (state == 0) {
            Slog.w(TAG, "finishReceiver [" + this.mQueueName + "] called but state is IDLE");
        }
        r.receiver = null;
        r.intent.setComponent(null);
        if (r.curApp != null) {
            r.curApp.curReceiver = null;
        }
        if (r.curFilter != null) {
            r.curFilter.receiverList.curBroadcast = null;
        }
        r.curFilter = null;
        r.curReceiver = null;
        r.curApp = null;
        this.mPendingBroadcast = null;
        r.resultCode = resultCode;
        r.resultData = resultData;
        r.resultExtras = resultExtras;
        r.resultAbort = resultAbort && (r.intent.getFlags() & 0x8000000) == 0 ? resultAbort : false;
        if (waitForServices && r.curComponent != null && r.queue.mDelayBehindServices && r.queue.mOrderedBroadcasts.size() > 0 && r.queue.mOrderedBroadcasts.get(0) == r) {
            Object obj;
            ActivityInfo nextReceiver = r.nextReceiver < r.receivers.size() ? ((obj = r.receivers.get(r.nextReceiver)) instanceof ActivityInfo ? (ActivityInfo)obj : null) : null;
            if ((receiver == null || nextReceiver == null || receiver.applicationInfo.uid != nextReceiver.applicationInfo.uid || !receiver.processName.equals(nextReceiver.processName)) && this.mService.mServices.hasBackgroundServices(r.userId)) {
                Slog.i("ActivityManager", "Delay finish: " + r.curComponent.flattenToShortString());
                r.state = 4;
                return false;
            }
        }
        r.curComponent = null;
        return state == 1 || state == 3;
    }

    public void backgroundServicesFinishedLocked(int userId) {
        if (this.mOrderedBroadcasts.size() > 0) {
            BroadcastRecord br = this.mOrderedBroadcasts.get(0);
            if (br.userId == userId && br.state == 4) {
                Slog.i("ActivityManager", "Resuming delayed broadcast");
                br.curComponent = null;
                br.state = 0;
                this.processNextBroadcast(false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void performReceiveLocked(ProcessRecord app, IIntentReceiver receiver, Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
        if (app != null) {
            if (app.thread == null) throw new RemoteException("app.thread must not be null");
            app.thread.scheduleRegisteredReceiver(receiver, intent, resultCode, data, extras, ordered, sticky, sendingUser, app.repProcState);
            return;
        } else {
            receiver.performReceive(intent, resultCode, data, extras, ordered, sticky, sendingUser);
        }
    }

    private final void deliverToRegisteredReceiverLocked(BroadcastRecord r, BroadcastFilter filter, boolean ordered) {
        block11: {
            int mode;
            int perm;
            boolean skip = false;
            if (filter.requiredPermission != null && (perm = this.mService.checkComponentPermission(filter.requiredPermission, r.callingPid, r.callingUid, -1, true)) != 0) {
                Slog.w(TAG, "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + filter.requiredPermission + " due to registered receiver " + filter);
                skip = true;
            }
            if (!skip && r.requiredPermission != null && (perm = this.mService.checkComponentPermission(r.requiredPermission, filter.receiverList.pid, filter.receiverList.uid, -1, true)) != 0) {
                Slog.w(TAG, "Permission Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " requires " + r.requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (r.appOp != -1 && (mode = this.mService.mAppOpsService.noteOperation(r.appOp, filter.receiverList.uid, filter.packageName)) != 0) {
                skip = true;
            }
            if (!skip) {
                boolean bl = skip = !this.mService.mIntentFirewall.checkBroadcast(r.intent, r.callingUid, r.callingPid, r.resolvedType, filter.receiverList.uid);
            }
            if (filter.receiverList.app == null || filter.receiverList.app.crashing) {
                Slog.w(TAG, "Skipping deliver [" + this.mQueueName + "] " + r + " to " + filter.receiverList + ": process crashing");
                skip = true;
            }
            if (!skip) {
                if (ordered) {
                    r.receiver = filter.receiverList.receiver.asBinder();
                    r.curFilter = filter;
                    filter.receiverList.curBroadcast = r;
                    r.state = 2;
                    if (filter.receiverList.app != null) {
                        r.curApp = filter.receiverList.app;
                        filter.receiverList.app.curReceiver = r;
                        this.mService.updateOomAdjLocked(r.curApp);
                    }
                }
                try {
                    BroadcastQueue.performReceiveLocked(filter.receiverList.app, filter.receiverList.receiver, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.initialSticky, r.userId);
                    if (ordered) {
                        r.state = 3;
                    }
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failure sending broadcast " + r.intent, e);
                    if (!ordered) break block11;
                    r.receiver = null;
                    r.curFilter = null;
                    filter.receiverList.curBroadcast = null;
                    if (filter.receiverList.app == null) break block11;
                    filter.receiverList.app.curReceiver = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processNextBroadcast(boolean fromMsg) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int mode;
            Object nextReceiver;
            BroadcastRecord r;
            this.mService.updateCpuStats();
            if (fromMsg) {
                this.mBroadcastsScheduled = false;
            }
            while (this.mParallelBroadcasts.size() > 0) {
                r = this.mParallelBroadcasts.remove(0);
                r.dispatchTime = SystemClock.uptimeMillis();
                r.dispatchClockTime = System.currentTimeMillis();
                int N = r.receivers.size();
                for (int i = 0; i < N; ++i) {
                    Object target = r.receivers.get(i);
                    this.deliverToRegisteredReceiverLocked(r, (BroadcastFilter)target, false);
                }
                this.addBroadcastToHistoryLocked(r);
            }
            if (this.mPendingBroadcast != null) {
                boolean isDead;
                SparseArray<ProcessRecord> i = this.mService.mPidsSelfLocked;
                synchronized (i) {
                    ProcessRecord proc = this.mService.mPidsSelfLocked.get(this.mPendingBroadcast.curApp.pid);
                    isDead = proc == null || proc.crashing;
                }
                if (!isDead) {
                    return;
                }
                Slog.w(TAG, "pending app  [" + this.mQueueName + "]" + this.mPendingBroadcast.curApp + " died before responding to broadcast");
                this.mPendingBroadcast.state = 0;
                this.mPendingBroadcast.nextReceiver = this.mPendingBroadcastRecvIndex;
                this.mPendingBroadcast = null;
            }
            boolean looped = false;
            do {
                int numReceivers;
                if (this.mOrderedBroadcasts.size() == 0) {
                    this.mService.scheduleAppGcsLocked();
                    if (looped) {
                        this.mService.updateOomAdjLocked();
                    }
                    return;
                }
                r = this.mOrderedBroadcasts.get(0);
                boolean forceReceive = false;
                int n = numReceivers = r.receivers != null ? r.receivers.size() : 0;
                if (this.mService.mProcessesReady && r.dispatchTime > 0L) {
                    long now = SystemClock.uptimeMillis();
                    if (numReceivers > 0 && now > r.dispatchTime + 2L * this.mTimeoutPeriod * (long)numReceivers) {
                        Slog.w(TAG, "Hung broadcast [" + this.mQueueName + "] discarded after timeout failure:" + " now=" + now + " dispatchTime=" + r.dispatchTime + " startTime=" + r.receiverTime + " intent=" + r.intent + " numReceivers=" + numReceivers + " nextReceiver=" + r.nextReceiver + " state=" + r.state);
                        this.broadcastTimeoutLocked(false);
                        forceReceive = true;
                        r.state = 0;
                    }
                }
                if (r.state != 0) {
                    return;
                }
                if (r.receivers != null && r.nextReceiver < numReceivers && !r.resultAbort && !forceReceive) continue;
                if (r.resultTo != null) {
                    try {
                        BroadcastQueue.performReceiveLocked(r.callerApp, r.resultTo, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, false, false, r.userId);
                        r.resultTo = null;
                    }
                    catch (RemoteException e) {
                        r.resultTo = null;
                        Slog.w(TAG, "Failure [" + this.mQueueName + "] sending broadcast result of " + r.intent, e);
                    }
                }
                this.cancelBroadcastTimeoutLocked();
                this.addBroadcastToHistoryLocked(r);
                this.mOrderedBroadcasts.remove(0);
                r = null;
                looped = true;
            } while (r == null);
            int recIdx = r.nextReceiver++;
            r.receiverTime = SystemClock.uptimeMillis();
            if (recIdx == 0) {
                r.dispatchTime = r.receiverTime;
                r.dispatchClockTime = System.currentTimeMillis();
            }
            if (!this.mPendingBroadcastTimeoutMessage) {
                long timeoutTime = r.receiverTime + this.mTimeoutPeriod;
                this.setBroadcastTimeoutLocked(timeoutTime);
            }
            if ((nextReceiver = r.receivers.get(recIdx)) instanceof BroadcastFilter) {
                BroadcastFilter filter = (BroadcastFilter)nextReceiver;
                this.deliverToRegisteredReceiverLocked(r, filter, r.ordered);
                if (r.receiver == null || !r.ordered) {
                    r.state = 0;
                    this.scheduleBroadcastsLocked();
                }
                return;
            }
            ResolveInfo info = (ResolveInfo)nextReceiver;
            ComponentName component = new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
            boolean skip = false;
            int perm = this.mService.checkComponentPermission(info.activityInfo.permission, r.callingPid, r.callingUid, info.activityInfo.applicationInfo.uid, info.activityInfo.exported);
            if (perm != 0) {
                if (!info.activityInfo.exported) {
                    Slog.w(TAG, "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " is not exported from uid " + info.activityInfo.applicationInfo.uid + " due to receiver " + component.flattenToShortString());
                } else {
                    Slog.w(TAG, "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + info.activityInfo.permission + " due to receiver " + component.flattenToShortString());
                }
                skip = true;
            }
            if (info.activityInfo.applicationInfo.uid != 1000 && r.requiredPermission != null) {
                try {
                    perm = AppGlobals.getPackageManager().checkPermission(r.requiredPermission, info.activityInfo.applicationInfo.packageName);
                }
                catch (RemoteException e) {
                    perm = -1;
                }
                if (perm != 0) {
                    Slog.w(TAG, "Permission Denial: receiving " + r.intent + " to " + component.flattenToShortString() + " requires " + r.requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                    skip = true;
                }
            }
            if (r.appOp != -1 && (mode = this.mService.mAppOpsService.noteOperation(r.appOp, info.activityInfo.applicationInfo.uid, info.activityInfo.packageName)) != 0) {
                skip = true;
            }
            if (!skip) {
                skip = !this.mService.mIntentFirewall.checkBroadcast(r.intent, r.callingUid, r.callingPid, r.resolvedType, info.activityInfo.applicationInfo.uid);
            }
            boolean isSingleton = false;
            try {
                isSingleton = this.mService.isSingleton(info.activityInfo.processName, info.activityInfo.applicationInfo, info.activityInfo.name, info.activityInfo.flags);
            }
            catch (SecurityException e) {
                Slog.w(TAG, e.getMessage());
                skip = true;
            }
            if ((info.activityInfo.flags & 0x40000000) != 0 && ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", info.activityInfo.applicationInfo.uid) != 0) {
                Slog.w(TAG, "Permission Denial: Receiver " + component.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS");
                skip = true;
            }
            if (r.curApp != null && r.curApp.crashing) {
                Slog.w(TAG, "Skipping deliver ordered [" + this.mQueueName + "] " + r + " to " + r.curApp + ": process crashing");
                skip = true;
            }
            if (!skip) {
                boolean isAvailable = false;
                try {
                    isAvailable = AppGlobals.getPackageManager().isPackageAvailable(info.activityInfo.packageName, UserHandle.getUserId(info.activityInfo.applicationInfo.uid));
                }
                catch (Exception e) {
                    Slog.w(TAG, "Exception getting recipient info for " + info.activityInfo.packageName, e);
                }
                if (!isAvailable) {
                    skip = true;
                }
            }
            if (skip) {
                r.receiver = null;
                r.curFilter = null;
                r.state = 0;
                this.scheduleBroadcastsLocked();
                return;
            }
            r.state = 1;
            String targetProcess = info.activityInfo.processName;
            r.curComponent = component;
            int receiverUid = info.activityInfo.applicationInfo.uid;
            if (r.callingUid != 1000 && isSingleton && this.mService.isValidSingletonCall(r.callingUid, receiverUid)) {
                info.activityInfo = this.mService.getActivityInfoForUser(info.activityInfo, 0);
            }
            r.curReceiver = info.activityInfo;
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(r.curComponent.getPackageName(), false, UserHandle.getUserId(r.callingUid));
            }
            catch (RemoteException e) {
            }
            catch (IllegalArgumentException e) {
                Slog.w(TAG, "Failed trying to unstop package " + r.curComponent.getPackageName() + ": " + e);
            }
            ProcessRecord app = this.mService.getProcessRecordLocked(targetProcess, info.activityInfo.applicationInfo.uid, false);
            if (app != null && app.thread != null) {
                try {
                    app.addPackage(info.activityInfo.packageName, info.activityInfo.applicationInfo.versionCode, this.mService.mProcessStats);
                    this.processCurBroadcastLocked(r, app);
                    return;
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Exception when sending broadcast to " + r.curComponent, e);
                }
                catch (RuntimeException e) {
                    Slog.wtf(TAG, "Failed sending broadcast to " + r.curComponent + " with " + r.intent, e);
                    this.logBroadcastReceiverDiscardLocked(r);
                    this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
                    this.scheduleBroadcastsLocked();
                    r.state = 0;
                    return;
                }
            }
            if ((r.curApp = this.mService.startProcessLocked(targetProcess, info.activityInfo.applicationInfo, true, r.intent.getFlags() | 4, "broadcast", r.curComponent, (r.intent.getFlags() & 0x2000000) != 0, false, false)) == null) {
                Slog.w(TAG, "Unable to launch app " + info.activityInfo.applicationInfo.packageName + "/" + info.activityInfo.applicationInfo.uid + " for broadcast " + r.intent + ": process is bad");
                this.logBroadcastReceiverDiscardLocked(r);
                this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
                this.scheduleBroadcastsLocked();
                r.state = 0;
                return;
            }
            this.mPendingBroadcast = r;
            this.mPendingBroadcastRecvIndex = recIdx;
        }
    }

    final void setBroadcastTimeoutLocked(long timeoutTime) {
        if (!this.mPendingBroadcastTimeoutMessage) {
            Message msg = this.mHandler.obtainMessage(201, this);
            this.mHandler.sendMessageAtTime(msg, timeoutTime);
            this.mPendingBroadcastTimeoutMessage = true;
        }
    }

    final void cancelBroadcastTimeoutLocked() {
        if (this.mPendingBroadcastTimeoutMessage) {
            this.mHandler.removeMessages(201, this);
            this.mPendingBroadcastTimeoutMessage = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void broadcastTimeoutLocked(boolean fromMsg) {
        if (fromMsg) {
            this.mPendingBroadcastTimeoutMessage = false;
        }
        if (this.mOrderedBroadcasts.size() == 0) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        BroadcastRecord r = this.mOrderedBroadcasts.get(0);
        if (fromMsg) {
            if (this.mService.mDidDexOpt) {
                this.mService.mDidDexOpt = false;
                long timeoutTime = SystemClock.uptimeMillis() + this.mTimeoutPeriod;
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
            if (!this.mService.mProcessesReady) {
                return;
            }
            long timeoutTime = r.receiverTime + this.mTimeoutPeriod;
            if (timeoutTime > now) {
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
        }
        BroadcastRecord br = this.mOrderedBroadcasts.get(0);
        if (br.state == 4) {
            Slog.i("ActivityManager", "Waited long enough for: " + (br.curComponent != null ? br.curComponent.flattenToShortString() : "(null)"));
            br.curComponent = null;
            br.state = 0;
            this.processNextBroadcast(false);
            return;
        }
        Slog.w(TAG, "Timeout of broadcast " + r + " - receiver=" + r.receiver + ", started " + (now - r.receiverTime) + "ms ago");
        r.receiverTime = now;
        ++r.anrCount;
        if (r.nextReceiver <= 0) {
            Slog.w(TAG, "Timeout on receiver with nextReceiver <= 0");
            return;
        }
        ProcessRecord app = null;
        String anrMessage = null;
        Object curReceiver = r.receivers.get(r.nextReceiver - 1);
        Slog.w(TAG, "Receiver during timeout: " + curReceiver);
        this.logBroadcastReceiverDiscardLocked(r);
        if (curReceiver instanceof BroadcastFilter) {
            BroadcastFilter bf = (BroadcastFilter)curReceiver;
            if (bf.receiverList.pid != 0 && bf.receiverList.pid != ActivityManagerService.MY_PID) {
                SparseArray<ProcessRecord> sparseArray = this.mService.mPidsSelfLocked;
                synchronized (sparseArray) {
                    app = this.mService.mPidsSelfLocked.get(bf.receiverList.pid);
                }
            }
        } else {
            app = r.curApp;
        }
        if (app != null) {
            anrMessage = "Broadcast of " + r.intent.toString();
        }
        if (this.mPendingBroadcast == r) {
            this.mPendingBroadcast = null;
        }
        this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
        this.scheduleBroadcastsLocked();
        if (anrMessage != null) {
            this.mHandler.post(new AppNotResponding(app, anrMessage));
        }
    }

    private final void addBroadcastToHistoryLocked(BroadcastRecord r) {
        if (r.callingUid < 0) {
            return;
        }
        System.arraycopy(this.mBroadcastHistory, 0, this.mBroadcastHistory, 1, MAX_BROADCAST_HISTORY - 1);
        r.finishTime = SystemClock.uptimeMillis();
        this.mBroadcastHistory[0] = r;
        System.arraycopy(this.mBroadcastSummaryHistory, 0, this.mBroadcastSummaryHistory, 1, MAX_BROADCAST_SUMMARY_HISTORY - 1);
        this.mBroadcastSummaryHistory[0] = r.intent;
    }

    final void logBroadcastReceiverDiscardLocked(BroadcastRecord r) {
        if (r.nextReceiver > 0) {
            Object curReceiver = r.receivers.get(r.nextReceiver - 1);
            if (curReceiver instanceof BroadcastFilter) {
                BroadcastFilter bf = (BroadcastFilter)curReceiver;
                EventLog.writeEvent(30024, bf.owningUserId, System.identityHashCode(r), r.intent.getAction(), r.nextReceiver - 1, System.identityHashCode(bf));
            } else {
                ResolveInfo ri = (ResolveInfo)curReceiver;
                EventLog.writeEvent(30025, UserHandle.getUserId(ri.activityInfo.applicationInfo.uid), System.identityHashCode(r), r.intent.getAction(), r.nextReceiver - 1, ri.toString());
            }
        } else {
            Slog.w(TAG, "Discarding broadcast before first receiver is invoked: " + r);
            EventLog.writeEvent(30025, -1, System.identityHashCode(r), r.intent.getAction(), r.nextReceiver, "NONE");
        }
    }

    final boolean dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage, boolean needSep) {
        Bundle bundle;
        BroadcastRecord r;
        int i;
        if (this.mParallelBroadcasts.size() > 0 || this.mOrderedBroadcasts.size() > 0 || this.mPendingBroadcast != null) {
            BroadcastRecord br;
            int i2;
            boolean printed = false;
            for (i2 = this.mParallelBroadcasts.size() - 1; i2 >= 0; --i2) {
                br = this.mParallelBroadcasts.get(i2);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Broadcast " + this.mQueueName + " #" + i2 + ":");
                br.dump(pw, "    ");
            }
            printed = false;
            needSep = true;
            for (i2 = this.mOrderedBroadcasts.size() - 1; i2 >= 0; --i2) {
                br = this.mOrderedBroadcasts.get(i2);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active ordered broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Ordered Broadcast " + this.mQueueName + " #" + i2 + ":");
                this.mOrderedBroadcasts.get(i2).dump(pw, "    ");
            }
            if (dumpPackage == null || this.mPendingBroadcast != null && dumpPackage.equals(this.mPendingBroadcast.callerPackage)) {
                if (needSep) {
                    pw.println();
                }
                pw.println("  Pending broadcast [" + this.mQueueName + "]:");
                if (this.mPendingBroadcast != null) {
                    this.mPendingBroadcast.dump(pw, "    ");
                } else {
                    pw.println("    (null)");
                }
                needSep = true;
            }
        }
        boolean printed = false;
        for (i = 0; i < MAX_BROADCAST_HISTORY && (r = this.mBroadcastHistory[i]) != null; ++i) {
            if (dumpPackage != null && !dumpPackage.equals(r.callerPackage)) continue;
            if (!printed) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                pw.println("  Historical broadcasts [" + this.mQueueName + "]:");
                printed = true;
            }
            if (dumpAll) {
                pw.print("  Historical Broadcast " + this.mQueueName + " #");
                pw.print(i);
                pw.println(":");
                r.dump(pw, "    ");
                continue;
            }
            pw.print("  #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            pw.print("    ");
            pw.println(r.intent.toShortString(false, true, true, false));
            if (r.targetComp != null && r.targetComp != r.intent.getComponent()) {
                pw.print("    targetComp: ");
                pw.println(r.targetComp.toShortString());
            }
            if ((bundle = r.intent.getExtras()) == null) continue;
            pw.print("    extras: ");
            pw.println(bundle.toString());
        }
        if (dumpPackage == null) {
            Intent intent;
            if (dumpAll) {
                i = 0;
                printed = false;
            }
            while (i < MAX_BROADCAST_SUMMARY_HISTORY && (intent = this.mBroadcastSummaryHistory[i]) != null) {
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Historical broadcasts summary [" + this.mQueueName + "]:");
                    printed = true;
                }
                if (!dumpAll && i >= 50) {
                    pw.println("  ...");
                    break;
                }
                pw.print("  #");
                pw.print(i);
                pw.print(": ");
                pw.println(intent.toShortString(false, true, true, false));
                bundle = intent.getExtras();
                if (bundle != null) {
                    pw.print("    extras: ");
                    pw.println(bundle.toString());
                }
                ++i;
            }
        }
        return needSep;
    }

    private final class AppNotResponding
    implements Runnable {
        private final ProcessRecord mApp;
        private final String mAnnotation;

        public AppNotResponding(ProcessRecord app, String annotation) {
            this.mApp = app;
            this.mAnnotation = annotation;
        }

        @Override
        public void run() {
            BroadcastQueue.this.mService.appNotResponding(this.mApp, null, null, false, this.mAnnotation);
        }
    }

    private final class BroadcastHandler
    extends Handler {
        public BroadcastHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 200: {
                    BroadcastQueue.this.processNextBroadcast(true);
                    break;
                }
                case 201: {
                    ActivityManagerService activityManagerService = BroadcastQueue.this.mService;
                    synchronized (activityManagerService) {
                        BroadcastQueue.this.broadcastTimeoutLocked(true);
                        break;
                    }
                }
            }
        }
    }
}

