/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.IConnectivityManager;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.net.BaseNetworkObserver;
import java.net.Inet4Address;

public class Nat464Xlat
extends BaseNetworkObserver {
    private Context mContext;
    private INetworkManagementService mNMService;
    private IConnectivityManager mConnService;
    private boolean mIsStarted;
    private boolean mIsRunning;
    private LinkProperties mLP;
    private LinkProperties mBaseLP;
    private Handler mHandler;
    private Messenger mNetworkMessenger;
    private static final String CLAT_INTERFACE_NAME = "clat4";
    private static final String TAG = "Nat464Xlat";

    public Nat464Xlat(Context context, INetworkManagementService nmService, IConnectivityManager connService, Handler handler) {
        this.mContext = context;
        this.mNMService = nmService;
        this.mConnService = connService;
        this.mHandler = handler;
        this.mIsStarted = false;
        this.mIsRunning = false;
        this.mLP = new LinkProperties();
        try {
            if (this.mNMService.isClatdStarted()) {
                this.mNMService.stopClatd();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public static boolean requiresClat(NetworkAgentInfo nai) {
        int netType = nai.networkInfo.getType();
        boolean connected = nai.networkInfo.isConnected();
        boolean hasIPv4Address = nai.linkProperties != null ? nai.linkProperties.hasIPv4Address() : false;
        Slog.d(TAG, "requiresClat: netType=" + netType + ", connected=" + connected + ", hasIPv4Address=" + hasIPv4Address);
        return netType == 0 && connected && !hasIPv4Address;
    }

    public boolean isRunningClat(NetworkAgentInfo network) {
        return this.mNetworkMessenger == network.messenger;
    }

    public void startClat(NetworkAgentInfo network) {
        if (this.mNetworkMessenger != null && this.mNetworkMessenger != network.messenger) {
            Slog.e(TAG, "startClat: too many networks requesting clat");
            return;
        }
        this.mNetworkMessenger = network.messenger;
        LinkProperties lp = network.linkProperties;
        this.mBaseLP = new LinkProperties(lp);
        if (this.mIsStarted) {
            Slog.e(TAG, "startClat: already started");
            return;
        }
        String iface = lp.getInterfaceName();
        Slog.i(TAG, "Starting clatd on " + iface + ", lp=" + lp);
        try {
            this.mNMService.startClatd(iface);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error starting clat daemon: " + e);
        }
        this.mIsStarted = true;
    }

    public void stopClat() {
        if (this.mIsStarted) {
            Slog.i(TAG, "Stopping clatd");
            try {
                this.mNMService.stopClatd();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error stopping clat daemon: " + e);
            }
            this.mIsStarted = false;
            this.mIsRunning = false;
            this.mNetworkMessenger = null;
            this.mBaseLP = null;
            this.mLP.clear();
        } else {
            Slog.e(TAG, "stopClat: already stopped");
        }
    }

    private void updateConnectivityService() {
        Message msg = this.mHandler.obtainMessage(528387, this.mBaseLP);
        msg.replyTo = this.mNetworkMessenger;
        Slog.i(TAG, "sending message to ConnectivityService: " + msg);
        msg.sendToTarget();
    }

    public void fixupLinkProperties(NetworkAgentInfo nai, LinkProperties oldLp) {
        if (this.isRunningClat(nai) && nai.linkProperties != null && !nai.linkProperties.getAllInterfaceNames().contains(CLAT_INTERFACE_NAME)) {
            Slog.d(TAG, "clatd running, updating NAI for " + nai.linkProperties.getInterfaceName());
            for (LinkProperties stacked : oldLp.getStackedLinks()) {
                if (!CLAT_INTERFACE_NAME.equals(stacked.getInterfaceName())) continue;
                nai.linkProperties.addStackedLink(stacked);
                break;
            }
        }
    }

    @Override
    public void interfaceAdded(String iface) {
        if (iface.equals(CLAT_INTERFACE_NAME)) {
            Slog.i(TAG, "interface clat4 added, mIsRunning = " + this.mIsRunning + " -> true");
            this.mIsRunning = true;
            try {
                InterfaceConfiguration config = this.mNMService.getInterfaceConfig(iface);
                LinkAddress clatAddress = config.getLinkAddress();
                this.mLP.clear();
                this.mLP.setInterfaceName(iface);
                RouteInfo ipv4Default = new RouteInfo(new LinkAddress(Inet4Address.ANY, 0), clatAddress.getAddress(), iface);
                this.mLP.addRoute(ipv4Default);
                this.mLP.addLinkAddress(clatAddress);
                this.mBaseLP.addStackedLink(this.mLP);
                Slog.i(TAG, "Adding stacked link. tracker LP: " + this.mBaseLP);
                this.updateConnectivityService();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error getting link properties: " + e);
            }
        }
    }

    @Override
    public void interfaceRemoved(String iface) {
        if (iface == CLAT_INTERFACE_NAME) {
            if (this.mIsRunning) {
                NetworkUtils.resetConnections(CLAT_INTERFACE_NAME, 1);
                this.mBaseLP.removeStackedLink(this.mLP);
                this.updateConnectivityService();
            }
            Slog.i(TAG, "interface clat4 removed, mIsRunning = " + this.mIsRunning + " -> false");
            this.mIsRunning = false;
            this.mLP.clear();
            Slog.i(TAG, "mLP = " + this.mLP);
        }
    }
}

