/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.os.RemoteException;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DeviceOwner {
    private static final String TAG = "DevicePolicyManagerService";
    private static final String DEVICE_OWNER_XML = "device_owner.xml";
    private static final String TAG_DEVICE_OWNER = "device-owner";
    private static final String TAG_PROFILE_OWNER = "profile-owner";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PACKAGE = "package";
    private static final String ATTR_COMPONENT_NAME = "component";
    private static final String ATTR_USERID = "userId";
    private AtomicFile fileForWriting;
    private InputStream mInputStreamForTest;
    private OutputStream mOutputStreamForTest;
    private OwnerInfo mDeviceOwner;
    private final HashMap<Integer, OwnerInfo> mProfileOwners = new HashMap();

    private DeviceOwner() {
    }

    DeviceOwner(InputStream in, OutputStream out) {
        this.mInputStreamForTest = in;
        this.mOutputStreamForTest = out;
    }

    static DeviceOwner load() {
        DeviceOwner owner = new DeviceOwner();
        if (new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML).exists()) {
            owner.readOwnerFile();
            return owner;
        }
        return null;
    }

    static DeviceOwner createWithDeviceOwner(String packageName, String ownerName) {
        DeviceOwner owner = new DeviceOwner();
        owner.mDeviceOwner = new OwnerInfo(ownerName, packageName);
        return owner;
    }

    static DeviceOwner createWithProfileOwner(String packageName, String ownerName, int userId) {
        DeviceOwner owner = new DeviceOwner();
        owner.mProfileOwners.put(userId, new OwnerInfo(ownerName, packageName));
        return owner;
    }

    static DeviceOwner createWithProfileOwner(ComponentName admin, String ownerName, int userId) {
        DeviceOwner owner = new DeviceOwner();
        owner.mProfileOwners.put(userId, new OwnerInfo(ownerName, admin));
        return owner;
    }

    String getDeviceOwnerPackageName() {
        return this.mDeviceOwner != null ? this.mDeviceOwner.packageName : null;
    }

    String getDeviceOwnerName() {
        return this.mDeviceOwner != null ? this.mDeviceOwner.name : null;
    }

    void setDeviceOwner(String packageName, String ownerName) {
        this.mDeviceOwner = new OwnerInfo(ownerName, packageName);
    }

    void clearDeviceOwner() {
        this.mDeviceOwner = null;
    }

    void setProfileOwner(String packageName, String ownerName, int userId) {
        this.mProfileOwners.put(userId, new OwnerInfo(ownerName, packageName));
    }

    void setProfileOwner(ComponentName admin, String ownerName, int userId) {
        this.mProfileOwners.put(userId, new OwnerInfo(ownerName, admin));
    }

    void removeProfileOwner(int userId) {
        this.mProfileOwners.remove(userId);
    }

    String getProfileOwnerPackageName(int userId) {
        OwnerInfo profileOwner = this.mProfileOwners.get(userId);
        return profileOwner != null ? profileOwner.packageName : null;
    }

    ComponentName getProfileOwnerComponent(int userId) {
        OwnerInfo profileOwner = this.mProfileOwners.get(userId);
        return profileOwner != null ? profileOwner.admin : null;
    }

    String getProfileOwnerName(int userId) {
        OwnerInfo profileOwner = this.mProfileOwners.get(userId);
        return profileOwner != null ? profileOwner.name : null;
    }

    Set<Integer> getProfileOwnerKeys() {
        return this.mProfileOwners.keySet();
    }

    boolean hasDeviceOwner() {
        return this.mDeviceOwner != null;
    }

    static boolean isInstalled(String packageName, PackageManager pm) {
        try {
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            if (pi != null && pi.applicationInfo.flags != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            Slog.w(TAG, "Device Owner package " + packageName + " not installed.");
        }
        return false;
    }

    static boolean isInstalledForUser(String packageName, int userHandle) {
        try {
            PackageInfo pi = AppGlobals.getPackageManager().getPackageInfo(packageName, 0, userHandle);
            if (pi != null && pi.applicationInfo.flags != 0) {
                return true;
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Package manager has died", re);
        }
        return false;
    }

    void readOwnerFile() {
        try {
            int type;
            InputStream input = this.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(input, null);
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                String tag = parser.getName();
                if (tag.equals(TAG_DEVICE_OWNER)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    String packageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                    this.mDeviceOwner = new OwnerInfo(name, packageName);
                    continue;
                }
                if (tag.equals(TAG_PROFILE_OWNER)) {
                    String profileOwnerPackageName = parser.getAttributeValue(null, ATTR_PACKAGE);
                    String profileOwnerName = parser.getAttributeValue(null, ATTR_NAME);
                    String profileOwnerComponentStr = parser.getAttributeValue(null, ATTR_COMPONENT_NAME);
                    int userId = Integer.parseInt(parser.getAttributeValue(null, ATTR_USERID));
                    OwnerInfo profileOwnerInfo = null;
                    if (profileOwnerComponentStr != null) {
                        ComponentName admin = ComponentName.unflattenFromString(profileOwnerComponentStr);
                        if (admin != null) {
                            profileOwnerInfo = new OwnerInfo(profileOwnerName, admin);
                        } else {
                            Slog.e(TAG, "Error parsing device-owner file. Bad component name " + profileOwnerComponentStr);
                        }
                    }
                    if (profileOwnerInfo == null) {
                        profileOwnerInfo = new OwnerInfo(profileOwnerName, profileOwnerPackageName);
                    }
                    this.mProfileOwners.put(userId, profileOwnerInfo);
                    continue;
                }
                throw new XmlPullParserException("Unexpected tag in device owner file: " + tag);
            }
            input.close();
        }
        catch (XmlPullParserException xppe) {
            Slog.e(TAG, "Error parsing device-owner file\n" + xppe);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "IO Exception when reading device-owner file\n" + ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOwnerFile() {
        DeviceOwner deviceOwner = this;
        synchronized (deviceOwner) {
            this.writeOwnerFileLocked();
        }
    }

    private void writeOwnerFileLocked() {
        try {
            OutputStream outputStream = this.startWrite();
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(outputStream, "utf-8");
            out.startDocument(null, true);
            if (this.mDeviceOwner != null) {
                out.startTag(null, TAG_DEVICE_OWNER);
                out.attribute(null, ATTR_PACKAGE, this.mDeviceOwner.packageName);
                if (this.mDeviceOwner.name != null) {
                    out.attribute(null, ATTR_NAME, this.mDeviceOwner.name);
                }
                out.endTag(null, TAG_DEVICE_OWNER);
            }
            if (this.mProfileOwners.size() > 0) {
                for (Map.Entry<Integer, OwnerInfo> owner : this.mProfileOwners.entrySet()) {
                    out.startTag(null, TAG_PROFILE_OWNER);
                    OwnerInfo ownerInfo = owner.getValue();
                    out.attribute(null, ATTR_PACKAGE, ownerInfo.packageName);
                    out.attribute(null, ATTR_NAME, ownerInfo.name);
                    out.attribute(null, ATTR_USERID, Integer.toString(owner.getKey()));
                    if (ownerInfo.admin != null) {
                        out.attribute(null, ATTR_COMPONENT_NAME, ownerInfo.admin.flattenToString());
                    }
                    out.endTag(null, TAG_PROFILE_OWNER);
                }
            }
            out.endDocument();
            out.flush();
            this.finishWrite(outputStream);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "IO Exception when writing device-owner file\n" + ioe);
        }
    }

    private InputStream openRead() throws IOException {
        if (this.mInputStreamForTest != null) {
            return this.mInputStreamForTest;
        }
        return new AtomicFile(new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML)).openRead();
    }

    private OutputStream startWrite() throws IOException {
        if (this.mOutputStreamForTest != null) {
            return this.mOutputStreamForTest;
        }
        this.fileForWriting = new AtomicFile(new File(Environment.getSystemSecureDirectory(), DEVICE_OWNER_XML));
        return this.fileForWriting.startWrite();
    }

    private void finishWrite(OutputStream stream) {
        if (this.fileForWriting != null) {
            this.fileForWriting.finishWrite((FileOutputStream)stream);
        }
    }

    static class OwnerInfo {
        public String name;
        public String packageName;
        public ComponentName admin;

        public OwnerInfo(String name, String packageName) {
            this.name = name;
            this.packageName = packageName;
            this.admin = new ComponentName(packageName, "");
        }

        public OwnerInfo(String name, ComponentName admin) {
            this.name = name;
            this.admin = admin;
            this.packageName = admin.getPackageName();
        }
    }
}

