/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.MathUtils;
import android.util.Slog;
import android.util.Spline;
import android.util.TimeUtils;
import com.android.server.LocalServices;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.io.PrintWriter;
import java.util.Arrays;

class AutomaticBrightnessController {
    private static final String TAG = "AutomaticBrightnessController";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PRETEND_LIGHT_SENSOR_ABSENT = false;
    private static final boolean USE_SCREEN_AUTO_BRIGHTNESS_ADJUSTMENT = true;
    private static final float SCREEN_AUTO_BRIGHTNESS_ADJUSTMENT_MAX_GAMMA = 3.0f;
    private static final int LIGHT_SENSOR_RATE_MILLIS = 1000;
    private static final int AMBIENT_LIGHT_HORIZON = 10000;
    private static final long BRIGHTENING_LIGHT_DEBOUNCE = 4000L;
    private static final long DARKENING_LIGHT_DEBOUNCE = 8000L;
    private static final float BRIGHTENING_LIGHT_HYSTERESIS = 0.1f;
    private static final float DARKENING_LIGHT_HYSTERESIS = 0.2f;
    private static final int WEIGHTING_INTERCEPT = 10000;
    private static final long AMBIENT_LIGHT_PREDICTION_TIME_MILLIS = 100L;
    private static final boolean USE_TWILIGHT_ADJUSTMENT = PowerManager.useTwilightAdjustmentFeature();
    private static final float TWILIGHT_ADJUSTMENT_MAX_GAMMA = 1.5f;
    private static final long TWILIGHT_ADJUSTMENT_TIME = 0x6DDD00L;
    private static final int MSG_UPDATE_AMBIENT_LUX = 1;
    private final Callbacks mCallbacks;
    private final SensorManager mSensorManager;
    private final Sensor mLightSensor;
    private final TwilightManager mTwilight;
    private final Spline mScreenAutoBrightnessSpline;
    private final int mScreenBrightnessRangeMinimum;
    private final int mScreenBrightnessRangeMaximum;
    private int mLightSensorWarmUpTimeConfig;
    private boolean mLightSensorEnabled;
    private long mLightSensorEnableTime;
    private float mAmbientLux;
    private boolean mAmbientLuxValid;
    private float mBrighteningLuxThreshold;
    private float mDarkeningLuxThreshold;
    private float mLastObservedLux;
    private long mLastObservedLuxTime;
    private int mRecentLightSamples;
    private AmbientLightRingBuffer mAmbientLightRingBuffer;
    private AutomaticBrightnessHandler mHandler;
    private int mScreenAutoBrightness = -1;
    private float mScreenAutoBrightnessAdjustment = 0.0f;
    private float mLastScreenAutoBrightnessGamma = 1.0f;
    private final SensorEventListener mLightSensorListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (AutomaticBrightnessController.this.mLightSensorEnabled) {
                long time = SystemClock.uptimeMillis();
                float lux = event.values[0];
                AutomaticBrightnessController.this.handleLightSensorEvent(time, lux);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private final TwilightListener mTwilightListener = new TwilightListener(){

        @Override
        public void onTwilightStateChanged() {
            AutomaticBrightnessController.this.updateAutoBrightness(true);
        }
    };

    public AutomaticBrightnessController(Callbacks callbacks, Looper looper, SensorManager sensorManager, Spline autoBrightnessSpline, int lightSensorWarmUpTime, int brightnessMin, int brightnessMax) {
        this.mCallbacks = callbacks;
        this.mTwilight = LocalServices.getService(TwilightManager.class);
        this.mSensorManager = sensorManager;
        this.mScreenAutoBrightnessSpline = autoBrightnessSpline;
        this.mScreenBrightnessRangeMinimum = brightnessMin;
        this.mScreenBrightnessRangeMaximum = brightnessMax;
        this.mLightSensorWarmUpTimeConfig = lightSensorWarmUpTime;
        this.mHandler = new AutomaticBrightnessHandler(looper);
        this.mAmbientLightRingBuffer = new AmbientLightRingBuffer();
        this.mLightSensor = this.mSensorManager.getDefaultSensor(5);
        if (USE_TWILIGHT_ADJUSTMENT) {
            this.mTwilight.registerListener(this.mTwilightListener, this.mHandler);
        }
    }

    public int getAutomaticScreenBrightness() {
        return this.mScreenAutoBrightness;
    }

    public void configure(boolean enable, float adjustment) {
        boolean changed = this.setLightSensorEnabled(enable);
        if (changed |= this.setScreenAutoBrightnessAdjustment(adjustment)) {
            this.updateAutoBrightness(false);
        }
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Automatic Brightness Controller Configuration:");
        pw.println("  mScreenAutoBrightnessSpline=" + this.mScreenAutoBrightnessSpline);
        pw.println("  mScreenBrightnessRangeMinimum=" + this.mScreenBrightnessRangeMinimum);
        pw.println("  mScreenBrightnessRangeMaximum=" + this.mScreenBrightnessRangeMaximum);
        pw.println("  mLightSensorWarmUpTimeConfig=" + this.mLightSensorWarmUpTimeConfig);
        pw.println();
        pw.println("Automatic Brightness Controller State:");
        pw.println("  mLightSensor=" + this.mLightSensor);
        pw.println("  mTwilight.getCurrentState()=" + this.mTwilight.getCurrentState());
        pw.println("  mLightSensorEnabled=" + this.mLightSensorEnabled);
        pw.println("  mLightSensorEnableTime=" + TimeUtils.formatUptime(this.mLightSensorEnableTime));
        pw.println("  mAmbientLux=" + this.mAmbientLux);
        pw.println("  mBrighteningLuxThreshold=" + this.mBrighteningLuxThreshold);
        pw.println("  mDarkeningLuxThreshold=" + this.mDarkeningLuxThreshold);
        pw.println("  mLastObservedLux=" + this.mLastObservedLux);
        pw.println("  mLastObservedLuxTime=" + TimeUtils.formatUptime(this.mLastObservedLuxTime));
        pw.println("  mRecentLightSamples=" + this.mRecentLightSamples);
        pw.println("  mAmbientLightRingBuffer=" + this.mAmbientLightRingBuffer);
        pw.println("  mScreenAutoBrightness=" + this.mScreenAutoBrightness);
        pw.println("  mScreenAutoBrightnessAdjustment=" + this.mScreenAutoBrightnessAdjustment);
        pw.println("  mLastScreenAutoBrightnessGamma=" + this.mLastScreenAutoBrightnessGamma);
    }

    private boolean setLightSensorEnabled(boolean enable) {
        if (enable) {
            if (!this.mLightSensorEnabled) {
                this.mLightSensorEnabled = true;
                this.mLightSensorEnableTime = SystemClock.uptimeMillis();
                this.mSensorManager.registerListener(this.mLightSensorListener, this.mLightSensor, 1000000, this.mHandler);
                return true;
            }
        } else if (this.mLightSensorEnabled) {
            this.mLightSensorEnabled = false;
            this.mAmbientLuxValid = false;
            this.mRecentLightSamples = 0;
            this.mAmbientLightRingBuffer.clear();
            this.mHandler.removeMessages(1);
            this.mSensorManager.unregisterListener(this.mLightSensorListener);
        }
        return false;
    }

    private void handleLightSensorEvent(long time, float lux) {
        this.mHandler.removeMessages(1);
        this.applyLightSensorMeasurement(time, lux);
        this.updateAmbientLux(time);
    }

    private void applyLightSensorMeasurement(long time, float lux) {
        ++this.mRecentLightSamples;
        this.mAmbientLightRingBuffer.prune(time - 10000L);
        this.mAmbientLightRingBuffer.push(time, lux);
        this.mLastObservedLux = lux;
        this.mLastObservedLuxTime = time;
    }

    private boolean setScreenAutoBrightnessAdjustment(float adjustment) {
        if (adjustment != this.mScreenAutoBrightnessAdjustment) {
            this.mScreenAutoBrightnessAdjustment = adjustment;
            return true;
        }
        return false;
    }

    private void setAmbientLux(float lux) {
        this.mAmbientLux = lux;
        this.mBrighteningLuxThreshold = this.mAmbientLux * 1.1f;
        this.mDarkeningLuxThreshold = this.mAmbientLux * 0.8f;
    }

    private float calculateAmbientLux(long now) {
        int N = this.mAmbientLightRingBuffer.size();
        if (N == 0) {
            Slog.e(TAG, "calculateAmbientLux: No ambient light readings available");
            return -1.0f;
        }
        float sum = 0.0f;
        float totalWeight = 0.0f;
        long endTime = 100L;
        for (int i = N - 1; i >= 0; --i) {
            long startTime = this.mAmbientLightRingBuffer.getTime(i) - now;
            float weight = AutomaticBrightnessController.calculateWeight(startTime, endTime);
            float lux = this.mAmbientLightRingBuffer.getLux(i);
            totalWeight += weight;
            sum += this.mAmbientLightRingBuffer.getLux(i) * weight;
            endTime = startTime;
        }
        return sum / totalWeight;
    }

    private static float calculateWeight(long startDelta, long endDelta) {
        return AutomaticBrightnessController.weightIntegral(endDelta) - AutomaticBrightnessController.weightIntegral(startDelta);
    }

    private static float weightIntegral(long x) {
        return (float)x * ((float)x * 0.5f + 10000.0f);
    }

    private long nextAmbientLightBrighteningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) <= this.mBrighteningLuxThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + 4000L;
    }

    private long nextAmbientLightDarkeningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) >= this.mDarkeningLuxThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + 8000L;
    }

    private void updateAmbientLux() {
        long time = SystemClock.uptimeMillis();
        this.mAmbientLightRingBuffer.prune(time - 10000L);
        this.updateAmbientLux(time);
    }

    private void updateAmbientLux(long time) {
        long nextTransitionTime;
        if (!this.mAmbientLuxValid) {
            long timeWhenSensorWarmedUp = (long)this.mLightSensorWarmUpTimeConfig + this.mLightSensorEnableTime;
            if (time < timeWhenSensorWarmedUp) {
                this.mHandler.sendEmptyMessageAtTime(1, timeWhenSensorWarmedUp);
                return;
            }
            this.setAmbientLux(this.calculateAmbientLux(time));
            this.mAmbientLuxValid = true;
            this.updateAutoBrightness(true);
        }
        long nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
        long nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        float ambientLux = this.calculateAmbientLux(time);
        if (ambientLux >= this.mBrighteningLuxThreshold && nextBrightenTransition <= time || ambientLux <= this.mDarkeningLuxThreshold && nextDarkenTransition <= time) {
            this.setAmbientLux(ambientLux);
            this.updateAutoBrightness(true);
            nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
            nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        }
        nextTransitionTime = (nextTransitionTime = Math.min(nextDarkenTransition, nextBrightenTransition)) > time ? nextTransitionTime : time + 1000L;
        this.mHandler.sendEmptyMessageAtTime(1, nextTransitionTime);
    }

    private void updateAutoBrightness(boolean sendUpdate) {
        int newScreenAutoBrightness;
        TwilightState state;
        if (!this.mAmbientLuxValid) {
            return;
        }
        float value = this.mScreenAutoBrightnessSpline.interpolate(this.mAmbientLux);
        float gamma = 1.0f;
        if (this.mScreenAutoBrightnessAdjustment != 0.0f) {
            float adjGamma = MathUtils.pow(3.0f, Math.min(1.0f, Math.max(-1.0f, -this.mScreenAutoBrightnessAdjustment)));
            gamma *= adjGamma;
        }
        if (USE_TWILIGHT_ADJUSTMENT && (state = this.mTwilight.getCurrentState()) != null && state.isNight()) {
            long now = System.currentTimeMillis();
            float earlyGamma = AutomaticBrightnessController.getTwilightGamma(now, state.getYesterdaySunset(), state.getTodaySunrise());
            float lateGamma = AutomaticBrightnessController.getTwilightGamma(now, state.getTodaySunset(), state.getTomorrowSunrise());
            gamma *= earlyGamma * lateGamma;
        }
        if (gamma != 1.0f) {
            float in = value;
            value = MathUtils.pow(value, gamma);
        }
        if (this.mScreenAutoBrightness != (newScreenAutoBrightness = this.clampScreenBrightness(Math.round(value * 255.0f)))) {
            this.mScreenAutoBrightness = newScreenAutoBrightness;
            this.mLastScreenAutoBrightnessGamma = gamma;
            if (sendUpdate) {
                this.mCallbacks.updateBrightness();
            }
        }
    }

    private int clampScreenBrightness(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum);
    }

    private static float getTwilightGamma(long now, long lastSunset, long nextSunrise) {
        if (lastSunset < 0L || nextSunrise < 0L || now < lastSunset || now > nextSunrise) {
            return 1.0f;
        }
        if (now < lastSunset + 0x6DDD00L) {
            return MathUtils.lerp(1.0f, 1.5f, (float)(now - lastSunset) / 7200000.0f);
        }
        if (now > nextSunrise - 0x6DDD00L) {
            return MathUtils.lerp(1.0f, 1.5f, (float)(nextSunrise - now) / 7200000.0f);
        }
        return 1.5f;
    }

    private static final class AmbientLightRingBuffer {
        private static final float BUFFER_SLACK = 1.5f;
        private static final int DEFAULT_CAPACITY = (int)Math.ceil(15.0);
        private float[] mRingLux;
        private long[] mRingTime;
        private int mCapacity;
        private int mStart;
        private int mEnd;
        private int mCount;

        public AmbientLightRingBuffer() {
            this(DEFAULT_CAPACITY);
        }

        public AmbientLightRingBuffer(int initialCapacity) {
            this.mCapacity = initialCapacity;
            this.mRingLux = new float[this.mCapacity];
            this.mRingTime = new long[this.mCapacity];
        }

        public float getLux(int index) {
            return this.mRingLux[this.offsetOf(index)];
        }

        public long getTime(int index) {
            return this.mRingTime[this.offsetOf(index)];
        }

        public void push(long time, float lux) {
            int next = this.mEnd;
            if (this.mCount == this.mCapacity) {
                int newSize = this.mCapacity * 2;
                float[] newRingLux = new float[newSize];
                long[] newRingTime = new long[newSize];
                int length = this.mCapacity - this.mStart;
                System.arraycopy((float[])this.mRingLux, (int)this.mStart, (float[])newRingLux, (int)0, (int)length);
                System.arraycopy((long[])this.mRingTime, (int)this.mStart, (long[])newRingTime, (int)0, (int)length);
                if (this.mStart != 0) {
                    System.arraycopy((float[])this.mRingLux, (int)0, (float[])newRingLux, (int)length, (int)this.mStart);
                    System.arraycopy((long[])this.mRingTime, (int)0, (long[])newRingTime, (int)length, (int)this.mStart);
                }
                this.mRingLux = newRingLux;
                this.mRingTime = newRingTime;
                next = this.mCapacity;
                this.mCapacity = newSize;
                this.mStart = 0;
            }
            this.mRingTime[next] = time;
            this.mRingLux[next] = lux;
            this.mEnd = next + 1;
            if (this.mEnd == this.mCapacity) {
                this.mEnd = 0;
            }
            ++this.mCount;
        }

        public void prune(long horizon) {
            if (this.mCount == 0) {
                return;
            }
            while (this.mCount > 1) {
                int next = this.mStart + 1;
                if (next >= this.mCapacity) {
                    next -= this.mCapacity;
                }
                if (this.mRingTime[next] > horizon) break;
                this.mStart = next;
                --this.mCount;
            }
            if (this.mRingTime[this.mStart] < horizon) {
                this.mRingTime[this.mStart] = horizon;
            }
        }

        public int size() {
            return this.mCount;
        }

        public boolean isEmpty() {
            return this.mCount == 0;
        }

        public void clear() {
            this.mStart = 0;
            this.mEnd = 0;
            this.mCount = 0;
        }

        public String toString() {
            int length = this.mCapacity - this.mStart;
            float[] lux = new float[this.mCount];
            long[] time = new long[this.mCount];
            if (this.mCount <= length) {
                System.arraycopy((float[])this.mRingLux, (int)this.mStart, (float[])lux, (int)0, (int)this.mCount);
                System.arraycopy((long[])this.mRingTime, (int)this.mStart, (long[])time, (int)0, (int)this.mCount);
            } else {
                System.arraycopy((float[])this.mRingLux, (int)this.mStart, (float[])lux, (int)0, (int)length);
                System.arraycopy((float[])this.mRingLux, (int)0, (float[])lux, (int)length, (int)(this.mCount - length));
                System.arraycopy((long[])this.mRingTime, (int)this.mStart, (long[])time, (int)0, (int)length);
                System.arraycopy((long[])this.mRingTime, (int)0, (long[])time, (int)length, (int)(this.mCount - length));
            }
            return "AmbientLightRingBuffer{mCapacity=" + this.mCapacity + ", mStart=" + this.mStart + ", mEnd=" + this.mEnd + ", mCount=" + this.mCount + ", mRingLux=" + Arrays.toString(lux) + ", mRingTime=" + Arrays.toString(time) + "}";
        }

        private int offsetOf(int index) {
            if (index >= this.mCount || index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if ((index += this.mStart) >= this.mCapacity) {
                index -= this.mCapacity;
            }
            return index;
        }
    }

    static interface Callbacks {
        public void updateBrightness();
    }

    private final class AutomaticBrightnessHandler
    extends Handler {
        public AutomaticBrightnessHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AutomaticBrightnessController.this.updateAmbientLux();
                }
            }
        }
    }
}

