/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayEventReceiver;
import android.view.SurfaceControl;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;
import java.io.PrintWriter;
import java.util.Arrays;

final class LocalDisplayAdapter
extends DisplayAdapter {
    private static final String TAG = "LocalDisplayAdapter";
    private static final int[] BUILT_IN_DISPLAY_IDS_TO_SCAN = new int[]{0, 1};
    private final SparseArray<LocalDisplayDevice> mDevices = new SparseArray();
    private HotplugDisplayEventReceiver mHotplugReceiver;

    public LocalDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener) {
        super(syncRoot, context, handler, listener, TAG);
    }

    @Override
    public void registerLocked() {
        super.registerLocked();
        this.mHotplugReceiver = new HotplugDisplayEventReceiver(this.getHandler().getLooper());
        for (int builtInDisplayId : BUILT_IN_DISPLAY_IDS_TO_SCAN) {
            this.tryConnectDisplayLocked(builtInDisplayId);
        }
    }

    private void tryConnectDisplayLocked(int builtInDisplayId) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(builtInDisplayId);
        if (displayToken != null) {
            SurfaceControl.PhysicalDisplayInfo[] configs = SurfaceControl.getDisplayConfigs(displayToken);
            if (configs == null) {
                Slog.w(TAG, "No valid configs found for display device " + builtInDisplayId);
                return;
            }
            int activeConfig = SurfaceControl.getActiveConfig(displayToken);
            if (activeConfig < 0) {
                Slog.w(TAG, "No active config found for display device " + builtInDisplayId);
                return;
            }
            LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
            if (device == null) {
                device = new LocalDisplayDevice(displayToken, builtInDisplayId, configs, activeConfig);
                this.mDevices.put(builtInDisplayId, device);
                this.sendDisplayDeviceEventLocked(device, 1);
            } else if (device.updatePhysicalDisplayInfoLocked(configs, activeConfig)) {
                this.sendDisplayDeviceEventLocked(device, 2);
            }
        }
    }

    private void tryDisconnectDisplayLocked(int builtInDisplayId) {
        LocalDisplayDevice device = this.mDevices.get(builtInDisplayId);
        if (device != null) {
            this.mDevices.remove(builtInDisplayId);
            this.sendDisplayDeviceEventLocked(device, 3);
        }
    }

    static int getPowerModeForState(int state) {
        switch (state) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 2;
    }

    private final class HotplugDisplayEventReceiver
    extends DisplayEventReceiver {
        public HotplugDisplayEventReceiver(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHotplug(long timestampNanos, int builtInDisplayId, boolean connected) {
            DisplayManagerService.SyncRoot syncRoot = LocalDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (connected) {
                    LocalDisplayAdapter.this.tryConnectDisplayLocked(builtInDisplayId);
                } else {
                    LocalDisplayAdapter.this.tryDisconnectDisplayLocked(builtInDisplayId);
                }
            }
        }
    }

    private final class LocalDisplayDevice
    extends DisplayDevice {
        private final int mBuiltInDisplayId;
        private final SurfaceControl.PhysicalDisplayInfo mPhys;
        private final int mDefaultPhysicalDisplayInfo;
        private DisplayDeviceInfo mInfo;
        private boolean mHavePendingChanges;
        private int mState;
        private float[] mSupportedRefreshRates;
        private int[] mRefreshRateConfigIndices;
        private float mLastRequestedRefreshRate;

        public LocalDisplayDevice(IBinder displayToken, int builtInDisplayId, SurfaceControl.PhysicalDisplayInfo[] physicalDisplayInfos, int activeDisplayInfo) {
            super(LocalDisplayAdapter.this, displayToken);
            this.mState = 0;
            this.mBuiltInDisplayId = builtInDisplayId;
            this.mPhys = new SurfaceControl.PhysicalDisplayInfo(physicalDisplayInfos[activeDisplayInfo]);
            this.mDefaultPhysicalDisplayInfo = activeDisplayInfo;
            this.updateSupportedRefreshRatesLocked(physicalDisplayInfos, this.mPhys);
        }

        public boolean updatePhysicalDisplayInfoLocked(SurfaceControl.PhysicalDisplayInfo[] physicalDisplayInfos, int activeDisplayInfo) {
            SurfaceControl.PhysicalDisplayInfo newPhys = physicalDisplayInfos[activeDisplayInfo];
            if (!this.mPhys.equals(newPhys)) {
                this.mPhys.copyFrom(newPhys);
                this.updateSupportedRefreshRatesLocked(physicalDisplayInfos, this.mPhys);
                this.mHavePendingChanges = true;
                return true;
            }
            return false;
        }

        @Override
        public void applyPendingDisplayDeviceInfoChangesLocked() {
            if (this.mHavePendingChanges) {
                this.mInfo = null;
                this.mHavePendingChanges = false;
            }
        }

        @Override
        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.width = this.mPhys.width;
                this.mInfo.height = this.mPhys.height;
                this.mInfo.refreshRate = this.mPhys.refreshRate;
                this.mInfo.supportedRefreshRates = this.mSupportedRefreshRates;
                this.mInfo.appVsyncOffsetNanos = this.mPhys.appVsyncOffsetNanos;
                this.mInfo.presentationDeadlineNanos = this.mPhys.presentationDeadlineNanos;
                this.mInfo.state = this.mState;
                if (this.mPhys.secure) {
                    this.mInfo.flags = 12;
                }
                if (this.mBuiltInDisplayId == 0) {
                    this.mInfo.name = LocalDisplayAdapter.this.getContext().getResources().getString(17040842);
                    this.mInfo.flags |= 3;
                    this.mInfo.type = 1;
                    this.mInfo.densityDpi = (int)(this.mPhys.density * 160.0f + 0.5f);
                    this.mInfo.xDpi = this.mPhys.xDpi;
                    this.mInfo.yDpi = this.mPhys.yDpi;
                    this.mInfo.touch = 1;
                } else {
                    this.mInfo.type = 2;
                    this.mInfo.flags |= 0x40;
                    this.mInfo.name = LocalDisplayAdapter.this.getContext().getResources().getString(17040843);
                    this.mInfo.touch = 2;
                    this.mInfo.setAssumedDensityForExternalDisplay(this.mPhys.width, this.mPhys.height);
                    if ("portrait".equals(SystemProperties.get("persist.demo.hdmirotation"))) {
                        this.mInfo.rotation = 3;
                    }
                    if (SystemProperties.getBoolean("persist.demo.hdmirotates", false)) {
                        this.mInfo.flags |= 2;
                    }
                }
            }
            return this.mInfo;
        }

        @Override
        public Runnable requestDisplayStateLocked(final int state) {
            if (this.mState != state) {
                final int displayId = this.mBuiltInDisplayId;
                final IBinder token = this.getDisplayTokenLocked();
                final int mode = LocalDisplayAdapter.getPowerModeForState(state);
                this.mState = state;
                this.updateDeviceInfoLocked();
                return new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Trace.traceBegin(131072L, "requestDisplayState(" + Display.stateToString(state) + ", id=" + displayId + ")");
                        try {
                            SurfaceControl.setDisplayPowerMode(token, mode);
                        }
                        finally {
                            Trace.traceEnd(131072L);
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public void requestRefreshRateLocked(float refreshRate) {
            if (this.mLastRequestedRefreshRate == refreshRate) {
                return;
            }
            this.mLastRequestedRefreshRate = refreshRate;
            if (refreshRate != 0.0f) {
                int N = this.mSupportedRefreshRates.length;
                for (int i = 0; i < N; ++i) {
                    if (refreshRate != this.mSupportedRefreshRates[i]) continue;
                    int configIndex = this.mRefreshRateConfigIndices[i];
                    SurfaceControl.setActiveConfig(this.getDisplayTokenLocked(), configIndex);
                    return;
                }
                Slog.w(LocalDisplayAdapter.TAG, "Requested refresh rate " + refreshRate + " is unsupported.");
            }
            SurfaceControl.setActiveConfig(this.getDisplayTokenLocked(), this.mDefaultPhysicalDisplayInfo);
        }

        @Override
        public void dumpLocked(PrintWriter pw) {
            super.dumpLocked(pw);
            pw.println("mBuiltInDisplayId=" + this.mBuiltInDisplayId);
            pw.println("mPhys=" + this.mPhys);
            pw.println("mState=" + Display.stateToString(this.mState));
        }

        private void updateDeviceInfoLocked() {
            this.mInfo = null;
            LocalDisplayAdapter.this.sendDisplayDeviceEventLocked(this, 2);
        }

        private void updateSupportedRefreshRatesLocked(SurfaceControl.PhysicalDisplayInfo[] physicalDisplayInfos, SurfaceControl.PhysicalDisplayInfo activePhys) {
            int N = physicalDisplayInfos.length;
            int idx = 0;
            this.mSupportedRefreshRates = new float[N];
            this.mRefreshRateConfigIndices = new int[N];
            for (int i = 0; i < N; ++i) {
                SurfaceControl.PhysicalDisplayInfo phys = physicalDisplayInfos[i];
                if (activePhys.width != phys.width || activePhys.height != phys.height || activePhys.density != phys.density || activePhys.xDpi != phys.xDpi || activePhys.yDpi != phys.yDpi) continue;
                this.mSupportedRefreshRates[idx] = phys.refreshRate;
                this.mRefreshRateConfigIndices[idx++] = i;
            }
            if (idx != N) {
                this.mSupportedRefreshRates = Arrays.copyOfRange(this.mSupportedRefreshRates, 0, idx);
                this.mRefreshRateConfigIndices = Arrays.copyOfRange(this.mRefreshRateConfigIndices, 0, idx);
            }
        }
    }
}

