/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.service.fingerprint.FingerprintUtils;
import android.service.fingerprint.IFingerprintService;
import android.service.fingerprint.IFingerprintServiceReceiver;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.server.SystemService;
import java.lang.ref.WeakReference;

public class FingerprintService
extends SystemService {
    private final String TAG = "FingerprintService";
    private static final boolean DEBUG = true;
    private ArrayMap<IBinder, ClientData> mClients = new ArrayMap();
    private static final int MSG_NOTIFY = 10;
    Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    FingerprintService.this.handleNotify(msg.arg1, msg.arg2, (Integer)msg.obj);
                    break;
                }
                default: {
                    Slog.w("FingerprintService", "Unknown message:" + msg.what);
                }
            }
        }
    };
    private Context mContext;
    private static final int STATE_IDLE = 0;
    private static final int STATE_LISTENING = 1;
    private static final int STATE_ENROLLING = 2;
    private static final int STATE_REMOVING = 3;
    private static final long MS_PER_SEC = 1000L;
    public static final String USE_FINGERPRINT = "android.permission.USE_FINGERPRINT";
    public static final String ENROLL_FINGERPRINT = "android.permission.ENROLL_FINGERPRINT";

    public FingerprintService(Context context) {
        super(context);
        this.mContext = context;
        this.nativeInit(this);
    }

    native int nativeEnroll(int var1);

    native int nativeEnrollCancel();

    native int nativeRemove(int var1);

    native int nativeOpenHal();

    native int nativeCloseHal();

    native void nativeInit(FingerprintService var1);

    void notify(int msg, int arg1, int arg2) {
        this.mHandler.obtainMessage(10, msg, arg1, arg2).sendToTarget();
    }

    void handleNotify(int msg, int arg1, int arg2) {
        Slog.v("FingerprintService", "handleNotify(msg=" + msg + ", arg1=" + arg1 + ", arg2=" + arg2 + ")");
        block17: for (int i = 0; i < this.mClients.size(); ++i) {
            ClientData clientData = this.mClients.valueAt(i);
            if (clientData == null || clientData.receiver == null) {
                Slog.v("FingerprintService", "clientData at " + i + " is invalid!!");
                continue;
            }
            switch (msg) {
                case -1: {
                    int error = arg1;
                    try {
                        clientData.receiver.onError(error);
                    }
                    catch (RemoteException e) {
                        Slog.e("FingerprintService", "can't send message to client. Did it die?", e);
                        this.mClients.remove(this.mClients.keyAt(i));
                    }
                    continue block17;
                }
                case 1: {
                    int acquireInfo = arg1;
                    try {
                        clientData.receiver.onAcquired(acquireInfo);
                    }
                    catch (RemoteException e) {
                        Slog.e("FingerprintService", "can't send message to client. Did it die?", e);
                        this.mClients.remove(this.mClients.keyAt(i));
                    }
                    continue block17;
                }
                case 2: {
                    int fingerId = arg1;
                    try {
                        clientData.receiver.onProcessed(fingerId);
                    }
                    catch (RemoteException e) {
                        Slog.e("FingerprintService", "can't send message to client. Did it die?", e);
                        this.mClients.remove(this.mClients.keyAt(i));
                    }
                    continue block17;
                }
                case 3: {
                    int fingerId = arg1;
                    int remaining = arg2;
                    if (clientData.state == 2) {
                        try {
                            clientData.receiver.onEnrollResult(fingerId, remaining);
                        }
                        catch (RemoteException e) {
                            Slog.e("FingerprintService", "can't send message to client. Did it die?", e);
                            this.mClients.remove(this.mClients.keyAt(i));
                        }
                        if (remaining != 0) continue block17;
                        FingerprintUtils.addFingerprintIdForUser(fingerId, this.mContext.getContentResolver(), clientData.userId);
                        clientData.state = 0;
                        continue block17;
                    }
                    Slog.w("FingerprintService", "Client not enrolling");
                    continue block17;
                }
                case 4: {
                    int fingerId = arg1;
                    if (fingerId == 0) {
                        throw new IllegalStateException("Got illegal id from HAL");
                    }
                    FingerprintUtils.removeFingerprintIdForUser(fingerId, this.mContext.getContentResolver(), clientData.userId);
                    if (clientData.receiver != null) {
                        try {
                            clientData.receiver.onRemoved(fingerId);
                        }
                        catch (RemoteException e) {
                            Slog.e("FingerprintService", "can't send message to client. Did it die?", e);
                            this.mClients.remove(this.mClients.keyAt(i));
                        }
                    }
                    clientData.state = 1;
                }
            }
        }
    }

    void startEnroll(IBinder token, long timeout, int userId) {
        ClientData clientData = this.mClients.get(token);
        if (clientData != null) {
            if (clientData.userId != userId) {
                throw new IllegalStateException("Bad user");
            }
            clientData.state = 2;
            this.nativeEnroll((int)(timeout / 1000L));
        } else {
            Slog.w("FingerprintService", "enroll(): No listener registered");
        }
    }

    void startEnrollCancel(IBinder token, int userId) {
        ClientData clientData = this.mClients.get(token);
        if (clientData != null) {
            if (clientData.userId != userId) {
                throw new IllegalStateException("Bad user");
            }
            clientData.state = 1;
            this.nativeEnrollCancel();
        } else {
            Slog.w("FingerprintService", "enrollCancel(): No listener registered");
        }
    }

    void startRemove(IBinder token, int fingerId, int userId) {
        ClientData clientData = this.mClients.get(token);
        if (clientData != null) {
            if (clientData.userId != userId) {
                throw new IllegalStateException("Bad user");
            }
            clientData.state = 3;
            int result = this.nativeRemove(fingerId);
            if (result != 0) {
                Slog.w("FingerprintService", "Error removing fingerprint with id = " + fingerId);
            }
        } else {
            Slog.w("FingerprintService", "remove(" + token + "): No listener registered");
        }
    }

    void addListener(IBinder token, IFingerprintServiceReceiver receiver, int userId) {
        Slog.v("FingerprintService", "startListening(" + receiver + ")");
        if (this.mClients.get(token) == null) {
            ClientData clientData = new ClientData();
            clientData.state = 1;
            clientData.receiver = receiver;
            clientData.userId = userId;
            clientData.tokenWatcher = new TokenWatcher(token);
            try {
                token.linkToDeath(clientData.tokenWatcher, 0);
                this.mClients.put(token, clientData);
            }
            catch (RemoteException e) {
                Slog.w("FingerprintService", "caught remote exception in linkToDeath: ", e);
            }
        } else {
            Slog.v("FingerprintService", "listener already registered for " + token);
        }
    }

    void removeListener(IBinder token, int userId) {
        Slog.v("FingerprintService", "stopListening(" + token + ")");
        ClientData clientData = this.mClients.get(token);
        if (clientData != null) {
            token.unlinkToDeath(clientData.tokenWatcher, 0);
            this.mClients.remove(token);
        } else {
            Slog.v("FingerprintService", "listener not registered: " + token);
        }
        this.mClients.remove(token);
    }

    void checkPermission(String permisison) {
    }

    @Override
    public void onStart() {
        this.publishBinderService("fingerprint", new FingerprintServiceWrapper());
        this.nativeOpenHal();
    }

    private final class FingerprintServiceWrapper
    extends IFingerprintService.Stub {
        private FingerprintServiceWrapper() {
        }

        @Override
        public void enroll(IBinder token, long timeout, int userId) {
            FingerprintService.this.checkPermission(FingerprintService.ENROLL_FINGERPRINT);
            FingerprintService.this.startEnroll(token, timeout, userId);
        }

        @Override
        public void enrollCancel(IBinder token, int userId) {
            FingerprintService.this.checkPermission(FingerprintService.ENROLL_FINGERPRINT);
            FingerprintService.this.startEnrollCancel(token, userId);
        }

        @Override
        public void remove(IBinder token, int fingerprintId, int userId) {
            FingerprintService.this.checkPermission(FingerprintService.ENROLL_FINGERPRINT);
            FingerprintService.this.startRemove(token, fingerprintId, userId);
        }

        @Override
        public void startListening(IBinder token, IFingerprintServiceReceiver receiver, int userId) {
            FingerprintService.this.checkPermission(FingerprintService.USE_FINGERPRINT);
            FingerprintService.this.addListener(token, receiver, userId);
        }

        @Override
        public void stopListening(IBinder token, int userId) {
            FingerprintService.this.checkPermission(FingerprintService.USE_FINGERPRINT);
            FingerprintService.this.removeListener(token, userId);
        }
    }

    private class TokenWatcher
    implements IBinder.DeathRecipient {
        WeakReference<IBinder> token;

        TokenWatcher(IBinder token) {
            this.token = new WeakReference<IBinder>(token);
        }

        IBinder getToken() {
            return (IBinder)this.token.get();
        }

        @Override
        public void binderDied() {
            FingerprintService.this.mClients.remove(this.token);
            this.token = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.token != null) {
                    Slog.w("FingerprintService", "removing leaked reference: " + this.token);
                    FingerprintService.this.mClients.remove(this.token);
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class ClientData {
        public IFingerprintServiceReceiver receiver;
        int state;
        int userId;
        public TokenWatcher tokenWatcher;

        private ClientData() {
        }

        IBinder getToken() {
            return this.tokenWatcher.getToken();
        }
    }
}

