/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;

public class OneTouchRecordAction
extends HdmiCecFeatureAction {
    private static final String TAG = "OneTouchRecordAction";
    private static final int RECORD_STATUS_TIMEOUT_MS = 120000;
    private static final int STATE_WAITING_FOR_RECORD_STATUS = 1;
    private static final int STATE_RECORDING_IN_PROGRESS = 2;
    private final int mRecorderAddress;
    private final byte[] mRecordSource;

    OneTouchRecordAction(HdmiCecLocalDevice source, int recorderAddress, byte[] recordSource) {
        super(source);
        this.mRecorderAddress = recorderAddress;
        this.mRecordSource = recordSource;
    }

    @Override
    boolean start() {
        this.sendRecordOn();
        return true;
    }

    private void sendRecordOn() {
        this.sendCommand(HdmiCecMessageBuilder.buildRecordOn(this.getSourceAddress(), this.mRecorderAddress, this.mRecordSource), new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    OneTouchRecordAction.this.tv().announceOneTouchRecordResult(49);
                    OneTouchRecordAction.this.finish();
                    return;
                }
                OneTouchRecordAction.this.mState = 1;
                OneTouchRecordAction.this.addTimer(OneTouchRecordAction.this.mState, 120000);
            }
        });
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 10: {
                return this.handleRecordStatus(cmd);
            }
        }
        return false;
    }

    private boolean handleRecordStatus(HdmiCecMessage cmd) {
        if (cmd.getSource() != this.mRecorderAddress) {
            return false;
        }
        byte recordStatus = cmd.getParams()[0];
        this.tv().announceOneTouchRecordResult(recordStatus);
        Slog.i(TAG, "Got record status:" + recordStatus + " from " + cmd.getSource());
        switch (recordStatus) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mState = 2;
                this.mActionTimer.clearTimerMessage();
                break;
            }
            default: {
                this.finish();
            }
        }
        return true;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            Slog.w(TAG, "Timeout in invalid state:[Expected:" + this.mState + ", Actual:" + state + "]");
            return;
        }
        this.tv().announceOneTouchRecordResult(49);
        this.finish();
    }

    int getRecorderAddress() {
        return this.mRecorderAddress;
    }
}

