/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.util.SparseIntArray;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import java.util.List;

public class PowerStatusMonitorAction
extends HdmiCecFeatureAction {
    private static final String TAG = "PowerStatusMonitorAction";
    private static final int STATE_WAIT_FOR_REPORT_POWER_STATUS = 1;
    private static final int STATE_WAIT_FOR_NEXT_MONITORING = 2;
    private static final int INVALID_POWER_STATUS = -2;
    private static final int MONITIROING_INTERNAL_MS = 60000;
    private static final int REPORT_POWER_STATUS_TIMEOUT_MS = 5000;
    private final SparseIntArray mPowerStatus = new SparseIntArray();

    PowerStatusMonitorAction(HdmiCecLocalDevice source) {
        super(source);
    }

    @Override
    boolean start() {
        this.queryPowerStatus();
        return true;
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        return this.handleReportPowerStatus(cmd);
    }

    private boolean handleReportPowerStatus(HdmiCecMessage cmd) {
        int sourceAddress = cmd.getSource();
        int oldStatus = this.mPowerStatus.get(sourceAddress, -2);
        if (oldStatus == -2) {
            return false;
        }
        int newStatus = cmd.getParams()[0] & 0xFF;
        this.updatePowerStatus(sourceAddress, newStatus, true);
        return true;
    }

    @Override
    void handleTimerEvent(int state) {
        switch (this.mState) {
            case 2: {
                this.queryPowerStatus();
                break;
            }
            case 1: {
                this.handleTimeout();
            }
        }
    }

    private void handleTimeout() {
        for (int i = 0; i < this.mPowerStatus.size(); ++i) {
            int logicalAddress = this.mPowerStatus.keyAt(i);
            this.updatePowerStatus(logicalAddress, -1, false);
        }
        this.mPowerStatus.clear();
        this.mState = 2;
    }

    private void resetPowerStatus(List<HdmiDeviceInfo> deviceInfos) {
        this.mPowerStatus.clear();
        for (HdmiDeviceInfo info : deviceInfos) {
            this.mPowerStatus.append(info.getLogicalAddress(), info.getDevicePowerStatus());
        }
    }

    private void queryPowerStatus() {
        List<HdmiDeviceInfo> deviceInfos = this.tv().getDeviceInfoList(false);
        this.resetPowerStatus(deviceInfos);
        for (HdmiDeviceInfo info : deviceInfos) {
            final int logicalAddress = info.getLogicalAddress();
            this.sendCommand(HdmiCecMessageBuilder.buildGiveDevicePowerStatus(this.getSourceAddress(), logicalAddress), new HdmiControlService.SendMessageCallback(){

                @Override
                public void onSendCompleted(int error) {
                    if (error != 0) {
                        PowerStatusMonitorAction.this.updatePowerStatus(logicalAddress, -1, true);
                    }
                }
            });
        }
        this.mState = 1;
        this.addTimer(2, 60000);
        this.addTimer(1, 5000);
    }

    private void updatePowerStatus(int logicalAddress, int newStatus, boolean remove) {
        this.tv().updateDevicePowerStatus(logicalAddress, newStatus);
        if (remove) {
            this.mPowerStatus.delete(logicalAddress);
        }
    }
}

