/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.SystemAudioActionFromAvr;
import com.android.server.hdmi.SystemAudioActionFromTv;
import com.android.server.hdmi.SystemAudioStatusAction;

final class SystemAudioAutoInitiationAction
extends HdmiCecFeatureAction {
    private final int mAvrAddress;
    private static final int STATE_WAITING_FOR_SYSTEM_AUDIO_MODE_STATUS = 1;

    SystemAudioAutoInitiationAction(HdmiCecLocalDevice source, int avrAddress) {
        super(source);
        this.mAvrAddress = avrAddress;
    }

    @Override
    boolean start() {
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        this.sendGiveSystemAudioModeStatus();
        return true;
    }

    private void sendGiveSystemAudioModeStatus() {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveSystemAudioModeStatus(this.getSourceAddress(), this.mAvrAddress), new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    SystemAudioAutoInitiationAction.this.tv().setSystemAudioMode(false, true);
                    SystemAudioAutoInitiationAction.this.finish();
                }
            }
        });
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 126: {
                this.handleSystemAudioModeStatusMessage();
                return true;
            }
        }
        return false;
    }

    private void handleSystemAudioModeStatusMessage() {
        if (this.tv().getSystemAudioModeSetting()) {
            if (this.canChangeSystemAudio()) {
                this.addAndStartAction(new SystemAudioActionFromTv(this.tv(), this.mAvrAddress, true, null));
            }
        } else {
            this.tv().setSystemAudioMode(false, true);
            if (this.canChangeSystemAudio()) {
                this.addAndStartAction(new SystemAudioStatusAction(this.tv(), this.mAvrAddress, null));
            }
        }
        this.finish();
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        switch (this.mState) {
            case 1: {
                this.handleSystemAudioModeStatusTimeout();
            }
        }
    }

    private void handleSystemAudioModeStatusTimeout() {
        if (this.tv().getSystemAudioModeSetting()) {
            if (this.canChangeSystemAudio()) {
                this.addAndStartAction(new SystemAudioActionFromTv(this.tv(), this.mAvrAddress, true, null));
            }
        } else {
            this.tv().setSystemAudioMode(false, true);
        }
        this.finish();
    }

    private boolean canChangeSystemAudio() {
        return !this.tv().hasAction(SystemAudioActionFromTv.class) && !this.tv().hasAction(SystemAudioActionFromAvr.class);
    }
}

