/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

abstract class RemoteListenerHelper<TListener extends IInterface> {
    private final String mTag;
    private final HashMap<IBinder, LinkedListener> mListenerMap = new HashMap();

    protected RemoteListenerHelper(String name) {
        Preconditions.checkNotNull(name);
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(TListener listener) {
        Preconditions.checkNotNull(listener, "Attempted to register a 'null' listener.");
        if (!this.isSupported()) {
            Log.e(this.mTag, "Refused to add listener, the feature is not supported.");
            return false;
        }
        IBinder binder = listener.asBinder();
        LinkedListener deathListener = new LinkedListener(this, listener);
        HashMap<IBinder, LinkedListener> hashMap = this.mListenerMap;
        synchronized (hashMap) {
            if (this.mListenerMap.containsKey(binder)) {
                return true;
            }
            try {
                binder.linkToDeath(deathListener, 0);
            }
            catch (RemoteException e) {
                Log.e(this.mTag, "Remote listener already died.", e);
                return false;
            }
            this.mListenerMap.put(binder, deathListener);
            if (this.mListenerMap.size() == 1 && !this.registerWithService()) {
                Log.e(this.mTag, "RegisterWithService failed, listener will be removed.");
                this.removeListener(listener);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(TListener listener) {
        LinkedListener linkedListener;
        Preconditions.checkNotNull(listener, "Attempted to remove a 'null' listener.");
        if (!this.isSupported()) {
            Log.e(this.mTag, "Refused to remove listener, the feature is not supported.");
            return false;
        }
        IBinder binder = listener.asBinder();
        HashMap<IBinder, LinkedListener> hashMap = this.mListenerMap;
        synchronized (hashMap) {
            linkedListener = this.mListenerMap.remove(binder);
            if (this.mListenerMap.isEmpty() && linkedListener != null) {
                this.unregisterFromService();
            }
        }
        if (linkedListener != null) {
            binder.unlinkToDeath(linkedListener, 0);
        }
        return true;
    }

    protected abstract boolean isSupported();

    protected abstract boolean registerWithService();

    protected abstract void unregisterFromService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreach(ListenerOperation operation) {
        ArrayList<LinkedListener> linkedListeners;
        HashMap<IBinder, LinkedListener> hashMap = this.mListenerMap;
        synchronized (hashMap) {
            Collection<LinkedListener> values = this.mListenerMap.values();
            linkedListeners = new ArrayList<LinkedListener>(values);
        }
        for (LinkedListener linkedListener : linkedListeners) {
            Object listener = linkedListener.getUnderlyingListener();
            try {
                operation.execute(listener);
            }
            catch (RemoteException e) {
                Log.e(this.mTag, "Error in monitored listener.", e);
                this.removeListener(listener);
            }
        }
    }

    private static class LinkedListener
    implements IBinder.DeathRecipient {
        private final TListener mListener;
        final /* synthetic */ RemoteListenerHelper this$0;

        public LinkedListener(TListener listener) {
            this.this$0 = var1_1;
            this.mListener = listener;
        }

        public TListener getUnderlyingListener() {
            return this.mListener;
        }

        @Override
        public void binderDied() {
            Log.d(this.this$0.mTag, "Remote Listener died: " + this.mListener);
            this.this$0.removeListener(this.mListener);
        }
    }

    protected static interface ListenerOperation<TListener extends IInterface> {
        public void execute(TListener var1) throws RemoteException;
    }
}

