/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.LinkProperties;
import com.android.server.net.DnsServerEntry;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class DnsServerRepository {
    public static final int NUM_CURRENT_SERVERS = 3;
    public static final int NUM_SERVERS = 12;
    private Set<InetAddress> mCurrentServers = new HashSet<InetAddress>();
    public static final String TAG = "DnsServerRepository";
    private ArrayList<DnsServerEntry> mAllServers = new ArrayList(12);
    private HashMap<InetAddress, DnsServerEntry> mIndex = new HashMap(12);

    public synchronized void setDnsServersOn(LinkProperties lp) {
        lp.setDnsServers(this.mCurrentServers);
    }

    public synchronized boolean addServers(long lifetime, String[] addresses) {
        long now = System.currentTimeMillis();
        long expiry = now + 1000L * lifetime;
        for (String addressString : addresses) {
            InetAddress address;
            try {
                address = InetAddress.parseNumericAddress(addressString);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            if (this.updateExistingEntry(address, expiry) || expiry <= now) continue;
            DnsServerEntry entry = new DnsServerEntry(address, expiry);
            this.mAllServers.add(entry);
            this.mIndex.put(address, entry);
        }
        Collections.sort(this.mAllServers);
        return this.updateCurrentServers();
    }

    private synchronized boolean updateExistingEntry(InetAddress address, long expiry) {
        DnsServerEntry existing = this.mIndex.get(address);
        if (existing != null) {
            existing.expiry = expiry;
            return true;
        }
        return false;
    }

    private synchronized boolean updateCurrentServers() {
        long now = System.currentTimeMillis();
        boolean changed = false;
        for (int i = this.mAllServers.size() - 1; i >= 0 && (i >= 12 || this.mAllServers.get((int)i).expiry < now); --i) {
            DnsServerEntry removed = this.mAllServers.remove(i);
            this.mIndex.remove(removed.address);
            changed |= this.mCurrentServers.remove(removed.address);
        }
        for (DnsServerEntry entry : this.mAllServers) {
            if (this.mCurrentServers.size() >= 3) break;
            changed |= this.mCurrentServers.add(entry.address);
        }
        return changed;
    }
}

