/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.IpConfiguration;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StaticIpConfiguration;
import android.util.Log;
import android.util.SparseArray;
import com.android.server.net.DelayedDiskWrite;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;

public class IpConfigStore {
    private static final String TAG = "IpConfigStore";
    private static final boolean DBG = true;
    protected final DelayedDiskWrite mWriter = new DelayedDiskWrite();
    protected static final String ID_KEY = "id";
    protected static final String IP_ASSIGNMENT_KEY = "ipAssignment";
    protected static final String LINK_ADDRESS_KEY = "linkAddress";
    protected static final String GATEWAY_KEY = "gateway";
    protected static final String DNS_KEY = "dns";
    protected static final String PROXY_SETTINGS_KEY = "proxySettings";
    protected static final String PROXY_HOST_KEY = "proxyHost";
    protected static final String PROXY_PORT_KEY = "proxyPort";
    protected static final String PROXY_PAC_FILE = "proxyPac";
    protected static final String EXCLUSION_LIST_KEY = "exclusionList";
    protected static final String EOS = "eos";
    protected static final int IPCONFIG_FILE_VERSION = 2;

    private boolean writeConfig(DataOutputStream out, int configKey, IpConfiguration config) throws IOException {
        boolean written = false;
        try {
            switch (config.ipAssignment) {
                case STATIC: {
                    out.writeUTF(IP_ASSIGNMENT_KEY);
                    out.writeUTF(config.ipAssignment.toString());
                    StaticIpConfiguration staticIpConfiguration = config.staticIpConfiguration;
                    if (staticIpConfiguration != null) {
                        if (staticIpConfiguration.ipAddress != null) {
                            LinkAddress ipAddress = staticIpConfiguration.ipAddress;
                            out.writeUTF(LINK_ADDRESS_KEY);
                            out.writeUTF(ipAddress.getAddress().getHostAddress());
                            out.writeInt(ipAddress.getPrefixLength());
                        }
                        if (staticIpConfiguration.gateway != null) {
                            out.writeUTF(GATEWAY_KEY);
                            out.writeInt(0);
                            out.writeInt(1);
                            out.writeUTF(staticIpConfiguration.gateway.getHostAddress());
                        }
                        for (InetAddress inetAddr : staticIpConfiguration.dnsServers) {
                            out.writeUTF(DNS_KEY);
                            out.writeUTF(inetAddr.getHostAddress());
                        }
                    }
                    written = true;
                    break;
                }
                case DHCP: {
                    out.writeUTF(IP_ASSIGNMENT_KEY);
                    out.writeUTF(config.ipAssignment.toString());
                    written = true;
                    break;
                }
                case UNASSIGNED: {
                    break;
                }
                default: {
                    this.loge("Ignore invalid ip assignment while writing");
                }
            }
            switch (config.proxySettings) {
                case STATIC: {
                    ProxyInfo proxyProperties = config.httpProxy;
                    String exclusionList = proxyProperties.getExclusionListAsString();
                    out.writeUTF(PROXY_SETTINGS_KEY);
                    out.writeUTF(config.proxySettings.toString());
                    out.writeUTF(PROXY_HOST_KEY);
                    out.writeUTF(proxyProperties.getHost());
                    out.writeUTF(PROXY_PORT_KEY);
                    out.writeInt(proxyProperties.getPort());
                    out.writeUTF(EXCLUSION_LIST_KEY);
                    out.writeUTF(exclusionList);
                    written = true;
                    break;
                }
                case PAC: {
                    ProxyInfo proxyPacProperties = config.httpProxy;
                    out.writeUTF(PROXY_SETTINGS_KEY);
                    out.writeUTF(config.proxySettings.toString());
                    out.writeUTF(PROXY_PAC_FILE);
                    out.writeUTF(proxyPacProperties.getPacFileUrl().toString());
                    written = true;
                    break;
                }
                case NONE: {
                    out.writeUTF(PROXY_SETTINGS_KEY);
                    out.writeUTF(config.proxySettings.toString());
                    written = true;
                    break;
                }
                case UNASSIGNED: {
                    break;
                }
                default: {
                    this.loge("Ignore invalid proxy settings while writing");
                }
            }
            if (written) {
                out.writeUTF(ID_KEY);
                out.writeInt(configKey);
            }
        }
        catch (NullPointerException e) {
            this.loge("Failure in writing " + config + e);
        }
        out.writeUTF(EOS);
        return written;
    }

    public void writeIpAndProxyConfigurations(String filePath, final SparseArray<IpConfiguration> networks) {
        this.mWriter.write(filePath, new DelayedDiskWrite.Writer(){

            @Override
            public void onWriteCalled(DataOutputStream out) throws IOException {
                out.writeInt(2);
                for (int i = 0; i < networks.size(); ++i) {
                    IpConfigStore.this.writeConfig(out, networks.keyAt(i), (IpConfiguration)networks.valueAt(i));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<IpConfiguration> readIpAndProxyConfigurations(String filePath) {
        SparseArray<IpConfiguration> networks = new SparseArray<IpConfiguration>();
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(filePath)));
            int version = ((DataInputStream)in).readInt();
            if (version != 2 && version != 1) {
                this.loge("Bad version on IP configuration file, ignore read");
                SparseArray<IpConfiguration> sparseArray = null;
                return sparseArray;
            }
            try {
                while (true) {
                    int id2 = -1;
                    IpConfiguration.IpAssignment ipAssignment = IpConfiguration.IpAssignment.DHCP;
                    IpConfiguration.ProxySettings proxySettings = IpConfiguration.ProxySettings.NONE;
                    StaticIpConfiguration staticIpConfiguration = new StaticIpConfiguration();
                    String proxyHost = null;
                    String pacFileUrl = null;
                    int proxyPort = -1;
                    String exclusionList = null;
                    while (true) {
                        String key = ((DataInputStream)in).readUTF();
                        try {
                            if (key.equals(ID_KEY)) {
                                id2 = ((DataInputStream)in).readInt();
                                continue;
                            }
                            if (key.equals(IP_ASSIGNMENT_KEY)) {
                                ipAssignment = IpConfiguration.IpAssignment.valueOf(((DataInputStream)in).readUTF());
                                continue;
                            }
                            if (key.equals(LINK_ADDRESS_KEY)) {
                                LinkAddress linkAddr = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                                if (linkAddr.getAddress() instanceof Inet4Address && staticIpConfiguration.ipAddress == null) {
                                    staticIpConfiguration.ipAddress = linkAddr;
                                    continue;
                                }
                                this.loge("Non-IPv4 or duplicate address: " + linkAddr);
                                continue;
                            }
                            if (key.equals(GATEWAY_KEY)) {
                                RouteInfo route;
                                LinkAddress dest = null;
                                InetAddress gateway = null;
                                if (version == 1) {
                                    gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                                    if (staticIpConfiguration.gateway == null) {
                                        staticIpConfiguration.gateway = gateway;
                                        continue;
                                    }
                                    this.loge("Duplicate gateway: " + gateway.getHostAddress());
                                    continue;
                                }
                                if (((DataInputStream)in).readInt() == 1) {
                                    dest = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                                }
                                if (((DataInputStream)in).readInt() == 1) {
                                    gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                                }
                                if ((route = new RouteInfo(dest, gateway)).isIPv4Default() && staticIpConfiguration.gateway == null) {
                                    staticIpConfiguration.gateway = gateway;
                                    continue;
                                }
                                this.loge("Non-IPv4 default or duplicate route: " + route);
                                continue;
                            }
                            if (key.equals(DNS_KEY)) {
                                staticIpConfiguration.dnsServers.add(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()));
                                continue;
                            }
                            if (key.equals(PROXY_SETTINGS_KEY)) {
                                proxySettings = IpConfiguration.ProxySettings.valueOf(((DataInputStream)in).readUTF());
                                continue;
                            }
                            if (key.equals(PROXY_HOST_KEY)) {
                                proxyHost = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(PROXY_PORT_KEY)) {
                                proxyPort = ((DataInputStream)in).readInt();
                                continue;
                            }
                            if (key.equals(PROXY_PAC_FILE)) {
                                pacFileUrl = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(EXCLUSION_LIST_KEY)) {
                                exclusionList = ((DataInputStream)in).readUTF();
                                continue;
                            }
                            if (key.equals(EOS)) break;
                            this.loge("Ignore unknown key " + key + "while reading");
                        }
                        catch (IllegalArgumentException e) {
                            this.loge("Ignore invalid address while reading" + e);
                        }
                    }
                    if (id2 != -1) {
                        IpConfiguration config = new IpConfiguration();
                        networks.put(id2, config);
                        switch (ipAssignment) {
                            case STATIC: {
                                config.staticIpConfiguration = staticIpConfiguration;
                                config.ipAssignment = ipAssignment;
                                break;
                            }
                            case DHCP: {
                                config.ipAssignment = ipAssignment;
                                break;
                            }
                            case UNASSIGNED: {
                                this.loge("BUG: Found UNASSIGNED IP on file, use DHCP");
                                config.ipAssignment = IpConfiguration.IpAssignment.DHCP;
                                break;
                            }
                            default: {
                                this.loge("Ignore invalid ip assignment while reading.");
                                config.ipAssignment = IpConfiguration.IpAssignment.UNASSIGNED;
                            }
                        }
                        switch (proxySettings) {
                            case STATIC: {
                                ProxyInfo proxyInfo = new ProxyInfo(proxyHost, proxyPort, exclusionList);
                                config.proxySettings = proxySettings;
                                config.httpProxy = proxyInfo;
                                break;
                            }
                            case PAC: {
                                ProxyInfo proxyPacProperties = new ProxyInfo(pacFileUrl);
                                config.proxySettings = proxySettings;
                                config.httpProxy = proxyPacProperties;
                                break;
                            }
                            case NONE: {
                                config.proxySettings = proxySettings;
                                break;
                            }
                            case UNASSIGNED: {
                                this.loge("BUG: Found UNASSIGNED proxy on file, use NONE");
                                config.proxySettings = IpConfiguration.ProxySettings.NONE;
                                break;
                            }
                            default: {
                                this.loge("Ignore invalid proxy settings while reading");
                                config.proxySettings = IpConfiguration.ProxySettings.UNASSIGNED;
                                break;
                            }
                        }
                        continue;
                    }
                    this.log("Missing id while parsing configuration");
                }
            }
            catch (EOFException ignore) {
            }
            catch (IOException e) {
                this.loge("Error parsing configuration: " + e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return networks;
    }

    protected void loge(String s) {
        Log.e(TAG, s);
    }

    protected void log(String s) {
        Log.d(TAG, s);
    }
}

