/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.util.AtomicFile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FileRotator;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.net.NetworkIdentitySet;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import libcore.io.IoUtils;

public class NetworkStatsCollection
implements FileRotator.Reader {
    private static final int FILE_MAGIC = 1095648596;
    private static final int VERSION_NETWORK_INIT = 1;
    private static final int VERSION_UID_INIT = 1;
    private static final int VERSION_UID_WITH_IDENT = 2;
    private static final int VERSION_UID_WITH_TAG = 3;
    private static final int VERSION_UID_WITH_SET = 4;
    private static final int VERSION_UNIFIED_INIT = 16;
    private HashMap<Key, NetworkStatsHistory> mStats = Maps.newHashMap();
    private final long mBucketDuration;
    private long mStartMillis;
    private long mEndMillis;
    private long mTotalBytes;
    private boolean mDirty;

    public NetworkStatsCollection(long bucketDuration) {
        this.mBucketDuration = bucketDuration;
        this.reset();
    }

    public void reset() {
        this.mStats.clear();
        this.mStartMillis = Long.MAX_VALUE;
        this.mEndMillis = Long.MIN_VALUE;
        this.mTotalBytes = 0L;
        this.mDirty = false;
    }

    public long getStartMillis() {
        return this.mStartMillis;
    }

    public long getFirstAtomicBucketMillis() {
        if (this.mStartMillis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.mStartMillis + this.mBucketDuration;
    }

    public long getEndMillis() {
        return this.mEndMillis;
    }

    public long getTotalBytes() {
        return this.mTotalBytes;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public void clearDirty() {
        this.mDirty = false;
    }

    public boolean isEmpty() {
        return this.mStartMillis == Long.MAX_VALUE && this.mEndMillis == Long.MIN_VALUE;
    }

    public NetworkStatsHistory getHistory(NetworkTemplate template, int uid, int set, int tag, int fields) {
        return this.getHistory(template, uid, set, tag, fields, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public NetworkStatsHistory getHistory(NetworkTemplate template, int uid, int set, int tag, int fields, long start, long end) {
        NetworkStatsHistory combined = new NetworkStatsHistory(this.mBucketDuration, this.estimateBuckets(), fields);
        for (Map.Entry<Key, NetworkStatsHistory> entry : this.mStats.entrySet()) {
            boolean setMatches;
            Key key = entry.getKey();
            boolean bl = setMatches = set == -1 || key.set == set;
            if (key.uid != uid || !setMatches || key.tag != tag || !NetworkStatsCollection.templateMatches(template, key.ident)) continue;
            combined.recordHistory(entry.getValue(), start, end);
        }
        return combined;
    }

    public NetworkStats getSummary(NetworkTemplate template, long start, long end) {
        long now = System.currentTimeMillis();
        NetworkStats stats = new NetworkStats(end - start, 24);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        NetworkStatsHistory.Entry historyEntry = null;
        if (start == end) {
            return stats;
        }
        for (Map.Entry<Key, NetworkStatsHistory> mapEntry : this.mStats.entrySet()) {
            Key key = mapEntry.getKey();
            if (!NetworkStatsCollection.templateMatches(template, key.ident)) continue;
            NetworkStatsHistory history = mapEntry.getValue();
            historyEntry = history.getValues(start, end, now, historyEntry);
            entry.iface = NetworkStats.IFACE_ALL;
            entry.uid = key.uid;
            entry.set = key.set;
            entry.tag = key.tag;
            entry.rxBytes = historyEntry.rxBytes;
            entry.rxPackets = historyEntry.rxPackets;
            entry.txBytes = historyEntry.txBytes;
            entry.txPackets = historyEntry.txPackets;
            entry.operations = historyEntry.operations;
            if (entry.isEmpty()) continue;
            stats.combineValues(entry);
        }
        return stats;
    }

    public void recordData(NetworkIdentitySet ident, int uid, int set, int tag, long start, long end, NetworkStats.Entry entry) {
        NetworkStatsHistory history = this.findOrCreateHistory(ident, uid, set, tag);
        history.recordData(start, end, entry);
        this.noteRecordedHistory(history.getStart(), history.getEnd(), entry.rxBytes + entry.txBytes);
    }

    private void recordHistory(Key key, NetworkStatsHistory history) {
        if (history.size() == 0) {
            return;
        }
        this.noteRecordedHistory(history.getStart(), history.getEnd(), history.getTotalBytes());
        NetworkStatsHistory target = this.mStats.get(key);
        if (target == null) {
            target = new NetworkStatsHistory(history.getBucketDuration());
            this.mStats.put(key, target);
        }
        target.recordEntireHistory(history);
    }

    public void recordCollection(NetworkStatsCollection another) {
        for (Map.Entry<Key, NetworkStatsHistory> entry : another.mStats.entrySet()) {
            this.recordHistory(entry.getKey(), entry.getValue());
        }
    }

    private NetworkStatsHistory findOrCreateHistory(NetworkIdentitySet ident, int uid, int set, int tag) {
        Key key = new Key(ident, uid, set, tag);
        NetworkStatsHistory existing = this.mStats.get(key);
        NetworkStatsHistory updated = null;
        if (existing == null) {
            updated = new NetworkStatsHistory(this.mBucketDuration, 10);
        } else if (existing.getBucketDuration() != this.mBucketDuration) {
            updated = new NetworkStatsHistory(existing, this.mBucketDuration);
        }
        if (updated != null) {
            this.mStats.put(key, updated);
            return updated;
        }
        return existing;
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.read(new DataInputStream(in));
    }

    public void read(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != 1095648596) {
            throw new ProtocolException("unexpected magic: " + magic);
        }
        int version = in.readInt();
        switch (version) {
            case 16: {
                int identSize = in.readInt();
                for (int i = 0; i < identSize; ++i) {
                    NetworkIdentitySet ident = new NetworkIdentitySet(in);
                    int size = in.readInt();
                    for (int j = 0; j < size; ++j) {
                        int uid = in.readInt();
                        int set = in.readInt();
                        int tag = in.readInt();
                        Key key = new Key(ident, uid, set, tag);
                        NetworkStatsHistory history = new NetworkStatsHistory(in);
                        this.recordHistory(key, history);
                    }
                }
                break;
            }
            default: {
                throw new ProtocolException("unexpected version: " + version);
            }
        }
    }

    public void write(DataOutputStream out) throws IOException {
        ArrayList keys;
        HashMap<NetworkIdentitySet, ArrayList> keysByIdent = Maps.newHashMap();
        for (Key key : this.mStats.keySet()) {
            keys = (ArrayList)keysByIdent.get(key.ident);
            if (keys == null) {
                keys = Lists.newArrayList();
                keysByIdent.put(key.ident, keys);
            }
            keys.add(key);
        }
        out.writeInt(1095648596);
        out.writeInt(16);
        out.writeInt(keysByIdent.size());
        for (NetworkIdentitySet ident : keysByIdent.keySet()) {
            keys = (ArrayList)keysByIdent.get(ident);
            ident.writeToStream(out);
            out.writeInt(keys.size());
            for (Key key : keys) {
                NetworkStatsHistory history = this.mStats.get(key);
                out.writeInt(key.uid);
                out.writeInt(key.set);
                out.writeInt(key.tag);
                history.writeToStream(out);
            }
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public void readLegacyNetwork(File file) throws IOException {
        AtomicFile inputFile = new AtomicFile(file);
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(inputFile.openRead()));
            int magic = in.readInt();
            if (magic != 1095648596) {
                throw new ProtocolException("unexpected magic: " + magic);
            }
            int version = in.readInt();
            switch (version) {
                case 1: {
                    int size = in.readInt();
                    for (int i = 0; i < size; ++i) {
                        NetworkIdentitySet ident = new NetworkIdentitySet(in);
                        NetworkStatsHistory history = new NetworkStatsHistory(in);
                        Key key = new Key(ident, -1, -1, 0);
                        this.recordHistory(key, history);
                    }
                    break;
                }
                default: {
                    throw new ProtocolException("unexpected version: " + version);
                }
            }
        }
        catch (FileNotFoundException e) {
            IoUtils.closeQuietly(in);
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void readLegacyUid(File file, boolean onlyTags) throws IOException {
        AtomicFile inputFile = new AtomicFile(file);
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(inputFile.openRead()));
            int magic = in.readInt();
            if (magic != 1095648596) {
                throw new ProtocolException("unexpected magic: " + magic);
            }
            int version = in.readInt();
            switch (version) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    int identSize = in.readInt();
                    for (int i = 0; i < identSize; ++i) {
                        NetworkIdentitySet ident = new NetworkIdentitySet(in);
                        int size = in.readInt();
                        for (int j = 0; j < size; ++j) {
                            int uid = in.readInt();
                            int set = version >= 4 ? in.readInt() : 0;
                            int tag = in.readInt();
                            Key key = new Key(ident, uid, set, tag);
                            NetworkStatsHistory history = new NetworkStatsHistory(in);
                            if (tag == 0 == onlyTags) continue;
                            this.recordHistory(key, history);
                        }
                    }
                    break;
                }
                default: {
                    throw new ProtocolException("unexpected version: " + version);
                }
            }
        }
        catch (FileNotFoundException e) {
            IoUtils.closeQuietly(in);
            return;
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    public void removeUids(int[] uids) {
        ArrayList<Key> knownKeys = Lists.newArrayList();
        knownKeys.addAll(this.mStats.keySet());
        for (Key key : knownKeys) {
            if (!ArrayUtils.contains(uids, key.uid)) continue;
            if (key.tag == 0) {
                NetworkStatsHistory uidHistory = this.mStats.get(key);
                NetworkStatsHistory removedHistory = this.findOrCreateHistory(key.ident, -4, 0, 0);
                removedHistory.recordEntireHistory(uidHistory);
            }
            this.mStats.remove(key);
            this.mDirty = true;
        }
    }

    private void noteRecordedHistory(long startMillis, long endMillis, long totalBytes) {
        if (startMillis < this.mStartMillis) {
            this.mStartMillis = startMillis;
        }
        if (endMillis > this.mEndMillis) {
            this.mEndMillis = endMillis;
        }
        this.mTotalBytes += totalBytes;
        this.mDirty = true;
    }

    private int estimateBuckets() {
        return (int)(Math.min(this.mEndMillis - this.mStartMillis, 3024000000L) / this.mBucketDuration);
    }

    public void dump(IndentingPrintWriter pw) {
        ArrayList<Key> keys = Lists.newArrayList();
        keys.addAll(this.mStats.keySet());
        Collections.sort(keys);
        for (Key key : keys) {
            pw.print("ident=");
            pw.print(key.ident.toString());
            pw.print(" uid=");
            pw.print(key.uid);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(key.set));
            pw.print(" tag=");
            pw.println(NetworkStats.tagToString(key.tag));
            NetworkStatsHistory history = this.mStats.get(key);
            pw.increaseIndent();
            history.dump(pw, true);
            pw.decreaseIndent();
        }
    }

    private static boolean templateMatches(NetworkTemplate template, NetworkIdentitySet identSet) {
        for (NetworkIdentity ident : identSet) {
            if (!template.matches(ident)) continue;
            return true;
        }
        return false;
    }

    private static class Key
    implements Comparable<Key> {
        public final NetworkIdentitySet ident;
        public final int uid;
        public final int set;
        public final int tag;
        private final int hashCode;

        public Key(NetworkIdentitySet ident, int uid, int set, int tag) {
            this.ident = ident;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
            this.hashCode = Objects.hash(ident, uid, set, tag);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.uid == key.uid && this.set == key.set && this.tag == key.tag && Objects.equals(this.ident, key.ident);
            }
            return false;
        }

        @Override
        public int compareTo(Key another) {
            return Integer.compare(this.uid, another.uid);
        }
    }
}

