/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.AlarmManager;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.LinkProperties;
import android.net.NetworkIdentity;
import android.net.NetworkState;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.MathUtils;
import android.util.NtpTrustedTime;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FileRotator;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.NetworkManagementSocketTagger;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.NetworkIdentitySet;
import com.android.server.net.NetworkStatsCollection;
import com.android.server.net.NetworkStatsRecorder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;

public class NetworkStatsService
extends INetworkStatsService.Stub {
    private static final String TAG = "NetworkStats";
    private static final boolean LOGV = false;
    private static final int MSG_PERFORM_POLL = 1;
    private static final int MSG_UPDATE_IFACES = 2;
    private static final int MSG_REGISTER_GLOBAL_ALERT = 3;
    private static final int FLAG_PERSIST_NETWORK = 1;
    private static final int FLAG_PERSIST_UID = 2;
    private static final int FLAG_PERSIST_ALL = 3;
    private static final int FLAG_PERSIST_FORCE = 256;
    private static final String TAG_NETSTATS_ERROR = "netstats_error";
    private final Context mContext;
    private final INetworkManagementService mNetworkManager;
    private final AlarmManager mAlarmManager;
    private final TrustedTime mTime;
    private final TelephonyManager mTeleManager;
    private final NetworkStatsSettings mSettings;
    private final File mSystemDir;
    private final File mBaseDir;
    private final PowerManager.WakeLock mWakeLock;
    private IConnectivityManager mConnManager;
    public static final String ACTION_NETWORK_STATS_POLL = "com.android.server.action.NETWORK_STATS_POLL";
    public static final String ACTION_NETWORK_STATS_UPDATED = "com.android.server.action.NETWORK_STATS_UPDATED";
    private PendingIntent mPollIntent;
    private static final String PREFIX_DEV = "dev";
    private static final String PREFIX_XT = "xt";
    private static final String PREFIX_UID = "uid";
    private static final String PREFIX_UID_TAG = "uid_tag";
    private final Object mStatsLock = new Object();
    private final ArrayMap<String, NetworkIdentitySet> mActiveIfaces = new ArrayMap();
    private final ArrayMap<String, NetworkIdentitySet> mActiveUidIfaces = new ArrayMap();
    private String mActiveIface;
    private String[] mMobileIfaces = new String[0];
    private final DropBoxNonMonotonicObserver mNonMonotonicObserver = new DropBoxNonMonotonicObserver();
    private NetworkStatsRecorder mDevRecorder;
    private NetworkStatsRecorder mXtRecorder;
    private NetworkStatsRecorder mUidRecorder;
    private NetworkStatsRecorder mUidTagRecorder;
    private NetworkStatsCollection mDevStatsCached;
    private NetworkStatsCollection mXtStatsCached;
    private SparseIntArray mActiveUidCounterSet = new SparseIntArray();
    private NetworkStats mUidOperations = new NetworkStats(0L, 10);
    private final Handler mHandler;
    private boolean mSystemReady;
    private long mPersistThreshold = 0x200000L;
    private long mGlobalAlertBytes;
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.updateIfaces();
        }
    };
    private BroadcastReceiver mTetherReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(1);
        }
    };
    private BroadcastReceiver mPollReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(3);
            NetworkStatsService.this.registerGlobalAlert();
        }
    };
    private BroadcastReceiver mRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.mWakeLock.acquire();
                try {
                    NetworkStatsService.this.removeUidsLocked(new int[]{uid});
                }
                finally {
                    NetworkStatsService.this.mWakeLock.release();
                }
            }
        }
    };
    private BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.mWakeLock.acquire();
                try {
                    NetworkStatsService.this.removeUserLocked(userId);
                }
                finally {
                    NetworkStatsService.this.mWakeLock.release();
                }
            }
        }
    };
    private BroadcastReceiver mShutdownReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.shutdownLocked();
            }
        }
    };
    private INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        @Override
        public void limitReached(String limitName, String iface) {
            NetworkStatsService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkStatsService.TAG);
            if ("globalAlert".equals(limitName)) {
                boolean flags = true;
                NetworkStatsService.this.mHandler.obtainMessage(1, 1, 0).sendToTarget();
                NetworkStatsService.this.mHandler.obtainMessage(3).sendToTarget();
            }
        }
    };
    private int mLastPhoneState = -1;
    private int mLastPhoneNetworkType = 0;
    private PhoneStateListener mPhoneListener = new PhoneStateListener(){

        @Override
        public void onDataConnectionStateChanged(int state, int networkType) {
            boolean networkTypeChanged;
            boolean stateChanged = state != NetworkStatsService.this.mLastPhoneState;
            boolean bl = networkTypeChanged = networkType != NetworkStatsService.this.mLastPhoneNetworkType;
            if (networkTypeChanged && !stateChanged) {
                NetworkStatsService.this.mHandler.sendMessageDelayed(NetworkStatsService.this.mHandler.obtainMessage(2), 1000L);
            }
            NetworkStatsService.this.mLastPhoneState = state;
            NetworkStatsService.this.mLastPhoneNetworkType = networkType;
        }
    };
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int flags = msg.arg1;
                    NetworkStatsService.this.performPoll(flags);
                    return true;
                }
                case 2: {
                    NetworkStatsService.this.updateIfaces();
                    return true;
                }
                case 3: {
                    NetworkStatsService.this.registerGlobalAlert();
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkStatsService(Context context, INetworkManagementService networkManager, IAlarmManager alarmManager) {
        this(context, networkManager, alarmManager, NtpTrustedTime.getInstance(context), NetworkStatsService.getDefaultSystemDir(), new DefaultNetworkStatsSettings(context));
    }

    private static File getDefaultSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkStatsService(Context context, INetworkManagementService networkManager, IAlarmManager alarmManager, TrustedTime time, File systemDir, NetworkStatsSettings settings) {
        this.mContext = Preconditions.checkNotNull(context, "missing Context");
        this.mNetworkManager = Preconditions.checkNotNull(networkManager, "missing INetworkManagementService");
        this.mTime = Preconditions.checkNotNull(time, "missing TrustedTime");
        this.mTeleManager = Preconditions.checkNotNull(TelephonyManager.getDefault(), "missing TelephonyManager");
        this.mSettings = Preconditions.checkNotNull(settings, "missing NetworkStatsSettings");
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, TAG);
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this.mHandlerCallback);
        this.mSystemDir = Preconditions.checkNotNull(systemDir);
        this.mBaseDir = new File(systemDir, "netstats");
        this.mBaseDir.mkdirs();
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = Preconditions.checkNotNull(connManager, "missing IConnectivityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        this.mSystemReady = true;
        if (!this.isBandwidthControlEnabled()) {
            Slog.w(TAG, "bandwidth controls disabled, unable to track stats");
            return;
        }
        this.mDevRecorder = this.buildRecorder(PREFIX_DEV, this.mSettings.getDevConfig(), false);
        this.mXtRecorder = this.buildRecorder(PREFIX_XT, this.mSettings.getXtConfig(), false);
        this.mUidRecorder = this.buildRecorder(PREFIX_UID, this.mSettings.getUidConfig(), false);
        this.mUidTagRecorder = this.buildRecorder(PREFIX_UID_TAG, this.mSettings.getUidTagConfig(), true);
        this.updatePersistThresholds();
        Object object = this.mStatsLock;
        synchronized (object) {
            this.maybeUpgradeLegacyStatsLocked();
            this.mDevStatsCached = this.mDevRecorder.getOrLoadCompleteLocked();
            this.mXtStatsCached = this.mXtRecorder.getOrLoadCompleteLocked();
            this.bootstrapStatsLocked();
        }
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter tetherFilter = new IntentFilter("android.net.conn.TETHER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mTetherReceiver, tetherFilter, null, this.mHandler);
        IntentFilter pollFilter = new IntentFilter(ACTION_NETWORK_STATS_POLL);
        this.mContext.registerReceiver(this.mPollReceiver, pollFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter removedFilter = new IntentFilter("android.intent.action.UID_REMOVED");
        this.mContext.registerReceiver(this.mRemovedReceiver, removedFilter, null, this.mHandler);
        IntentFilter userFilter = new IntentFilter("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        IntentFilter shutdownFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        this.mContext.registerReceiver(this.mShutdownReceiver, shutdownFilter);
        try {
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.registerPollAlarmLocked();
        this.registerGlobalAlert();
    }

    private NetworkStatsRecorder buildRecorder(String prefix, NetworkStatsSettings.Config config, boolean includeTags) {
        DropBoxManager dropBox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        return new NetworkStatsRecorder(new FileRotator(this.mBaseDir, prefix, config.rotateAgeMillis, config.deleteAgeMillis), this.mNonMonotonicObserver, dropBox, prefix, config.bucketDuration, includeTags);
    }

    private void shutdownLocked() {
        this.mContext.unregisterReceiver(this.mConnReceiver);
        this.mContext.unregisterReceiver(this.mTetherReceiver);
        this.mContext.unregisterReceiver(this.mPollReceiver);
        this.mContext.unregisterReceiver(this.mRemovedReceiver);
        this.mContext.unregisterReceiver(this.mShutdownReceiver);
        long currentTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        this.mDevRecorder.forcePersistLocked(currentTime);
        this.mXtRecorder.forcePersistLocked(currentTime);
        this.mUidRecorder.forcePersistLocked(currentTime);
        this.mUidTagRecorder.forcePersistLocked(currentTime);
        this.mDevRecorder = null;
        this.mXtRecorder = null;
        this.mUidRecorder = null;
        this.mUidTagRecorder = null;
        this.mDevStatsCached = null;
        this.mXtStatsCached = null;
        this.mSystemReady = false;
    }

    private void maybeUpgradeLegacyStatsLocked() {
        try {
            File file = new File(this.mSystemDir, "netstats.bin");
            if (file.exists()) {
                this.mDevRecorder.importLegacyNetworkLocked(file);
                file.delete();
            }
            if ((file = new File(this.mSystemDir, "netstats_xt.bin")).exists()) {
                file.delete();
            }
            if ((file = new File(this.mSystemDir, "netstats_uid.bin")).exists()) {
                this.mUidRecorder.importLegacyUidLocked(file);
                this.mUidTagRecorder.importLegacyUidLocked(file);
                file.delete();
            }
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem during legacy upgrade", e);
        }
        catch (OutOfMemoryError e) {
            Log.wtf(TAG, "problem during legacy upgrade", e);
        }
    }

    private void registerPollAlarmLocked() {
        if (this.mPollIntent != null) {
            this.mAlarmManager.cancel(this.mPollIntent);
        }
        this.mPollIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_NETWORK_STATS_POLL), 0);
        long currentRealtime = SystemClock.elapsedRealtime();
        this.mAlarmManager.setInexactRepeating(3, currentRealtime, this.mSettings.getPollInterval(), this.mPollIntent);
    }

    private void registerGlobalAlert() {
        try {
            this.mNetworkManager.setGlobalAlert(this.mGlobalAlertBytes);
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "problem registering for global alert: " + e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public INetworkStatsSession openSession() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        this.assertBandwidthControlEnabled();
        return new INetworkStatsSession.Stub(){
            private NetworkStatsCollection mUidComplete;
            private NetworkStatsCollection mUidTagComplete;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NetworkStatsCollection getUidComplete() {
                Object object = NetworkStatsService.this.mStatsLock;
                synchronized (object) {
                    if (this.mUidComplete == null) {
                        this.mUidComplete = NetworkStatsService.this.mUidRecorder.getOrLoadCompleteLocked();
                    }
                    return this.mUidComplete;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NetworkStatsCollection getUidTagComplete() {
                Object object = NetworkStatsService.this.mStatsLock;
                synchronized (object) {
                    if (this.mUidTagComplete == null) {
                        this.mUidTagComplete = NetworkStatsService.this.mUidTagRecorder.getOrLoadCompleteLocked();
                    }
                    return this.mUidTagComplete;
                }
            }

            @Override
            public NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end) {
                return NetworkStatsService.this.internalGetSummaryForNetwork(template, start, end);
            }

            @Override
            public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields) {
                return NetworkStatsService.this.internalGetHistoryForNetwork(template, fields);
            }

            @Override
            public NetworkStats getSummaryForAllUid(NetworkTemplate template, long start, long end, boolean includeTags) {
                NetworkStats stats = this.getUidComplete().getSummary(template, start, end);
                if (includeTags) {
                    NetworkStats tagStats = this.getUidTagComplete().getSummary(template, start, end);
                    stats.combineAllValues(tagStats);
                }
                return stats;
            }

            @Override
            public NetworkStatsHistory getHistoryForUid(NetworkTemplate template, int uid, int set, int tag, int fields) {
                if (tag == 0) {
                    return this.getUidComplete().getHistory(template, uid, set, tag, fields);
                }
                return this.getUidTagComplete().getHistory(template, uid, set, tag, fields);
            }

            @Override
            public void close() {
                this.mUidComplete = null;
                this.mUidTagComplete = null;
            }
        };
    }

    private NetworkStats internalGetSummaryForNetwork(NetworkTemplate template, long start, long end) {
        if (!this.mSettings.getReportXtOverDev()) {
            return this.mDevStatsCached.getSummary(template, start, end);
        }
        long firstAtomicBucket = this.mXtStatsCached.getFirstAtomicBucketMillis();
        NetworkStats dev = this.mDevStatsCached.getSummary(template, Math.min(start, firstAtomicBucket), Math.min(end, firstAtomicBucket));
        NetworkStats xt = this.mXtStatsCached.getSummary(template, Math.max(start, firstAtomicBucket), Math.max(end, firstAtomicBucket));
        xt.combineAllValues(dev);
        return xt;
    }

    private NetworkStatsHistory internalGetHistoryForNetwork(NetworkTemplate template, int fields) {
        if (!this.mSettings.getReportXtOverDev()) {
            return this.mDevStatsCached.getHistory(template, -1, -1, 0, fields);
        }
        long firstAtomicBucket = this.mXtStatsCached.getFirstAtomicBucketMillis();
        NetworkStatsHistory dev = this.mDevStatsCached.getHistory(template, -1, -1, 0, fields, Long.MIN_VALUE, firstAtomicBucket);
        NetworkStatsHistory xt = this.mXtStatsCached.getHistory(template, -1, -1, 0, fields, firstAtomicBucket, Long.MAX_VALUE);
        xt.recordEntireHistory(dev);
        return xt;
    }

    @Override
    public long getNetworkTotalBytes(NetworkTemplate template, long start, long end) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        this.assertBandwidthControlEnabled();
        return this.internalGetSummaryForNetwork(template, start, end).getTotalBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
        NetworkStats networkLayer;
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        }
        this.assertBandwidthControlEnabled();
        long token = Binder.clearCallingIdentity();
        try {
            networkLayer = this.mNetworkManager.getNetworkStatsUidDetail(uid);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        networkLayer.spliceOperationsFrom(this.mUidOperations);
        NetworkStats dataLayer = new NetworkStats(networkLayer.getElapsedRealtime(), networkLayer.size());
        NetworkStats.Entry entry = null;
        for (int i = 0; i < networkLayer.size(); ++i) {
            entry = networkLayer.getValues(i, entry);
            entry.iface = NetworkStats.IFACE_ALL;
            dataLayer.combineValues(entry);
        }
        return dataLayer;
    }

    @Override
    public String[] getMobileIfaces() {
        return this.mMobileIfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementOperationCount(int uid, int tag, int operationCount) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_NETWORK_ACCOUNTING", TAG);
        }
        if (operationCount < 0) {
            throw new IllegalArgumentException("operation count can only be incremented");
        }
        if (tag == 0) {
            throw new IllegalArgumentException("operation count must have specific tag");
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = this.mActiveUidCounterSet.get(uid, 0);
            this.mUidOperations.combineValues(this.mActiveIface, uid, set, tag, 0L, 0L, 0L, 0L, operationCount);
            this.mUidOperations.combineValues(this.mActiveIface, uid, set, 0, 0L, 0L, 0L, 0L, operationCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidForeground(int uid, boolean uidForeground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_NETWORK_ACCOUNTING", TAG);
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = uidForeground ? 1 : 0;
            int oldSet = this.mActiveUidCounterSet.get(uid, 0);
            if (oldSet != set) {
                this.mActiveUidCounterSet.put(uid, set);
                NetworkManagementSocketTagger.setKernelCounterSet(uid, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdate() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        this.assertBandwidthControlEnabled();
        long token = Binder.clearCallingIdentity();
        try {
            this.performPoll(3);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advisePersistThreshold(long thresholdBytes) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_NETWORK_ACCOUNTING", TAG);
        this.assertBandwidthControlEnabled();
        this.mPersistThreshold = MathUtils.constrain(thresholdBytes, 131072L, 0x200000L);
        long currentTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        Object object = this.mStatsLock;
        synchronized (object) {
            if (!this.mSystemReady) {
                return;
            }
            this.updatePersistThresholds();
            this.mDevRecorder.maybePersistLocked(currentTime);
            this.mXtRecorder.maybePersistLocked(currentTime);
            this.mUidRecorder.maybePersistLocked(currentTime);
            this.mUidTagRecorder.maybePersistLocked(currentTime);
        }
        this.registerGlobalAlert();
    }

    private void updatePersistThresholds() {
        this.mDevRecorder.setPersistThreshold(this.mSettings.getDevPersistBytes(this.mPersistThreshold));
        this.mXtRecorder.setPersistThreshold(this.mSettings.getXtPersistBytes(this.mPersistThreshold));
        this.mUidRecorder.setPersistThreshold(this.mSettings.getUidPersistBytes(this.mPersistThreshold));
        this.mUidTagRecorder.setPersistThreshold(this.mSettings.getUidTagPersistBytes(this.mPersistThreshold));
        this.mGlobalAlertBytes = this.mSettings.getGlobalAlertBytes(this.mPersistThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfaces() {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            try {
                this.updateIfacesLocked();
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    private void updateIfacesLocked() {
        LinkProperties activeLink;
        NetworkState[] states;
        if (!this.mSystemReady) {
            return;
        }
        this.performPollLocked(1);
        try {
            states = this.mConnManager.getAllNetworkState();
            activeLink = this.mConnManager.getActiveLinkProperties();
        }
        catch (RemoteException e) {
            return;
        }
        this.mActiveIface = activeLink != null ? activeLink.getInterfaceName() : null;
        this.mActiveIfaces.clear();
        this.mActiveUidIfaces.clear();
        ArraySet<String> mobileIfaces = new ArraySet<String>();
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            boolean isMobile = ConnectivityManager.isNetworkTypeMobile(state.networkInfo.getType());
            NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
            String baseIface = state.linkProperties.getInterfaceName();
            if (baseIface != null) {
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveIfaces, baseIface).add(ident);
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveUidIfaces, baseIface).add(ident);
                if (isMobile) {
                    mobileIfaces.add(baseIface);
                }
            }
            List<LinkProperties> stackedLinks = state.linkProperties.getStackedLinks();
            for (LinkProperties stackedLink : stackedLinks) {
                String stackedIface = stackedLink.getInterfaceName();
                if (stackedIface == null) continue;
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveUidIfaces, stackedIface).add(ident);
                if (!isMobile) continue;
                mobileIfaces.add(stackedIface);
            }
        }
        this.mMobileIfaces = mobileIfaces.toArray(new String[mobileIfaces.size()]);
    }

    private static <K> NetworkIdentitySet findOrCreateNetworkIdentitySet(ArrayMap<K, NetworkIdentitySet> map, K key) {
        NetworkIdentitySet ident = map.get(key);
        if (ident == null) {
            ident = new NetworkIdentitySet();
            map.put(key, ident);
        }
        return ident;
    }

    private void bootstrapStatsLocked() {
        long currentTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        try {
            NetworkStats uidSnapshot = this.getNetworkStatsUidDetail();
            NetworkStats xtSnapshot = this.mNetworkManager.getNetworkStatsSummaryXt();
            NetworkStats devSnapshot = this.mNetworkManager.getNetworkStatsSummaryDev();
            this.mDevRecorder.recordSnapshotLocked(devSnapshot, this.mActiveIfaces, currentTime);
            this.mXtRecorder.recordSnapshotLocked(xtSnapshot, this.mActiveIfaces, currentTime);
            this.mUidRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, currentTime);
            this.mUidTagRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, currentTime);
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "problem reading network stats: " + e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPoll(int flags) {
        if (this.mTime.getCacheAge() > this.mSettings.getTimeCacheMaxAge()) {
            this.mTime.forceRefresh();
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            try {
                this.performPollLocked(flags);
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    private void performPollLocked(int flags) {
        if (!this.mSystemReady) {
            return;
        }
        long startRealtime = SystemClock.elapsedRealtime();
        boolean persistNetwork = (flags & 1) != 0;
        boolean persistUid = (flags & 2) != 0;
        boolean persistForce = (flags & 0x100) != 0;
        long currentTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
        try {
            NetworkStats uidSnapshot = this.getNetworkStatsUidDetail();
            NetworkStats xtSnapshot = this.mNetworkManager.getNetworkStatsSummaryXt();
            NetworkStats devSnapshot = this.mNetworkManager.getNetworkStatsSummaryDev();
            this.mDevRecorder.recordSnapshotLocked(devSnapshot, this.mActiveIfaces, currentTime);
            this.mXtRecorder.recordSnapshotLocked(xtSnapshot, this.mActiveIfaces, currentTime);
            this.mUidRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, currentTime);
            this.mUidTagRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, currentTime);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem reading network stats", e);
            return;
        }
        catch (RemoteException e) {
            return;
        }
        if (persistForce) {
            this.mDevRecorder.forcePersistLocked(currentTime);
            this.mXtRecorder.forcePersistLocked(currentTime);
            this.mUidRecorder.forcePersistLocked(currentTime);
            this.mUidTagRecorder.forcePersistLocked(currentTime);
        } else {
            if (persistNetwork) {
                this.mDevRecorder.maybePersistLocked(currentTime);
                this.mXtRecorder.maybePersistLocked(currentTime);
            }
            if (persistUid) {
                this.mUidRecorder.maybePersistLocked(currentTime);
                this.mUidTagRecorder.maybePersistLocked(currentTime);
            }
        }
        if (this.mSettings.getSampleEnabled()) {
            this.performSampleLocked();
        }
        Intent updatedIntent = new Intent(ACTION_NETWORK_STATS_UPDATED);
        updatedIntent.setFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(updatedIntent, UserHandle.ALL, "android.permission.READ_NETWORK_USAGE_HISTORY");
    }

    private void performSampleLocked() {
        long trustedTime = this.mTime.hasCache() ? this.mTime.currentTimeMillis() : -1L;
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileWildcard();
        NetworkStats.Entry devTotal = this.mDevRecorder.getTotalSinceBootLocked(template);
        NetworkStats.Entry xtTotal = this.mXtRecorder.getTotalSinceBootLocked(template);
        NetworkStats.Entry uidTotal = this.mUidRecorder.getTotalSinceBootLocked(template);
        EventLogTags.writeNetstatsMobileSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, trustedTime);
        template = NetworkTemplate.buildTemplateWifiWildcard();
        devTotal = this.mDevRecorder.getTotalSinceBootLocked(template);
        xtTotal = this.mXtRecorder.getTotalSinceBootLocked(template);
        uidTotal = this.mUidRecorder.getTotalSinceBootLocked(template);
        EventLogTags.writeNetstatsWifiSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, trustedTime);
    }

    private void removeUidsLocked(int ... uids) {
        this.performPollLocked(3);
        this.mUidRecorder.removeUidsLocked(uids);
        this.mUidTagRecorder.removeUidsLocked(uids);
        for (int uid : uids) {
            NetworkManagementSocketTagger.resetKernelUidStats(uid);
        }
    }

    private void removeUserLocked(int userId) {
        int[] uids = new int[]{};
        List<ApplicationInfo> apps = this.mContext.getPackageManager().getInstalledApplications(8704);
        for (ApplicationInfo app : apps) {
            int uid = UserHandle.getUid(userId, app.uid);
            uids = ArrayUtils.appendInt(uids, uid);
        }
        this.removeUidsLocked(uids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        HashSet<String> argSet = new HashSet<String>();
        for (String arg : args) {
            argSet.add(arg);
        }
        boolean poll = argSet.contains("--poll") || argSet.contains("poll");
        boolean checkin = argSet.contains("--checkin");
        boolean fullHistory = argSet.contains("--full") || argSet.contains("full");
        boolean includeUid = argSet.contains("--uid") || argSet.contains("detail");
        boolean includeTag = argSet.contains("--tag") || argSet.contains("detail");
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        Object object = this.mStatsLock;
        synchronized (object) {
            int i;
            if (poll) {
                this.performPollLocked(259);
                pw.println("Forced poll");
                return;
            }
            if (checkin) {
                pw.println("Current files:");
                pw.increaseIndent();
                for (String file : this.mBaseDir.list()) {
                    pw.println(file);
                }
                pw.decreaseIndent();
                return;
            }
            pw.println("Active interfaces:");
            pw.increaseIndent();
            for (i = 0; i < this.mActiveIfaces.size(); ++i) {
                pw.printPair("iface", this.mActiveIfaces.keyAt(i));
                pw.printPair("ident", this.mActiveIfaces.valueAt(i));
                pw.println();
            }
            pw.decreaseIndent();
            pw.println("Active UID interfaces:");
            pw.increaseIndent();
            for (i = 0; i < this.mActiveUidIfaces.size(); ++i) {
                pw.printPair("iface", this.mActiveUidIfaces.keyAt(i));
                pw.printPair("ident", this.mActiveUidIfaces.valueAt(i));
                pw.println();
            }
            pw.decreaseIndent();
            pw.println("Dev stats:");
            pw.increaseIndent();
            this.mDevRecorder.dumpLocked(pw, fullHistory);
            pw.decreaseIndent();
            pw.println("Xt stats:");
            pw.increaseIndent();
            this.mXtRecorder.dumpLocked(pw, fullHistory);
            pw.decreaseIndent();
            if (includeUid) {
                pw.println("UID stats:");
                pw.increaseIndent();
                this.mUidRecorder.dumpLocked(pw, fullHistory);
                pw.decreaseIndent();
            }
            if (includeTag) {
                pw.println("UID tag stats:");
                pw.increaseIndent();
                this.mUidTagRecorder.dumpLocked(pw, fullHistory);
                pw.decreaseIndent();
            }
        }
    }

    private NetworkStats getNetworkStatsUidDetail() throws RemoteException {
        NetworkStats uidSnapshot = this.mNetworkManager.getNetworkStatsUidDetail(-1);
        NetworkStats tetherSnapshot = this.getNetworkStatsTethering();
        uidSnapshot.combineAllValues(tetherSnapshot);
        uidSnapshot.combineAllValues(this.mUidOperations);
        return uidSnapshot;
    }

    private NetworkStats getNetworkStatsTethering() throws RemoteException {
        try {
            return this.mNetworkManager.getNetworkStatsTethering();
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem reading network stats", e);
            return new NetworkStats(0L, 10);
        }
    }

    private void assertBandwidthControlEnabled() {
        if (!this.isBandwidthControlEnabled()) {
            throw new IllegalStateException("Bandwidth module disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mNetworkManager.isBandwidthControlEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static class DefaultNetworkStatsSettings
    implements NetworkStatsSettings {
        private final ContentResolver mResolver;

        public DefaultNetworkStatsSettings(Context context) {
            this.mResolver = Preconditions.checkNotNull(context.getContentResolver());
        }

        private long getGlobalLong(String name, long def) {
            return Settings.Global.getLong(this.mResolver, name, def);
        }

        private boolean getGlobalBoolean(String name, boolean def) {
            int defInt = def ? 1 : 0;
            return Settings.Global.getInt(this.mResolver, name, defInt) != 0;
        }

        @Override
        public long getPollInterval() {
            return this.getGlobalLong("netstats_poll_interval", 1800000L);
        }

        @Override
        public long getTimeCacheMaxAge() {
            return this.getGlobalLong("netstats_time_cache_max_age", 86400000L);
        }

        @Override
        public long getGlobalAlertBytes(long def) {
            return this.getGlobalLong("netstats_global_alert_bytes", def);
        }

        @Override
        public boolean getSampleEnabled() {
            return this.getGlobalBoolean("netstats_sample_enabled", true);
        }

        @Override
        public boolean getReportXtOverDev() {
            return this.getGlobalBoolean("netstats_report_xt_over_dev", true);
        }

        @Override
        public NetworkStatsSettings.Config getDevConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_dev_bucket_duration", 3600000L), this.getGlobalLong("netstats_dev_rotate_age", 1296000000L), this.getGlobalLong("netstats_dev_delete_age", 7776000000L));
        }

        @Override
        public NetworkStatsSettings.Config getXtConfig() {
            return this.getDevConfig();
        }

        @Override
        public NetworkStatsSettings.Config getUidConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_uid_bucket_duration", 0x6DDD00L), this.getGlobalLong("netstats_uid_rotate_age", 1296000000L), this.getGlobalLong("netstats_uid_delete_age", 7776000000L));
        }

        @Override
        public NetworkStatsSettings.Config getUidTagConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_uid_tag_bucket_duration", 0x6DDD00L), this.getGlobalLong("netstats_uid_tag_rotate_age", 432000000L), this.getGlobalLong("netstats_uid_tag_delete_age", 1296000000L));
        }

        @Override
        public long getDevPersistBytes(long def) {
            return this.getGlobalLong("netstats_dev_persist_bytes", def);
        }

        @Override
        public long getXtPersistBytes(long def) {
            return this.getDevPersistBytes(def);
        }

        @Override
        public long getUidPersistBytes(long def) {
            return this.getGlobalLong("netstats_uid_persist_bytes", def);
        }

        @Override
        public long getUidTagPersistBytes(long def) {
            return this.getGlobalLong("netstats_uid_tag_persist_bytes", def);
        }
    }

    private class DropBoxNonMonotonicObserver
    implements NetworkStats.NonMonotonicObserver<String> {
        private DropBoxNonMonotonicObserver() {
        }

        @Override
        public void foundNonMonotonic(NetworkStats left, int leftIndex, NetworkStats right, int rightIndex, String cookie) {
            Log.w(NetworkStatsService.TAG, "found non-monotonic values; saving to dropbox");
            StringBuilder builder = new StringBuilder();
            builder.append("found non-monotonic " + cookie + " values at left[" + leftIndex + "] - right[" + rightIndex + "]\n");
            builder.append("left=").append(left).append('\n');
            builder.append("right=").append(right).append('\n');
            DropBoxManager dropBox = (DropBoxManager)NetworkStatsService.this.mContext.getSystemService("dropbox");
            dropBox.addText(NetworkStatsService.TAG_NETSTATS_ERROR, builder.toString());
        }
    }

    public static interface NetworkStatsSettings {
        public long getPollInterval();

        public long getTimeCacheMaxAge();

        public boolean getSampleEnabled();

        public boolean getReportXtOverDev();

        public Config getDevConfig();

        public Config getXtConfig();

        public Config getUidConfig();

        public Config getUidTagConfig();

        public long getGlobalAlertBytes(long var1);

        public long getDevPersistBytes(long var1);

        public long getXtPersistBytes(long var1);

        public long getUidPersistBytes(long var1);

        public long getUidTagPersistBytes(long var1);

        public static class Config {
            public final long bucketDuration;
            public final long rotateAgeMillis;
            public final long deleteAgeMillis;

            public Config(long bucketDuration, long rotateAgeMillis, long deleteAgeMillis) {
                this.bucketDuration = bucketDuration;
                this.rotateAgeMillis = rotateAgeMillis;
                this.deleteAgeMillis = deleteAgeMillis;
            }
        }
    }
}

