/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.service.notification.Condition;
import android.service.notification.IConditionListener;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.notification.CountdownConditionProvider;
import com.android.server.notification.DowntimeConditionProvider;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class ConditionProviders
extends ManagedServices {
    private static final Condition[] NO_CONDITIONS = new Condition[0];
    private final ZenModeHelper mZenModeHelper;
    private final ArrayMap<IBinder, IConditionListener> mListeners = new ArrayMap();
    private final ArrayList<ConditionRecord> mRecords = new ArrayList();
    private final CountdownConditionProvider mCountdown = new CountdownConditionProvider();
    private final DowntimeConditionProvider mDowntime = new DowntimeConditionProvider();
    private Condition mExitCondition;
    private ComponentName mExitConditionComponent;

    public ConditionProviders(Context context, Handler handler, ManagedServices.UserProfiles userProfiles, ZenModeHelper zenModeHelper) {
        super(context, handler, new Object(), userProfiles);
        this.mZenModeHelper = zenModeHelper;
        this.mZenModeHelper.addCallback(new ZenModeHelperCallback());
        this.loadZenConfig();
    }

    @Override
    protected ManagedServices.Config getConfig() {
        ManagedServices.Config c = new ManagedServices.Config();
        c.caption = "condition provider";
        c.serviceInterface = "android.service.notification.ConditionProviderService";
        c.secureSettingName = "enabled_condition_providers";
        c.bindPermission = "android.permission.BIND_CONDITION_PROVIDER_SERVICE";
        c.settingsAction = "android.settings.ACTION_CONDITION_PROVIDER_SETTINGS";
        c.clientLabel = 17040696;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        super.dump(pw, filter);
        Object object = this.mMutex;
        synchronized (object) {
            int i;
            if (filter == null) {
                pw.print("    mListeners(");
                pw.print(this.mListeners.size());
                pw.println("):");
                for (i = 0; i < this.mListeners.size(); ++i) {
                    pw.print("      ");
                    pw.println(this.mListeners.keyAt(i));
                }
            }
            pw.print("    mRecords(");
            pw.print(this.mRecords.size());
            pw.println("):");
            for (i = 0; i < this.mRecords.size(); ++i) {
                ConditionRecord r = this.mRecords.get(i);
                if (filter != null && !filter.matches(r.component)) continue;
                pw.print("      ");
                pw.println(r);
                String countdownDesc = CountdownConditionProvider.tryParseDescription(r.id);
                if (countdownDesc == null) continue;
                pw.print("        (");
                pw.print(countdownDesc);
                pw.println(")");
            }
        }
        this.mCountdown.dump(pw, filter);
        this.mDowntime.dump(pw, filter);
    }

    @Override
    protected IInterface asInterface(IBinder binder) {
        return IConditionProvider.Stub.asInterface(binder);
    }

    @Override
    public void onBootPhaseAppsCanStart() {
        super.onBootPhaseAppsCanStart();
        this.mCountdown.attachBase(this.mContext);
        this.registerService(this.mCountdown.asInterface(), CountdownConditionProvider.COMPONENT, 0);
        this.mDowntime.attachBase(this.mContext);
        this.registerService(this.mDowntime.asInterface(), DowntimeConditionProvider.COMPONENT, 0);
        this.mDowntime.setCallback(new DowntimeCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
        Slog.d(this.TAG, "onServiceAdded " + info);
        IConditionProvider provider = ConditionProviders.provider(info);
        try {
            provider.onConnected();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.mMutex;
        synchronized (object) {
            if (info.component.equals(this.mExitConditionComponent)) {
                ConditionRecord manualRecord = this.getRecordLocked(this.mExitCondition.id, this.mExitConditionComponent);
                manualRecord.isManual = true;
            }
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                ConditionRecord r = this.mRecords.get(i);
                if (!r.component.equals(info.component)) continue;
                r.info = info;
                if (!r.isAutomatic && !r.isManual) continue;
                this.subscribeLocked(r);
            }
        }
    }

    @Override
    protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
        if (removed == null) {
            return;
        }
        for (int i = this.mRecords.size() - 1; i >= 0; --i) {
            ConditionRecord r = this.mRecords.get(i);
            if (!r.component.equals(removed.component)) continue;
            if (r.isManual) {
                this.mZenModeHelper.setZenMode(0, "manualServiceRemoved");
            }
            if (r.isAutomatic) {
                this.mZenModeHelper.setZenMode(0, "automaticServiceRemoved");
            }
            this.mRecords.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedServices.ManagedServiceInfo checkServiceToken(IConditionProvider provider) {
        Object object = this.mMutex;
        synchronized (object) {
            return this.checkServiceTokenLocked(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestZenModeConditions(IConditionListener callback, int relevance) {
        Object object = this.mMutex;
        synchronized (object) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "requestZenModeConditions callback=" + callback + " relevance=" + Condition.relevanceToString(relevance));
            }
            if (callback == null) {
                return;
            }
            if ((relevance &= 3) != 0) {
                this.mListeners.put(callback.asBinder(), callback);
                this.requestConditionsLocked(relevance);
            } else {
                this.mListeners.remove(callback.asBinder());
                if (this.mListeners.isEmpty()) {
                    this.requestConditionsLocked(0);
                }
            }
        }
    }

    private Condition[] validateConditions(String pkg, Condition[] conditions) {
        if (conditions == null || conditions.length == 0) {
            return null;
        }
        int N = conditions.length;
        ArrayMap<Uri, Condition> valid = new ArrayMap<Uri, Condition>(N);
        for (int i = 0; i < N; ++i) {
            Uri id2 = conditions[i].id;
            if (!Condition.isValidId(id2, pkg)) {
                Slog.w(this.TAG, "Ignoring condition from " + pkg + " for invalid id: " + id2);
                continue;
            }
            if (valid.containsKey(id2)) {
                Slog.w(this.TAG, "Ignoring condition from " + pkg + " for duplicate id: " + id2);
                continue;
            }
            valid.put(id2, conditions[i]);
        }
        if (valid.size() == 0) {
            return null;
        }
        if (valid.size() == N) {
            return conditions;
        }
        Condition[] rt = new Condition[valid.size()];
        for (int i = 0; i < rt.length; ++i) {
            rt[i] = (Condition)valid.valueAt(i);
        }
        return rt;
    }

    private ConditionRecord getRecordLocked(Uri id2, ComponentName component) {
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            ConditionRecord r = this.mRecords.get(i);
            if (!r.id.equals(id2) || !r.component.equals(component)) continue;
            return r;
        }
        ConditionRecord r = new ConditionRecord(id2, component);
        this.mRecords.add(r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConditions(String pkg, ManagedServices.ManagedServiceInfo info, Condition[] conditions) {
        Object object = this.mMutex;
        synchronized (object) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "notifyConditions pkg=" + pkg + " info=" + info + " conditions=" + (conditions == null ? null : Arrays.asList(conditions)));
            }
            if ((conditions = this.validateConditions(pkg, conditions)) == null || conditions.length == 0) {
                return;
            }
            int N = conditions.length;
            for (IConditionListener listener : this.mListeners.values()) {
                try {
                    listener.onConditionsReceived(conditions);
                }
                catch (RemoteException e) {
                    Slog.w(this.TAG, "Error sending conditions to listener " + listener, e);
                }
            }
            for (int i = 0; i < N; ++i) {
                boolean failed;
                Condition c = conditions[i];
                ConditionRecord r = this.getRecordLocked(c.id, info.component);
                r.info = info;
                r.condition = c;
                if (r.isManual && (c.state == 0 || c.state == 3)) {
                    boolean bl = failed = c.state == 3;
                    if (failed) {
                        Slog.w(this.TAG, "Exit zen: manual condition failed: " + c);
                    } else if (this.DEBUG) {
                        Slog.d(this.TAG, "Exit zen: manual condition false: " + c);
                    }
                    this.mZenModeHelper.setZenMode(0, "manualConditionExit");
                    this.unsubscribeLocked(r);
                    r.isManual = false;
                }
                if (!r.isAutomatic) continue;
                if (c.state == 0 || c.state == 3) {
                    boolean bl = failed = c.state == 3;
                    if (failed) {
                        Slog.w(this.TAG, "Exit zen: automatic condition failed: " + c);
                    } else if (this.DEBUG) {
                        Slog.d(this.TAG, "Exit zen: automatic condition false: " + c);
                    }
                    this.mZenModeHelper.setZenMode(0, "automaticConditionExit");
                    continue;
                }
                if (c.state != 1) continue;
                Slog.d(this.TAG, "Enter zen: automatic condition true: " + c);
                this.mZenModeHelper.setZenMode(1, "automaticConditionEnter");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZenModeCondition(Condition condition, String reason) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "setZenModeCondition " + condition);
        }
        Object object = this.mMutex;
        synchronized (object) {
            ComponentName conditionComponent = null;
            if (condition != null) {
                ConditionRecord r;
                if (ZenModeConfig.isValidCountdownConditionId(condition.id)) {
                    r = this.getRecordLocked(condition.id, CountdownConditionProvider.COMPONENT);
                    if (r.info == null) {
                        r.info = this.checkServiceTokenLocked(this.mCountdown.asInterface());
                    }
                }
                if (ZenModeConfig.isValidDowntimeConditionId(condition.id)) {
                    r = this.getRecordLocked(condition.id, DowntimeConditionProvider.COMPONENT);
                    if (r.info == null) {
                        r.info = this.checkServiceTokenLocked(this.mDowntime.asInterface());
                    }
                }
            }
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                boolean idEqual;
                ConditionRecord r = this.mRecords.get(i);
                boolean bl = idEqual = condition != null && r.id.equals(condition.id);
                if (r.isManual && !idEqual) {
                    this.unsubscribeLocked(r);
                    r.isManual = false;
                } else if (idEqual && !r.isManual) {
                    this.subscribeLocked(r);
                    r.isManual = true;
                }
                if (!idEqual) continue;
                conditionComponent = r.component;
            }
            if (!Objects.equals(this.mExitCondition, condition)) {
                this.mExitCondition = condition;
                this.mExitConditionComponent = conditionComponent;
                ZenLog.traceExitCondition(this.mExitCondition, this.mExitConditionComponent, reason);
                this.saveZenConfigLocked();
            }
        }
    }

    private void subscribeLocked(ConditionRecord r) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "subscribeLocked " + r);
        }
        IConditionProvider provider = ConditionProviders.provider(r);
        RemoteException re = null;
        if (provider != null) {
            try {
                Slog.d(this.TAG, "Subscribing to " + r.id + " with " + provider);
                provider.onSubscribe(r.id);
            }
            catch (RemoteException e) {
                Slog.w(this.TAG, "Error subscribing to " + r, e);
                re = e;
            }
        }
        ZenLog.traceSubscribe(r != null ? r.id : null, provider, re);
    }

    private static <T> ArraySet<T> safeSet(T ... items) {
        ArraySet<T> rt = new ArraySet<T>();
        if (items == null || items.length == 0) {
            return rt;
        }
        for (T item : items) {
            if (item == null) continue;
            rt.add(item);
        }
        return rt;
    }

    public void setAutomaticZenModeConditions(Uri[] conditionIds) {
        this.setAutomaticZenModeConditions(conditionIds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAutomaticZenModeConditions(Uri[] conditionIds, boolean save) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "setAutomaticZenModeConditions " + (conditionIds == null ? null : Arrays.asList(conditionIds)));
        }
        Object object = this.mMutex;
        synchronized (object) {
            ArraySet<Uri> newIds = ConditionProviders.safeSet(conditionIds);
            int N = this.mRecords.size();
            boolean changed = false;
            for (int i = 0; i < N; ++i) {
                ConditionRecord r = this.mRecords.get(i);
                boolean automatic = newIds.contains(r.id);
                if (!r.isAutomatic && automatic) {
                    this.subscribeLocked(r);
                    r.isAutomatic = true;
                    changed = true;
                    continue;
                }
                if (!r.isAutomatic || automatic) continue;
                this.unsubscribeLocked(r);
                r.isAutomatic = false;
                changed = true;
            }
            if (save && changed) {
                this.saveZenConfigLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Condition[] getAutomaticZenModeConditions() {
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mRecords.size();
            ArrayList<Condition> rt = null;
            for (int i = 0; i < N; ++i) {
                ConditionRecord r = this.mRecords.get(i);
                if (!r.isAutomatic || r.condition == null) continue;
                if (rt == null) {
                    rt = new ArrayList<Condition>();
                }
                rt.add(r.condition);
            }
            return rt == null ? NO_CONDITIONS : rt.toArray(new Condition[rt.size()]);
        }
    }

    private void unsubscribeLocked(ConditionRecord r) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "unsubscribeLocked " + r);
        }
        IConditionProvider provider = ConditionProviders.provider(r);
        RemoteException re = null;
        if (provider != null) {
            try {
                provider.onUnsubscribe(r.id);
            }
            catch (RemoteException e) {
                Slog.w(this.TAG, "Error unsubscribing to " + r, e);
                re = e;
            }
        }
        ZenLog.traceUnsubscribe(r != null ? r.id : null, provider, re);
    }

    private static IConditionProvider provider(ConditionRecord r) {
        return r == null ? null : ConditionProviders.provider(r.info);
    }

    private static IConditionProvider provider(ManagedServices.ManagedServiceInfo info) {
        return info == null ? null : (IConditionProvider)info.service;
    }

    private void requestConditionsLocked(int flags) {
        for (ManagedServices.ManagedServiceInfo info : this.mServices) {
            IConditionProvider provider = ConditionProviders.provider(info);
            if (provider == null) continue;
            for (int i = this.mRecords.size() - 1; i >= 0; --i) {
                ConditionRecord r = this.mRecords.get(i);
                if (r.info != info || r.isManual || r.isAutomatic) continue;
                this.mRecords.remove(i);
            }
            try {
                provider.onRequestConditions(flags);
            }
            catch (RemoteException e) {
                Slog.w(this.TAG, "Error requesting conditions from " + info.component, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadZenConfig() {
        ZenModeConfig config = this.mZenModeHelper.getConfig();
        if (config == null) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "loadZenConfig: no config");
            }
            return;
        }
        Object object = this.mMutex;
        synchronized (object) {
            boolean changingExit = !Objects.equals(this.mExitCondition, config.exitCondition);
            this.mExitCondition = config.exitCondition;
            this.mExitConditionComponent = config.exitConditionComponent;
            if (changingExit) {
                ZenLog.traceExitCondition(this.mExitCondition, this.mExitConditionComponent, "config");
            }
            this.mDowntime.setConfig(config);
            if (config.conditionComponents == null || config.conditionIds == null || config.conditionComponents.length != config.conditionIds.length) {
                if (this.DEBUG) {
                    Slog.d(this.TAG, "loadZenConfig: no conditions");
                }
                this.setAutomaticZenModeConditions(null, false);
                return;
            }
            ArraySet<Uri> newIds = new ArraySet<Uri>();
            int N = config.conditionComponents.length;
            for (int i = 0; i < N; ++i) {
                ComponentName component = config.conditionComponents[i];
                Uri id2 = config.conditionIds[i];
                if (component == null || id2 == null) continue;
                this.getRecordLocked(id2, component);
                newIds.add(id2);
            }
            if (this.DEBUG) {
                Slog.d(this.TAG, "loadZenConfig: N=" + N);
            }
            this.setAutomaticZenModeConditions(newIds.toArray(new Uri[newIds.size()]), false);
        }
    }

    private void saveZenConfigLocked() {
        ZenModeConfig config = this.mZenModeHelper.getConfig();
        if (config == null) {
            return;
        }
        config = config.copy();
        ArrayList<ConditionRecord> automatic = new ArrayList<ConditionRecord>();
        int automaticN = this.mRecords.size();
        for (int i = 0; i < automaticN; ++i) {
            ConditionRecord r = this.mRecords.get(i);
            if (!r.isAutomatic) continue;
            automatic.add(r);
        }
        if (automatic.isEmpty()) {
            config.conditionComponents = null;
            config.conditionIds = null;
        } else {
            int N = automatic.size();
            config.conditionComponents = new ComponentName[N];
            config.conditionIds = new Uri[N];
            for (int i = 0; i < N; ++i) {
                ConditionRecord r = (ConditionRecord)automatic.get(i);
                config.conditionComponents[i] = r.component;
                config.conditionIds[i] = r.id;
            }
        }
        config.exitCondition = this.mExitCondition;
        config.exitConditionComponent = this.mExitConditionComponent;
        if (this.DEBUG) {
            Slog.d(this.TAG, "Setting zen config to: " + config);
        }
        this.mZenModeHelper.setConfig(config);
    }

    private static class ConditionRecord {
        public final Uri id;
        public final ComponentName component;
        public Condition condition;
        public ManagedServices.ManagedServiceInfo info;
        public boolean isAutomatic;
        public boolean isManual;

        private ConditionRecord(Uri id2, ComponentName component) {
            this.id = id2;
            this.component = component;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ConditionRecord[id=").append(this.id).append(",component=").append(this.component);
            if (this.isAutomatic) {
                sb.append(",automatic");
            }
            if (this.isManual) {
                sb.append(",manual");
            }
            return sb.append(']').toString();
        }
    }

    private class DowntimeCallback
    implements DowntimeConditionProvider.Callback {
        private DowntimeCallback() {
        }

        @Override
        public void onDowntimeChanged(boolean inDowntime) {
            int mode = ConditionProviders.this.mZenModeHelper.getZenMode();
            ZenModeConfig config = ConditionProviders.this.mZenModeHelper.getConfig();
            if (inDowntime && mode == 0 && config != null) {
                Condition condition = ConditionProviders.this.mDowntime.createCondition(config.toDowntimeInfo(), 1);
                ConditionProviders.this.mZenModeHelper.setZenMode(1, "downtimeEnter");
                ConditionProviders.this.setZenModeCondition(condition, "downtime");
            }
            if (!inDowntime && ConditionProviders.this.mDowntime.isDowntimeCondition(ConditionProviders.this.mExitCondition) && (mode == 1 || mode == 2)) {
                ConditionProviders.this.mZenModeHelper.setZenMode(0, "downtimeExit");
            }
        }
    }

    private class ZenModeHelperCallback
    extends ZenModeHelper.Callback {
        private ZenModeHelperCallback() {
        }

        @Override
        void onConfigChanged() {
            ConditionProviders.this.loadZenConfig();
        }

        @Override
        void onZenModeChanged() {
            int mode = ConditionProviders.this.mZenModeHelper.getZenMode();
            if (mode == 0) {
                ConditionProviders.this.setZenModeCondition(null, "zenOff");
            }
        }
    }
}

