/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.notification.NotificationManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ManagedServices {
    protected final String TAG = this.getClass().getSimpleName();
    protected final boolean DEBUG = Log.isLoggable(this.TAG, 3);
    private static final String ENABLED_SERVICES_SEPARATOR = ":";
    protected final Context mContext;
    protected final Object mMutex;
    private final UserProfiles mUserProfiles;
    private final SettingsObserver mSettingsObserver;
    private final Config mConfig;
    protected final ArrayList<ManagedServiceInfo> mServices = new ArrayList();
    private final ArrayList<String> mServicesBinding = new ArrayList();
    private ArraySet<ComponentName> mEnabledServicesForCurrentProfiles = new ArraySet();
    private ArraySet<String> mEnabledServicesPackageNames = new ArraySet();
    private int[] mLastSeenProfileIds;

    public ManagedServices(Context context, Handler handler, Object mutex, UserProfiles userProfiles) {
        this.mContext = context;
        this.mMutex = mutex;
        this.mUserProfiles = userProfiles;
        this.mConfig = this.getConfig();
        this.mSettingsObserver = new SettingsObserver(handler);
    }

    protected abstract Config getConfig();

    private String getCaption() {
        return this.mConfig.caption;
    }

    protected abstract IInterface asInterface(IBinder var1);

    protected abstract void onServiceAdded(ManagedServiceInfo var1);

    protected void onServiceRemovedLocked(ManagedServiceInfo removed) {
    }

    private ManagedServiceInfo newServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
        return new ManagedServiceInfo(service, component, userid, isSystem, connection, targetSdkVersion);
    }

    public void onBootPhaseAppsCanStart() {
        this.mSettingsObserver.observe();
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    All " + this.getCaption() + "s (" + this.mEnabledServicesForCurrentProfiles.size() + ") enabled for current profiles:");
        for (ComponentName cmpt : this.mEnabledServicesForCurrentProfiles) {
            if (filter != null && !filter.matches(cmpt)) continue;
            pw.println("      " + cmpt);
        }
        pw.println("    Live " + this.getCaption() + "s (" + this.mServices.size() + "):");
        for (ManagedServiceInfo info : this.mServices) {
            if (filter != null && !filter.matches(info.component)) continue;
            pw.println("      " + info.component + " (user " + info.userid + "): " + info.service + (info.isSystem ? " SYSTEM" : ""));
        }
    }

    public void onPackagesChanged(boolean queryReplace, String[] pkgList) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onPackagesChanged queryReplace=" + queryReplace + " pkgList=" + (pkgList == null ? null : Arrays.asList(pkgList)) + " mEnabledServicesPackageNames=" + this.mEnabledServicesPackageNames);
        }
        boolean anyServicesInvolved = false;
        if (pkgList != null && pkgList.length > 0) {
            for (String pkgName : pkgList) {
                if (!this.mEnabledServicesPackageNames.contains(pkgName)) continue;
                anyServicesInvolved = true;
            }
        }
        if (anyServicesInvolved) {
            if (!queryReplace) {
                this.disableNonexistentServices();
            }
            this.rebindServices();
        }
    }

    public void onUserSwitched() {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserSwitched");
        }
        if (Arrays.equals(this.mLastSeenProfileIds, this.mUserProfiles.getCurrentProfileIds())) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "Current profile IDs didn't change, skipping rebindServices().");
            }
            return;
        }
        this.rebindServices();
    }

    public ManagedServiceInfo checkServiceTokenLocked(IInterface service) {
        this.checkNotNull(service);
        IBinder token = service.asBinder();
        int N = this.mServices.size();
        for (int i = 0; i < N; ++i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (info.service.asBinder() != token) continue;
            return info;
        }
        throw new SecurityException("Disallowed call from unknown " + this.getCaption() + ": " + service);
    }

    public void unregisterService(IInterface service, int userid) {
        this.checkNotNull(service);
        this.unregisterServiceImpl(service, userid);
    }

    public void registerService(IInterface service, ComponentName component, int userid) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.registerServiceImpl(service, component, userid);
        if (info != null) {
            this.onServiceAdded(info);
        }
    }

    private void disableNonexistentServices() {
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int N = userIds.length;
        for (int i = 0; i < N; ++i) {
            this.disableNonexistentServices(userIds[i]);
        }
    }

    private void disableNonexistentServices(int userId) {
        String flatIn = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), this.mConfig.secureSettingName, userId);
        if (!TextUtils.isEmpty(flatIn)) {
            if (this.DEBUG) {
                Slog.v(this.TAG, "flat before: " + flatIn);
            }
            PackageManager pm = this.mContext.getPackageManager();
            List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(new Intent(this.mConfig.serviceInterface), 132, userId);
            if (this.DEBUG) {
                Slog.v(this.TAG, this.mConfig.serviceInterface + " services: " + installedServices);
            }
            ArraySet<ComponentName> installed = new ArraySet<ComponentName>();
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                if (!this.mConfig.bindPermission.equals(info.permission)) {
                    Slog.w(this.TAG, "Skipping " + this.getCaption() + " service " + info.packageName + "/" + info.name + ": it does not require the permission " + this.mConfig.bindPermission);
                    continue;
                }
                installed.add(new ComponentName(info.packageName, info.name));
            }
            String flatOut = "";
            if (!installed.isEmpty()) {
                String[] enabled = flatIn.split(ENABLED_SERVICES_SEPARATOR);
                ArrayList<String> remaining = new ArrayList<String>(enabled.length);
                for (int i = 0; i < enabled.length; ++i) {
                    ComponentName enabledComponent = ComponentName.unflattenFromString(enabled[i]);
                    if (!installed.contains(enabledComponent)) continue;
                    remaining.add(enabled[i]);
                }
                flatOut = TextUtils.join((CharSequence)ENABLED_SERVICES_SEPARATOR, remaining);
            }
            if (this.DEBUG) {
                Slog.v(this.TAG, "flat after: " + flatOut);
            }
            if (!flatIn.equals(flatOut)) {
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), this.mConfig.secureSettingName, flatOut, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindServices() {
        if (this.DEBUG) {
            Slog.d(this.TAG, "rebindServices");
        }
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int nUserIds = userIds.length;
        SparseArray<String> flat = new SparseArray<String>();
        for (int i = 0; i < nUserIds; ++i) {
            flat.put(userIds[i], Settings.Secure.getStringForUser(this.mContext.getContentResolver(), this.mConfig.secureSettingName, userIds[i]));
        }
        ArrayList<ManagedServiceInfo> toRemove = new ArrayList<ManagedServiceInfo>();
        SparseArray toAdd = new SparseArray();
        Object object = this.mMutex;
        synchronized (object) {
            for (ManagedServiceInfo service : this.mServices) {
                if (service.isSystem) continue;
                toRemove.add(service);
            }
            ArraySet<ComponentName> newEnabled = new ArraySet<ComponentName>();
            ArraySet<String> newPackages = new ArraySet<String>();
            for (int i = 0; i < nUserIds; ++i) {
                ArrayList<ComponentName> add = new ArrayList<ComponentName>();
                toAdd.put(userIds[i], add);
                String toDecode = (String)flat.get(userIds[i]);
                if (toDecode == null) continue;
                String[] components = toDecode.split(ENABLED_SERVICES_SEPARATOR);
                for (int j = 0; j < components.length; ++j) {
                    ComponentName component = ComponentName.unflattenFromString(components[j]);
                    if (component == null) continue;
                    newEnabled.add(component);
                    add.add(component);
                    newPackages.add(component.getPackageName());
                }
            }
            this.mEnabledServicesForCurrentProfiles = newEnabled;
            this.mEnabledServicesPackageNames = newPackages;
        }
        for (ManagedServiceInfo info : toRemove) {
            ComponentName component = info.component;
            int oldUser = info.userid;
            Slog.v(this.TAG, "disabling " + this.getCaption() + " for user " + oldUser + ": " + component);
            this.unregisterService(component, info.userid);
        }
        for (int i = 0; i < nUserIds; ++i) {
            ArrayList add = (ArrayList)toAdd.get(userIds[i]);
            int N = add.size();
            for (int j = 0; j < N; ++j) {
                ComponentName component = (ComponentName)add.get(j);
                Slog.v(this.TAG, "enabling " + this.getCaption() + " for user " + userIds[i] + ": " + component);
                this.registerService(component, userIds[i]);
            }
        }
        this.mLastSeenProfileIds = this.mUserProfiles.getCurrentProfileIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ComponentName name, final int userid) {
        if (this.DEBUG) {
            Slog.v(this.TAG, "registerService: " + name + " u=" + userid);
        }
        Object object = this.mMutex;
        synchronized (object) {
            final String servicesBindingTag = name.toString() + "/" + userid;
            if (this.mServicesBinding.contains(servicesBindingTag)) {
                return;
            }
            this.mServicesBinding.add(servicesBindingTag);
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (!name.equals(info.component) || info.userid != userid) continue;
                if (this.DEBUG) {
                    Slog.v(this.TAG, "    disconnecting old " + this.getCaption() + ": " + info.service);
                }
                this.removeServiceLocked(i);
                if (info.connection == null) continue;
                this.mContext.unbindService(info.connection);
            }
            Intent intent = new Intent(this.mConfig.serviceInterface);
            intent.setComponent(name);
            intent.putExtra("android.intent.extra.client_label", this.mConfig.clientLabel);
            PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent(this.mConfig.settingsAction), 0);
            intent.putExtra("android.intent.extra.client_intent", pendingIntent);
            ApplicationInfo appInfo = null;
            try {
                appInfo = this.mContext.getPackageManager().getApplicationInfo(name.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
            final int targetSdkVersion = appInfo != null ? appInfo.targetSdkVersion : 1;
            try {
                if (this.DEBUG) {
                    Slog.v(this.TAG, "binding: " + intent);
                }
                if (!this.mContext.bindServiceAsUser(intent, new ServiceConnection(){
                    IInterface mService;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onServiceConnected(ComponentName name, IBinder binder) {
                        boolean added = false;
                        ManagedServiceInfo info = null;
                        Object object = ManagedServices.this.mMutex;
                        synchronized (object) {
                            ManagedServices.this.mServicesBinding.remove(servicesBindingTag);
                            try {
                                this.mService = ManagedServices.this.asInterface(binder);
                                info = ManagedServices.this.newServiceInfo(this.mService, name, userid, false, this, targetSdkVersion);
                                binder.linkToDeath(info, 0);
                                added = ManagedServices.this.mServices.add(info);
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                        }
                        if (added) {
                            ManagedServices.this.onServiceAdded(info);
                        }
                    }

                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Slog.v(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " connection lost: " + name);
                    }
                }, 1, new UserHandle(userid))) {
                    this.mServicesBinding.remove(servicesBindingTag);
                    Slog.w(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent);
                    return;
                }
            }
            catch (SecurityException ex) {
                Slog.e(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent, ex);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (!name.equals(info.component) || info.userid != userid) continue;
                this.removeServiceLocked(i);
                if (info.connection == null) continue;
                try {
                    this.mContext.unbindService(info.connection);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Slog.e(this.TAG, this.getCaption() + " " + name + " could not be unbound: " + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo removeServiceImpl(IInterface service, int userid) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "removeServiceImpl service=" + service + " u=" + userid);
        }
        ManagedServiceInfo serviceInfo = null;
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (info.service.asBinder() != service.asBinder() || info.userid != userid) continue;
                if (this.DEBUG) {
                    Slog.d(this.TAG, "Removing active service " + info.component);
                }
                serviceInfo = this.removeServiceLocked(i);
            }
        }
        return serviceInfo;
    }

    private ManagedServiceInfo removeServiceLocked(int i) {
        ManagedServiceInfo info = this.mServices.remove(i);
        this.onServiceRemovedLocked(info);
        return info;
    }

    private void checkNotNull(IInterface service) {
        if (service == null) {
            throw new IllegalArgumentException(this.getCaption() + " must not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo registerServiceImpl(IInterface service, ComponentName component, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            try {
                ManagedServiceInfo info = this.newServiceInfo(service, component, userid, true, null, 21);
                service.asBinder().linkToDeath(info, 0);
                this.mServices.add(info);
                return info;
            }
            catch (RemoteException e) {
            }
        }
        return null;
    }

    private void unregisterServiceImpl(IInterface service, int userid) {
        ManagedServiceInfo info = this.removeServiceImpl(service, userid);
        if (info != null && info.connection != null) {
            this.mContext.unbindService(info.connection);
        }
    }

    protected static class Config {
        String caption;
        String serviceInterface;
        String secureSettingName;
        String bindPermission;
        String settingsAction;
        int clientLabel;

        protected Config() {
        }
    }

    public static class UserProfiles {
        private final SparseArray<UserInfo> mCurrentProfiles = new SparseArray();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(Context context) {
            UserManager userManager = (UserManager)context.getSystemService("user");
            if (userManager != null) {
                int currentUserId = ActivityManager.getCurrentUser();
                List<UserInfo> profiles = userManager.getProfiles(currentUserId);
                SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
                synchronized (sparseArray) {
                    this.mCurrentProfiles.clear();
                    for (UserInfo user : profiles) {
                        this.mCurrentProfiles.put(user.id, user);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getCurrentProfileIds() {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                int[] users = new int[this.mCurrentProfiles.size()];
                int N = this.mCurrentProfiles.size();
                for (int i = 0; i < N; ++i) {
                    users[i] = this.mCurrentProfiles.keyAt(i);
                }
                return users;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                return this.mCurrentProfiles.get(userId) != null;
            }
        }
    }

    public class ManagedServiceInfo
    implements IBinder.DeathRecipient {
        public IInterface service;
        public ComponentName component;
        public int userid;
        public boolean isSystem;
        public ServiceConnection connection;
        public int targetSdkVersion;

        public ManagedServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
            this.service = service;
            this.component = component;
            this.userid = userid;
            this.isSystem = isSystem;
            this.connection = connection;
            this.targetSdkVersion = targetSdkVersion;
        }

        public String toString() {
            return "ManagedServiceInfo[" + "component=" + this.component + ",userid=" + this.userid + ",isSystem=" + this.isSystem + ",targetSdkVersion=" + this.targetSdkVersion + ",connection=" + (this.connection == null ? null : "<connection>") + ",service=" + this.service + ']';
        }

        public boolean enabledAndUserMatches(int nid) {
            if (!this.isEnabledForCurrentProfiles()) {
                return false;
            }
            if (this.userid == -1) {
                return true;
            }
            if (nid == -1 || nid == this.userid) {
                return true;
            }
            return this.supportsProfiles() && ManagedServices.this.mUserProfiles.isCurrentProfile(nid);
        }

        public boolean supportsProfiles() {
            return this.targetSdkVersion >= 21;
        }

        @Override
        public void binderDied() {
            if (ManagedServices.this.DEBUG) {
                Slog.d(ManagedServices.this.TAG, "binderDied");
            }
            ManagedServices.this.removeServiceImpl(this.service, this.userid);
        }

        public boolean isEnabledForCurrentProfiles() {
            if (this.isSystem) {
                return true;
            }
            if (this.connection == null) {
                return false;
            }
            return ManagedServices.this.mEnabledServicesForCurrentProfiles.contains(this.component);
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        private final Uri mSecureSettingsUri;

        private SettingsObserver(Handler handler) {
            super(handler);
            this.mSecureSettingsUri = Settings.Secure.getUriFor(((ManagedServices)ManagedServices.this).mConfig.secureSettingName);
        }

        private void observe() {
            ContentResolver resolver = ManagedServices.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mSecureSettingsUri, false, this, -1);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        private void update(Uri uri) {
            if (uri == null || this.mSecureSettingsUri.equals(uri)) {
                if (ManagedServices.this.DEBUG) {
                    Slog.d(ManagedServices.this.TAG, "Setting changed: mSecureSettingsUri=" + this.mSecureSettingsUri + " / uri=" + uri);
                }
                ManagedServices.this.rebindServices();
            }
        }
    }
}

