/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import com.android.server.notification.NotificationRecord;
import java.util.Comparator;

public class NotificationComparator
implements Comparator<NotificationRecord> {
    @Override
    public int compare(NotificationRecord left, NotificationRecord right) {
        float rightPeople;
        int rightScore;
        int rightPackagePriority;
        int leftPackagePriority = left.getPackagePriority();
        if (leftPackagePriority != (rightPackagePriority = right.getPackagePriority())) {
            return -1 * Integer.compare(leftPackagePriority, rightPackagePriority);
        }
        int leftScore = left.sbn.getScore();
        if (leftScore != (rightScore = right.sbn.getScore())) {
            return -1 * Integer.compare(leftScore, rightScore);
        }
        float leftPeople = left.getContactAffinity();
        if (leftPeople != (rightPeople = right.getContactAffinity())) {
            return -1 * Float.compare(leftPeople, rightPeople);
        }
        return -1 * Long.compare(left.getRankingTimeMs(), right.getRankingTimeMs());
    }
}

