/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RankingHelper
implements RankingConfig {
    private static final String TAG = "RankingHelper";
    private static final boolean DEBUG = false;
    private static final int XML_VERSION = 1;
    private static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator = new NotificationComparator();
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, SparseIntArray> mPackagePriorities;
    private final ArrayMap<String, SparseIntArray> mPackageVisibilities;
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp;
    private final Context mContext;
    private final Handler mRankingHandler;

    public RankingHelper(Context context, Handler rankingHandler, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        this.mPackagePriorities = new ArrayMap();
        this.mPackageVisibilities = new ArrayMap();
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext);
                extractor.setConfig(this);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
        this.mProxyByGroupTmp = new ArrayMap();
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                Message m = Message.obtain(this.mRankingHandler, 4, recon);
                long delay = recon.getDelay(TimeUnit.MILLISECONDS);
                this.mRankingHandler.sendMessageDelayed(m, delay);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    public void readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        this.mPackagePriorities.clear();
        int version = RankingHelper.safeInt(parser, ATT_VERSION, 1);
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && TAG_RANKING.equals(tag)) {
                return;
            }
            if (type != 2 || !TAG_PACKAGE.equals(tag)) continue;
            int uid = RankingHelper.safeInt(parser, ATT_UID, -1);
            int priority = RankingHelper.safeInt(parser, ATT_PRIORITY, 0);
            int vis = RankingHelper.safeInt(parser, ATT_VISIBILITY, -1000);
            String name = parser.getAttributeValue(null, ATT_NAME);
            if (TextUtils.isEmpty(name)) continue;
            if (priority != 0) {
                SparseIntArray priorityByUid = this.mPackagePriorities.get(name);
                if (priorityByUid == null) {
                    priorityByUid = new SparseIntArray();
                    this.mPackagePriorities.put(name, priorityByUid);
                }
                priorityByUid.put(uid, priority);
            }
            if (vis == -1000) continue;
            SparseIntArray visibilityByUid = this.mPackageVisibilities.get(name);
            if (visibilityByUid == null) {
                visibilityByUid = new SparseIntArray();
                this.mPackageVisibilities.put(name, visibilityByUid);
            }
            visibilityByUid.put(uid, vis);
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    public void writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        ArraySet<String> packageNames = new ArraySet<String>(this.mPackagePriorities.size() + this.mPackageVisibilities.size());
        packageNames.addAll(this.mPackagePriorities.keySet());
        packageNames.addAll(this.mPackageVisibilities.keySet());
        ArraySet<Integer> packageUids = new ArraySet<Integer>();
        for (String packageName : packageNames) {
            int j;
            int M;
            packageUids.clear();
            SparseIntArray priorityByUid = this.mPackagePriorities.get(packageName);
            SparseIntArray visibilityByUid = this.mPackageVisibilities.get(packageName);
            if (priorityByUid != null) {
                M = priorityByUid.size();
                for (j = 0; j < M; ++j) {
                    packageUids.add(priorityByUid.keyAt(j));
                }
            }
            if (visibilityByUid != null) {
                M = visibilityByUid.size();
                for (j = 0; j < M; ++j) {
                    packageUids.add(visibilityByUid.keyAt(j));
                }
            }
            for (Integer uid : packageUids) {
                int visibility;
                int priority;
                out.startTag(null, TAG_PACKAGE);
                out.attribute(null, ATT_NAME, packageName);
                if (priorityByUid != null && (priority = priorityByUid.get(uid)) != 0) {
                    out.attribute(null, ATT_PRIORITY, Integer.toString(priority));
                }
                if (visibilityByUid != null && (visibility = visibilityByUid.get(uid)) != -1000) {
                    out.attribute(null, ATT_VISIBILITY, Integer.toString(visibility));
                }
                out.attribute(null, ATT_UID, Integer.toString(uid));
                out.endTag(null, TAG_PACKAGE);
            }
        }
        out.endTag(null, TAG_RANKING);
    }

    private void updateConfig() {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            this.mSignalExtractors[i].setConfig(this);
        }
        this.mRankingHandler.sendEmptyMessage(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        try {
            Collections.sort(notificationList, this.mPreliminaryComparator);
        }
        catch (RuntimeException ex) {
            Log.e(TAG, "Extreme badness during notification sort", ex);
            Log.e(TAG, "Current notification list: ");
            for (int i = 0; i < N; ++i) {
                NotificationRecord nr = notificationList.get(i);
                Log.e(TAG, String.format("  [%d] %s (group %s, rank %d, sortkey %s)", i, nr, nr.getGroupKey(), nr.getAuthoritativeRank(), nr.getNotification().getSortKey()));
            }
            throw ex;
        }
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = N - 1; i >= 0; --i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                if (!isGroupSummary && this.mProxyByGroupTmp.containsKey(groupKey)) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", Character.valueOf(record.isRecentlyIntrusive() ? (char)'0' : '1'), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return RankingHelper.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    @Override
    public int getPackagePriority(String packageName, int uid) {
        int priority = 0;
        SparseIntArray priorityByUid = this.mPackagePriorities.get(packageName);
        if (priorityByUid != null) {
            priority = priorityByUid.get(uid, 0);
        }
        return priority;
    }

    @Override
    public void setPackagePriority(String packageName, int uid, int priority) {
        if (priority == this.getPackagePriority(packageName, uid)) {
            return;
        }
        SparseIntArray priorityByUid = this.mPackagePriorities.get(packageName);
        if (priorityByUid == null) {
            priorityByUid = new SparseIntArray();
            this.mPackagePriorities.put(packageName, priorityByUid);
        }
        priorityByUid.put(uid, priority);
        this.updateConfig();
    }

    @Override
    public int getPackageVisibilityOverride(String packageName, int uid) {
        int visibility = -1000;
        SparseIntArray visibilityByUid = this.mPackageVisibilities.get(packageName);
        if (visibilityByUid != null) {
            visibility = visibilityByUid.get(uid, -1000);
        }
        return visibility;
    }

    @Override
    public void setPackageVisibilityOverride(String packageName, int uid, int visibility) {
        if (visibility == this.getPackageVisibilityOverride(packageName, uid)) {
            return;
        }
        SparseIntArray visibilityByUid = this.mPackageVisibilities.get(packageName);
        if (visibilityByUid == null) {
            visibilityByUid = new SparseIntArray();
            this.mPackageVisibilities.put(packageName, visibilityByUid);
        }
        visibilityByUid.put(uid, visibility);
        this.updateConfig();
    }

    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        int i;
        int N;
        if (filter == null) {
            N = this.mSignalExtractors.length;
            pw.print(prefix);
            pw.print("mSignalExtractors.length = ");
            pw.println(N);
            for (i = 0; i < N; ++i) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(this.mSignalExtractors[i]);
            }
        }
        N = this.mPackagePriorities.size();
        if (filter == null) {
            pw.print(prefix);
            pw.println("package priorities:");
        }
        for (i = 0; i < N; ++i) {
            String name = this.mPackagePriorities.keyAt(i);
            if (filter != null && !filter.matches(name)) continue;
            SparseIntArray priorityByUid = this.mPackagePriorities.get(name);
            int M = priorityByUid.size();
            for (int j = 0; j < M; ++j) {
                int uid = priorityByUid.keyAt(j);
                int priority = priorityByUid.get(uid);
                pw.print(prefix);
                pw.print("  ");
                pw.print(name);
                pw.print(" (");
                pw.print(uid);
                pw.print(") has priority: ");
                pw.println(priority);
            }
        }
    }
}

