/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.input.InputManagerInternal;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.EventLog;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.server.LocalServices;
import com.android.server.power.SuspendBlocker;

final class Notifier {
    private static final String TAG = "PowerManagerNotifier";
    private static final boolean DEBUG = false;
    private static final int POWER_STATE_UNKNOWN = 0;
    private static final int POWER_STATE_AWAKE = 1;
    private static final int POWER_STATE_ASLEEP = 2;
    private static final int MSG_USER_ACTIVITY = 1;
    private static final int MSG_BROADCAST = 2;
    private static final int MSG_WIRELESS_CHARGING_STARTED = 3;
    private final Object mLock = new Object();
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private final IAppOpsService mAppOps;
    private final SuspendBlocker mSuspendBlocker;
    private final WindowManagerPolicy mPolicy;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final InputManagerInternal mInputManagerInternal;
    private final NotifierHandler mHandler;
    private final Intent mScreenOnIntent;
    private final Intent mScreenOffIntent;
    private int mActualPowerState;
    private int mLastGoToSleepReason;
    private boolean mPendingWakeUpBroadcast;
    private boolean mPendingGoToSleepBroadcast;
    private int mBroadcastedPowerState;
    private boolean mBroadcastInProgress;
    private long mBroadcastStartTime;
    private boolean mUserActivityPending;
    private final BroadcastReceiver mWakeUpBroadcastDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            EventLog.writeEvent(2726, 1, SystemClock.uptimeMillis() - Notifier.this.mBroadcastStartTime, 1);
            Notifier.this.sendNextBroadcast();
        }
    };
    private final BroadcastReceiver mGoToSleepBroadcastDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            EventLog.writeEvent(2726, 0, SystemClock.uptimeMillis() - Notifier.this.mBroadcastStartTime, 1);
            Notifier.this.sendNextBroadcast();
        }
    };

    public Notifier(Looper looper, Context context, IBatteryStats batteryStats, IAppOpsService appOps, SuspendBlocker suspendBlocker, WindowManagerPolicy policy) {
        this.mContext = context;
        this.mBatteryStats = batteryStats;
        this.mAppOps = appOps;
        this.mSuspendBlocker = suspendBlocker;
        this.mPolicy = policy;
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        this.mHandler = new NotifierHandler(looper);
        this.mScreenOnIntent = new Intent("android.intent.action.SCREEN_ON");
        this.mScreenOnIntent.addFlags(0x50000000);
        this.mScreenOffIntent = new Intent("android.intent.action.SCREEN_OFF");
        this.mScreenOffIntent.addFlags(0x50000000);
        try {
            this.mBatteryStats.noteInteractive(true);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void onWakeLockAcquired(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag) {
        try {
            boolean unimportantForLogging;
            int monitorType = Notifier.getBatteryStatsWakeLockMonitorType(flags);
            boolean bl = unimportantForLogging = (flags & 0x40000000) != 0 && ownerUid == 1000;
            if (workSource != null) {
                this.mBatteryStats.noteStartWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType, unimportantForLogging);
            } else {
                this.mBatteryStats.noteStartWakelock(ownerUid, ownerPid, tag, historyTag, monitorType, unimportantForLogging);
                this.mAppOps.startOperation(AppOpsManager.getToken(this.mAppOps), 40, ownerUid, packageName);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void onWakeLockChanging(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag, int newFlags, String newTag, String newPackageName, int newOwnerUid, int newOwnerPid, WorkSource newWorkSource, String newHistoryTag) {
        if (workSource != null && newWorkSource != null) {
            int monitorType = Notifier.getBatteryStatsWakeLockMonitorType(flags);
            int newMonitorType = Notifier.getBatteryStatsWakeLockMonitorType(newFlags);
            boolean unimportantForLogging = (newFlags & 0x40000000) != 0 && newOwnerUid == 1000;
            try {
                this.mBatteryStats.noteChangeWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType, newWorkSource, newOwnerPid, newTag, newHistoryTag, newMonitorType, unimportantForLogging);
            }
            catch (RemoteException ex) {}
        } else {
            this.onWakeLockReleased(flags, tag, packageName, ownerUid, ownerPid, workSource, historyTag);
            this.onWakeLockAcquired(newFlags, newTag, newPackageName, newOwnerUid, newOwnerPid, newWorkSource, newHistoryTag);
        }
    }

    public void onWakeLockReleased(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag) {
        try {
            int monitorType = Notifier.getBatteryStatsWakeLockMonitorType(flags);
            if (workSource != null) {
                this.mBatteryStats.noteStopWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType);
            } else {
                this.mBatteryStats.noteStopWakelock(ownerUid, ownerPid, tag, historyTag, monitorType);
                this.mAppOps.finishOperation(AppOpsManager.getToken(this.mAppOps), 40, ownerUid, packageName);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    private static int getBatteryStatsWakeLockMonitorType(int flags) {
        switch (flags & 0xFFFF) {
            case 1: 
            case 32: {
                return 0;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInteractiveStateChangeStarted(boolean interactive, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (interactive) {
                if (this.mActualPowerState != 1) {
                    this.mActualPowerState = 1;
                    this.mPendingWakeUpBroadcast = true;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            EventLog.writeEvent(2728, 1, 0, 0, 0);
                            Notifier.this.mPolicy.wakingUp();
                            Notifier.this.mActivityManagerInternal.wakingUp();
                        }
                    });
                    this.updatePendingBroadcastLocked();
                }
            } else {
                this.mLastGoToSleepReason = reason;
            }
        }
        this.mInputManagerInternal.setInteractive(interactive);
        if (interactive) {
            try {
                this.mBatteryStats.noteInteractive(true);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInteractiveStateChangeFinished(boolean interactive) {
        Object object = this.mLock;
        synchronized (object) {
            if (!interactive && this.mActualPowerState != 2) {
                this.mActualPowerState = 2;
                this.mPendingGoToSleepBroadcast = true;
                if (this.mUserActivityPending) {
                    this.mUserActivityPending = false;
                    this.mHandler.removeMessages(1);
                }
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int why = 2;
                        switch (Notifier.this.mLastGoToSleepReason) {
                            case 1: {
                                why = 1;
                                break;
                            }
                            case 2: {
                                why = 3;
                            }
                        }
                        EventLog.writeEvent(2728, 0, why, 0, 0);
                        Notifier.this.mPolicy.goingToSleep(why);
                        Notifier.this.mActivityManagerInternal.goingToSleep();
                    }
                });
                this.updatePendingBroadcastLocked();
            }
        }
        if (!interactive) {
            try {
                this.mBatteryStats.noteInteractive(false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserActivity(int event, int uid) {
        try {
            this.mBatteryStats.noteUserActivity(uid, event);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserActivityPending) {
                this.mUserActivityPending = true;
                Message msg = this.mHandler.obtainMessage(1);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
            }
        }
    }

    public void onWirelessChargingStarted() {
        this.mSuspendBlocker.acquire();
        Message msg = this.mHandler.obtainMessage(3);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    private void updatePendingBroadcastLocked() {
        if (!this.mBroadcastInProgress && this.mActualPowerState != 0 && (this.mPendingWakeUpBroadcast || this.mPendingGoToSleepBroadcast || this.mActualPowerState != this.mBroadcastedPowerState)) {
            this.mBroadcastInProgress = true;
            this.mSuspendBlocker.acquire();
            Message msg = this.mHandler.obtainMessage(2);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    private void finishPendingBroadcastLocked() {
        this.mBroadcastInProgress = false;
        this.mSuspendBlocker.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUserActivity() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserActivityPending) {
                return;
            }
            this.mUserActivityPending = false;
        }
        this.mPolicy.userActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendNextBroadcast() {
        int powerState;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBroadcastedPowerState == 0) {
                this.mPendingWakeUpBroadcast = false;
                this.mBroadcastedPowerState = 1;
            } else if (this.mBroadcastedPowerState == 1) {
                if (!this.mPendingWakeUpBroadcast && !this.mPendingGoToSleepBroadcast && this.mActualPowerState != 2) {
                    this.finishPendingBroadcastLocked();
                    return;
                }
                this.mPendingGoToSleepBroadcast = false;
                this.mBroadcastedPowerState = 2;
            } else {
                if (!this.mPendingWakeUpBroadcast && !this.mPendingGoToSleepBroadcast && this.mActualPowerState != 1) {
                    this.finishPendingBroadcastLocked();
                    return;
                }
                this.mPendingWakeUpBroadcast = false;
                this.mBroadcastedPowerState = 1;
            }
            this.mBroadcastStartTime = SystemClock.uptimeMillis();
            powerState = this.mBroadcastedPowerState;
        }
        EventLog.writeEvent(2725, 1);
        if (powerState == 1) {
            this.sendWakeUpBroadcast();
            return;
        }
        this.sendGoToSleepBroadcast();
    }

    private void sendWakeUpBroadcast() {
        if (ActivityManagerNative.isSystemReady()) {
            this.mContext.sendOrderedBroadcastAsUser(this.mScreenOnIntent, UserHandle.ALL, null, this.mWakeUpBroadcastDone, this.mHandler, 0, null, null);
        } else {
            EventLog.writeEvent(2727, 2, 1);
            this.sendNextBroadcast();
        }
    }

    private void sendGoToSleepBroadcast() {
        if (ActivityManagerNative.isSystemReady()) {
            this.mContext.sendOrderedBroadcastAsUser(this.mScreenOffIntent, UserHandle.ALL, null, this.mGoToSleepBroadcastDone, this.mHandler, 0, null, null);
        } else {
            EventLog.writeEvent(2727, 3, 1);
            this.sendNextBroadcast();
        }
    }

    private void playWirelessChargingStartedSound() {
        Ringtone sfx;
        Uri soundUri;
        String soundPath = Settings.Global.getString(this.mContext.getContentResolver(), "wireless_charging_started_sound");
        if (soundPath != null && (soundUri = Uri.parse("file://" + soundPath)) != null && (sfx = RingtoneManager.getRingtone(this.mContext, soundUri)) != null) {
            sfx.setStreamType(1);
            sfx.play();
        }
        this.mSuspendBlocker.release();
    }

    private final class NotifierHandler
    extends Handler {
        public NotifierHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Notifier.this.sendUserActivity();
                    break;
                }
                case 2: {
                    Notifier.this.sendNextBroadcast();
                    break;
                }
                case 3: {
                    Notifier.this.playWirelessChargingStartedSound();
                }
            }
        }
    }
}

