/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.print.IPrintSpooler;
import android.print.IPrintSpoolerCallbacks;
import android.print.IPrintSpoolerClient;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.util.Slog;
import android.util.TimedRemoteCaller;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

final class RemotePrintSpooler {
    private static final String LOG_TAG = "RemotePrintSpooler";
    private static final boolean DEBUG = false;
    private static final long BIND_SPOOLER_SERVICE_TIMEOUT = 10000L;
    private final Object mLock = new Object();
    private final GetPrintJobInfosCaller mGetPrintJobInfosCaller = new GetPrintJobInfosCaller();
    private final GetPrintJobInfoCaller mGetPrintJobInfoCaller = new GetPrintJobInfoCaller();
    private final SetPrintJobStateCaller mSetPrintJobStatusCaller = new SetPrintJobStateCaller();
    private final SetPrintJobTagCaller mSetPrintJobTagCaller = new SetPrintJobTagCaller();
    private final ServiceConnection mServiceConnection = new MyServiceConnection();
    private final Context mContext;
    private final UserHandle mUserHandle;
    private final PrintSpoolerClient mClient;
    private final Intent mIntent;
    private final PrintSpoolerCallbacks mCallbacks;
    private IPrintSpooler mRemoteInstance;
    private boolean mDestroyed;
    private boolean mCanUnbind;

    public RemotePrintSpooler(Context context, int userId, PrintSpoolerCallbacks callbacks) {
        this.mContext = context;
        this.mUserHandle = new UserHandle(userId);
        this.mCallbacks = callbacks;
        this.mClient = new PrintSpoolerClient(this);
        this.mIntent = new Intent();
        this.mIntent.setComponent(new ComponentName("com.android.printspooler", "com.android.printspooler.model.PrintSpoolerService"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<PrintJobInfo> getPrintJobInfos(ComponentName componentName, int state, int appId) {
        this.throwIfCalledOnMainThread();
        List<PrintJobInfo> list = this.mLock;
        synchronized (list) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            list = this.mGetPrintJobInfosCaller.getPrintJobInfos(this.getRemoteInstanceLazy(), componentName, state, appId);
            return list;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error getting print jobs.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error getting print jobs.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createPrintJob(PrintJobInfo printJob) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            this.getRemoteInstanceLazy().createPrintJob(printJob);
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error creating print job.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error creating print job.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePrintJobData(ParcelFileDescriptor fd, PrintJobId printJobId) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            this.getRemoteInstanceLazy().writePrintJobData(fd, printJobId);
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error writing print job data.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error writing print job data.", te);
        }
        finally {
            IoUtils.closeQuietly(fd);
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            object = this.mGetPrintJobInfoCaller.getPrintJobInfo(this.getRemoteInstanceLazy(), printJobId, appId);
            return object;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error getting print job info.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error getting print job info.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPrintJobState(PrintJobId printJobId, int state, String error) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            boolean bl = this.mSetPrintJobStatusCaller.setPrintJobState(this.getRemoteInstanceLazy(), printJobId, state, error);
            return bl;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error setting print job state.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error setting print job state.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setPrintJobTag(PrintJobId printJobId, String tag) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            boolean bl = this.mSetPrintJobTagCaller.setPrintJobTag(this.getRemoteInstanceLazy(), printJobId, tag);
            return bl;
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error setting print job tag.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error setting print job tag.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPrintJobCancelling(PrintJobId printJobId, boolean cancelling) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            this.getRemoteInstanceLazy().setPrintJobCancelling(printJobId, cancelling);
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error setting print job cancelling.", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error setting print job cancelling.", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeObsoletePrintJobs() {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            this.getRemoteInstanceLazy().removeObsoletePrintJobs();
        }
        catch (RemoteException re) {
            Slog.e(LOG_TAG, "Error removing obsolete print jobs .", re);
        }
        catch (TimeoutException te) {
            Slog.e(LOG_TAG, "Error removing obsolete print jobs .", te);
        }
        finally {
            Object re = this.mLock;
            synchronized (re) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.unbindLocked();
            this.mDestroyed = true;
            this.mCanUnbind = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.append(prefix).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
            pw.append(prefix).append("bound=").append(this.mRemoteInstance != null ? "true" : "false").println();
            pw.flush();
            try {
                this.getRemoteInstanceLazy().asBinder().dump(fd, new String[]{prefix});
            }
            catch (TimeoutException te) {
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAllPrintJobsHandled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.unbindLocked();
        }
    }

    private void onPrintJobStateChanged(PrintJobInfo printJob) {
        this.mCallbacks.onPrintJobStateChanged(printJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPrintSpooler getRemoteInstanceLazy() throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteInstance != null) {
                return this.mRemoteInstance;
            }
            this.bindLocked();
            return this.mRemoteInstance;
        }
    }

    private void bindLocked() throws TimeoutException {
        if (this.mRemoteInstance != null) {
            return;
        }
        this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 1, this.mUserHandle);
        long startMillis = SystemClock.uptimeMillis();
        while (this.mRemoteInstance == null) {
            long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
            long remainingMillis = 10000L - elapsedMillis;
            if (remainingMillis <= 0L) {
                throw new TimeoutException("Cannot get spooler!");
            }
            try {
                this.mLock.wait(remainingMillis);
            }
            catch (InterruptedException ie) {}
        }
        this.mCanUnbind = true;
        this.mLock.notifyAll();
    }

    private void unbindLocked() {
        if (this.mRemoteInstance == null) {
            return;
        }
        while (true) {
            if (this.mCanUnbind) {
                this.clearClientLocked();
                this.mRemoteInstance = null;
                this.mContext.unbindService(this.mServiceConnection);
                return;
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void setClientLocked() {
        try {
            this.mRemoteInstance.setClient(this.mClient);
        }
        catch (RemoteException re) {
            Slog.d(LOG_TAG, "Error setting print spooler client", re);
        }
    }

    private void clearClientLocked() {
        try {
            this.mRemoteInstance.setClient(null);
        }
        catch (RemoteException re) {
            Slog.d(LOG_TAG, "Error clearing print spooler client", re);
        }
    }

    private void throwIfDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot interact with a destroyed instance.");
        }
    }

    private void throwIfCalledOnMainThread() {
        if (Thread.currentThread() == this.mContext.getMainLooper().getThread()) {
            throw new RuntimeException("Cannot invoke on the main thread");
        }
    }

    private static final class PrintSpoolerClient
    extends IPrintSpoolerClient.Stub {
        private final WeakReference<RemotePrintSpooler> mWeakSpooler;

        public PrintSpoolerClient(RemotePrintSpooler spooler) {
            this.mWeakSpooler = new WeakReference<RemotePrintSpooler>(spooler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrintJobQueued(PrintJobInfo printJob) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.mCallbacks.onPrintJobQueued(printJob);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllPrintJobsForServiceHandled(ComponentName printService) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.mCallbacks.onAllPrintJobsForServiceHandled(printService);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllPrintJobsHandled() {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.onAllPrintJobsHandled();
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrintJobStateChanged(PrintJobInfo printJob) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.onPrintJobStateChanged(printJob);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    private static abstract class BasePrintSpoolerServiceCallbacks
    extends IPrintSpoolerCallbacks.Stub {
        private BasePrintSpoolerServiceCallbacks() {
        }

        @Override
        public void onGetPrintJobInfosResult(List<PrintJobInfo> printJobIds, int sequence) {
        }

        @Override
        public void onGetPrintJobInfoResult(PrintJobInfo printJob, int sequence) {
        }

        @Override
        public void onCancelPrintJobResult(boolean canceled, int sequence) {
        }

        @Override
        public void onSetPrintJobStateResult(boolean success, int sequece) {
        }

        @Override
        public void onSetPrintJobTagResult(boolean success, int sequence) {
        }
    }

    private static final class SetPrintJobTagCaller
    extends TimedRemoteCaller<Boolean> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            @Override
            public void onSetPrintJobTagResult(boolean success, int sequence) {
                SetPrintJobTagCaller.this.onRemoteMethodResult(success, sequence);
            }
        };

        public SetPrintJobTagCaller() {
            super(5000L);
        }

        public boolean setPrintJobTag(IPrintSpooler target, PrintJobId printJobId, String tag) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.setPrintJobTag(printJobId, tag, this.mCallback, sequence);
            return (Boolean)this.getResultTimed(sequence);
        }
    }

    private static final class SetPrintJobStateCaller
    extends TimedRemoteCaller<Boolean> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            @Override
            public void onSetPrintJobStateResult(boolean success, int sequence) {
                SetPrintJobStateCaller.this.onRemoteMethodResult(success, sequence);
            }
        };

        public SetPrintJobStateCaller() {
            super(5000L);
        }

        public boolean setPrintJobState(IPrintSpooler target, PrintJobId printJobId, int status, String error) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.setPrintJobState(printJobId, status, error, this.mCallback, sequence);
            return (Boolean)this.getResultTimed(sequence);
        }
    }

    private static final class GetPrintJobInfoCaller
    extends TimedRemoteCaller<PrintJobInfo> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            @Override
            public void onGetPrintJobInfoResult(PrintJobInfo printJob, int sequence) {
                GetPrintJobInfoCaller.this.onRemoteMethodResult(printJob, sequence);
            }
        };

        public GetPrintJobInfoCaller() {
            super(5000L);
        }

        public PrintJobInfo getPrintJobInfo(IPrintSpooler target, PrintJobId printJobId, int appId) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getPrintJobInfo(printJobId, this.mCallback, appId, sequence);
            return (PrintJobInfo)this.getResultTimed(sequence);
        }
    }

    private static final class GetPrintJobInfosCaller
    extends TimedRemoteCaller<List<PrintJobInfo>> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            @Override
            public void onGetPrintJobInfosResult(List<PrintJobInfo> printJobs, int sequence) {
                GetPrintJobInfosCaller.this.onRemoteMethodResult(printJobs, sequence);
            }
        };

        public GetPrintJobInfosCaller() {
            super(5000L);
        }

        public List<PrintJobInfo> getPrintJobInfos(IPrintSpooler target, ComponentName componentName, int state, int appId) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getPrintJobInfos(this.mCallback, componentName, state, appId, sequence);
            return (List)this.getResultTimed(sequence);
        }
    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = RemotePrintSpooler.this.mLock;
            synchronized (object) {
                RemotePrintSpooler.this.mRemoteInstance = IPrintSpooler.Stub.asInterface(service);
                RemotePrintSpooler.this.setClientLocked();
                RemotePrintSpooler.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = RemotePrintSpooler.this.mLock;
            synchronized (object) {
                RemotePrintSpooler.this.clearClientLocked();
                RemotePrintSpooler.this.mRemoteInstance = null;
            }
        }
    }

    public static interface PrintSpoolerCallbacks {
        public void onPrintJobQueued(PrintJobInfo var1);

        public void onAllPrintJobsForServiceHandled(ComponentName var1);

        public void onPrintJobStateChanged(PrintJobInfo var1);
    }
}

