/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.os.Binder;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.format.Formatter;
import android.util.EventLog;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.server.EventLogTags;
import com.android.server.SystemService;
import com.android.server.pm.PackageManagerService;
import com.android.server.storage.DeviceStorageMonitorInternal;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class DeviceStorageMonitorService
extends SystemService {
    static final String TAG = "DeviceStorageMonitorService";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final int DEVICE_MEMORY_WHAT = 1;
    private static final int MONITOR_INTERVAL = 1;
    private static final int LOW_MEMORY_NOTIFICATION_ID = 1;
    private static final int DEFAULT_FREE_STORAGE_LOG_INTERVAL_IN_MINUTES = 720;
    private static final long DEFAULT_DISK_FREE_CHANGE_REPORTING_THRESHOLD = 0x200000L;
    private static final long DEFAULT_CHECK_INTERVAL = 60000L;
    private long mFreeMem;
    private long mFreeMemAfterLastCacheClear;
    private long mLastReportedFreeMem;
    private long mLastReportedFreeMemTime = 0L;
    boolean mLowMemFlag = false;
    private boolean mMemFullFlag = false;
    private final boolean mIsBootImageOnDisk;
    private final ContentResolver mResolver;
    private final long mTotalMemory;
    private final StatFs mDataFileStats;
    private final StatFs mSystemFileStats;
    private final StatFs mCacheFileStats;
    private static final File DATA_PATH = Environment.getDataDirectory();
    private static final File SYSTEM_PATH = Environment.getRootDirectory();
    private static final File CACHE_PATH = Environment.getDownloadCacheDirectory();
    private long mThreadStartTime = -1L;
    boolean mClearSucceeded = false;
    boolean mClearingCache;
    private final Intent mStorageLowIntent;
    private final Intent mStorageOkIntent;
    private final Intent mStorageFullIntent;
    private final Intent mStorageNotFullIntent;
    private CachePackageDataObserver mClearCacheObserver;
    private CacheFileDeletedObserver mCacheFileDeletedObserver;
    private static final int _TRUE = 1;
    private static final int _FALSE = 0;
    long mMemLowThreshold;
    private long mMemCacheStartTrimThreshold;
    private long mMemCacheTrimToThreshold;
    private long mMemFullThreshold;
    static final String SERVICE = "devicestoragemonitor";
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            if (msg.what != 1) {
                Slog.e(DeviceStorageMonitorService.TAG, "Will not process invalid message");
                return;
            }
            DeviceStorageMonitorService.this.checkMemory(msg.arg1 == 1);
        }
    };
    private final DeviceStorageMonitorInternal mLocalService = new DeviceStorageMonitorInternal(){

        @Override
        public void checkMemory() {
            DeviceStorageMonitorService.this.postCheckMemoryMsg(true, 0L);
        }

        @Override
        public boolean isMemoryLow() {
            return DeviceStorageMonitorService.this.mLowMemFlag || !DeviceStorageMonitorService.this.mIsBootImageOnDisk;
        }

        @Override
        public long getMemoryLowThreshold() {
            return DeviceStorageMonitorService.this.mMemLowThreshold;
        }
    };
    private final IBinder mRemoteService = new Binder(){

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (DeviceStorageMonitorService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump devicestoragemonitor from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            DeviceStorageMonitorService.this.dumpImpl(pw);
        }
    };

    private void restatDataDir() {
        long threshold;
        long delta;
        try {
            this.mDataFileStats.restat(DATA_PATH.getAbsolutePath());
            this.mFreeMem = (long)this.mDataFileStats.getAvailableBlocks() * (long)this.mDataFileStats.getBlockSize();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String debugFreeMem = SystemProperties.get("debug.freemem");
        if (!"".equals(debugFreeMem)) {
            this.mFreeMem = Long.parseLong(debugFreeMem);
        }
        long freeMemLogInterval = Settings.Global.getLong(this.mResolver, "sys_free_storage_log_interval", 720L) * 60L * 1000L;
        long currTime = SystemClock.elapsedRealtime();
        if (this.mLastReportedFreeMemTime == 0L || currTime - this.mLastReportedFreeMemTime >= freeMemLogInterval) {
            this.mLastReportedFreeMemTime = currTime;
            long mFreeSystem = -1L;
            long mFreeCache = -1L;
            try {
                this.mSystemFileStats.restat(SYSTEM_PATH.getAbsolutePath());
                mFreeSystem = (long)this.mSystemFileStats.getAvailableBlocks() * (long)this.mSystemFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.mCacheFileStats.restat(CACHE_PATH.getAbsolutePath());
                mFreeCache = (long)this.mCacheFileStats.getAvailableBlocks() * (long)this.mCacheFileStats.getBlockSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            EventLog.writeEvent(2746, this.mFreeMem, mFreeSystem, mFreeCache);
        }
        if ((delta = this.mFreeMem - this.mLastReportedFreeMem) > (threshold = Settings.Global.getLong(this.mResolver, "disk_free_change_reporting_threshold", 0x200000L)) || delta < -threshold) {
            this.mLastReportedFreeMem = this.mFreeMem;
            EventLog.writeEvent(2744, this.mFreeMem);
        }
    }

    private void clearCache() {
        if (this.mClearCacheObserver == null) {
            this.mClearCacheObserver = new CachePackageDataObserver();
        }
        this.mClearingCache = true;
        try {
            IPackageManager.Stub.asInterface(ServiceManager.getService("package")).freeStorageAndNotify(this.mMemCacheTrimToThreshold, this.mClearCacheObserver);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to get handle for PackageManger Exception: " + e);
            this.mClearingCache = false;
            this.mClearSucceeded = false;
        }
    }

    void checkMemory(boolean checkCache) {
        if (this.mClearingCache) {
            long diffTime = System.currentTimeMillis() - this.mThreadStartTime;
            if (diffTime > 600000L) {
                Slog.w(TAG, "Thread that clears cache file seems to run for ever");
            }
        } else {
            this.restatDataDir();
            if (this.mFreeMem < this.mMemLowThreshold) {
                if (checkCache) {
                    if (this.mFreeMem < this.mMemCacheStartTrimThreshold && this.mFreeMemAfterLastCacheClear - this.mFreeMem >= (this.mMemLowThreshold - this.mMemCacheStartTrimThreshold) / 4L) {
                        this.mThreadStartTime = System.currentTimeMillis();
                        this.mClearSucceeded = false;
                        this.clearCache();
                    }
                } else {
                    this.mFreeMemAfterLastCacheClear = this.mFreeMem;
                    if (!this.mLowMemFlag) {
                        Slog.i(TAG, "Running low on memory. Sending notification");
                        this.sendNotification();
                        this.mLowMemFlag = true;
                    }
                }
            } else {
                this.mFreeMemAfterLastCacheClear = this.mFreeMem;
                if (this.mLowMemFlag) {
                    Slog.i(TAG, "Memory available. Cancelling notification");
                    this.cancelNotification();
                    this.mLowMemFlag = false;
                }
            }
            if (!this.mLowMemFlag && !this.mIsBootImageOnDisk) {
                Slog.i(TAG, "No boot image on disk due to lack of space. Sending notification");
                this.sendNotification();
            }
            if (this.mFreeMem < this.mMemFullThreshold) {
                if (!this.mMemFullFlag) {
                    this.sendFullNotification();
                    this.mMemFullFlag = true;
                }
            } else if (this.mMemFullFlag) {
                this.cancelFullNotification();
                this.mMemFullFlag = false;
            }
        }
        this.postCheckMemoryMsg(true, 60000L);
    }

    void postCheckMemoryMsg(boolean clearCache, long delay) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, clearCache ? 1 : 0, 0), delay);
    }

    public DeviceStorageMonitorService(Context context) {
        super(context);
        this.mResolver = context.getContentResolver();
        this.mIsBootImageOnDisk = DeviceStorageMonitorService.isBootImageOnDisk();
        this.mDataFileStats = new StatFs(DATA_PATH.getAbsolutePath());
        this.mSystemFileStats = new StatFs(SYSTEM_PATH.getAbsolutePath());
        this.mCacheFileStats = new StatFs(CACHE_PATH.getAbsolutePath());
        this.mTotalMemory = (long)this.mDataFileStats.getBlockCount() * (long)this.mDataFileStats.getBlockSize();
        this.mStorageLowIntent = new Intent("android.intent.action.DEVICE_STORAGE_LOW");
        this.mStorageLowIntent.addFlags(0x4000000);
        this.mStorageOkIntent = new Intent("android.intent.action.DEVICE_STORAGE_OK");
        this.mStorageOkIntent.addFlags(0x4000000);
        this.mStorageFullIntent = new Intent("android.intent.action.DEVICE_STORAGE_FULL");
        this.mStorageFullIntent.addFlags(0x4000000);
        this.mStorageNotFullIntent = new Intent("android.intent.action.DEVICE_STORAGE_NOT_FULL");
        this.mStorageNotFullIntent.addFlags(0x4000000);
    }

    private static boolean isBootImageOnDisk() {
        for (String instructionSet : PackageManagerService.getAllDexCodeInstructionSets()) {
            if (VMRuntime.isBootClassPathOnDisk(instructionSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onStart() {
        StorageManager sm = StorageManager.from(this.getContext());
        this.mMemLowThreshold = sm.getStorageLowBytes(DATA_PATH);
        this.mMemFullThreshold = sm.getStorageFullBytes(DATA_PATH);
        this.mMemCacheStartTrimThreshold = (this.mMemLowThreshold * 3L + this.mMemFullThreshold) / 4L;
        this.mMemCacheTrimToThreshold = this.mMemLowThreshold + (this.mMemLowThreshold - this.mMemCacheStartTrimThreshold) * 2L;
        this.mFreeMemAfterLastCacheClear = this.mTotalMemory;
        this.checkMemory(true);
        this.mCacheFileDeletedObserver = new CacheFileDeletedObserver();
        this.mCacheFileDeletedObserver.startWatching();
        this.publishBinderService(SERVICE, this.mRemoteService);
        this.publishLocalService(DeviceStorageMonitorInternal.class, this.mLocalService);
    }

    void dumpImpl(PrintWriter pw) {
        Context context = this.getContext();
        pw.println("Current DeviceStorageMonitor state:");
        pw.print("  mFreeMem=");
        pw.print(Formatter.formatFileSize(context, this.mFreeMem));
        pw.print(" mTotalMemory=");
        pw.println(Formatter.formatFileSize(context, this.mTotalMemory));
        pw.print("  mFreeMemAfterLastCacheClear=");
        pw.println(Formatter.formatFileSize(context, this.mFreeMemAfterLastCacheClear));
        pw.print("  mLastReportedFreeMem=");
        pw.print(Formatter.formatFileSize(context, this.mLastReportedFreeMem));
        pw.print(" mLastReportedFreeMemTime=");
        TimeUtils.formatDuration(this.mLastReportedFreeMemTime, SystemClock.elapsedRealtime(), pw);
        pw.println();
        pw.print("  mLowMemFlag=");
        pw.print(this.mLowMemFlag);
        pw.print(" mMemFullFlag=");
        pw.println(this.mMemFullFlag);
        pw.print(" mIsBootImageOnDisk=");
        pw.print(this.mIsBootImageOnDisk);
        pw.print("  mClearSucceeded=");
        pw.print(this.mClearSucceeded);
        pw.print(" mClearingCache=");
        pw.println(this.mClearingCache);
        pw.print("  mMemLowThreshold=");
        pw.print(Formatter.formatFileSize(context, this.mMemLowThreshold));
        pw.print(" mMemFullThreshold=");
        pw.println(Formatter.formatFileSize(context, this.mMemFullThreshold));
        pw.print("  mMemCacheStartTrimThreshold=");
        pw.print(Formatter.formatFileSize(context, this.mMemCacheStartTrimThreshold));
        pw.print(" mMemCacheTrimToThreshold=");
        pw.println(Formatter.formatFileSize(context, this.mMemCacheTrimToThreshold));
    }

    private void sendNotification() {
        Context context = this.getContext();
        EventLog.writeEvent(2745, this.mFreeMem);
        Intent lowMemIntent = new Intent(Environment.isExternalStorageEmulated() ? "android.settings.INTERNAL_STORAGE_SETTINGS" : "android.intent.action.MANAGE_PACKAGE_STORAGE");
        lowMemIntent.putExtra("memory", this.mFreeMem);
        lowMemIntent.addFlags(0x10000000);
        NotificationManager mNotificationMgr = (NotificationManager)context.getSystemService("notification");
        CharSequence title = context.getText(17040472);
        CharSequence details = context.getText(this.mIsBootImageOnDisk ? 17040473 : 17040474);
        PendingIntent intent = PendingIntent.getActivityAsUser(context, 0, lowMemIntent, 0, null, UserHandle.CURRENT);
        Notification notification = new Notification.Builder(context).setSmallIcon(17303119).setTicker(title).setColor(context.getResources().getColor(17170520)).setContentTitle(title).setContentText(details).setContentIntent(intent).setStyle(new Notification.BigTextStyle().bigText(details)).setVisibility(1).setCategory("sys").build();
        notification.flags |= 0x20;
        mNotificationMgr.notifyAsUser(null, 1, notification, UserHandle.ALL);
        context.sendStickyBroadcastAsUser(this.mStorageLowIntent, UserHandle.ALL);
    }

    private void cancelNotification() {
        Context context = this.getContext();
        NotificationManager mNotificationMgr = (NotificationManager)context.getSystemService("notification");
        mNotificationMgr.cancelAsUser(null, 1, UserHandle.ALL);
        context.removeStickyBroadcastAsUser(this.mStorageLowIntent, UserHandle.ALL);
        context.sendBroadcastAsUser(this.mStorageOkIntent, UserHandle.ALL);
    }

    private void sendFullNotification() {
        this.getContext().sendStickyBroadcastAsUser(this.mStorageFullIntent, UserHandle.ALL);
    }

    private void cancelFullNotification() {
        this.getContext().removeStickyBroadcastAsUser(this.mStorageFullIntent, UserHandle.ALL);
        this.getContext().sendBroadcastAsUser(this.mStorageNotFullIntent, UserHandle.ALL);
    }

    private static class CacheFileDeletedObserver
    extends FileObserver {
        public CacheFileDeletedObserver() {
            super(Environment.getDownloadCacheDirectory().getAbsolutePath(), 512);
        }

        @Override
        public void onEvent(int event, String path) {
            EventLogTags.writeCacheFileDeleted(path);
        }
    }

    private class CachePackageDataObserver
    extends IPackageDataObserver.Stub {
        private CachePackageDataObserver() {
        }

        @Override
        public void onRemoveCompleted(String packageName, boolean succeeded) {
            DeviceStorageMonitorService.this.mClearSucceeded = succeeded;
            DeviceStorageMonitorService.this.mClearingCache = false;
            DeviceStorageMonitorService.this.postCheckMemoryMsg(false, 0L);
        }
    }
}

