/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.twilight;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.Time;
import com.android.server.SystemService;
import com.android.server.TwilightCalculator;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.util.ArrayList;
import java.util.Iterator;
import libcore.util.Objects;

public final class TwilightService
extends SystemService {
    static final String TAG = "TwilightService";
    static final boolean DEBUG = false;
    static final String ACTION_UPDATE_TWILIGHT_STATE = "com.android.server.action.UPDATE_TWILIGHT_STATE";
    final Object mLock = new Object();
    AlarmManager mAlarmManager;
    LocationManager mLocationManager;
    LocationHandler mLocationHandler;
    final ArrayList<TwilightListenerRecord> mListeners = new ArrayList();
    TwilightState mTwilightState;
    private final TwilightManager mService = new TwilightManager(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TwilightState getCurrentState() {
            Object object = TwilightService.this.mLock;
            synchronized (object) {
                return TwilightService.this.mTwilightState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerListener(TwilightListener listener, Handler handler) {
            Object object = TwilightService.this.mLock;
            synchronized (object) {
                TwilightService.this.mListeners.add(new TwilightListenerRecord(listener, handler));
                if (TwilightService.this.mListeners.size() == 1) {
                    TwilightService.this.mLocationHandler.enableLocationUpdates();
                }
            }
        }
    };
    private final BroadcastReceiver mUpdateLocationReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.AIRPLANE_MODE".equals(intent.getAction()) && !intent.getBooleanExtra("state", false)) {
                TwilightService.this.mLocationHandler.requestLocationUpdate();
                return;
            }
            TwilightService.this.mLocationHandler.requestTwilightUpdate();
        }
    };
    private final LocationListener mEmptyLocationListener = new LocationListener(){

        @Override
        public void onLocationChanged(Location location) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };
    private final LocationListener mLocationListener = new LocationListener(){

        @Override
        public void onLocationChanged(Location location) {
            TwilightService.this.mLocationHandler.processNewLocation(location);
        }

        @Override
        public void onProviderDisabled(String provider) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };

    public TwilightService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
        this.mLocationManager = (LocationManager)this.getContext().getSystemService("location");
        this.mLocationHandler = new LocationHandler();
        IntentFilter filter = new IntentFilter("android.intent.action.AIRPLANE_MODE");
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        filter.addAction(ACTION_UPDATE_TWILIGHT_STATE);
        this.getContext().registerReceiver(this.mUpdateLocationReceiver, filter);
        this.publishLocalService(TwilightManager.class, this.mService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTwilightState(TwilightState state) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Objects.equal(this.mTwilightState, state)) {
                this.mTwilightState = state;
                int listenerLen = this.mListeners.size();
                for (int i = 0; i < listenerLen; ++i) {
                    this.mListeners.get(i).postUpdate();
                }
            }
        }
    }

    private static boolean hasMoved(Location from, Location to) {
        float totalAccuracy;
        if (to == null) {
            return false;
        }
        if (from == null) {
            return true;
        }
        if (to.getElapsedRealtimeNanos() < from.getElapsedRealtimeNanos()) {
            return false;
        }
        float distance = from.distanceTo(to);
        return distance >= (totalAccuracy = from.getAccuracy() + to.getAccuracy());
    }

    private final class LocationHandler
    extends Handler {
        private static final int MSG_ENABLE_LOCATION_UPDATES = 1;
        private static final int MSG_GET_NEW_LOCATION_UPDATE = 2;
        private static final int MSG_PROCESS_NEW_LOCATION = 3;
        private static final int MSG_DO_TWILIGHT_UPDATE = 4;
        private static final long LOCATION_UPDATE_MS = 86400000L;
        private static final long MIN_LOCATION_UPDATE_MS = 1800000L;
        private static final float LOCATION_UPDATE_DISTANCE_METER = 20000.0f;
        private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MIN = 5000L;
        private static final long LOCATION_UPDATE_ENABLE_INTERVAL_MAX = 900000L;
        private static final double FACTOR_GMT_OFFSET_LONGITUDE = 0.004166666666666667;
        private boolean mPassiveListenerEnabled;
        private boolean mNetworkListenerEnabled;
        private boolean mDidFirstInit;
        private long mLastNetworkRegisterTime = -1800000L;
        private long mLastUpdateInterval;
        private Location mLocation;
        private final TwilightCalculator mTwilightCalculator = new TwilightCalculator();

        private LocationHandler() {
        }

        public void processNewLocation(Location location) {
            Message msg = this.obtainMessage(3, location);
            this.sendMessage(msg);
        }

        public void enableLocationUpdates() {
            this.sendEmptyMessage(1);
        }

        public void requestLocationUpdate() {
            this.sendEmptyMessage(2);
        }

        public void requestTwilightUpdate() {
            this.sendEmptyMessage(4);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    boolean hasBetterAccuracy;
                    Location location = (Location)msg.obj;
                    boolean hasMoved = TwilightService.hasMoved(this.mLocation, location);
                    boolean bl = hasBetterAccuracy = this.mLocation == null || location.getAccuracy() < this.mLocation.getAccuracy();
                    if (!hasMoved && !hasBetterAccuracy) break;
                    this.setLocation(location);
                    break;
                }
                case 2: {
                    if (!this.mNetworkListenerEnabled) {
                        return;
                    }
                    if (this.mLastNetworkRegisterTime + 1800000L >= SystemClock.elapsedRealtime()) {
                        return;
                    }
                    this.mNetworkListenerEnabled = false;
                    TwilightService.this.mLocationManager.removeUpdates(TwilightService.this.mEmptyLocationListener);
                }
                case 1: {
                    boolean passiveLocationEnabled;
                    boolean networkLocationEnabled;
                    try {
                        networkLocationEnabled = TwilightService.this.mLocationManager.isProviderEnabled("network");
                    }
                    catch (Exception e) {
                        networkLocationEnabled = false;
                    }
                    if (!this.mNetworkListenerEnabled && networkLocationEnabled) {
                        this.mNetworkListenerEnabled = true;
                        this.mLastNetworkRegisterTime = SystemClock.elapsedRealtime();
                        TwilightService.this.mLocationManager.requestLocationUpdates("network", 86400000L, 0.0f, TwilightService.this.mEmptyLocationListener);
                        if (!this.mDidFirstInit) {
                            this.mDidFirstInit = true;
                            if (this.mLocation == null) {
                                this.retrieveLocation();
                            }
                        }
                    }
                    try {
                        passiveLocationEnabled = TwilightService.this.mLocationManager.isProviderEnabled("passive");
                    }
                    catch (Exception e) {
                        passiveLocationEnabled = false;
                    }
                    if (!this.mPassiveListenerEnabled && passiveLocationEnabled) {
                        this.mPassiveListenerEnabled = true;
                        TwilightService.this.mLocationManager.requestLocationUpdates("passive", 0L, 20000.0f, TwilightService.this.mLocationListener);
                    }
                    if (this.mNetworkListenerEnabled && this.mPassiveListenerEnabled) break;
                    this.mLastUpdateInterval = (long)((double)this.mLastUpdateInterval * 1.5);
                    if (this.mLastUpdateInterval == 0L) {
                        this.mLastUpdateInterval = 5000L;
                    } else if (this.mLastUpdateInterval > 900000L) {
                        this.mLastUpdateInterval = 900000L;
                    }
                    this.sendEmptyMessageDelayed(1, this.mLastUpdateInterval);
                    break;
                }
                case 4: {
                    this.updateTwilightState();
                }
            }
        }

        private void retrieveLocation() {
            Location location = null;
            Iterator<String> providers = TwilightService.this.mLocationManager.getProviders(new Criteria(), true).iterator();
            while (providers.hasNext()) {
                Location lastKnownLocation = TwilightService.this.mLocationManager.getLastKnownLocation(providers.next());
                if (location != null && (lastKnownLocation == null || location.getElapsedRealtimeNanos() >= lastKnownLocation.getElapsedRealtimeNanos())) continue;
                location = lastKnownLocation;
            }
            if (location == null) {
                Time currentTime = new Time();
                currentTime.set(System.currentTimeMillis());
                double lngOffset = 0.004166666666666667 * (double)(currentTime.gmtoff - (long)(currentTime.isDst > 0 ? 3600 : 0));
                location = new Location("fake");
                location.setLongitude(lngOffset);
                location.setLatitude(0.0);
                location.setAccuracy(417000.0f);
                location.setTime(System.currentTimeMillis());
                location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            }
            this.setLocation(location);
        }

        private void setLocation(Location location) {
            this.mLocation = location;
            this.updateTwilightState();
        }

        private void updateTwilightState() {
            if (this.mLocation == null) {
                TwilightService.this.setTwilightState(null);
                return;
            }
            long now = System.currentTimeMillis();
            this.mTwilightCalculator.calculateTwilight(now - 86400000L, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            long yesterdaySunset = this.mTwilightCalculator.mSunset;
            this.mTwilightCalculator.calculateTwilight(now, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            boolean isNight = this.mTwilightCalculator.mState == 1;
            long todaySunrise = this.mTwilightCalculator.mSunrise;
            long todaySunset = this.mTwilightCalculator.mSunset;
            this.mTwilightCalculator.calculateTwilight(now + 86400000L, this.mLocation.getLatitude(), this.mLocation.getLongitude());
            long tomorrowSunrise = this.mTwilightCalculator.mSunrise;
            TwilightState state = new TwilightState(isNight, yesterdaySunset, todaySunrise, todaySunset, tomorrowSunrise);
            TwilightService.this.setTwilightState(state);
            long nextUpdate = 0L;
            if (todaySunrise == -1L || todaySunset == -1L) {
                nextUpdate = now + 43200000L;
            } else {
                nextUpdate += 60000L;
                nextUpdate = now > todaySunset ? (nextUpdate += tomorrowSunrise) : (now > todaySunrise ? (nextUpdate += todaySunset) : (nextUpdate += todaySunrise));
            }
            Intent updateIntent = new Intent(TwilightService.ACTION_UPDATE_TWILIGHT_STATE);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(TwilightService.this.getContext(), 0, updateIntent, 0);
            TwilightService.this.mAlarmManager.cancel(pendingIntent);
            TwilightService.this.mAlarmManager.setExact(1, nextUpdate, pendingIntent);
        }
    }

    private static class TwilightListenerRecord
    implements Runnable {
        private final TwilightListener mListener;
        private final Handler mHandler;

        public TwilightListenerRecord(TwilightListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        public void postUpdate() {
            this.mHandler.post(this);
        }

        @Override
        public void run() {
            this.mListener.onTwilightStateChanged();
        }
    }
}

