/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

public class UnixCalendar {
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long WEEK_IN_MILLIS = 604800000L;
    private static final long MONTH_IN_MILLIS = 2592000000L;
    private static final long YEAR_IN_MILLIS = 31536000000L;
    private long mTime;

    public UnixCalendar(long time) {
        this.mTime = time;
    }

    public void truncateToDay() {
        this.mTime -= this.mTime % 86400000L;
    }

    public void truncateToWeek() {
        this.mTime -= this.mTime % 604800000L;
    }

    public void truncateToMonth() {
        this.mTime -= this.mTime % 2592000000L;
    }

    public void truncateToYear() {
        this.mTime -= this.mTime % 31536000000L;
    }

    public void addDays(int val) {
        this.mTime += (long)val * 86400000L;
    }

    public void addWeeks(int val) {
        this.mTime += (long)val * 604800000L;
    }

    public void addMonths(int val) {
        this.mTime += (long)val * 2592000000L;
    }

    public void addYears(int val) {
        this.mTime += (long)val * 31536000000L;
    }

    public void setTimeInMillis(long time) {
        this.mTime = time;
    }

    public long getTimeInMillis() {
        return this.mTime;
    }

    public static void truncateTo(UnixCalendar calendar, int intervalType) {
        switch (intervalType) {
            case 3: {
                calendar.truncateToYear();
                break;
            }
            case 2: {
                calendar.truncateToMonth();
                break;
            }
            case 1: {
                calendar.truncateToWeek();
                break;
            }
            case 0: {
                calendar.truncateToDay();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't truncate date to interval " + intervalType);
            }
        }
    }
}

