/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.hardware.soundtrigger.SoundTrigger;
import android.text.TextUtils;
import android.util.Slog;
import java.util.Locale;
import java.util.UUID;

public class DatabaseHelper
extends SQLiteOpenHelper {
    static final String TAG = "SoundModelDBHelper";
    static final boolean DBG = false;
    private static final String NAME = "sound_model.db";
    private static final int VERSION = 4;
    private static final String CREATE_TABLE_SOUND_MODEL = "CREATE TABLE sound_model(model_uuid TEXT PRIMARY KEY,keyphrase_id INTEGER,type INTEGER,data BLOB,recognition_modes INTEGER,locale TEXT,hint_text TEXT,users TEXT)";

    public DatabaseHelper(Context context) {
        super(context, NAME, null, 4);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE_SOUND_MODEL);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS sound_model");
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) {
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            boolean bl;
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("model_uuid", soundModel.uuid.toString());
            values.put("type", 0);
            values.put("data", soundModel.data);
            if (soundModel.keyphrases == null || soundModel.keyphrases.length != 1) return false;
            values.put("keyphrase_id", soundModel.keyphrases[0].id);
            values.put("recognition_modes", soundModel.keyphrases[0].recognitionModes);
            values.put("users", DatabaseHelper.getCommaSeparatedString(soundModel.keyphrases[0].users));
            values.put("locale", soundModel.keyphrases[0].locale);
            values.put("hint_text", soundModel.keyphrases[0].text);
            try {
                bl = db.insertWithOnConflict("sound_model", null, values, 5) != -1L;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKeyphraseSoundModel(int keyphraseId, int userHandle, String bcp47Locale) {
        bcp47Locale = Locale.forLanguageTag(bcp47Locale).toLanguageTag();
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            boolean bl;
            SoundTrigger.KeyphraseSoundModel soundModel = this.getKeyphraseSoundModel(keyphraseId, userHandle, bcp47Locale);
            if (soundModel == null) {
                return false;
            }
            SQLiteDatabase db = this.getWritableDatabase();
            String soundModelClause = "model_uuid='" + soundModel.uuid.toString() + "'";
            try {
                bl = db.delete("sound_model", soundModelClause, null) != 0;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, int userHandle, String bcp47Locale) {
        bcp47Locale = Locale.forLanguageTag(bcp47Locale).toLanguageTag();
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            String selectQuery = "SELECT  * FROM sound_model WHERE keyphrase_id= '" + keyphraseId + "' AND " + "locale" + "='" + bcp47Locale + "'";
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor c = db.rawQuery(selectQuery, null);
            try {
                if (c.moveToFirst()) {
                    do {
                        SoundTrigger.KeyphraseSoundModel model;
                        int type;
                        if ((type = c.getInt(c.getColumnIndex("type"))) != 0) continue;
                        String modelUuid = c.getString(c.getColumnIndex("model_uuid"));
                        if (modelUuid == null) {
                            Slog.w(TAG, "Ignoring SoundModel since it doesn't specify an ID");
                            continue;
                        }
                        byte[] data = c.getBlob(c.getColumnIndex("data"));
                        int recognitionModes = c.getInt(c.getColumnIndex("recognition_modes"));
                        int[] users = DatabaseHelper.getArrayForCommaSeparatedString(c.getString(c.getColumnIndex("users")));
                        String modelLocale = c.getString(c.getColumnIndex("locale"));
                        String text = c.getString(c.getColumnIndex("hint_text"));
                        if (users == null) {
                            Slog.w(TAG, "Ignoring SoundModel since it doesn't specify users");
                            continue;
                        }
                        boolean isAvailableForCurrentUser = false;
                        for (int user : users) {
                            if (userHandle != user) continue;
                            isAvailableForCurrentUser = true;
                            break;
                        }
                        if (!isAvailableForCurrentUser) continue;
                        SoundTrigger.Keyphrase[] keyphrases = new SoundTrigger.Keyphrase[]{new SoundTrigger.Keyphrase(keyphraseId, recognitionModes, modelLocale, text, users)};
                        SoundTrigger.KeyphraseSoundModel keyphraseSoundModel = model = new SoundTrigger.KeyphraseSoundModel(UUID.fromString(modelUuid), null, data, keyphrases);
                        return keyphraseSoundModel;
                    } while (c.moveToNext());
                }
                Slog.w(TAG, "No SoundModel available for the given keyphrase");
            }
            finally {
                c.close();
                db.close();
            }
            return null;
        }
    }

    private static String getCommaSeparatedString(int[] users) {
        if (users == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < users.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(users[i]);
        }
        return sb.toString();
    }

    private static int[] getArrayForCommaSeparatedString(String text) {
        if (TextUtils.isEmpty(text)) {
            return null;
        }
        String[] usersStr = text.split(",");
        int[] users = new int[usersStr.length];
        for (int i = 0; i < usersStr.length; ++i) {
            users[i] = Integer.valueOf(usersStr[i]);
        }
        return users;
    }

    public static interface SoundModelContract {
        public static final String TABLE = "sound_model";
        public static final String KEY_MODEL_UUID = "model_uuid";
        public static final String KEY_KEYPHRASE_ID = "keyphrase_id";
        public static final String KEY_TYPE = "type";
        public static final String KEY_DATA = "data";
        public static final String KEY_RECOGNITION_MODES = "recognition_modes";
        public static final String KEY_LOCALE = "locale";
        public static final String KEY_HINT_TEXT = "hint_text";
        public static final String KEY_USERS = "users";
    }
}

