/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManagerNative;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.InputChannel;
import android.view.KeyEvent;
import com.android.server.input.InputApplicationHandle;
import com.android.server.input.InputManagerService;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.util.Arrays;
import java.util.HashMap;

final class InputMonitor
implements InputManagerService.WindowManagerCallbacks {
    private final WindowManagerService mService;
    private WindowState mInputFocus;
    private boolean mInputDispatchFrozen;
    private boolean mInputDispatchEnabled;
    private boolean mUpdateInputWindowsNeeded = true;
    private InputWindowHandle[] mInputWindowHandles;
    private int mInputWindowHandleCount;
    private final Object mInputDevicesReadyMonitor = new Object();
    private boolean mInputDevicesReady;
    Rect mTmpRect = new Rect();

    public InputMonitor(WindowManagerService service) {
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyInputChannelBroken(InputWindowHandle inputWindowHandle) {
        if (inputWindowHandle == null) {
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = (WindowState)inputWindowHandle.windowState;
            if (windowState != null) {
                Slog.i("WindowManager", "WINDOW DIED " + windowState);
                this.mService.removeWindowLocked(windowState.mSession, windowState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long notifyANR(InputApplicationHandle inputApplicationHandle, InputWindowHandle inputWindowHandle, String reason) {
        AppWindowToken appWindowToken = null;
        WindowState windowState = null;
        boolean aboveSystem = false;
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (inputWindowHandle != null && (windowState = (WindowState)inputWindowHandle.windowState) != null) {
                appWindowToken = windowState.mAppToken;
            }
            if (appWindowToken == null && inputApplicationHandle != null) {
                appWindowToken = (AppWindowToken)inputApplicationHandle.appWindowToken;
            }
            if (windowState != null) {
                Slog.i("WindowManager", "Input event dispatching timed out sending to " + windowState.mAttrs.getTitle() + ".  Reason: " + reason);
                int systemAlertLayer = this.mService.mPolicy.windowTypeToLayerLw(2003);
                aboveSystem = windowState.mBaseLayer > systemAlertLayer;
            } else if (appWindowToken != null) {
                Slog.i("WindowManager", "Input event dispatching timed out sending to application " + appWindowToken.stringName + ".  Reason: " + reason);
            } else {
                Slog.i("WindowManager", "Input event dispatching timed out .  Reason: " + reason);
            }
            this.mService.saveANRStateLocked(appWindowToken, windowState, reason);
        }
        if (appWindowToken != null && appWindowToken.appToken != null) {
            try {
                boolean abort = appWindowToken.appToken.keyDispatchingTimedOut(reason);
                if (!abort) {
                    return appWindowToken.inputDispatchingTimeoutNanos;
                }
            }
            catch (RemoteException ex) {}
        } else if (windowState != null) {
            try {
                long timeout = ActivityManagerNative.getDefault().inputDispatchingTimedOut(windowState.mSession.mPid, aboveSystem, reason);
                if (timeout >= 0L) {
                    return timeout;
                }
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return 0L;
    }

    private void addInputWindowHandleLw(InputWindowHandle windowHandle) {
        if (this.mInputWindowHandles == null) {
            this.mInputWindowHandles = new InputWindowHandle[16];
        }
        if (this.mInputWindowHandleCount >= this.mInputWindowHandles.length) {
            this.mInputWindowHandles = Arrays.copyOf(this.mInputWindowHandles, this.mInputWindowHandleCount * 2);
        }
        this.mInputWindowHandles[this.mInputWindowHandleCount++] = windowHandle;
    }

    private void addInputWindowHandleLw(InputWindowHandle inputWindowHandle, WindowState child, int flags, int privateFlags, int type, boolean isVisible, boolean hasFocus, boolean hasWallpaper) {
        boolean modal;
        inputWindowHandle.name = child.toString();
        boolean bl = modal = (flags & 0x28) == 0;
        if (modal && child.mAppToken != null) {
            flags |= 0x20;
            child.getStackBounds(this.mTmpRect);
            inputWindowHandle.touchableRegion.set(this.mTmpRect);
        } else {
            child.getTouchableRegion(inputWindowHandle.touchableRegion);
        }
        inputWindowHandle.layoutParamsFlags = flags;
        inputWindowHandle.layoutParamsPrivateFlags = privateFlags;
        inputWindowHandle.layoutParamsType = type;
        inputWindowHandle.dispatchingTimeoutNanos = child.getInputDispatchingTimeoutNanos();
        inputWindowHandle.visible = isVisible;
        inputWindowHandle.canReceiveKeys = child.canReceiveKeys();
        inputWindowHandle.hasFocus = hasFocus;
        inputWindowHandle.hasWallpaper = hasWallpaper;
        inputWindowHandle.paused = child.mAppToken != null ? child.mAppToken.paused : false;
        inputWindowHandle.layer = child.mLayer;
        inputWindowHandle.ownerPid = child.mSession.mPid;
        inputWindowHandle.ownerUid = child.mSession.mUid;
        inputWindowHandle.inputFeatures = child.mAttrs.inputFeatures;
        Rect frame = child.mFrame;
        inputWindowHandle.frameLeft = frame.left;
        inputWindowHandle.frameTop = frame.top;
        inputWindowHandle.frameRight = frame.right;
        inputWindowHandle.frameBottom = frame.bottom;
        inputWindowHandle.scaleFactor = child.mGlobalScale != 1.0f ? 1.0f / child.mGlobalScale : 1.0f;
        this.addInputWindowHandleLw(inputWindowHandle);
    }

    private void clearInputWindowHandlesLw() {
        while (this.mInputWindowHandleCount != 0) {
            this.mInputWindowHandles[--this.mInputWindowHandleCount] = null;
        }
    }

    public void setUpdateInputWindowsNeededLw() {
        this.mUpdateInputWindowsNeeded = true;
    }

    public void updateInputWindowsLw(boolean force) {
        boolean inDrag;
        if (!force && !this.mUpdateInputWindowsNeeded) {
            return;
        }
        this.mUpdateInputWindowsNeeded = false;
        WindowStateAnimator universeBackground = this.mService.mAnimator.mUniverseBackground;
        int aboveUniverseLayer = this.mService.mAnimator.mAboveUniverseLayer;
        boolean addedUniverse = false;
        boolean bl = inDrag = this.mService.mDragState != null;
        if (inDrag) {
            InputWindowHandle dragWindowHandle = this.mService.mDragState.mDragWindowHandle;
            if (dragWindowHandle != null) {
                this.addInputWindowHandleLw(dragWindowHandle);
            } else {
                Slog.w("WindowManager", "Drag is in progress but there is no drag window handle.");
            }
        }
        int NFW = this.mService.mFakeWindows.size();
        for (int i = 0; i < NFW; ++i) {
            this.addInputWindowHandleLw(this.mService.mFakeWindows.get((int)i).mWindowHandle);
        }
        int numDisplays = this.mService.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windows = this.mService.mDisplayContents.valueAt(displayNdx).getWindowList();
            for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                boolean onDefaultDisplay;
                WindowState child = (WindowState)windows.get(winNdx);
                InputChannel inputChannel = child.mInputChannel;
                InputWindowHandle inputWindowHandle = child.mInputWindowHandle;
                if (inputChannel == null || inputWindowHandle == null || child.mRemoved) continue;
                int flags = child.mAttrs.flags;
                int privateFlags = child.mAttrs.privateFlags;
                int type = child.mAttrs.type;
                boolean hasFocus = child == this.mInputFocus;
                boolean isVisible = child.isVisibleLw();
                boolean hasWallpaper = child == this.mService.mWallpaperTarget && (privateFlags & 0x400) == 0;
                boolean bl2 = onDefaultDisplay = child.getDisplayId() == 0;
                if (inDrag && isVisible && onDefaultDisplay) {
                    this.mService.mDragState.sendDragStartedIfNeededLw(child);
                }
                if (universeBackground != null && !addedUniverse && child.mBaseLayer < aboveUniverseLayer && onDefaultDisplay) {
                    WindowState u = universeBackground.mWin;
                    if (u.mInputChannel != null && u.mInputWindowHandle != null) {
                        this.addInputWindowHandleLw(u.mInputWindowHandle, u, u.mAttrs.flags, u.mAttrs.privateFlags, u.mAttrs.type, true, u == this.mInputFocus, false);
                    }
                    addedUniverse = true;
                }
                if (child.mWinAnimator == universeBackground) continue;
                this.addInputWindowHandleLw(inputWindowHandle, child, flags, privateFlags, type, isVisible, hasFocus, hasWallpaper);
            }
        }
        this.mService.mInputManager.setInputWindows(this.mInputWindowHandles);
        this.clearInputWindowHandlesLw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyConfigurationChanged() {
        this.mService.sendNewConfiguration();
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                this.mInputDevicesReady = true;
                this.mInputDevicesReadyMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForInputDevicesReady(long timeoutMillis) {
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                try {
                    this.mInputDevicesReadyMonitor.wait(timeoutMillis);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return this.mInputDevicesReady;
        }
    }

    @Override
    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        this.mService.mPolicy.notifyLidSwitchChanged(whenNanos, lidOpen);
    }

    @Override
    public void notifyCameraLensCoverSwitchChanged(long whenNanos, boolean lensCovered) {
        this.mService.mPolicy.notifyCameraLensCoverSwitchChanged(whenNanos, lensCovered);
    }

    @Override
    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        return this.mService.mPolicy.interceptKeyBeforeQueueing(event, policyFlags);
    }

    @Override
    public int interceptMotionBeforeQueueingNonInteractive(long whenNanos, int policyFlags) {
        return this.mService.mPolicy.interceptMotionBeforeQueueingNonInteractive(whenNanos, policyFlags);
    }

    @Override
    public long interceptKeyBeforeDispatching(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.interceptKeyBeforeDispatching(windowState, event, policyFlags);
    }

    @Override
    public KeyEvent dispatchUnhandledKey(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.dispatchUnhandledKey(windowState, event, policyFlags);
    }

    @Override
    public int getPointerLayer() {
        return this.mService.mPolicy.windowTypeToLayerLw(2018) * 10000 + 1000;
    }

    public void setInputFocusLw(WindowState newWindow, boolean updateInputWindows) {
        if (newWindow != this.mInputFocus) {
            if (newWindow != null && newWindow.canReceiveKeys()) {
                newWindow.mToken.paused = false;
            }
            this.mInputFocus = newWindow;
            this.setUpdateInputWindowsNeededLw();
            if (updateInputWindows) {
                this.updateInputWindowsLw(false);
            }
        }
    }

    public void setFocusedAppLw(AppWindowToken newApp) {
        if (newApp == null) {
            this.mService.mInputManager.setFocusedApplication(null);
        } else {
            InputApplicationHandle handle = newApp.mInputApplicationHandle;
            handle.name = newApp.toString();
            handle.dispatchingTimeoutNanos = newApp.inputDispatchingTimeoutNanos;
            this.mService.mInputManager.setFocusedApplication(handle);
        }
    }

    public void pauseDispatchingLw(WindowToken window) {
        if (!window.paused) {
            window.paused = true;
            this.updateInputWindowsLw(true);
        }
    }

    public void resumeDispatchingLw(WindowToken window) {
        if (window.paused) {
            window.paused = false;
            this.updateInputWindowsLw(true);
        }
    }

    public void freezeInputDispatchingLw() {
        if (!this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = true;
            this.updateInputDispatchModeLw();
        }
    }

    public void thawInputDispatchingLw() {
        if (this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = false;
            this.updateInputDispatchModeLw();
        }
    }

    public void setEventDispatchingLw(boolean enabled) {
        if (this.mInputDispatchEnabled != enabled) {
            this.mInputDispatchEnabled = enabled;
            this.updateInputDispatchModeLw();
        }
    }

    private void updateInputDispatchModeLw() {
        this.mService.mInputManager.setInputDispatchMode(this.mInputDispatchEnabled, this.mInputDispatchFrozen);
    }
}

