/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Region;
import android.view.DisplayInfo;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowManagerService;

public class StackTapPointerEventListener
implements WindowManagerPolicy.PointerEventListener {
    private static final int TAP_TIMEOUT_MSEC = 300;
    private static final float TAP_MOTION_SLOP_INCHES = 0.125f;
    private final int mMotionSlop;
    private float mDownX;
    private float mDownY;
    private int mPointerId;
    private final Region mTouchExcludeRegion;
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;

    public StackTapPointerEventListener(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mTouchExcludeRegion = displayContent.mTouchExcludeRegion;
        DisplayInfo info = displayContent.getDisplayInfo();
        this.mMotionSlop = (int)((float)info.logicalDensityDpi * 0.125f);
    }

    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mPointerId = motionEvent.getPointerId(0);
                this.mDownX = motionEvent.getX();
                this.mDownY = motionEvent.getY();
                break;
            }
            case 2: {
                if (this.mPointerId < 0) break;
                int index = motionEvent.findPointerIndex(this.mPointerId);
                if (motionEvent.getEventTime() - motionEvent.getDownTime() <= 300L && !(motionEvent.getX(index) - this.mDownX > (float)this.mMotionSlop) && !(motionEvent.getY(index) - this.mDownY > (float)this.mMotionSlop)) break;
                this.mPointerId = -1;
                break;
            }
            case 1: 
            case 6: {
                int index = (action & 0xFF00) >> 8;
                if (this.mPointerId != motionEvent.getPointerId(index)) break;
                int x = (int)motionEvent.getX(index);
                int y = (int)motionEvent.getY(index);
                if (motionEvent.getEventTime() - motionEvent.getDownTime() < 300L && (float)x - this.mDownX < (float)this.mMotionSlop && (float)y - this.mDownY < (float)this.mMotionSlop && !this.mTouchExcludeRegion.contains(x, y)) {
                    this.mService.mH.obtainMessage(31, x, y, this.mDisplayContent).sendToTarget();
                }
                this.mPointerId = -1;
                break;
            }
        }
    }
}

