/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.EventLog;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;

class Task {
    TaskStack mStack;
    final AppTokenList mAppTokens = new AppTokenList();
    final int taskId;
    final int mUserId;
    boolean mDeferRemoval = false;

    Task(AppWindowToken wtoken, TaskStack stack, int userId) {
        this.taskId = wtoken.groupId;
        this.mAppTokens.add(wtoken);
        this.mStack = stack;
        this.mUserId = userId;
    }

    DisplayContent getDisplayContent() {
        return this.mStack.getDisplayContent();
    }

    void addAppToken(int addPos, AppWindowToken wtoken) {
        int lastPos = this.mAppTokens.size();
        for (int pos = 0; pos < lastPos && pos < addPos; ++pos) {
            if (!((AppWindowToken)this.mAppTokens.get((int)pos)).removed) continue;
            ++addPos;
        }
        this.mAppTokens.add(addPos, wtoken);
        this.mDeferRemoval = false;
    }

    boolean removeAppToken(AppWindowToken wtoken) {
        boolean removed = this.mAppTokens.remove(wtoken);
        if (this.mAppTokens.size() == 0) {
            EventLog.writeEvent(31003, this.taskId, "removeAppToken: last token");
        }
        return removed;
    }

    public String toString() {
        return "{taskId=" + this.taskId + " appTokens=" + this.mAppTokens + "}";
    }
}

