/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.util.EventLog;
import android.util.TypedValue;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TaskStack {
    private static final int DEFAULT_DIM_DURATION = 200;
    final int mStackId;
    private final WindowManagerService mService;
    private DisplayContent mDisplayContent;
    private final ArrayList<Task> mTasks = new ArrayList();
    private Rect mTmpRect = new Rect();
    private Rect mBounds = new Rect();
    private boolean mFullscreen = true;
    private DimLayer mDimLayer;
    WindowStateAnimator mDimWinAnimator;
    DimLayer mAnimationBackgroundSurface;
    WindowStateAnimator mAnimationBackgroundAnimator;
    boolean mDimmingTag;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    boolean mDeferDetach;

    TaskStack(WindowManagerService service, int stackId) {
        this.mService = service;
        this.mStackId = stackId;
        EventLog.writeEvent(31004, stackId, this.mBounds.left, this.mBounds.top, this.mBounds.right, this.mBounds.bottom);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    ArrayList<Task> getTasks() {
        return this.mTasks;
    }

    void resizeWindows() {
        boolean underStatusBar = this.mBounds.top == 0;
        ArrayList<WindowState> resizingWindows = this.mService.mResizingWindows;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (!resizingWindows.contains(win)) {
                        resizingWindows.add(win);
                    }
                    win.mUnderStatusBar = underStatusBar;
                }
            }
        }
    }

    boolean setBounds(Rect bounds) {
        boolean oldFullscreen = this.mFullscreen;
        if (this.mDisplayContent != null) {
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            this.mFullscreen = this.mTmpRect.equals(bounds);
        }
        if (this.mBounds.equals(bounds) && oldFullscreen == this.mFullscreen) {
            return false;
        }
        this.mDimLayer.setBounds(bounds);
        this.mAnimationBackgroundSurface.setBounds(bounds);
        this.mBounds.set(bounds);
        return true;
    }

    void getBounds(Rect out) {
        out.set(this.mBounds);
    }

    void updateDisplayInfo() {
        if (this.mFullscreen && this.mDisplayContent != null) {
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            this.setBounds(this.mTmpRect);
        }
    }

    boolean isFullscreen() {
        return this.mFullscreen;
    }

    boolean isAnimating() {
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowStateAnimator winAnimator = ((WindowState)windows.get((int)winNdx)).mWinAnimator;
                    if (!winAnimator.isAnimating() && !winAnimator.mWin.mExiting) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void addTask(Task task, boolean toTop) {
        int stackNdx;
        if (!toTop) {
            stackNdx = 0;
        } else {
            stackNdx = this.mTasks.size();
            if (!this.mService.isCurrentProfileLocked(task.mUserId)) {
                while (--stackNdx >= 0 && this.mService.isCurrentProfileLocked(this.mTasks.get((int)stackNdx).mUserId)) {
                }
                ++stackNdx;
            }
        }
        this.mTasks.add(stackNdx, task);
        task.mStack = this;
        this.mDisplayContent.moveStack(this, true);
        EventLog.writeEvent(31002, task.taskId, toTop ? 1 : 0, stackNdx);
    }

    void moveTaskToTop(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, true);
    }

    void moveTaskToBottom(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, false);
    }

    void removeTask(Task task) {
        this.mTasks.remove(task);
        if (this.mDisplayContent != null) {
            if (this.mTasks.isEmpty()) {
                this.mDisplayContent.moveStack(this, false);
            }
            this.mDisplayContent.layoutNeeded = true;
        }
    }

    void attachDisplayContent(DisplayContent displayContent) {
        if (this.mDisplayContent != null) {
            throw new IllegalStateException("attachDisplayContent: Already attached");
        }
        this.mDisplayContent = displayContent;
        this.mDimLayer = new DimLayer(this.mService, this, displayContent);
        this.mAnimationBackgroundSurface = new DimLayer(this.mService, this, displayContent);
        this.updateDisplayInfo();
    }

    void detachDisplay() {
        EventLog.writeEvent(31006, this.mStackId);
        boolean doAnotherLayoutPass = false;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList appWindowTokens = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int appNdx = appWindowTokens.size() - 1; appNdx >= 0; --appNdx) {
                WindowList appWindows = ((AppWindowToken)appWindowTokens.get((int)appNdx)).allAppWindows;
                for (int winNdx = appWindows.size() - 1; winNdx >= 0; --winNdx) {
                    this.mService.removeWindowInnerLocked(null, (WindowState)appWindows.get(winNdx));
                    doAnotherLayoutPass = true;
                }
            }
        }
        if (doAnotherLayoutPass) {
            this.mService.requestTraversalLocked();
        }
        this.mAnimationBackgroundSurface.destroySurface();
        this.mAnimationBackgroundSurface = null;
        this.mDimLayer.destroySurface();
        this.mDimLayer = null;
        this.mDisplayContent = null;
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.mAnimationBackgroundSurface.hide();
    }

    private long getDimBehindFadeDuration(long duration) {
        TypedValue tv = new TypedValue();
        this.mService.mContext.getResources().getValue(0x1130000, tv, true);
        if (tv.type == 6) {
            duration = (long)tv.getFraction(duration, duration);
        } else if (tv.type >= 16 && tv.type <= 31) {
            duration = tv.data;
        }
        return duration;
    }

    boolean animateDimLayers() {
        float dimAmount;
        int dimLayer;
        if (this.mDimWinAnimator == null) {
            dimLayer = this.mDimLayer.getLayer();
            dimAmount = 0.0f;
        } else {
            dimLayer = this.mDimWinAnimator.mAnimLayer - 1;
            dimAmount = this.mDimWinAnimator.mWin.mAttrs.dimAmount;
        }
        float targetAlpha = this.mDimLayer.getTargetAlpha();
        if (targetAlpha != dimAmount) {
            if (this.mDimWinAnimator == null) {
                this.mDimLayer.hide(200L);
            } else {
                long duration;
                long l = duration = this.mDimWinAnimator.mAnimating && this.mDimWinAnimator.mAnimation != null ? this.mDimWinAnimator.mAnimation.computeDurationHint() : 200L;
                if (targetAlpha > dimAmount) {
                    duration = this.getDimBehindFadeDuration(duration);
                }
                this.mDimLayer.show(dimLayer, dimAmount, duration);
            }
        } else if (this.mDimLayer.getLayer() != dimLayer) {
            this.mDimLayer.setLayer(dimLayer);
        }
        if (this.mDimLayer.isAnimating()) {
            if (!this.mService.okToDisplay()) {
                this.mDimLayer.show();
            } else {
                return this.mDimLayer.stepAnimation();
            }
        }
        return false;
    }

    void resetDimmingTag() {
        this.mDimmingTag = false;
    }

    void setDimmingTag() {
        this.mDimmingTag = true;
    }

    boolean testDimmingTag() {
        return this.mDimmingTag;
    }

    boolean isDimming() {
        return this.mDimLayer.isDimming();
    }

    boolean isDimming(WindowStateAnimator winAnimator) {
        return this.mDimWinAnimator == winAnimator && this.mDimLayer.isDimming();
    }

    void startDimmingIfNeeded(WindowStateAnimator newWinAnimator) {
        WindowStateAnimator existingDimWinAnimator = this.mDimWinAnimator;
        if (newWinAnimator.mSurfaceShown && (existingDimWinAnimator == null || !existingDimWinAnimator.mSurfaceShown || existingDimWinAnimator.mAnimLayer < newWinAnimator.mAnimLayer)) {
            this.mDimWinAnimator = newWinAnimator;
        }
    }

    void stopDimmingIfNeeded() {
        if (!this.mDimmingTag && this.isDimming()) {
            this.mDimWinAnimator = null;
        }
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mService.adjustAnimationBackground(winAnimator);
            this.mAnimationBackgroundSurface.show(animLayer - 1, (float)(color2 >> 24 & 0xFF) / 255.0f, 0L);
        }
    }

    void switchUser(int userId) {
        int top = this.mTasks.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            if (!this.mService.isCurrentProfileLocked(task.mUserId)) continue;
            this.mTasks.remove(taskNdx);
            this.mTasks.add(task);
            --top;
        }
    }

    void close() {
        this.mDimLayer.mDimSurface.destroy();
        this.mAnimationBackgroundSurface.mDimSurface.destroy();
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mStackId=");
        pw.println(this.mStackId);
        pw.print(prefix);
        pw.print("mDeferDetach=");
        pw.println(this.mDeferDetach);
        for (int taskNdx = 0; taskNdx < this.mTasks.size(); ++taskNdx) {
            pw.print(prefix);
            pw.println(this.mTasks.get(taskNdx));
        }
        if (this.mAnimationBackgroundSurface.isDimming()) {
            pw.print(prefix);
            pw.println("mWindowAnimationBackgroundSurface:");
            this.mAnimationBackgroundSurface.printTo(prefix + "  ", pw);
        }
        if (this.mDimLayer.isDimming()) {
            pw.print(prefix);
            pw.println("mDimLayer:");
            this.mDimLayer.printTo(prefix, pw);
            pw.print(prefix);
            pw.print("mDimWinAnimator=");
            pw.println(this.mDimWinAnimator);
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mTasks + "}";
    }
}

