/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import libcore.io.Libcore;

public final class DexFile {
    private long mCookie;
    private final String mFileName;
    private final CloseGuard guard = CloseGuard.get();
    public static final byte UP_TO_DATE = 0;
    public static final byte PATCHOAT_NEEDED = 1;
    public static final byte DEXOPT_NEEDED = 2;

    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    public DexFile(String fileName) throws IOException {
        this.mCookie = DexFile.openDexFile(fileName, null, 0);
        this.mFileName = fileName;
        this.guard.open("close");
    }

    private DexFile(String sourceName, String outputName, int flags) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect" + " your application from code injection attacks.");
                }
            }
            catch (ErrnoException ignored) {
                // empty catch block
            }
        }
        this.mCookie = DexFile.openDexFile(sourceName, outputName, flags);
        this.mFileName = sourceName;
        this.guard.open("close");
    }

    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags);
    }

    public String getName() {
        return this.mFileName;
    }

    public String toString() {
        return this.getName();
    }

    public void close() throws IOException {
        if (this.mCookie != 0L) {
            this.guard.close();
            DexFile.closeDexFile(this.mCookie);
            this.mCookie = 0L;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, long cookie, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static long openDexFile(String sourceName, String outputName, int flags) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getAbsolutePath(), outputName == null ? null : new File(outputName).getAbsolutePath(), flags);
    }

    private static native void closeDexFile(long var0);

    private static native Class defineClassNative(String var0, ClassLoader var1, long var2) throws ClassNotFoundException, NoClassDefFoundError;

    private static native String[] getClassNameList(long var0);

    private static native long openDexFileNative(String var0, String var1, int var2);

    public static native boolean isDexOptNeeded(String var0) throws FileNotFoundException, IOException;

    public static native byte isDexOptNeededInternal(String var0, String var1, String var2, boolean var3) throws FileNotFoundException, IOException;

    private class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(DexFile.this.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

