/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import libcore.io.Libcore;

public final class Console
implements Flushable {
    private static final Object CONSOLE_LOCK = new Object();
    private static final Console console = Console.makeConsole();
    private final ConsoleReader reader;
    private final PrintWriter writer;

    public static Console getConsole() {
        return console;
    }

    private static Console makeConsole() {
        if (!Libcore.os.isatty(FileDescriptor.in) || !Libcore.os.isatty(FileDescriptor.out)) {
            return null;
        }
        try {
            return new Console(System.in, System.out);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private Console(InputStream in, OutputStream out) throws UnsupportedEncodingException {
        this.reader = new ConsoleReader(in);
        this.writer = new ConsoleWriter(out);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    public Console format(String format, Object ... args) {
        Formatter f = new Formatter(this.writer);
        f.format(format, args);
        f.flush();
        return this;
    }

    public Console printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public Reader reader() {
        return this.reader;
    }

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String format, Object ... args) {
        Object object = CONSOLE_LOCK;
        synchronized (object) {
            this.format(format, args);
            return this.readLine();
        }
    }

    public char[] readPassword() {
        throw new UnsupportedOperationException();
    }

    public char[] readPassword(String format, Object ... args) {
        throw new UnsupportedOperationException();
    }

    public PrintWriter writer() {
        return this.writer;
    }

    private static class ConsoleWriter
    extends PrintWriter {
        public ConsoleWriter(OutputStream out) {
            super(out, true);
            this.lock = CONSOLE_LOCK;
        }

        @Override
        public void close() {
            this.flush();
        }
    }

    private static class ConsoleReader
    extends BufferedReader {
        public ConsoleReader(InputStream in) throws UnsupportedEncodingException {
            super(new InputStreamReader(in, System.getProperty("file.encoding")), 256);
            this.lock = CONSOLE_LOCK;
        }

        @Override
        public void close() {
        }
    }
}

