/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.NioUtils;
import java.nio.channels.FileChannel;
import libcore.io.IoBridge;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private final boolean shouldClose;
    private FileChannel channel;
    private final int mode;
    private final CloseGuard guard = CloseGuard.get();

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.mode = OsConstants.O_WRONLY | OsConstants.O_CREAT | (append ? OsConstants.O_APPEND : OsConstants.O_TRUNC);
        this.fd = IoBridge.open(file.getPath(), this.mode);
        this.shouldClose = true;
        this.guard.open("close");
    }

    public FileOutputStream(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        this.fd = fd;
        this.shouldClose = false;
        this.mode = OsConstants.O_WRONLY;
        this.channel = NioUtils.newFileChannel(this, fd, this.mode);
    }

    public FileOutputStream(String path) throws FileNotFoundException {
        this(path, false);
    }

    public FileOutputStream(String path, boolean append) throws FileNotFoundException {
        this(new File(path), append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.guard.close();
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.shouldClose) {
                IoBridge.closeAndSignalBlockedThreads(this.fd);
            } else {
                this.fd = new FileDescriptor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = NioUtils.newFileChannel(this, this.fd, this.mode);
            }
            return this.channel;
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    @Override
    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        IoBridge.write(this.fd, buffer, byteOffset, byteCount);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.write(new byte[]{(byte)oneByte}, 0, 1);
    }
}

