/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public class InputStreamReader
extends Reader {
    private InputStream in;
    private boolean endOfInput = false;
    private CharsetDecoder decoder;
    private final ByteBuffer bytes = ByteBuffer.allocate(8192);

    public InputStreamReader(InputStream in) {
        this(in, Charset.defaultCharset());
    }

    public InputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        super(in);
        if (charsetName == null) {
            throw new NullPointerException("charsetName == null");
        }
        this.in = in;
        try {
            this.decoder = Charset.forName(charsetName).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(charsetName).initCause(e);
        }
        this.bytes.limit(0);
    }

    public InputStreamReader(InputStream in, CharsetDecoder dec) {
        super(in);
        dec.averageCharsPerByte();
        this.in = in;
        this.decoder = dec;
        this.bytes.limit(0);
    }

    public InputStreamReader(InputStream in, Charset charset) {
        super(in);
        this.in = in;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.bytes.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.decoder != null) {
                this.decoder.reset();
            }
            this.decoder = null;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }

    public String getEncoding() {
        if (!this.isOpen()) {
            return null;
        }
        return this.decoder.charset().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("InputStreamReader is closed");
            }
            char[] buf = new char[1];
            int n = this.read(buf, 0, 1) != -1 ? buf[0] : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean needInput;
            if (!this.isOpen()) {
                throw new IOException("InputStreamReader is closed");
            }
            Arrays.checkOffsetAndCount(buffer.length, offset, count);
            if (count == 0) {
                return 0;
            }
            CharBuffer out = CharBuffer.wrap(buffer, offset, count);
            CoderResult result = CoderResult.UNDERFLOW;
            boolean bl = needInput = !this.bytes.hasRemaining();
            while (out.hasRemaining()) {
                if (needInput) {
                    try {
                        if (this.in.available() == 0 && out.position() > offset) {
                            break;
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    int desiredByteCount = this.bytes.capacity() - this.bytes.limit();
                    int off = this.bytes.arrayOffset() + this.bytes.limit();
                    int actualByteCount = this.in.read(this.bytes.array(), off, desiredByteCount);
                    if (actualByteCount == -1) {
                        this.endOfInput = true;
                        break;
                    }
                    if (actualByteCount == 0) break;
                    this.bytes.limit(this.bytes.limit() + actualByteCount);
                    needInput = false;
                }
                if (!(result = this.decoder.decode(this.bytes, out, false)).isUnderflow()) break;
                if (this.bytes.limit() == this.bytes.capacity()) {
                    this.bytes.compact();
                    this.bytes.limit(this.bytes.position());
                    this.bytes.position(0);
                }
                needInput = true;
            }
            if (result == CoderResult.UNDERFLOW && this.endOfInput) {
                result = this.decoder.decode(this.bytes, out, true);
                if (result == CoderResult.UNDERFLOW) {
                    result = this.decoder.flush(out);
                }
                this.decoder.reset();
            }
            if (result.isMalformed() || result.isUnmappable()) {
                result.throwException();
            }
            return out.position() - offset == 0 ? -1 : out.position() - offset;
        }
    }

    private boolean isOpen() {
        return this.in != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("InputStreamReader is closed");
            }
            try {
                return this.bytes.hasRemaining() || this.in.available() > 0;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

