/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainServerSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.ServerSocketChannel;
import libcore.io.IoBridge;

public class ServerSocket
implements Closeable {
    private static final int DEFAULT_BACKLOG = 50;
    private final SocketImpl impl;
    static SocketImplFactory factory;
    private boolean isBound;
    private boolean isClosed;
    private InetAddress localAddress;

    public SocketImpl getImpl$() {
        return this.impl;
    }

    public ServerSocket() throws IOException {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainServerSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50, Inet4Address.ANY);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, Inet4Address.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket(int port, int backlog, InetAddress localAddress) throws IOException {
        this.checkListen(port);
        this.impl = factory != null ? factory.createSocketImpl() : new PlainServerSocketImpl();
        InetAddress addr = localAddress == null ? Inet4Address.ANY : localAddress;
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            this.impl.create(true);
            try {
                this.impl.bind(addr, port);
                this.readBackBindState();
                this.impl.listen(backlog > 0 ? backlog : 50);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    private void readBackBindState() throws SocketException {
        this.localAddress = IoBridge.getSocketLocalAddress(this.impl.fd);
        this.isBound = true;
    }

    public Socket accept() throws IOException {
        this.checkOpen();
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound");
        }
        Socket aSocket = new Socket();
        try {
            this.implAccept(aSocket);
        }
        catch (IOException e) {
            aSocket.close();
            throw e;
        }
        return aSocket;
    }

    private void checkListen(int aPort) {
        if (aPort < 0 || aPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + aPort);
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.impl.close();
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.localAddress;
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws IOException {
        this.checkOpen();
        return (Integer)this.impl.getOption(4102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void implAccept(Socket aSocket) throws IOException {
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            this.impl.accept(aSocket.impl);
            aSocket.accepted();
        }
    }

    public static synchronized void setSocketFactory(SocketImplFactory aFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("Factory already set");
        }
        factory = aFactory;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkOpen();
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.impl.setOption(4102, timeout);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append("ServerSocket[");
        if (!this.isBound()) {
            return result.append("unbound]").toString();
        }
        return result.append("addr=").append(this.getInetAddress().getHostName()).append("/").append(this.getInetAddress().getHostAddress()).append(",port=0,localport=").append(this.getLocalPort()).append("]").toString();
    }

    public void bind(SocketAddress localAddr) throws IOException {
        this.bind(localAddr, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress localAddr, int backlog) throws IOException {
        int port;
        InetAddress addr;
        this.checkOpen();
        if (this.isBound()) {
            throw new BindException("Socket is already bound");
        }
        if (localAddr == null) {
            addr = Inet4Address.ANY;
            port = 0;
        } else {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Local address not an InetSocketAddress: " + localAddr.getClass());
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new SocketException("Host is unresolved: " + inetAddr.getHostName());
            }
            port = inetAddr.getPort();
        }
        ServerSocket serverSocket = this;
        synchronized (serverSocket) {
            try {
                this.impl.bind(addr, port);
                this.readBackBindState();
                this.impl.listen(backlog > 0 ? backlog : 50);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.localAddress, this.getLocalPort());
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkOpen();
        this.impl.setOption(4, reuse);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkOpen();
        return (Boolean)this.impl.getOption(4);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.checkOpen();
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.impl.setOption(4098, size);
    }

    public int getReceiveBufferSize() throws SocketException {
        this.checkOpen();
        return (Integer)this.impl.getOption(4098);
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

