/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import android.system.ErrnoException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.FileDescriptorChannel;
import java.nio.SocketChannelImpl;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.util.EmptyArray;

class DatagramChannelImpl
extends DatagramChannel
implements FileDescriptorChannel {
    private final FileDescriptor fd;
    private DatagramSocket socket;
    InetSocketAddress connectAddress;
    InetAddress localAddress;
    private int localPort;
    boolean connected = false;
    boolean isBound = false;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    protected DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = IoBridge.socket(false);
    }

    private DatagramChannelImpl() {
        super(SelectorProvider.provider());
        this.fd = new FileDescriptor();
        this.connectAddress = new InetSocketAddress(0);
    }

    @Override
    public synchronized DatagramSocket socket() {
        if (this.socket == null) {
            this.socket = new DatagramSocketAdapter(new PlainDatagramSocketImpl(this.fd, this.localPort), this);
        }
        return this.socket;
    }

    void onBind(boolean updateSocketState) {
        SocketAddress sa;
        try {
            sa = Libcore.os.getsockname(this.fd);
        }
        catch (ErrnoException errnoException) {
            throw new AssertionError((Object)errnoException);
        }
        this.isBound = true;
        InetSocketAddress localSocketAddress = (InetSocketAddress)sa;
        this.localAddress = localSocketAddress.getAddress();
        this.localPort = localSocketAddress.getPort();
        if (updateSocketState && this.socket != null) {
            this.socket.onBind(this.localAddress, this.localPort);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DatagramChannel connect(SocketAddress address) throws IOException {
        this.checkOpen();
        if (this.connected) {
            throw new IllegalStateException();
        }
        InetSocketAddress inetSocketAddress = SocketChannelImpl.validateAddress(address);
        InetAddress remoteAddress = inetSocketAddress.getAddress();
        int remotePort = inetSocketAddress.getPort();
        try {
            this.begin();
            IoBridge.connect(this.fd, remoteAddress, remotePort);
        }
        catch (ConnectException e) {
        }
        finally {
            this.end(true);
        }
        if (!this.isBound) {
            this.onBind(true);
        }
        this.onConnect(remoteAddress, remotePort, true);
        return this;
    }

    void onConnect(InetAddress remoteAddress, int remotePort, boolean updateSocketState) {
        this.connected = true;
        this.connectAddress = new InetSocketAddress(remoteAddress, remotePort);
        if (updateSocketState && this.socket != null) {
            this.socket.onConnect(remoteAddress, remotePort);
        }
    }

    @Override
    public synchronized DatagramChannel disconnect() throws IOException {
        if (!this.isConnected() || !this.isOpen()) {
            return this;
        }
        this.onDisconnect(true);
        try {
            Libcore.os.connect(this.fd, InetAddress.UNSPECIFIED, 0);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
        return this;
    }

    void onDisconnect(boolean updateSocketState) {
        this.connected = false;
        this.connectAddress = null;
        if (updateSocketState && this.socket != null && this.socket.isConnected()) {
            this.socket.onDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress receive(ByteBuffer target) throws IOException {
        target.checkWritable();
        this.checkOpen();
        if (!this.isBound) {
            return null;
        }
        SocketAddress retAddr = null;
        try {
            this.begin();
            Object object = this.readLock;
            synchronized (object) {
                boolean loop = this.isBlocking();
                retAddr = !target.isDirect() ? this.receiveImpl(target, loop) : this.receiveDirectImpl(target, loop);
            }
            this.end(retAddr != null);
        }
        catch (InterruptedIOException e) {
            SocketAddress socketAddress;
            try {
                socketAddress = null;
                this.end(retAddr != null);
            }
            catch (Throwable throwable) {
                this.end(retAddr != null);
                throw throwable;
            }
            return socketAddress;
        }
        return retAddr;
    }

    private SocketAddress receiveImpl(ByteBuffer target, boolean loop) throws IOException {
        SocketAddress retAddr = null;
        int oldposition = target.position();
        DatagramPacket receivePacket = target.hasArray() ? new DatagramPacket(target.array(), target.position() + target.arrayOffset(), target.remaining()) : new DatagramPacket(new byte[target.remaining()], target.remaining());
        do {
            int received = IoBridge.recvfrom(false, this.fd, receivePacket.getData(), receivePacket.getOffset(), receivePacket.getLength(), 0, receivePacket, this.isConnected());
            if (receivePacket.getAddress() == null) continue;
            if (received > 0) {
                if (target.hasArray()) {
                    target.position(oldposition + received);
                } else {
                    target.put(receivePacket.getData(), 0, received);
                }
            }
            retAddr = receivePacket.getSocketAddress();
            break;
        } while (loop);
        return retAddr;
    }

    private SocketAddress receiveDirectImpl(ByteBuffer target, boolean loop) throws IOException {
        SocketAddress retAddr = null;
        DatagramPacket receivePacket = new DatagramPacket(EmptyArray.BYTE, 0);
        int oldposition = target.position();
        do {
            int received = IoBridge.recvfrom(false, this.fd, target, 0, receivePacket, this.isConnected());
            if (receivePacket.getAddress() == null) continue;
            if (received > 0) {
                target.position(oldposition + received);
            }
            retAddr = receivePacket.getSocketAddress();
            break;
        } while (loop);
        return retAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(ByteBuffer source, SocketAddress socketAddress) throws IOException {
        this.checkNotNull(source);
        this.checkOpen();
        InetSocketAddress isa = (InetSocketAddress)socketAddress;
        if (isa.getAddress() == null) {
            throw new IOException();
        }
        if (this.isConnected() && !this.connectAddress.equals(isa)) {
            throw new IllegalArgumentException("Connected to " + this.connectAddress + ", not " + socketAddress);
        }
        Object object = this.writeLock;
        synchronized (object) {
            int sendCount = 0;
            try {
                this.begin();
                int oldPosition = source.position();
                sendCount = IoBridge.sendto(this.fd, source, 0, isa.getAddress(), isa.getPort());
                if (sendCount > 0) {
                    source.position(oldPosition + sendCount);
                }
                if (!this.isBound) {
                    this.onBind(true);
                }
                this.end(sendCount >= 0);
            }
            catch (Throwable throwable) {
                this.end(sendCount >= 0);
                throw throwable;
            }
            return sendCount;
        }
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        int readCount;
        target.checkWritable();
        this.checkOpenConnected();
        if (!target.hasRemaining()) {
            return 0;
        }
        if (target.isDirect() || target.hasArray()) {
            readCount = this.readImpl(target);
            if (readCount > 0) {
                target.position(target.position() + readCount);
            }
        } else {
            byte[] readArray = new byte[target.remaining()];
            ByteBuffer readBuffer = ByteBuffer.wrap(readArray);
            readCount = this.readImpl(readBuffer);
            if (readCount > 0) {
                target.put(readArray, 0, readCount);
            }
        }
        return readCount;
    }

    @Override
    public long read(ByteBuffer[] targets, int offset, int length) throws IOException {
        int readCount;
        int putLength;
        Arrays.checkOffsetAndCount(targets.length, offset, length);
        this.checkOpenConnected();
        int totalCount = FileChannelImpl.calculateTotalRemaining(targets, offset, length, true);
        if (totalCount == 0) {
            return 0L;
        }
        ByteBuffer readBuffer = ByteBuffer.allocate(totalCount);
        int index = offset;
        byte[] readArray = readBuffer.array();
        for (int left = readCount = this.readImpl(readBuffer); left > 0; left -= putLength) {
            putLength = Math.min(targets[index].remaining(), left);
            targets[index].put(readArray, readCount - left, putLength);
            ++index;
        }
        return readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readImpl(ByteBuffer dst) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int readCount = 0;
            try {
                this.begin();
                readCount = IoBridge.recvfrom(false, this.fd, dst, 0, null, this.isConnected());
                this.end(readCount > 0);
            }
            catch (InterruptedIOException e) {
                int n;
                try {
                    n = 0;
                    this.end(readCount > 0);
                }
                catch (Throwable throwable) {
                    this.end(readCount > 0);
                    throw throwable;
                }
                return n;
            }
            return readCount;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkNotNull(src);
        this.checkOpenConnected();
        if (!src.hasRemaining()) {
            return 0;
        }
        int writeCount = this.writeImpl(src);
        if (writeCount > 0) {
            src.position(src.position() + writeCount);
        }
        return writeCount;
    }

    @Override
    public long write(ByteBuffer[] sources, int offset, int length) throws IOException {
        int gap;
        int result;
        Arrays.checkOffsetAndCount(sources.length, offset, length);
        this.checkOpenConnected();
        int count = FileChannelImpl.calculateTotalRemaining(sources, offset, length, false);
        if (count == 0) {
            return 0L;
        }
        ByteBuffer writeBuf = ByteBuffer.allocate(count);
        for (int val = offset; val < length + offset; ++val) {
            ByteBuffer source = sources[val];
            int oldPosition = source.position();
            writeBuf.put(source);
            source.position(oldPosition);
        }
        writeBuf.flip();
        int val = offset;
        int written = result;
        for (result = this.writeImpl(writeBuf); result > 0; result -= gap) {
            ByteBuffer source = sources[val];
            gap = Math.min(result, source.remaining());
            source.position(source.position() + gap);
            ++val;
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(ByteBuffer buf) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int result = 0;
            try {
                this.begin();
                result = IoBridge.sendto(this.fd, buf, 0, null, 0);
                this.end(result > 0);
            }
            catch (Throwable throwable) {
                this.end(result > 0);
                throw throwable;
            }
            return result;
        }
    }

    @Override
    protected synchronized void implCloseSelectableChannel() throws IOException {
        this.onDisconnect(true);
        IoBridge.closeAndSignalBlockedThreads(this.fd);
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.onClose();
        }
    }

    @Override
    protected void implConfigureBlocking(boolean blocking) throws IOException {
        IoUtils.setBlocking(this.fd, blocking);
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void checkOpenConnected() throws IOException {
        this.checkOpen();
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
    }

    private void checkNotNull(ByteBuffer source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    private static class DatagramSocketAdapter
    extends DatagramSocket {
        private final DatagramChannelImpl channelImpl;

        DatagramSocketAdapter(DatagramSocketImpl socketimpl, DatagramChannelImpl channelImpl) {
            super(socketimpl);
            this.channelImpl = channelImpl;
            if (channelImpl.isBound) {
                this.onBind(channelImpl.localAddress, channelImpl.localPort);
            }
            if (channelImpl.connected) {
                this.onConnect(channelImpl.connectAddress.getAddress(), channelImpl.connectAddress.getPort());
            } else {
                this.onDisconnect();
            }
            if (!channelImpl.isOpen()) {
                this.onClose();
            }
        }

        @Override
        public DatagramChannel getChannel() {
            return this.channelImpl;
        }

        @Override
        public void bind(SocketAddress localAddr) throws SocketException {
            if (this.channelImpl.isConnected()) {
                throw new AlreadyConnectedException();
            }
            super.bind(localAddr);
            this.channelImpl.onBind(false);
        }

        @Override
        public void connect(SocketAddress peer) throws SocketException {
            if (this.isConnected()) {
                throw new IllegalStateException("Socket is already connected.");
            }
            super.connect(peer);
            this.channelImpl.onBind(false);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)peer;
            this.channelImpl.onConnect(inetSocketAddress.getAddress(), inetSocketAddress.getPort(), false);
        }

        @Override
        public void connect(InetAddress address, int port) {
            try {
                this.connect(new InetSocketAddress(address, port));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        @Override
        public void receive(DatagramPacket packet) throws IOException {
            if (!this.channelImpl.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            boolean wasBound = this.isBound();
            super.receive(packet);
            if (!wasBound) {
                this.channelImpl.onBind(false);
            }
        }

        @Override
        public void send(DatagramPacket packet) throws IOException {
            if (!this.channelImpl.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            boolean wasBound = this.isBound();
            super.send(packet);
            if (!wasBound) {
                this.channelImpl.onBind(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            DatagramChannelImpl datagramChannelImpl = this.channelImpl;
            synchronized (datagramChannelImpl) {
                super.close();
                if (this.channelImpl.isOpen()) {
                    try {
                        this.channelImpl.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void disconnect() {
            super.disconnect();
            this.channelImpl.onDisconnect(false);
        }
    }
}

