/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

final class FloatArrayBuffer
extends FloatBuffer {
    private final float[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    FloatArrayBuffer(float[] array2) {
        this(array2.length, array2, 0, false);
    }

    private FloatArrayBuffer(int capacity, float[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity, 0L);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static FloatArrayBuffer copy(FloatArrayBuffer other, int markOfOther, boolean isReadOnly) {
        FloatArrayBuffer buf = new FloatArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return FloatArrayBuffer.copy(this, this.mark, true);
    }

    @Override
    public FloatBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy((float[])this.backingArray, (int)(this.position + this.arrayOffset), (float[])this.backingArray, (int)this.arrayOffset, (int)this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        return FloatArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    @Override
    public FloatBuffer slice() {
        return new FloatArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    float[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    @Override
    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    @Override
    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    @Override
    public final float get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    @Override
    public final float get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    @Override
    public final FloatBuffer get(float[] dst, int dstOffset, int floatCount) {
        if (floatCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy((float[])this.backingArray, (int)(this.arrayOffset + this.position), (float[])dst, (int)dstOffset, (int)floatCount);
        this.position += floatCount;
        return this;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public FloatBuffer put(float c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    @Override
    public FloatBuffer put(int index, float c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int srcOffset, int floatCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (floatCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy((float[])src, (int)srcOffset, (float[])this.backingArray, (int)(this.arrayOffset + this.position), (int)floatCount);
        this.position += floatCount;
        return this;
    }
}

