/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import android.system.ErrnoException;
import android.system.OsConstants;
import java.nio.ByteBuffer;
import java.nio.MemoryBlock;
import java.nio.channels.FileChannel;
import libcore.io.Libcore;

public abstract class MappedByteBuffer
extends ByteBuffer {
    final FileChannel.MapMode mapMode;
    final MemoryBlock block;

    MappedByteBuffer(MemoryBlock block, int capacity, FileChannel.MapMode mapMode, long effectiveDirectAddress) {
        super(capacity, effectiveDirectAddress);
        this.mapMode = mapMode;
        this.block = block;
    }

    public final boolean isLoaded() {
        this.checkIsMapped();
        long address = this.block.toLong();
        long size = this.block.getSize();
        if (size == 0L) {
            return true;
        }
        try {
            int pageSize = (int)Libcore.os.sysconf(OsConstants._SC_PAGE_SIZE);
            int pageOffset = (int)(address % (long)pageSize);
            int pageCount = (int)(((size += (long)pageOffset) + (long)pageSize - 1L) / (long)pageSize);
            byte[] vector = new byte[pageCount];
            Libcore.os.mincore(address -= (long)pageOffset, size, vector);
            for (int i = 0; i < vector.length; ++i) {
                if ((vector[i] & 1) == 1) continue;
                return false;
            }
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public final MappedByteBuffer load() {
        this.checkIsMapped();
        try {
            Libcore.os.mlock(this.block.toLong(), this.block.getSize());
            Libcore.os.munlock(this.block.toLong(), this.block.getSize());
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
        return this;
    }

    public final MappedByteBuffer force() {
        this.checkIsMapped();
        if (this.mapMode == FileChannel.MapMode.READ_WRITE) {
            try {
                Libcore.os.msync(this.block.toLong(), this.block.getSize(), OsConstants.MS_SYNC);
            }
            catch (ErrnoException errnoException) {
                throw new AssertionError((Object)errnoException);
            }
        }
        return this;
    }

    private void checkIsMapped() {
        if (this.mapMode == null) {
            throw new UnsupportedOperationException();
        }
    }
}

