/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;

public abstract class Format
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -299282585814624189L;

    protected Format() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final String format(Object object) {
        return this.format(object, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(Object var1, StringBuffer var2, FieldPosition var3);

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return new AttributedString(this.format(object)).getIterator();
    }

    public Object parseObject(String string2) throws ParseException {
        ParsePosition position = new ParsePosition(0);
        Object result = this.parseObject(string2, position);
        if (position.getIndex() == 0) {
            throw new ParseException("Parse failure", position.getErrorIndex());
        }
        return result;
    }

    public abstract Object parseObject(String var1, ParsePosition var2);

    static boolean upTo(String string2, ParsePosition position, StringBuffer buffer, char stop) {
        int index = position.getIndex();
        int length = string2.length();
        boolean lastQuote = false;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string2.charAt(index++)) == '\'') {
                if (lastQuote) {
                    buffer.append('\'');
                }
                quote = !quote;
                lastQuote = true;
                continue;
            }
            if (ch == stop && !quote) {
                position.setIndex(index);
                return true;
            }
            lastQuote = false;
            buffer.append(ch);
        }
        position.setIndex(index);
        return false;
    }

    static boolean upToWithQuotes(String string2, ParsePosition position, StringBuffer buffer, char stop, char start) {
        int index = position.getIndex();
        int length = string2.length();
        int count = 1;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string2.charAt(index++)) == '\'') {
                boolean bl = quote = !quote;
            }
            if (!quote) {
                if (ch == stop) {
                    --count;
                }
                if (count == 0) {
                    position.setIndex(index);
                    return true;
                }
                if (ch == start) {
                    ++count;
                }
            }
            buffer.append(ch);
        }
        throw new IllegalArgumentException("Unmatched braces in the pattern");
    }

    public static class Field
    extends AttributedCharacterIterator.Attribute {
        private static final long serialVersionUID = 276966692217360283L;

        protected Field(String fieldName) {
            super(fieldName);
        }
    }
}

